/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notebooks.visualization.ui;

import com.intellij.notebooks.ui.editor.actions.command.mode.NotebookEditorMode;
import com.intellij.notebooks.ui.editor.actions.command.mode.NotebookEditorModeKt;
import com.intellij.notebooks.visualization.CaretBasedCellSelectionModelKt;
import com.intellij.notebooks.visualization.NotebookCellInlayManager;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.NotebookCellSelectionModel;
import com.intellij.notebooks.visualization.NotebookCellSelectionModelProviderKt;
import com.intellij.notebooks.visualization.NotebookVisualizationUiUtilKt;
import com.intellij.notebooks.visualization.inlay.JupyterBoundsChangeHandler;
import com.intellij.notebooks.visualization.ui.DecoratedEditor$1$onEditorCellViewEvents$;
import com.intellij.notebooks.visualization.ui.DecoratedEditorKt;
import com.intellij.notebooks.visualization.ui.EditorCell;
import com.intellij.notebooks.visualization.ui.EditorCellSelectionModel;
import com.intellij.notebooks.visualization.ui.EditorCellView;
import com.intellij.notebooks.visualization.ui.EditorCellViewEventListener;
import com.intellij.notebooks.visualization.ui.EditorLayerController;
import com.intellij.notebooks.visualization.ui.NestedScrollingSupportImpl;
import com.intellij.notebooks.visualization.ui.NotebookAWTMouseDispatcher;
import com.intellij.notebooks.visualization.ui.NotebookEditor;
import com.intellij.notebooks.visualization.ui.NotebookEditorKt;
import com.intellij.notebooks.visualization.ui.NotebookPositionKeeper;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.EditorMouseEventArea;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.ui.ComponentUtil;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.Line2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JComponent;
import javax.swing.JLayer;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.plaf.LayerUI;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u0000 32\u00020\u0001:\u000223B\u0019\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0003H\u0002J\b\u0010\u0018\u001a\u00020\u0016H\u0002J\b\u0010\u0019\u001a\u00020\u0016H\u0002J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\b\u0010\u001f\u001a\u00020\u0016H\u0002J\u001e\u0010 \u001a\u0010\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020#\u0018\u00010!2\u0006\u0010$\u001a\u00020%H\u0002J\u0010\u0010&\u001a\u00020\u00162\u0006\u0010'\u001a\u00020#H\u0002J\u0012\u0010(\u001a\u0004\u0018\u00010\t2\u0006\u0010'\u001a\u00020#H\u0002J(\u0010)\u001a\u00020\u00162\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020-2\u0006\u0010/\u001a\u000200H\u0016J(\u00101\u001a\u00020\u00162\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020-2\u0006\u0010/\u001a\u000200H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\n\u001a\u0004\u0018\u00010\t2\b\u0010\b\u001a\u0004\u0018\u00010\t@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lcom/intellij/notebooks/visualization/ui/DecoratedEditor;", "Lcom/intellij/notebooks/visualization/ui/NotebookEditor;", "editorImpl", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "manager", "Lcom/intellij/notebooks/visualization/NotebookCellInlayManager;", "<init>", "(Lcom/intellij/openapi/editor/impl/EditorImpl;Lcom/intellij/notebooks/visualization/NotebookCellInlayManager;)V", "value", "Lcom/intellij/notebooks/visualization/ui/EditorCellView;", "mouseOverCell", "getMouseOverCell", "()Lcom/intellij/notebooks/visualization/ui/EditorCellView;", "editorPositionKeeper", "Lcom/intellij/notebooks/visualization/ui/NotebookPositionKeeper;", "getEditorPositionKeeper", "()Lcom/intellij/notebooks/visualization/ui/NotebookPositionKeeper;", "selectionModel", "Lcom/intellij/notebooks/visualization/ui/EditorCellSelectionModel;", "selectionUpdateScheduled", "Ljava/util/concurrent/atomic/AtomicBoolean;", "wrapEditorComponent", "", "editor", "scheduleSelectionUpdate", "updateSelectionByCarets", "getCellsByCaretSelection", "", "Lcom/intellij/notebooks/visualization/ui/EditorCell;", "caret", "Lcom/intellij/openapi/editor/Caret;", "setupScrollPane", "getEditorPoint", "Lkotlin/Pair;", "Ljava/awt/Component;", "Ljava/awt/Point;", "e", "Ljava/awt/event/MouseEvent;", "updateMouseOverCell", "point", "getCellViewByPoint", "inlayClicked", "clickedCell", "Lcom/intellij/notebooks/visualization/NotebookCellLines$Interval;", "ctrlPressed", "", "shiftPressed", "mouseButton", "", "updateSelectionAfterClick", "EditorComponentWrapper", "Companion", "intellij.notebooks.visualization"})
@SourceDebugExtension(value={"SMAP\nDecoratedEditor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DecoratedEditor.kt\ncom/intellij/notebooks/visualization/ui/DecoratedEditor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,324:1\n1368#2:325\n1454#2,5:326\n774#2:331\n865#2,2:332\n295#2,2:334\n774#2:336\n865#2,2:337\n1#3:339\n*S KotlinDebug\n*F\n+ 1 DecoratedEditor.kt\ncom/intellij/notebooks/visualization/ui/DecoratedEditor\n*L\n203#1:325\n203#1:326,5\n209#1:331\n209#1:332,2\n255#1:334,2\n284#1:336\n284#1:337,2\n*E\n"})
public final class DecoratedEditor
implements NotebookEditor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EditorImpl editorImpl;
    @NotNull
    private final NotebookCellInlayManager manager;
    @Nullable
    private EditorCellView mouseOverCell;
    @NotNull
    private final NotebookPositionKeeper editorPositionKeeper;
    @NotNull
    private final EditorCellSelectionModel selectionModel;
    @NotNull
    private AtomicBoolean selectionUpdateScheduled;

    private DecoratedEditor(EditorImpl editorImpl, NotebookCellInlayManager manager) {
        this.editorImpl = editorImpl;
        this.manager = manager;
        this.editorPositionKeeper = new NotebookPositionKeeper(this.editorImpl);
        this.selectionModel = new EditorCellSelectionModel(this.manager);
        this.selectionUpdateScheduled = new AtomicBoolean(false);
        if (!GraphicsEnvironment.isHeadless()) {
            this.setupScrollPane();
        }
        this.wrapEditorComponent(this.editorImpl);
        EditorCellViewEventListener editorCellViewEventListener = new EditorCellViewEventListener(){

            /*
             * WARNING - void declaration
             */
            @Override
            public void onEditorCellViewEvents(List<? extends EditorCellViewEventListener.EditorCellViewEvent> events) {
                void $this$forEach$iv;
                Intrinsics.checkNotNullParameter(events, (String)"events");
                Sequence $this$filterIsInstance$iv = CollectionsKt.asSequence((Iterable)events);
                boolean $i$f$filterIsInstance = false;
                Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)1$onEditorCellViewEvents$$inlined$filterIsInstance$1.INSTANCE);
                Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
                $this$filterIsInstance$iv = sequence;
                DecoratedEditor decoratedEditor = this;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    EditorCellViewEventListener.CellViewRemoved it = (EditorCellViewEventListener.CellViewRemoved)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getView(), (Object)decoratedEditor.getMouseOverCell())) continue;
                    decoratedEditor.mouseOverCell = null;
                }
            }
        };
        Disposable disposable = this.editorImpl.getDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"getDisposable(...)");
        this.manager.addCellViewEventsListener(editorCellViewEventListener, disposable);
        this.editorImpl.getCaretModel().addCaretListener(new CaretListener(){

            public void caretAdded(CaretEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.scheduleSelectionUpdate();
            }

            public void caretPositionChanged(CaretEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.scheduleSelectionUpdate();
            }

            public void caretRemoved(CaretEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.scheduleSelectionUpdate();
            }
        });
        this.updateSelectionByCarets();
        NotebookEditorKt.getNotebookEditorKey().set((UserDataHolder)this.editorImpl, (Object)this);
    }

    @Override
    @Nullable
    public EditorCellView getMouseOverCell() {
        return this.mouseOverCell;
    }

    @Override
    @NotNull
    public NotebookPositionKeeper getEditorPositionKeeper() {
        return this.editorPositionKeeper;
    }

    private final void wrapEditorComponent(EditorImpl editor) {
        NotebookAWTMouseDispatcher notebookAWTMouseDispatcher;
        NestedScrollingSupportImpl nestedScrollingSupport = new NestedScrollingSupportImpl();
        JScrollPane jScrollPane = editor.getScrollPane();
        Intrinsics.checkNotNullExpressionValue((Object)jScrollPane, (String)"getScrollPane(...)");
        NotebookAWTMouseDispatcher $this$wrapEditorComponent_u24lambda_u245 = notebookAWTMouseDispatcher = new NotebookAWTMouseDispatcher(jScrollPane);
        boolean bl = false;
        $this$wrapEditorComponent_u24lambda_u245.getEventDispatcher().addListener(arg_0 -> DecoratedEditor.wrapEditorComponent$lambda$5$lambda$1(this, arg_0));
        $this$wrapEditorComponent_u24lambda_u245.getEventDispatcher().addListener(arg_0 -> DecoratedEditor.wrapEditorComponent$lambda$5$lambda$3(nestedScrollingSupport, arg_0));
        $this$wrapEditorComponent_u24lambda_u245.getEventDispatcher().addListener(arg_0 -> DecoratedEditor.wrapEditorComponent$lambda$5$lambda$4(this, arg_0));
        Disposer.register((Disposable)editor.getDisposable(), (Disposable)$this$wrapEditorComponent_u24lambda_u245);
        JViewport jViewport = editor.getScrollPane().getViewport();
        Editor editor2 = (Editor)editor;
        JViewport jViewport2 = editor.getScrollPane().getViewport();
        Intrinsics.checkNotNullExpressionValue((Object)jViewport2, (String)"getViewport(...)");
        EditorComponentImpl editorComponentImpl = editor.getContentComponent();
        Intrinsics.checkNotNullExpressionValue((Object)editorComponentImpl, (String)"getContentComponent(...)");
        jViewport.setView(new EditorComponentWrapper(editor2, jViewport2, (Component)editorComponentImpl));
    }

    private final void scheduleSelectionUpdate() {
        if (this.selectionUpdateScheduled.compareAndSet(false, true)) {
            ApplicationManager.getApplication().invokeLater(() -> DecoratedEditor.scheduleSelectionUpdate$lambda$6(this));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void updateSelectionByCarets() {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        List list = this.editorImpl.getCaretModel().getAllCarets();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAllCarets(...)");
        Iterable iterable = list;
        EditorCellSelectionModel editorCellSelectionModel = this.selectionModel;
        boolean $i$f$flatMap = false;
        void var3_4 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Caret it = (Caret)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            Iterable list$iv$iv = this.getCellsByCaretSelection(it);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        editorCellSelectionModel.replaceSelection((List)destination$iv$iv);
    }

    /*
     * WARNING - void declaration
     */
    private final List<EditorCell> getCellsByCaretSelection(Caret caret) {
        void $this$filterTo$iv$iv;
        DocumentEx documentEx = this.editorImpl.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"getDocument(...)");
        IntRange lines = CaretBasedCellSelectionModelKt.getSelectionLines((Document)documentEx, caret);
        Iterable $this$filter$iv = this.manager.getCells();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            EditorCell it = (EditorCell)element$iv$iv;
            boolean bl = false;
            if (!NotebookVisualizationUiUtilKt.hasIntersectionWith(it.getInterval().getLines(), lines)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final void setupScrollPane() {
        JScrollPane jScrollPane = this.editorImpl.getScrollPane();
        Intrinsics.checkNotNullExpressionValue((Object)jScrollPane, (String)"getScrollPane(...)");
        JScrollPane scrollPane = jScrollPane;
        this.editorImpl.getScrollPane().getViewport().setOpaque(false);
        scrollPane.getViewport().addChangeListener(arg_0 -> DecoratedEditor.setupScrollPane$lambda$11(this, arg_0));
    }

    private final Pair<Component, Point> getEditorPoint(MouseEvent e) {
        JComponent component = SwingUtilities.isDescendingFrom(e.getComponent(), (Component)this.editorImpl.getContentComponent()) ? (JComponent)this.editorImpl.getContentComponent() : (SwingUtilities.isDescendingFrom(e.getComponent(), (Component)this.editorImpl.getGutterComponentEx()) ? (JComponent)this.editorImpl.getGutterComponentEx() : null);
        return component != null ? TuplesKt.to((Object)component, (Object)SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), component)) : null;
    }

    private final void updateMouseOverCell(Point point) {
        block2: {
            EditorCellView currentOverCell = this.getCellViewByPoint(point);
            if (Intrinsics.areEqual((Object)this.getMouseOverCell(), (Object)currentOverCell)) break block2;
            EditorCellView editorCellView = this.getMouseOverCell();
            if (editorCellView != null) {
                editorCellView.mouseExited();
            }
            this.mouseOverCell = currentOverCell;
            EditorCellView editorCellView2 = this.getMouseOverCell();
            if (editorCellView2 != null) {
                editorCellView2.mouseEntered();
            }
        }
    }

    private final EditorCellView getCellViewByPoint(Point point) {
        EditorCell cur;
        Object v1;
        block1: {
            LogicalPosition logicalPosition = this.editorImpl.xyToLogicalPosition(point);
            Intrinsics.checkNotNullExpressionValue((Object)logicalPosition, (String)"xyToLogicalPosition(...)");
            LogicalPosition visualLine = logicalPosition;
            Iterable $this$firstOrNull$iv = this.manager.getCells();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                EditorCell it = (EditorCell)element$iv;
                boolean bl = false;
                if (!it.getInterval().getLines().contains(visualLine.line)) continue;
                v1 = element$iv;
                break block1;
            }
            v1 = null;
        }
        EditorCell editorCell = cur = (EditorCell)v1;
        return editorCell != null ? editorCell.getView() : null;
    }

    @Override
    public void inlayClicked(@NotNull NotebookCellLines.Interval clickedCell, boolean ctrlPressed, boolean shiftPressed, int mouseButton) {
        Intrinsics.checkNotNullParameter((Object)clickedCell, (String)"clickedCell");
        NotebookEditorModeKt.setMode((Editor)this.editorImpl, NotebookEditorMode.COMMAND);
        this.updateSelectionAfterClick(clickedCell, ctrlPressed, shiftPressed, mouseButton);
    }

    /*
     * WARNING - void declaration
     */
    private final void updateSelectionAfterClick(NotebookCellLines.Interval clickedCell, boolean ctrlPressed, boolean shiftPressed, int mouseButton) {
        NotebookCellSelectionModel notebookCellSelectionModel = NotebookCellSelectionModelProviderKt.getCellSelectionModel((Editor)this.editorImpl);
        Intrinsics.checkNotNull((Object)notebookCellSelectionModel);
        NotebookCellSelectionModel model = notebookCellSelectionModel;
        if (ctrlPressed) {
            if (model.isSelectedCell(clickedCell)) {
                model.removeSelection(clickedCell);
            } else {
                model.selectCell(clickedCell, true);
            }
        } else if (shiftPressed) {
            void $this$filterTo$iv$iv;
            NotebookCellLines.Interval primaryCell = model.getPrimarySelectedCell();
            int line1 = primaryCell.getLines().getFirst();
            int line2 = clickedCell.getLines().getFirst();
            IntRange range = new IntRange(Math.min(line1, line2), Math.max(line1, line2));
            List<NotebookCellLines.Interval> cellsInRange = NotebookVisualizationUiUtilKt.getCells((Editor)this.editorImpl, range);
            Iterable $this$filter$iv = model.getSelectedRegions();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                List it = (List)element$iv$iv;
                boolean bl = false;
                if (!DecoratedEditorKt.access$hasIntersection(it, cellsInRange)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List affectedSelectedCells = CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
            if (Intrinsics.areEqual((Object)affectedSelectedCells, cellsInRange)) {
                for (NotebookCellLines.Interval cell : CollectionsKt.minus((Iterable)cellsInRange, (Object)primaryCell)) {
                    model.removeSelection(cell);
                }
            } else {
                for (NotebookCellLines.Interval cell : CollectionsKt.minus((Iterable)affectedSelectedCells, (Iterable)cellsInRange)) {
                    model.removeSelection(cell);
                }
                for (NotebookCellLines.Interval cell : CollectionsKt.minus((Iterable)cellsInRange, (Iterable)affectedSelectedCells)) {
                    NotebookCellSelectionModel.selectCell$default(model, cell, false, 2, null);
                }
            }
        } else if (mouseButton == 1 && !model.isSelectedCell(clickedCell)) {
            model.selectSingleCell(clickedCell);
        }
    }

    private static final void wrapEditorComponent$lambda$5$lambda$1(DecoratedEditor this$0, AWTEvent event) {
        block1: {
            if (!(event instanceof MouseEvent)) break block1;
            Pair<Component, Point> pair = this$0.getEditorPoint((MouseEvent)event);
            if (pair != null) {
                Pair<Component, Point> pair2 = pair;
                boolean bl = false;
                Point point = (Point)pair2.component2();
                this$0.updateMouseOverCell(point);
            }
        }
    }

    private static final void wrapEditorComponent$lambda$5$lambda$3(NestedScrollingSupportImpl $nestedScrollingSupport, AWTEvent event) {
        if (event instanceof MouseWheelEvent) {
            $nestedScrollingSupport.processMouseWheelEvent((MouseWheelEvent)event);
        } else if (event instanceof MouseEvent) {
            if (((MouseEvent)event).getID() == 500 || ((MouseEvent)event).getID() == 502 || ((MouseEvent)event).getID() == 501) {
                Component component = ((MouseEvent)event).getComponent();
                JComponent jComponent = component instanceof JComponent ? (JComponent)component : null;
                JScrollPane jScrollPane = (JScrollPane)ComponentUtil.getParentOfType(JScrollPane.class, jComponent != null ? jComponent.findComponentAt(((MouseEvent)event).getPoint()) : null);
                if (jScrollPane != null) {
                    JScrollPane scrollPane = jScrollPane;
                    boolean bl = false;
                    $nestedScrollingSupport.processMouseEvent((MouseEvent)event, scrollPane);
                }
            } else if (((MouseEvent)event).getID() == 503) {
                $nestedScrollingSupport.processMouseMotionEvent((MouseEvent)event);
            }
        }
    }

    private static final void wrapEditorComponent$lambda$5$lambda$4(DecoratedEditor this$0, AWTEvent event) {
        if (event.getID() == 501 && event instanceof MouseEvent) {
            Object object = this$0.getEditorPoint((MouseEvent)event);
            if (object == null || (object = (Point)object.getSecond()) == null) {
                return;
            }
            Object point = object;
            Object object2 = this$0.getCellViewByPoint((Point)point);
            if (object2 == null || (object2 = ((EditorCellView)object2).getCell()) == null) {
                return;
            }
            Object selectedCell = object2;
            if (!Intrinsics.areEqual((Object)this$0.editorImpl.getMouseEventArea((MouseEvent)event), (Object)EditorMouseEventArea.EDITING_AREA)) {
                NotebookEditorModeKt.setMode((Editor)this$0.editorImpl, NotebookEditorMode.COMMAND);
            }
            this$0.updateSelectionAfterClick(((EditorCell)selectedCell).getInterval(), DecoratedEditorKt.access$isCtrlPressed((MouseEvent)event), DecoratedEditorKt.access$isShiftPressed((MouseEvent)event), ((MouseEvent)event).getButton());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void scheduleSelectionUpdate$lambda$6(DecoratedEditor this$0) {
        try {
            if (!this$0.editorImpl.isDisposed()) {
                this$0.updateSelectionByCarets();
            }
        }
        finally {
            this$0.selectionUpdateScheduled.set(false);
        }
    }

    private static final void setupScrollPane$lambda$11(DecoratedEditor this$0, ChangeEvent it) {
        block1: {
            Point it2;
            Point point = this$0.editorImpl.getContentComponent().getMousePosition();
            if (point != null) {
                it2 = point;
                boolean bl = false;
                this$0.updateMouseOverCell(it2);
            }
            Point point2 = this$0.editorImpl.getGutterComponentEx().getMousePosition();
            if (point2 == null) break block1;
            it2 = point2;
            boolean bl = false;
            this$0.updateMouseOverCell(it2);
        }
    }

    public /* synthetic */ DecoratedEditor(EditorImpl editorImpl, NotebookCellInlayManager manager, DefaultConstructorMarker $constructor_marker) {
        this(editorImpl, manager);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lcom/intellij/notebooks/visualization/ui/DecoratedEditor$Companion;", "", "<init>", "()V", "install", "", "original", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "manager", "Lcom/intellij/notebooks/visualization/NotebookCellInlayManager;", "intellij.notebooks.visualization"})
    public static final class Companion {
        private Companion() {
        }

        public final void install(@NotNull EditorImpl original, @NotNull NotebookCellInlayManager manager) {
            Intrinsics.checkNotNullParameter((Object)original, (String)"original");
            Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
            DecoratedEditor decoratedEditor = new DecoratedEditor(original, manager, null);
            Component component = decoratedEditor.editorImpl.getScrollPane().getViewport().getView();
            Intrinsics.checkNotNull((Object)component, (String)"null cannot be cast to non-null type com.intellij.notebooks.visualization.ui.DecoratedEditor.EditorComponentWrapper");
            EditorLayerController controller = new EditorLayerController((EditorComponentWrapper)component);
            original.putUserData(EditorLayerController.Companion.getEDITOR_LAYER_CONTROLLER_KEY(), (Object)controller);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0011\u001a\u00020\u0012H\u0014J\u0016\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0010J\u000e\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/notebooks/visualization/ui/DecoratedEditor$EditorComponentWrapper;", "Ljavax/swing/JPanel;", "editor", "Lcom/intellij/openapi/editor/Editor;", "editorViewport", "Ljavax/swing/JViewport;", "component", "Ljava/awt/Component;", "<init>", "(Lcom/intellij/openapi/editor/Editor;Ljavax/swing/JViewport;Ljava/awt/Component;)V", "layeredPane", "Ljavax/swing/JLayer;", "overlayLines", "", "Lkotlin/Pair;", "Ljava/awt/geom/Line2D;", "Ljava/awt/Color;", "validateTree", "", "addOverlayLine", "line", "color", "removeOverlayLine", "intellij.notebooks.visualization"})
    public static final class EditorComponentWrapper
    extends JPanel {
        @NotNull
        private final Editor editor;
        @NotNull
        private final JViewport editorViewport;
        @NotNull
        private final JLayer<JPanel> layeredPane;
        @NotNull
        private final List<Pair<Line2D, Color>> overlayLines;

        /*
         * WARNING - void declaration
         */
        public EditorComponentWrapper(@NotNull Editor editor, @NotNull JViewport editorViewport, @NotNull Component component) {
            void $this$_init__u24lambda_u241;
            JComponent jComponent;
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)editorViewport, (String)"editorViewport");
            Intrinsics.checkNotNullParameter((Object)component, (String)"component");
            super(new BorderLayout());
            this.editor = editor;
            this.editorViewport = editorViewport;
            this.overlayLines = new ArrayList();
            this.setOpaque(false);
            JPanel $this$_init__u24lambda_u240 = jComponent = new JPanel(new BorderLayout());
            boolean bl = false;
            $this$_init__u24lambda_u240.setOpaque(false);
            JViewport viewportWrapper2 = new JViewport(this){
                final /* synthetic */ EditorComponentWrapper this$0;
                {
                    this.this$0 = $receiver;
                }

                public Rectangle getViewRect() {
                    return EditorComponentWrapper.access$getEditorViewport$p(this.this$0).getViewRect();
                }
            };
            viewportWrapper2.setView(component);
            $this$_init__u24lambda_u240.add((Component)viewportWrapper2, "Center");
            JPanel editorPanel2 = jComponent;
            $this$_init__u24lambda_u240 = jComponent = new JLayer<Component>(editorPanel2);
            EditorComponentWrapper editorComponentWrapper = this;
            boolean bl2 = false;
            $this$_init__u24lambda_u241.setUI((LayerUI)new LayerUI<JPanel>(this){
                final /* synthetic */ EditorComponentWrapper this$0;
                {
                    this.this$0 = $receiver;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void paint(Graphics graphics, JComponent component) {
                    Intrinsics.checkNotNullParameter((Object)graphics, (String)"graphics");
                    Intrinsics.checkNotNullParameter((Object)component, (String)"component");
                    super.paint(graphics, component);
                    Graphics graphics2 = graphics.create();
                    Intrinsics.checkNotNull((Object)graphics2, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
                    Graphics2D g2d = (Graphics2D)graphics2;
                    try {
                        for (Pair pair : EditorComponentWrapper.access$getOverlayLines$p(this.this$0)) {
                            Line2D line = (Line2D)pair.component1();
                            Color color = (Color)pair.component2();
                            g2d.setColor(color);
                            g2d.draw(line);
                        }
                    }
                    finally {
                        g2d.dispose();
                    }
                }
            });
            editorComponentWrapper.layeredPane = jComponent;
            this.add((Component)this.layeredPane, "Center");
        }

        @Override
        protected void validateTree() {
            NotebookEditorKt.getNotebookEditor(this.editor).getEditorPositionKeeper().keepScrollingPositionWhile(() -> EditorComponentWrapper.validateTree$lambda$2(this));
        }

        public final void addOverlayLine(@NotNull Line2D line, @NotNull Color color) {
            Intrinsics.checkNotNullParameter((Object)line, (String)"line");
            Intrinsics.checkNotNullParameter((Object)color, (String)"color");
            this.overlayLines.add((Pair<Line2D, Color>)TuplesKt.to((Object)line, (Object)color));
            this.layeredPane.repaint();
        }

        public final void removeOverlayLine(@NotNull Line2D line) {
            Intrinsics.checkNotNullParameter((Object)line, (String)"line");
            this.overlayLines.removeIf(arg_0 -> EditorComponentWrapper.removeOverlayLine$lambda$4(arg_0 -> EditorComponentWrapper.removeOverlayLine$lambda$3(line, arg_0), arg_0));
            this.layeredPane.repaint();
        }

        private static final Unit validateTree$lambda$2(EditorComponentWrapper this$0) {
            JupyterBoundsChangeHandler.Companion.get(this$0.editor).postponeUpdates();
            super.validateTree();
            JupyterBoundsChangeHandler.Companion.get(this$0.editor).schedulePerformPostponed();
            return Unit.INSTANCE;
        }

        private static final boolean removeOverlayLine$lambda$3(Line2D $line, Pair it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return Intrinsics.areEqual((Object)it.getFirst(), (Object)$line);
        }

        private static final boolean removeOverlayLine$lambda$4(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        public static final /* synthetic */ JViewport access$getEditorViewport$p(EditorComponentWrapper $this) {
            return $this.editorViewport;
        }

        public static final /* synthetic */ List access$getOverlayLines$p(EditorComponentWrapper $this) {
            return $this.overlayLines;
        }
    }
}

