/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.jest.coverage;

import com.intellij.coverage.CoverageEngine;
import com.intellij.coverage.CoverageRunner;
import com.intellij.coverage.CoverageSuite;
import com.intellij.javascript.jest.coverage.JestCoverageEngine;
import com.intellij.javascript.nodejs.execution.NodeTargetRun;
import com.intellij.javascript.testing.CoverageProjectDataLoader;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.rt.coverage.data.ProjectData;
import java.io.File;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class JestCoverageRunner
extends CoverageRunner {
    private static final Logger LOG = Logger.getInstance(JestCoverageRunner.class);
    private String myWorkingDirectory;
    private NodeTargetRun myTargetRun;

    JestCoverageRunner() {
    }

    public void setWorkingDirectory(@Nullable String workingDirectory) {
        this.myWorkingDirectory = workingDirectory;
    }

    public void setTargetRun(@Nullable NodeTargetRun targetRun) {
        this.myTargetRun = targetRun;
    }

    @NotNull
    public static JestCoverageRunner getInstance() {
        JestCoverageRunner jestCoverageRunner = Objects.requireNonNull((JestCoverageRunner)CoverageRunner.getInstance(JestCoverageRunner.class));
        if (jestCoverageRunner == null) {
            JestCoverageRunner.$$$reportNull$$$0(0);
        }
        return jestCoverageRunner;
    }

    @Nullable
    public ProjectData loadCoverageData(@NotNull File sessionDataFile, @Nullable CoverageSuite baseCoverageSuite) {
        Path baseDir;
        if (sessionDataFile == null) {
            JestCoverageRunner.$$$reportNull$$$0(1);
        }
        if ((baseDir = this.getBaseDir()) == null && (baseDir = CoverageProjectDataLoader.guessBaseDir(sessionDataFile.toPath(), baseCoverageSuite != null ? baseCoverageSuite.getProject() : null)) == null) {
            return null;
        }
        try {
            return CoverageProjectDataLoader.readProjectData(sessionDataFile.toPath(), baseDir, this.myTargetRun);
        }
        catch (Exception e) {
            LOG.warn("Can't read coverage data", (Throwable)e);
            return null;
        }
    }

    @Nullable
    private Path getBaseDir() {
        String basePath = this.myWorkingDirectory;
        if (basePath != null) {
            try {
                return Path.of(basePath, new String[0]);
            }
            catch (InvalidPathException e) {
                LOG.error("Invalid coverage basePath: " + basePath, (Throwable)e);
            }
        }
        return null;
    }

    @NotNull
    public String getPresentableName() {
        return "Jest Test Run";
    }

    @NotNull
    public String getId() {
        return "JestJavaScriptTestRunnerCoverage";
    }

    @NotNull
    public String getDataFileExtension() {
        return "info";
    }

    public boolean acceptsCoverageEngine(@NotNull CoverageEngine engine) {
        if (engine == null) {
            JestCoverageRunner.$$$reportNull$$$0(2);
        }
        return engine instanceof JestCoverageEngine;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/jest/coverage/JestCoverageRunner";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sessionDataFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "engine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/jest/coverage/JestCoverageRunner";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "loadCoverageData";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "acceptsCoverageEngine";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }
}

