/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.library.node_modules;

import com.google.common.collect.ImmutableSet;
import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.library.FileIndexExtensionRecursionGuard;
import com.intellij.javascript.nodejs.library.node_modules.NodeJsActivityKey;
import com.intellij.javascript.nodejs.library.node_modules.NodeModulesDirectoryChecker;
import com.intellij.javascript.nodejs.library.node_modules.NodeModulesDirectoryManagerState;
import com.intellij.javascript.nodejs.library.node_modules.NodeModulesFileListener;
import com.intellij.javascript.nodejs.library.node_modules.NodeModulesLibrariesSnapshot;
import com.intellij.javascript.nodejs.library.node_modules.NodeModulesLibraryDirectory;
import com.intellij.javascript.nodejs.library.node_modules.NodeModulesLibraryStat;
import com.intellij.javascript.nodejs.library.node_modules.NodeModulesPackageJsonListener;
import com.intellij.javascript.nodejs.library.node_modules.NodeModulesRequestMerger;
import com.intellij.javascript.nodejs.library.node_modules.workspaceModel.JsEntityHelperKt;
import com.intellij.javascript.nodejs.library.node_modules.workspaceModel.NodeModulesEntityUtil;
import com.intellij.javascript.nodejs.packageJson.PackageJsonFileManager;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.library.JSLibraryManager;
import com.intellij.lang.javascript.library.JSLibraryMappings;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.modules.NodeModuleUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.RootsChangeRescanningInfo;
import com.intellij.openapi.roots.AdditionalLibraryRootsListener;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.platform.backend.observation.ActivityKey;
import com.intellij.platform.backend.observation.TrackingUtil;
import com.intellij.platform.backend.workspace.WorkspaceModelChangeListener;
import com.intellij.platform.backend.workspace.WorkspaceModelTopics;
import com.intellij.platform.workspace.jps.entities.ContentRootEntity;
import com.intellij.platform.workspace.jps.entities.ExcludeUrlEntity;
import com.intellij.platform.workspace.jps.entities.RootsKt;
import com.intellij.platform.workspace.storage.VersionedStorageChange;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.serviceContainer.AlreadyDisposedException;
import com.intellij.util.Alarm;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

@Service(value={Service.Level.PROJECT})
@State(name="NodeModulesDirectoryManager", storages={@Storage(value="$CACHE_FILE$")})
public final class NodeModulesDirectoryManager
implements PersistentStateComponent<NodeModulesDirectoryManagerState>,
Disposable {
    static final Logger LOG = Logger.getInstance(NodeModulesDirectoryManager.class);
    private final Project myProject;
    private final Set<VirtualFile> myHandledNodeModulesDirs;
    private final Map<VirtualFile, Options> myNodeModulesDirsToOptions;
    private final CachedValue<Set<VirtualFile>> myContentRootsCachedValue;
    private final AtomicReference<NodeModulesLibrariesSnapshot> mySnapshotRef;
    private final Map<VirtualFile, PackageJsonData> myDataByPackageJsonMap;
    final ProjectFileIndex myFileIndex;
    private final PackageJsonFileManager myPackageJsonFileManager;
    private final List<NodeModulesPackageJsonListener> myNodeModulesPackageJsonListeners;
    private final SimpleModificationTracker myNodeModulesDirChangeTracker;
    private JSLibraryManager myLibraryManager;
    private final NodeModulesDirectoryChecker myDirectoryChecker;
    private final Map<VirtualFile, Options> myAddedInCurrentSessionNodeModulesMap;
    private final boolean myJsAwareProject;
    private final NodeModulesRequestMerger myUpdateRequestMerger;
    private final BlockingQueue<NodeModulesLibraryDirectory> myDirectoriesToUpdate;
    private final AtomicBoolean myAllLibrariesUpdateRequested;
    final Map<VirtualFile, NodeModulesLibraryStat> myLibraryStatByDirMap;

    public NodeModulesDirectoryManager(@NotNull Project project) {
        if (project == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(0);
        }
        this.myHandledNodeModulesDirs = ConcurrentCollectionFactory.createConcurrentSet();
        this.myNodeModulesDirsToOptions = new ConcurrentHashMap<VirtualFile, Options>();
        this.mySnapshotRef = new AtomicReference();
        this.myDataByPackageJsonMap = new ConcurrentHashMap<VirtualFile, PackageJsonData>();
        this.myNodeModulesPackageJsonListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myNodeModulesDirChangeTracker = new SimpleModificationTracker();
        this.myDirectoryChecker = new NodeModulesDirectoryChecker();
        this.myAddedInCurrentSessionNodeModulesMap = ContainerUtil.createConcurrentWeakMap();
        this.myDirectoriesToUpdate = new LinkedBlockingQueue<NodeModulesLibraryDirectory>();
        this.myAllLibrariesUpdateRequested = new AtomicBoolean(false);
        this.myLibraryStatByDirMap = new ConcurrentHashMap<VirtualFile, NodeModulesLibraryStat>();
        this.myProject = project;
        this.myFileIndex = ProjectFileIndex.getInstance((Project)project);
        this.myPackageJsonFileManager = PackageJsonFileManager.getInstance(project);
        this.myContentRootsCachedValue = NodeModulesDirectoryManager.createContentRootsCachedValue(project);
        if (!this.myProject.isDefault()) {
            final NodeModulesRequestMerger rootsChangedMerger = new NodeModulesRequestMerger(this, Alarm.ThreadToUse.POOLED_THREAD, 100L, () -> this.rootsChanged());
            this.myProject.getMessageBus().connect((Disposable)this).subscribe(WorkspaceModelTopics.CHANGED, (Object)new WorkspaceModelChangeListener(){

                public void changed(@NotNull VersionedStorageChange event) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (!event.getChanges(ContentRootEntity.class).isEmpty()) {
                        rootsChangedMerger.request();
                    }
                    if (event.getChanges(ExcludeUrlEntity.class).stream().map(o -> o.getNewEntity() == null ? (ExcludeUrlEntity)o.getOldEntity() : (ExcludeUrlEntity)o.getNewEntity()).filter(Objects::nonNull).map(o -> RootsKt.getContentRoot((ExcludeUrlEntity)o)).anyMatch(Objects::nonNull)) {
                        rootsChangedMerger.request();
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/javascript/nodejs/library/node_modules/NodeModulesDirectoryManager$1", "changed"));
                }
            });
            VirtualFileManager.getInstance().addAsyncFileListener((AsyncFileListener)new NodeModulesFileListener(project, this, this.myPackageJsonFileManager), (Disposable)this);
            this.addNodeModulesPackageJsonListener((pkgName, file, modType) -> this.myNodeModulesDirChangeTracker.incModificationCount(), null);
        }
        this.myJsAwareProject = !NodeModulesDirectoryManager.isIdeaProject(project);
        this.myUpdateRequestMerger = new NodeModulesRequestMerger(this, Alarm.ThreadToUse.POOLED_THREAD, 300L, () -> TrackingUtil.trackActivity((Project)project, (ActivityKey)NodeJsActivityKey.INSTANCE, () -> {
            List<NodeModulesLibraryDirectory> directories;
            if (this.myAllLibrariesUpdateRequested.compareAndSet(true, false)) {
                directories = this.buildNodeModulesDirectories();
                this.myDirectoriesToUpdate.clear();
            } else {
                LinkedHashSet<NodeModulesLibraryDirectory> copy = new LinkedHashSet<NodeModulesLibraryDirectory>();
                this.myDirectoriesToUpdate.drainTo(copy);
                directories = NodeModulesDirectoryManager.getLibrariesWithDescendants(copy);
            }
            JsEntityHelperKt.updateNodeModulesLibraryEntities(directories, this.myProject);
        }));
    }

    @NotNull
    public VirtualFile getSymlinkSourceDependencyFile(@NotNull VirtualFile symlinkTargetDependencyFile, @NotNull VirtualFile contextFile) {
        NodeModulesLibrariesSnapshot snapshot;
        NodeModulesLibraryDirectory libraryDir;
        if (symlinkTargetDependencyFile == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(1);
        }
        if (contextFile == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(2);
        }
        NodeModulesLibraryDirectory nodeModulesLibraryDirectory = libraryDir = (snapshot = this.mySnapshotRef.get()) != null ? snapshot.findUpLibraryDirectory(contextFile) : null;
        if (libraryDir != null) {
            VirtualFile virtualFile = libraryDir.getSymlinkSource(symlinkTargetDependencyFile);
            if (virtualFile == null) {
                NodeModulesDirectoryManager.$$$reportNull$$$0(3);
            }
            return virtualFile;
        }
        VirtualFile virtualFile = symlinkTargetDependencyFile;
        if (virtualFile == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(4);
        }
        return virtualFile;
    }

    public static boolean isIdeaProject(@NotNull Project project) {
        if (project == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(5);
        }
        return ModuleManager.getInstance((Project)project).findModuleByName("intellij.idea.community.main") != null;
    }

    private void requestLibraryUpdate(@NotNull NodeModulesLibraryDirectory libraryDirectory) {
        if (libraryDirectory == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(6);
        }
        this.myDirectoriesToUpdate.add(libraryDirectory);
        this.myUpdateRequestMerger.request();
    }

    @NotNull
    private static CachedValue<Set<VirtualFile>> createContentRootsCachedValue(@NotNull Project project) {
        if (project == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(7);
        }
        CachedValue cachedValue = CachedValuesManager.getManager((Project)project).createCachedValue(() -> {
            Set excluded = (Set)ReadAction.compute(() -> {
                if (project.isDisposed()) {
                    return Collections.emptySet();
                }
                return ImmutableSet.copyOf((Object[])ProjectRootManager.getInstance((Project)project).getContentRoots());
            });
            return CachedValueProvider.Result.create((Object)excluded, (Object[])new Object[]{ProjectRootManager.getInstance((Project)project)});
        }, false);
        if (cachedValue == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(8);
        }
        return cachedValue;
    }

    private void rootsChanged() {
        this.myPackageJsonFileManager.rootsChanged();
        List nodeModulesForRemovalWithReason = (List)ReadAction.compute(() -> {
            if (this.myProject.isDisposed()) {
                return List.of();
            }
            Set<VirtualFile> excluded = this.collectProjectModelExcludeRoots();
            SmartList toRemove = new SmartList();
            for (VirtualFile dir : this.myHandledNodeModulesDirs) {
                if (!dir.isValid()) {
                    toRemove.add(Pair.create((Object)dir, (Object)"invalid directory"));
                    continue;
                }
                VirtualFile contentRoot = JSLibraryUtil.getContentRootForFile(this.myProject, dir);
                Options options = this.myNodeModulesDirsToOptions.get(dir);
                if (options != null && options.isEnabledOutsideOfContentRoots()) continue;
                if (contentRoot == null) {
                    toRemove.add(Pair.create((Object)dir, (Object)"out of content roots"));
                    continue;
                }
                if (dir.equals(contentRoot)) {
                    toRemove.add(Pair.create((Object)dir, (Object)"no library if node_modules is a content root"));
                    continue;
                }
                VirtualFile parent = dir.getParent();
                if ((parent == null || !this.myFileIndex.isExcluded(parent)) && !excluded.contains(dir)) continue;
                toRemove.add(Pair.create((Object)dir, (Object)"under excluded roots"));
            }
            return toRemove;
        });
        if (!nodeModulesForRemovalWithReason.isEmpty()) {
            for (Pair info : nodeModulesForRemovalWithReason) {
                this.myHandledNodeModulesDirs.remove(info.first);
                LOG.info("Removed " + ((VirtualFile)info.first).getPath() + ": " + (String)info.second);
            }
            this.resetSnapshot();
            if (NodeModulesDirectoryManager.shouldUseWorkspaceModel()) {
                JsEntityHelperKt.removeNodeModules(this.myProject, ContainerUtil.mapNotNull((Collection)nodeModulesForRemovalWithReason, pair -> (VirtualFile)pair.getFirst()));
            } else if (ApplicationManager.getApplication().isUnitTestMode()) {
                ApplicationManager.getApplication().invokeLater(() -> this.requestLibrariesUpdate(RootsChangeRescanningInfo.RESCAN_DEPENDENCIES_IF_NEEDED), this.myProject.getDisposed());
            } else {
                this.requestLibrariesUpdate(RootsChangeRescanningInfo.RESCAN_DEPENDENCIES_IF_NEEDED);
            }
        }
    }

    @NotNull
    private Set<VirtualFile> collectProjectModelExcludeRoots() {
        HashSet<VirtualFile> dirs = new HashSet<VirtualFile>();
        for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
            ContainerUtil.addAll(dirs, (Object[])ModuleRootManager.getInstance((Module)module).getExcludeRoots());
        }
        HashSet<VirtualFile> hashSet = dirs;
        if (hashSet == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(9);
        }
        return hashSet;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(10);
        }
        return project;
    }

    public boolean isForApplicationSourceCode(@NotNull VirtualFile nodeModulesDir) {
        if (nodeModulesDir == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(11);
        }
        return this.myDirectoryChecker.isForApplicationSourceCode(nodeModulesDir);
    }

    void incNodeModulesDirChangeTracker() {
        this.myNodeModulesDirChangeTracker.incModificationCount();
    }

    @NotNull
    public ModificationTracker getNodeModulesDirChangeTracker() {
        SimpleModificationTracker simpleModificationTracker = this.myNodeModulesDirChangeTracker;
        if (simpleModificationTracker == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(12);
        }
        return simpleModificationTracker;
    }

    @Nullable
    <T> T computeFileIndexExtensionPreventingRecursion(@NotNull ThrowableComputable<T, RuntimeException> computation) {
        if (computation == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(13);
        }
        FileIndexExtensionRecursionGuard guard = FileIndexExtensionRecursionGuard.getInstance(this.myProject);
        return guard.computeFileIndexExtensionPreventingRecursion(NodeModulesDirectoryManager.class, computation);
    }

    @NotNull
    public static NodeModulesDirectoryManager getInstance(@NotNull Project project) {
        if (project == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(14);
        }
        NodeModulesDirectoryManager nodeModulesDirectoryManager = (NodeModulesDirectoryManager)project.getService(NodeModulesDirectoryManager.class);
        if (nodeModulesDirectoryManager == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(15);
        }
        return nodeModulesDirectoryManager;
    }

    @NotNull
    public NodeModulesDirectoryManagerState getState() {
        NodeModulesDirectoryManagerState nodeModulesDirectoryManagerState = NodeModulesDirectoryManagerState.getState(this.myHandledNodeModulesDirs, (Function1<? super VirtualFile, Boolean>)((Function1)nodeModulesDir -> ((Options)ObjectUtils.notNull((Object)this.myAddedInCurrentSessionNodeModulesMap.get(nodeModulesDir), (Object)Options.DEFAULT)).isEnabledOutsideOfContentRoots()));
        if (nodeModulesDirectoryManagerState == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(16);
        }
        return nodeModulesDirectoryManagerState;
    }

    public void loadState(@NotNull NodeModulesDirectoryManagerState state) {
        if (state == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(17);
        }
        Map<VirtualFile, Options> map2 = NodeModulesDirectoryManagerState.convertStateToMap(state);
        this.incNodeModulesDirChangeTracker();
        this.myHandledNodeModulesDirs.clear();
        Set<VirtualFile> nodeModulesDirs = map2.keySet();
        if (!nodeModulesDirs.isEmpty()) {
            List expectedExcludedNodeModulesDirs = ContainerUtil.filter(nodeModulesDirs, d -> !this.isForApplicationSourceCode((VirtualFile)d));
            if (JsEntityHelperKt.listFoldersExcludedByModel(this.myProject).containsAll(expectedExcludedNodeModulesDirs)) {
                this.myHandledNodeModulesDirs.addAll(nodeModulesDirs);
            } else {
                LOG.info(NodeModulesDirectoryManager.class.getSimpleName() + " cache has been reset");
            }
        }
        this.myNodeModulesDirsToOptions.clear();
        this.myNodeModulesDirsToOptions.putAll(map2);
    }

    public void addNodeModulesPackageJsonListener(final @NotNull NodeModulesPackageJsonListener listener2, @Nullable Disposable disposable) {
        if (listener2 == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(18);
        }
        this.myNodeModulesPackageJsonListeners.add(listener2);
        if (disposable != null) {
            Disposer.register((Disposable)disposable, (Disposable)new Disposable(){

                public void dispose() {
                    NodeModulesDirectoryManager.this.removeNodeModulesPackageJsonListener(listener2);
                }
            });
        }
    }

    public void removeNodeModulesPackageJsonListener(@NotNull NodeModulesPackageJsonListener listener2) {
        if (listener2 == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(19);
        }
        this.myNodeModulesPackageJsonListeners.remove(listener2);
    }

    @Deprecated(forRemoval=true)
    public @Unmodifiable @NotNull List<NodeModulesLibraryDirectory> getNodeModulesDirectories() {
        List list = ContainerUtil.filter(this.getOrCreateSnapshot().getLibraryDirs(), dir -> dir.getNodeModulesDir().isValid());
        if (list == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(20);
        }
        return list;
    }

    @Unmodifiable @NotNull List<NodeModulesLibraryDirectory> buildNodeModulesDirectories() {
        List list = ContainerUtil.filter(this.getOrCreateSnapshot().getLibraryDirs(), dir -> dir.getNodeModulesDir().isValid());
        if (list == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(21);
        }
        return list;
    }

    public @Unmodifiable @NotNull List<VirtualFile> getNodeModulesDirs() {
        List list = ContainerUtil.filter(this.myHandledNodeModulesDirs, dir -> dir.isValid());
        if (list == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(22);
        }
        return list;
    }

    public boolean isNodeModulesLibraryDirWithMappings(@NotNull VirtualFile nodeModulesDir) {
        NodeModulesLibraryDirectory dir;
        if (nodeModulesDir == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(23);
        }
        return (dir = this.getOrCreateSnapshot().findLibraryDir(nodeModulesDir)) != null && !dir.isForApplicationSourceCode() && this.isLibraryWithMappings(dir);
    }

    public boolean isLibraryWithMappings(@NotNull NodeModulesLibraryDirectory libraryDirectory) {
        JSLibraryMappings mappings;
        if (libraryDirectory == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(24);
        }
        return !(mappings = this.getLibraryMappings()).getMappingsByLibraryName(libraryDirectory.getLibraryName()).isEmpty();
    }

    @NotNull
    private JSLibraryMappings getLibraryMappings() {
        JSLibraryMappings jSLibraryMappings = (JSLibraryMappings)this.getLibraryManager().getLibraryMappings();
        if (jSLibraryMappings == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(25);
        }
        return jSLibraryMappings;
    }

    @Contract(value="null -> false")
    public static boolean isNodeModulesDir(@Nullable VirtualFile dir) {
        return dir != null && dir.isDirectory() && NodeModulesDirectoryManager.isNodeModulesDirName(dir.getNameSequence());
    }

    public static boolean isNodeModulesDirName(@Nullable CharSequence fileName) {
        return fileName != null && StringUtil.equals((CharSequence)"node_modules", (CharSequence)fileName);
    }

    @Nullable
    private VirtualFile findTopLevelNodeModulesDirInsideContentRoots(@Nullable VirtualFile nodeModulesDir) {
        VirtualFile result2 = null;
        while (nodeModulesDir != null && this.myFileIndex.getContentRootForFile(nodeModulesDir, false) != null) {
            result2 = nodeModulesDir;
            nodeModulesDir = NodeModuleSearchUtil.findAncestorNodeModulesDir(nodeModulesDir);
        }
        return result2;
    }

    private void doAddNodeModulesDirs(@NotNull List<VirtualFile> nodeModulesDirs, @NotNull Options options) {
        if (nodeModulesDirs == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(26);
        }
        if (options == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(27);
        }
        SmartList dirsToProcess = new SmartList();
        for (VirtualFile nodeModulesDir : nodeModulesDirs) {
            this.myAddedInCurrentSessionNodeModulesMap.put(nodeModulesDir, options);
            if (!this.myHandledNodeModulesDirs.add(nodeModulesDir)) continue;
            this.myNodeModulesDirsToOptions.put(nodeModulesDir, options);
            dirsToProcess.add(nodeModulesDir);
        }
        if (dirsToProcess.isEmpty()) {
            return;
        }
        this.incNodeModulesDirChangeTracker();
        if (NodeModulesDirectoryManager.shouldUseWorkspaceModel()) {
            JsEntityHelperKt.addExcludeEntities(this.myProject, (List<? extends VirtualFile>)dirsToProcess);
        }
        this.createLibraries((List<VirtualFile>)dirsToProcess);
        for (VirtualFile dir : dirsToProcess) {
            this.notifyNodeModulesDirectoryChanged(dir, NodeModulesPackageJsonListener.ChangeType.ADDED);
        }
    }

    void createLibraries(@NotNull List<VirtualFile> nodeModulesDirs) {
        if (nodeModulesDirs == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(28);
        }
        Runnable r = () -> {
            try {
                this.createLibrary(nodeModulesDirs);
            }
            catch (AlreadyDisposedException e) {
                if (!this.myProject.isDisposed()) {
                    throw e;
                }
                LOG.info("Failed to calculate libraries due to disposed project: " + String.valueOf(nodeModulesDirs));
            }
        };
        Application application = ApplicationManager.getApplication();
        if (application.isUnitTestMode() || !application.isDispatchThread() && !application.isReadAccessAllowed()) {
            r.run();
        } else {
            application.executeOnPooledThread(r);
        }
    }

    private void createLibrary(@NotNull List<VirtualFile> nodeModulesDirs) {
        if (nodeModulesDirs == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(29);
        }
        this.resetSnapshot();
        NodeModulesLibrariesSnapshot snapshot = this.getOrCreateSnapshot();
        List libraryDirectories = ContainerUtil.mapNotNull(nodeModulesDirs, snapshot::findLibraryDir);
        List<NodeModulesLibraryDirectory> libraryDirectoriesWithDescendants = NodeModulesDirectoryManager.getLibrariesWithDescendants(libraryDirectories);
        for (NodeModulesLibraryDirectory libraryDirectory : libraryDirectoriesWithDescendants) {
            libraryDirectory.getLibrary();
        }
        if (NodeModulesDirectoryManager.shouldUseWorkspaceModel()) {
            JsEntityHelperKt.addLibraryEntities(this.myProject, libraryDirectoriesWithDescendants);
        }
        NodeModulesEntityUtil.INSTANCE.invokeUnderWriteAction(this.myProject, () -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            JSLibraryManager libraryManager = this.getLibraryManager();
            libraryManager.commitChanges(null);
            for (VirtualFile nodeModulesDir : nodeModulesDirs) {
                String libraryName = snapshot.findLibraryName(nodeModulesDir);
                if (libraryName == null) {
                    LOG.warn("No library name calculated for " + nodeModulesDir.getPath());
                    continue;
                }
                List mappings = ContainerUtil.createMaybeSingletonList((Object)nodeModulesDir.getParent());
                if (!mappings.isEmpty()) {
                    if (libraryManager.getLibraryByName(libraryName) == null) {
                        LOG.warn("Cannot find library by name " + libraryName + ", " + nodeModulesDir.getPath());
                        continue;
                    }
                    for (VirtualFile mapping : mappings) {
                        libraryManager.getLibraryMappings().associate(mapping, libraryName, true);
                    }
                }
                LOG.info("Associate " + libraryName + " with " + String.valueOf(mappings));
            }
            if (!NodeModulesDirectoryManager.shouldUseWorkspaceModel()) {
                String addedNodeModulesPaths = StringUtil.join((Collection)ContainerUtil.map((Collection)nodeModulesDirs, dir -> dir.getPath()), (String)",");
                libraryManager.commitChangesWithReason(RootsChangeRescanningInfo.RESCAN_DEPENDENCIES_IF_NEEDED, "adding " + nodeModulesDirs.size() + " " + StringUtil.pluralize((String)"library", (int)nodeModulesDirs.size()) + ": " + addedNodeModulesPaths);
                AdditionalLibraryRootsListener.fireAdditionalLibraryChanged((Project)this.myProject, (String)"node_modules", List.of((VirtualFile)nodeModulesDirs.get(0)), List.of(), (String)"node_modules");
            }
        });
    }

    @NotNull
    private static List<NodeModulesLibraryDirectory> getLibrariesWithDescendants(@NotNull Collection<NodeModulesLibraryDirectory> dirs) {
        if (dirs == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(30);
        }
        List list = dirs.stream().flatMap(directory -> directory.getThisAndDescendants().stream()).toList();
        List<NodeModulesLibraryDirectory> list2 = new LinkedHashSet(list).stream().toList();
        if (list2 == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(31);
        }
        return list2;
    }

    @NotNull
    private NodeModulesLibrariesSnapshot getOrCreateSnapshot() {
        NodeModulesLibrariesSnapshot snapshot = this.mySnapshotRef.get();
        while (snapshot == null) {
            snapshot = new NodeModulesLibrariesSnapshot(this, this.myHandledNodeModulesDirs, this.myPackageJsonFileManager.getValidPackageJsonFiles());
            this.mySnapshotRef.compareAndSet(null, snapshot);
            snapshot = this.mySnapshotRef.get();
        }
        NodeModulesLibrariesSnapshot nodeModulesLibrariesSnapshot = snapshot;
        if (nodeModulesLibrariesSnapshot == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(32);
        }
        return nodeModulesLibrariesSnapshot;
    }

    private void resetSnapshot() {
        this.incNodeModulesDirChangeTracker();
        this.mySnapshotRef.set(null);
    }

    public void setProvidedPackageJsonRoots(@NotNull VirtualFile packageJson, @NotNull PackageJsonData data) {
        if (packageJson == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(33);
        }
        if (data == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(34);
        }
        this.myDataByPackageJsonMap.put(packageJson, data);
    }

    void handleAddingPackageJson(@NotNull VirtualFile packageJson) {
        if (packageJson == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(35);
        }
        if (PackageJsonUtil.isPackageJsonFile(packageJson)) {
            this.myPackageJsonFileManager.onPackageJsonAdded(packageJson);
            this.handleNodeModulesPackageJsonChange(packageJson, NodeModulesPackageJsonListener.ChangeType.ADDED);
            this.addOrUpdateLibraryByPackageJson(packageJson);
        }
    }

    private void addOrUpdateLibraryByPackageJson(@NotNull VirtualFile packageJson) {
        VirtualFile nodeModulesDir;
        if (packageJson == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(36);
        }
        if ((nodeModulesDir = NodeModuleUtil.findNodeModulesByPackageJson(packageJson)) != null && nodeModulesDir.isValid()) {
            this.addOrUpdateLibrary(nodeModulesDir);
        }
    }

    private void addOrUpdateLibrary(@NotNull VirtualFile nodeModulesDir) {
        NodeModulesLibraryDirectory libraryDir;
        if (nodeModulesDir == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(37);
        }
        if ((libraryDir = this.getOrCreateSnapshot().findLibraryDir(nodeModulesDir)) == null) {
            this.addNodeModulesDir(nodeModulesDir);
        } else if (NodeModulesDirectoryManager.shouldUseWorkspaceModel()) {
            if (!this.myFileIndex.isExcluded(nodeModulesDir)) {
                JsEntityHelperKt.addExcludeEntities(this.myProject, List.of(nodeModulesDir));
                this.createLibraries(List.of(nodeModulesDir));
            } else {
                this.requestLibraryUpdate(libraryDir);
            }
        } else {
            this.requestLibrariesUpdate();
        }
    }

    void handleRemovingPackageJson(@NotNull VirtualFile packageJson) {
        if (packageJson == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(38);
        }
        if (PackageJsonUtil.isPackageJsonFile(packageJson)) {
            this.doRemovePackageJson(packageJson, null);
        }
    }

    void doRemovePackageJson(@NotNull VirtualFile packageJson, @Nullable VirtualFile packageJsonParent) {
        if (packageJson == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(39);
        }
        this.myPackageJsonFileManager.onPackageJsonRemoved(packageJson);
        this.handleNodeModulesPackageJsonChange(packageJson, NodeModulesPackageJsonListener.ChangeType.REMOVED);
        if (this.myDataByPackageJsonMap.remove(packageJson) != null) {
            VirtualFile nodeModulesDir;
            VirtualFile virtualFile = nodeModulesDir = packageJsonParent != null ? NodeModuleUtil.findChildNodeModulesDir(packageJsonParent) : NodeModuleUtil.findNodeModulesByPackageJson(packageJson);
            if (nodeModulesDir != null && nodeModulesDir.isValid()) {
                LOG.info("Removing node_modules library as " + packageJson.getPath() + " removed");
                if (NodeModulesDirectoryManager.shouldUseWorkspaceModel()) {
                    NodeModulesLibraryDirectory libraryDir = this.getOrCreateSnapshot().findLibraryDir(nodeModulesDir);
                    if (libraryDir != null) {
                        if (libraryDir.isForApplicationSourceCode()) {
                            JsEntityHelperKt.removeNodeModules(this.myProject, List.of(nodeModulesDir));
                        }
                        this.requestLibraryUpdate(libraryDir);
                    }
                } else {
                    this.myHandledNodeModulesDirs.remove(nodeModulesDir);
                    this.resetSnapshot();
                    this.requestLibrariesUpdate(RootsChangeRescanningInfo.TOTAL_RESCAN);
                }
            }
        }
    }

    void handlePackageJsonContentChanged(@NotNull VirtualFile packageJson) {
        if (packageJson == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(40);
        }
        if (PackageJsonUtil.isPackageJsonFile(packageJson) && !this.myProject.isDisposed()) {
            PackageJsonData newData;
            PackageJsonData oldData;
            this.myPackageJsonFileManager.onPackageJsonContentChanged(packageJson);
            this.handleNodeModulesPackageJsonChange(packageJson, NodeModulesPackageJsonListener.ChangeType.CONTENT_CHANGED);
            NodeModulesLibrariesSnapshot snapshot = this.mySnapshotRef.get();
            if (snapshot != null) {
                snapshot.onPackageJsonFileChanged(packageJson);
            }
            if ((oldData = this.myDataByPackageJsonMap.get(packageJson)) != null && !(newData = PackageJsonData.getOrCreate(packageJson)).getAllDependencies().equals(oldData.getAllDependencies())) {
                LOG.info("Updating node_modules library as " + packageJson.getPath() + " changed");
                this.myDataByPackageJsonMap.put(packageJson, newData);
                this.addOrUpdateLibraryByPackageJson(packageJson);
            }
        }
    }

    private void handleNodeModulesPackageJsonChange(VirtualFile packageJson, NodeModulesPackageJsonListener.ChangeType changeType) {
        String packageName = NodeModuleUtil.inferNodeModulePackageName(packageJson);
        if (packageName != null) {
            this.invokeListeners(listener2 -> listener2.onPackageJsonChanged(packageName, packageJson, changeType));
        }
    }

    private void notifyNodeModulesDirectoryChanged(@NotNull VirtualFile nodeModules, @NotNull NodeModulesPackageJsonListener.ChangeType changeType) {
        if (nodeModules == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(41);
        }
        if (changeType == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(42);
        }
        this.invokeListeners(listener2 -> listener2.onNodeModulesDirectoryChanged(nodeModules, changeType));
    }

    private void invokeListeners(Consumer<NodeModulesPackageJsonListener> listenerInvoker) {
        for (NodeModulesPackageJsonListener listener2 : this.myNodeModulesPackageJsonListeners) {
            try {
                listenerInvoker.accept(listener2);
            }
            catch (ProcessCanceledException ex) {
                LOG.error("Listener " + String.valueOf(listener2) + " invoked code, which threw ProcessCanceledException.Listeners should not invoke long running operations on notification thread.", (Throwable)ex);
            }
            catch (RuntimeException ex) {
                LOG.error("Listener " + String.valueOf(listener2) + " failed to process notification: " + ex.getMessage(), (Throwable)ex);
            }
        }
    }

    boolean hasDirectoriesToProcess() {
        return !this.myDirectoriesToUpdate.isEmpty();
    }

    void handleAddingNodeModulesDir(@NotNull VirtualFile file) {
        if (file == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(43);
        }
        if (NodeModulesDirectoryManager.isNodeModulesDir(file) && !this.myProject.isDisposed()) {
            this.addNodeModulesDir(file);
        }
    }

    public void addNodeModulesDir(@NotNull VirtualFile nodeModulesDir) {
        if (nodeModulesDir == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(44);
        }
        this.addNodeModulesDirs(List.of(nodeModulesDir));
    }

    public void addNodeModulesDirs(@NotNull List<VirtualFile> nodeModulesDirs) {
        if (nodeModulesDirs == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(45);
        }
        this.addNodeModulesDirs(nodeModulesDirs, Options.DEFAULT);
    }

    public void addNodeModulesDirs(@NotNull List<VirtualFile> nodeModulesDirs, @NotNull Options options) {
        if (nodeModulesDirs == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(46);
        }
        if (options == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(47);
        }
        List filtered = ContainerUtil.filter(nodeModulesDirs, nodeModulesDir -> this.canAddNodeModulesDir((VirtualFile)nodeModulesDir, options));
        this.doAddNodeModulesDirs(filtered, options);
    }

    public boolean canAddNodeModulesDir(@NotNull VirtualFile nodeModulesDir) {
        if (nodeModulesDir == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(48);
        }
        return this.canAddNodeModulesDir(nodeModulesDir, Options.DEFAULT);
    }

    public boolean canAddNodeModulesDir(@NotNull VirtualFile nodeModulesDir, @NotNull Options options) {
        if (nodeModulesDir == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(49);
        }
        if (options == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(50);
        }
        if (!nodeModulesDir.isValid()) {
            return false;
        }
        if (options.isEnabledOutsideOfContentRoots()) {
            return this.myJsAwareProject;
        }
        VirtualFile topLevelNodeModulesDir = this.findTopLevelNodeModulesDirInsideContentRoots(nodeModulesDir);
        if (topLevelNodeModulesDir == null || !nodeModulesDir.equals(topLevelNodeModulesDir) || !this.myFileIndex.isInContent(nodeModulesDir) || this.myFileIndex.isInLibrary(nodeModulesDir)) {
            return false;
        }
        VirtualFile contentRoot = this.myFileIndex.getContentRootForFile(nodeModulesDir, false);
        return contentRoot != null && this.myJsAwareProject && !topLevelNodeModulesDir.equals(contentRoot) && !this.myDirectoryChecker.isForApplicationSourceCode(nodeModulesDir);
    }

    public boolean isAdded(@NotNull VirtualFile nodeModulesDir) {
        if (nodeModulesDir == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(51);
        }
        return this.myHandledNodeModulesDirs.contains(nodeModulesDir);
    }

    void handleRemovingNodeModulesDir(@NotNull VirtualFile dir) {
        if (dir == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(52);
        }
        SmartList toRemove = new SmartList();
        for (VirtualFile nodeModulesDir : this.myHandledNodeModulesDirs) {
            if (!nodeModulesDir.isValid()) {
                toRemove.add(Pair.create((Object)nodeModulesDir, (Object)"invalid directory"));
                continue;
            }
            if (!VfsUtilCore.isAncestor((VirtualFile)dir, (VirtualFile)nodeModulesDir, (boolean)false)) continue;
            toRemove.add(Pair.create((Object)nodeModulesDir, (Object)"ancestor removed"));
        }
        if (!toRemove.isEmpty()) {
            for (Pair pair2 : toRemove) {
                this.myHandledNodeModulesDirs.remove(pair2.first);
                LOG.info("Removing " + String.valueOf(pair2.first) + ": " + (String)pair2.second);
            }
            this.resetSnapshot();
            if (NodeModulesDirectoryManager.shouldUseWorkspaceModel()) {
                JsEntityHelperKt.removeNodeModules(this.myProject, ContainerUtil.map((Collection)toRemove, pair -> (VirtualFile)pair.first));
            } else {
                this.requestLibrariesUpdate(RootsChangeRescanningInfo.TOTAL_RESCAN);
            }
            for (Pair pair2 : toRemove) {
                this.notifyNodeModulesDirectoryChanged((VirtualFile)pair2.first, NodeModulesPackageJsonListener.ChangeType.REMOVED);
            }
        }
    }

    private void requestLibrariesUpdate(@NotNull RootsChangeRescanningInfo info) {
        if (info == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(53);
        }
        this.getLibraryManager().scheduleCommitChanges(info);
    }

    public void requestLibrariesUpdate() {
        this.incNodeModulesDirChangeTracker();
        if (NodeModulesDirectoryManager.shouldUseWorkspaceModel()) {
            this.myAllLibrariesUpdateRequested.set(true);
            this.myUpdateRequestMerger.request();
        } else {
            this.resetSnapshot();
            this.requestLibrariesUpdate(RootsChangeRescanningInfo.RESCAN_DEPENDENCIES_IF_NEEDED);
        }
    }

    @NotNull
    private JSLibraryManager getLibraryManager() {
        JSLibraryManager libraryManager = this.myLibraryManager;
        if (libraryManager == null) {
            this.myLibraryManager = libraryManager = (JSLibraryManager)((Object)ReadAction.compute(() -> JSLibraryManager.getInstance(this.myProject)));
        }
        JSLibraryManager jSLibraryManager = libraryManager;
        if (jSLibraryManager == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(54);
        }
        return jSLibraryManager;
    }

    public boolean isUnderContentRoots(@NotNull VirtualFile file) {
        if (file == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(55);
        }
        return VfsUtilCore.isUnder((VirtualFile)file, (Set)((Set)this.myContentRootsCachedValue.getValue()));
    }

    public void dispose() {
    }

    @Nullable
    NodeModulesLibraryDirectory findUpNodeModules(@Nullable VirtualFile file) {
        NodeModulesLibrariesSnapshot snapshot = file != null ? this.mySnapshotRef.get() : null;
        return snapshot != null ? snapshot.findNodeModulesDirectoryByTopLevelDependentFile(file) : null;
    }

    void onFileCreatedOrDeleted(@NotNull VirtualFile file) {
        NodeModulesLibraryDirectory nodeModulesDir;
        if (file == null) {
            NodeModulesDirectoryManager.$$$reportNull$$$0(56);
        }
        if ((nodeModulesDir = this.findUpNodeModules(file.getParent())) != null) {
            if (NodeModulesDirectoryManager.shouldUseWorkspaceModel()) {
                this.requestLibraryUpdate(nodeModulesDir);
            } else if (file.isDirectory()) {
                this.resetSnapshot();
                this.requestLibrariesUpdate(RootsChangeRescanningInfo.RESCAN_DEPENDENCIES_IF_NEEDED);
            } else {
                nodeModulesDir.invalidateRoots();
            }
        }
    }

    public static boolean shouldUseWorkspaceModel() {
        return Registry.is((String)"node_modules.use.workspace.model", (boolean)true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 8, 9, 10, 12, 15, 16, 20, 21, 22, 25, 31, 32, 54 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symlinkTargetDependencyFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextFile";
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 15: 
            case 16: 
            case 20: 
            case 21: 
            case 22: 
            case 25: 
            case 31: 
            case 32: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/library/node_modules/NodeModulesDirectoryManager";
                break;
            }
            case 6: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryDirectory";
                break;
            }
            case 11: 
            case 23: 
            case 37: 
            case 44: 
            case 48: 
            case 49: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeModulesDir";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computation";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 26: 
            case 28: 
            case 29: 
            case 45: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeModulesDirs";
                break;
            }
            case 27: 
            case 47: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirs";
                break;
            }
            case 33: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageJson";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeModules";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeType";
                break;
            }
            case 43: 
            case 55: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/library/node_modules/NodeModulesDirectoryManager";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSymlinkSourceDependencyFile";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createContentRootsCachedValue";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "collectProjectModelExcludeRoots";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeModulesDirChangeTracker";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeModulesDirectories";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "buildNodeModulesDirectories";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeModulesDirs";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryMappings";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibrariesWithDescendants";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateSnapshot";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getSymlinkSourceDependencyFile";
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 15: 
            case 16: 
            case 20: 
            case 21: 
            case 22: 
            case 25: 
            case 31: 
            case 32: 
            case 54: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isIdeaProject";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "requestLibraryUpdate";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createContentRootsCachedValue";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isForApplicationSourceCode";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "computeFileIndexExtensionPreventingRecursion";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addNodeModulesPackageJsonListener";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "removeNodeModulesPackageJsonListener";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isNodeModulesLibraryDirWithMappings";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isLibraryWithMappings";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "doAddNodeModulesDirs";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "createLibraries";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "createLibrary";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getLibrariesWithDescendants";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "setProvidedPackageJsonRoots";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "handleAddingPackageJson";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "addOrUpdateLibraryByPackageJson";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "addOrUpdateLibrary";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "handleRemovingPackageJson";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "doRemovePackageJson";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "handlePackageJsonContentChanged";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "notifyNodeModulesDirectoryChanged";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "handleAddingNodeModulesDir";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "addNodeModulesDir";
                break;
            }
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "addNodeModulesDirs";
                break;
            }
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "canAddNodeModulesDir";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "isAdded";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "handleRemovingNodeModulesDir";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "requestLibrariesUpdate";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "isUnderContentRoots";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "onFileCreatedOrDeleted";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 8, 9, 10, 12, 15, 16, 20, 21, 22, 25, 31, 32, 54 -> new IllegalStateException(string);
        };
    }

    public static class Options {
        static final Options DEFAULT = new Options(false);
        private final boolean myEnabledOutsideOfContentRoots;

        public Options(boolean enabledOutsideOfContentRoots) {
            this.myEnabledOutsideOfContentRoots = enabledOutsideOfContentRoots;
        }

        boolean isEnabledOutsideOfContentRoots() {
            return this.myEnabledOutsideOfContentRoots;
        }
    }
}

