/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.library.node_modules.NodeModulesDirectoryManager;
import com.intellij.javascript.nodejs.library.node_modules.NodeModulesPackageJsonListener;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageRef;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.linter.AutodetectLinterPackage;
import com.intellij.lang.javascript.linter.JsLinterManagerListener;
import com.intellij.lang.javascript.service.JSLanguageServiceBase;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MultiRootJSLinterLanguageServiceManager<TService extends JSLanguageServiceBase>
implements Disposable {
    protected static final Logger LOG = Logger.getInstance(MultiRootJSLinterLanguageServiceManager.class);
    protected final Project myProject;
    private final EventDispatcher<JsLinterManagerListener> myEventDispatcher;
    @NotNull
    private final Set<ServiceInfo<TService>> myActiveServices;
    @NotNull
    private final ConcurrentHashMap<Location, ServiceInfo<TService>> myServices;
    @NotNull
    private final String myPackageName;

    public MultiRootJSLinterLanguageServiceManager(@NotNull Project project, @NotNull String packageName) {
        if (project == null) {
            MultiRootJSLinterLanguageServiceManager.$$$reportNull$$$0(0);
        }
        if (packageName == null) {
            MultiRootJSLinterLanguageServiceManager.$$$reportNull$$$0(1);
        }
        this.myEventDispatcher = EventDispatcher.create(JsLinterManagerListener.class);
        this.myActiveServices = ConcurrentCollectionFactory.createConcurrentSet();
        this.myServices = new ConcurrentHashMap();
        this.myProject = project;
        this.myPackageName = packageName;
        NodeModulesDirectoryManager.getInstance(project).addNodeModulesPackageJsonListener((changedPackageName, packageJson, changeType) -> {
            if (StringUtil.equals((CharSequence)changedPackageName, (CharSequence)this.myPackageName)) {
                this.handlePackageJsonChanged(packageJson, changeType);
            }
        }, this);
        project.getMessageBus().connect((Disposable)this).subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            public void after(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
                if (events == null) {
                    1.$$$reportNull$$$0(0);
                }
                for (VFileEvent vFileEvent : events) {
                    if (!(vFileEvent instanceof VFileDeleteEvent) && !MultiRootJSLinterLanguageServiceManager.isRenameFileEvent(vFileEvent)) continue;
                    MultiRootJSLinterLanguageServiceManager.this.handleContainingDirectoryChanged(vFileEvent);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/lang/javascript/linter/MultiRootJSLinterLanguageServiceManager$1", "after"));
            }
        });
    }

    public void addJsLinterManagerListener(@NotNull JsLinterManagerListener listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            MultiRootJSLinterLanguageServiceManager.$$$reportNull$$$0(2);
        }
        if (parentDisposable == null) {
            MultiRootJSLinterLanguageServiceManager.$$$reportNull$$$0(3);
        }
        this.myEventDispatcher.addListener((EventListener)listener2, parentDisposable);
    }

    private void handleContainingDirectoryChanged(@NotNull VFileEvent event) {
        if (event == null) {
            MultiRootJSLinterLanguageServiceManager.$$$reportNull$$$0(4);
        }
        String changed = event.getPath();
        for (Map.Entry<Location, ServiceInfo<TService>> entry : this.myServices.entrySet()) {
            String packagePath = entry.getKey().nodePackage.getSystemIndependentPath();
            if (!FileUtil.isAncestor((String)changed, (String)packagePath, (boolean)false)) continue;
            MultiRootJSLinterLanguageServiceManager.markAsDeleted(entry.getValue(), packagePath, String.format("VFS event %s", event));
            this.jsLinterStateChanged();
        }
    }

    private void handlePackageJsonChanged(@NotNull VirtualFile packageJson, @NotNull NodeModulesPackageJsonListener.ChangeType changeType) {
        VirtualFile packageDir;
        if (packageJson == null) {
            MultiRootJSLinterLanguageServiceManager.$$$reportNull$$$0(5);
        }
        if (changeType == null) {
            MultiRootJSLinterLanguageServiceManager.$$$reportNull$$$0(6);
        }
        String changedPackagePath = (packageDir = packageJson.getParent()) != null ? packageDir.getPath() : null;
        for (Map.Entry<Location, ServiceInfo<TService>> entry : this.myServices.entrySet()) {
            String packagePath = entry.getKey().nodePackage.getSystemIndependentPath();
            if (!StringUtil.equals((CharSequence)changedPackagePath, (CharSequence)packagePath)) continue;
            MultiRootJSLinterLanguageServiceManager.markAsDeleted(entry.getValue(), packagePath, String.format("package.json was %s", new Object[]{changeType}));
            this.jsLinterStateChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <TResult, TThrowable extends Throwable> TResult useService(@NotNull VirtualFile virtualFile, @NotNull NodePackageRef storedPackage, @NotNull Callback<? super TService, TResult, TThrowable> callback) throws TThrowable {
        ServiceInfo serviceInfo;
        if (virtualFile == null) {
            MultiRootJSLinterLanguageServiceManager.$$$reportNull$$$0(7);
        }
        if (storedPackage == null) {
            MultiRootJSLinterLanguageServiceManager.$$$reportNull$$$0(8);
        }
        if (callback == null) {
            MultiRootJSLinterLanguageServiceManager.$$$reportNull$$$0(9);
        }
        if ((serviceInfo = (ServiceInfo)ReadAction.compute(() -> this.acquireService(virtualFile, storedPackage))) != null) {
            this.myActiveServices.add(serviceInfo);
        }
        try {
            JSLanguageServiceBase service = serviceInfo != null ? (JSLanguageServiceBase)serviceInfo.service : null;
            TResult TResult = callback.fun(service);
            return TResult;
        }
        finally {
            if (serviceInfo != null) {
                this.myActiveServices.remove(serviceInfo);
            }
        }
    }

    @Nullable
    private ServiceInfo<TService> acquireService(@NotNull VirtualFile virtualFile, @NotNull NodePackageRef storedPackage) {
        NodePackage resolvedPackage;
        if (virtualFile == null) {
            MultiRootJSLinterLanguageServiceManager.$$$reportNull$$$0(10);
        }
        if (storedPackage == null) {
            MultiRootJSLinterLanguageServiceManager.$$$reportNull$$$0(11);
        }
        if ((resolvedPackage = AutodetectLinterPackage.resolve(storedPackage, this.myProject, virtualFile, this.myPackageName, (Processor<? super VirtualFile>)((Processor)packageJson -> this.hasLinterSpecificConfiguration((VirtualFile)packageJson)))) == null) {
            return null;
        }
        VirtualFile workingDirectory = this.getWorkingDirectory(resolvedPackage, this.myProject, virtualFile);
        this.terminateUnusedServices();
        Ref serviceCreated = Ref.create((Object)false);
        ServiceInfo service = this.myServices.computeIfAbsent(new Location(resolvedPackage, workingDirectory), location -> {
            LOG.debug(String.format("Creating new service for path %s", location.nodePackage.getSystemDependentPath()));
            serviceCreated.set((Object)true);
            return new ServiceInfo<TService>(this.createServiceInstance(resolvedPackage, location.workingDirectory));
        });
        if (((Boolean)serviceCreated.get()).booleanValue()) {
            this.jsLinterStateChanged();
        }
        return service;
    }

    protected boolean hasLinterSpecificConfiguration(@NotNull VirtualFile packageJson) {
        if (packageJson == null) {
            MultiRootJSLinterLanguageServiceManager.$$$reportNull$$$0(12);
        }
        return false;
    }

    @NotNull
    protected abstract TService createServiceInstance(@NotNull NodePackage var1, @NotNull VirtualFile var2);

    private void terminateUnusedServices() {
        boolean changed = false;
        for (Map.Entry<Location, ServiceInfo<TService>> entry : this.myServices.entrySet()) {
            Location path2;
            ServiceInfo<TService> value = entry.getValue();
            if (this.myActiveServices.contains(value) || !value.deleted || (value = this.myServices.remove(path2 = entry.getKey())) == null) continue;
            LOG.debug(String.format("Terminating service with path %s because %s", path2, "deleted"));
            Disposer.dispose(value.service);
            changed = true;
        }
        if (changed) {
            this.jsLinterStateChanged();
            DaemonCodeAnalyzer.getInstance((Project)this.myProject).restart();
        }
    }

    public void terminateInactiveService(@NotNull TService service) {
        if (service == null) {
            MultiRootJSLinterLanguageServiceManager.$$$reportNull$$$0(13);
        }
        for (Map.Entry<Location, ServiceInfo<TService>> entry : this.myServices.entrySet()) {
            Location location = entry.getKey();
            ServiceInfo<TService> serviceInfo = entry.getValue();
            if (serviceInfo.service != service) continue;
            MultiRootJSLinterLanguageServiceManager.markAsDeleted(serviceInfo, location.workingDirectory.getPath(), "inactive service termination");
            this.terminateUnusedServices();
            return;
        }
    }

    public void terminateService(@NotNull ServiceInfo<TService> serviceInfo) {
        if (serviceInfo == null) {
            MultiRootJSLinterLanguageServiceManager.$$$reportNull$$$0(14);
        }
        MultiRootJSLinterLanguageServiceManager.markAsDeleted(serviceInfo, "(no path)", "manual single service termination");
        this.terminateUnusedServices();
    }

    public void terminateServices() {
        new ArrayList<ServiceInfo<TService>>(this.myServices.values()).forEach((Consumer<ServiceInfo<TService>>)((Consumer<ServiceInfo>)info -> Disposer.dispose(info.service)));
        this.myServices.clear();
        this.jsLinterStateChanged();
    }

    public void dispose() {
        this.terminateServices();
    }

    private static void markAsDeleted(@NotNull ServiceInfo<?> info, @NotNull String path2, @NotNull String reason) {
        if (info == null) {
            MultiRootJSLinterLanguageServiceManager.$$$reportNull$$$0(15);
        }
        if (path2 == null) {
            MultiRootJSLinterLanguageServiceManager.$$$reportNull$$$0(16);
        }
        if (reason == null) {
            MultiRootJSLinterLanguageServiceManager.$$$reportNull$$$0(17);
        }
        LOG.debug(String.format("Marking service with path %s as deleted because %s", path2, reason));
        info.deleted = true;
    }

    @NotNull
    protected VirtualFile getWorkingDirectory(@NotNull NodePackage resolvedPackage, @NotNull Project project, @NotNull VirtualFile file) {
        if (resolvedPackage == null) {
            MultiRootJSLinterLanguageServiceManager.$$$reportNull$$$0(18);
        }
        if (project == null) {
            MultiRootJSLinterLanguageServiceManager.$$$reportNull$$$0(19);
        }
        if (file == null) {
            MultiRootJSLinterLanguageServiceManager.$$$reportNull$$$0(20);
        }
        VirtualFile fromLocalNodeModules = MultiRootJSLinterLanguageServiceManager.getLocalNodeModulesParent(resolvedPackage, project);
        VirtualFile fromDeclaredDependency = this.getPackageJsonWithDependencyParentDir(file, project);
        if (fromLocalNodeModules != null && fromDeclaredDependency != null && VfsUtilCore.isAncestor((VirtualFile)fromLocalNodeModules, (VirtualFile)fromDeclaredDependency, (boolean)false)) {
            VirtualFile virtualFile = fromDeclaredDependency;
            if (virtualFile == null) {
                MultiRootJSLinterLanguageServiceManager.$$$reportNull$$$0(21);
            }
            return virtualFile;
        }
        if (fromDeclaredDependency != null) {
            VirtualFile virtualFile = fromDeclaredDependency;
            if (virtualFile == null) {
                MultiRootJSLinterLanguageServiceManager.$$$reportNull$$$0(22);
            }
            return virtualFile;
        }
        if (fromLocalNodeModules != null) {
            VirtualFile virtualFile = fromLocalNodeModules;
            if (virtualFile == null) {
                MultiRootJSLinterLanguageServiceManager.$$$reportNull$$$0(23);
            }
            return virtualFile;
        }
        ProjectFileIndex projectFileIndex = ProjectFileIndex.getInstance((Project)project);
        VirtualFile packageJson = PackageJsonUtil.findUpPackageJson(file);
        VirtualFile virtualFile = (VirtualFile)ObjectUtils.coalesce((Object)(packageJson != null ? packageJson.getParent() : null), (Object)projectFileIndex.getContentRootForFile(file, false), (Object)file.getParent());
        if (virtualFile == null) {
            MultiRootJSLinterLanguageServiceManager.$$$reportNull$$$0(24);
        }
        return virtualFile;
    }

    @Nullable
    private static VirtualFile getLocalNodeModulesParent(@NotNull NodePackage resolvedPackage, @NotNull Project project) {
        if (resolvedPackage == null) {
            MultiRootJSLinterLanguageServiceManager.$$$reportNull$$$0(25);
        }
        if (project == null) {
            MultiRootJSLinterLanguageServiceManager.$$$reportNull$$$0(26);
        }
        VirtualFile packageVFile = LocalFileSystem.getInstance().findFileByPath(resolvedPackage.getSystemDependentPath());
        ProjectFileIndex projectFileIndex = ProjectFileIndex.getInstance((Project)project);
        VirtualFile packageParent = packageVFile != null ? packageVFile.getParent() : null;
        return packageParent != null && StringUtil.equals((CharSequence)packageParent.getNameSequence(), (CharSequence)"node_modules") && projectFileIndex.getContentRootForFile(packageParent, false) != null ? packageParent.getParent() : null;
    }

    @Nullable
    private VirtualFile getPackageJsonWithDependencyParentDir(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            MultiRootJSLinterLanguageServiceManager.$$$reportNull$$$0(27);
        }
        if (project == null) {
            MultiRootJSLinterLanguageServiceManager.$$$reportNull$$$0(28);
        }
        Ref result2 = new Ref();
        PackageJsonUtil.processUpPackageJsonFiles(project, file, (Processor<? super VirtualFile>)((Processor)packageJsonFile -> {
            PackageJsonData data = PackageJsonData.getOrCreate(packageJsonFile);
            if (data.isDependencyOfAnyType(this.myPackageName)) {
                result2.set((Object)packageJsonFile.getParent());
            }
            return true;
        }));
        return (VirtualFile)result2.get();
    }

    private static boolean isRenameFileEvent(@NotNull VFileEvent event) {
        if (event == null) {
            MultiRootJSLinterLanguageServiceManager.$$$reportNull$$$0(29);
        }
        if (event instanceof VFilePropertyChangeEvent) {
            VFilePropertyChangeEvent changeEvent = (VFilePropertyChangeEvent)event;
            return "name".equals(changeEvent.getPropertyName()) && Objects.equals(changeEvent.getOldValue(), changeEvent.getNewValue());
        }
        return false;
    }

    @NotNull
    public Map<Location, ServiceInfo<TService>> getJsLinterServices() {
        return new HashMap<Location, ServiceInfo<TService>>(this.myServices);
    }

    public void jsLinterStateChanged() {
        ((JsLinterManagerListener)this.myEventDispatcher.getMulticaster()).jsLinterStateChanged();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 21, 22, 23, 24 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 4: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 5: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageJson";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeType";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storedPackage";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceInfo";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reason";
                break;
            }
            case 18: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedPackage";
                break;
            }
            case 20: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/MultiRootJSLinterLanguageServiceManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/MultiRootJSLinterLanguageServiceManager";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getWorkingDirectory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addJsLinterManagerListener";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "handleContainingDirectoryChanged";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "handlePackageJsonChanged";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "useService";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "acquireService";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "hasLinterSpecificConfiguration";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "terminateInactiveService";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "terminateService";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "markAsDeleted";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getWorkingDirectory";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getLocalNodeModulesParent";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getPackageJsonWithDependencyParentDir";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "isRenameFileEvent";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 21, 22, 23, 24 -> new IllegalStateException(string);
        };
    }

    public record Location(@NotNull NodePackage nodePackage, @NotNull VirtualFile workingDirectory) {
        @NotNull
        private final NodePackage nodePackage;
        @NotNull
        private final VirtualFile workingDirectory;

        public Location(@NotNull NodePackage nodePackage, @NotNull VirtualFile workingDirectory) {
            if (nodePackage == null) {
                Location.$$$reportNull$$$0(0);
            }
            if (workingDirectory == null) {
                Location.$$$reportNull$$$0(1);
            }
        }

        @NotNull
        public NodePackage nodePackage() {
            NodePackage nodePackage = this.nodePackage;
            if (nodePackage == null) {
                Location.$$$reportNull$$$0(2);
            }
            return nodePackage;
        }

        @NotNull
        public VirtualFile workingDirectory() {
            VirtualFile virtualFile = this.workingDirectory;
            if (virtualFile == null) {
                Location.$$$reportNull$$$0(3);
            }
            return virtualFile;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nodePackage";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "workingDirectory";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/linter/MultiRootJSLinterLanguageServiceManager$Location";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/linter/MultiRootJSLinterLanguageServiceManager$Location";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "nodePackage";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "workingDirectory";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    public static final class ServiceInfo<T extends Disposable> {
        @NotNull
        public final T service;
        private boolean deleted;

        private ServiceInfo(@NotNull T service) {
            if (service == null) {
                ServiceInfo.$$$reportNull$$$0(0);
            }
            this.deleted = false;
            this.service = service;
        }

        public boolean isDeleted() {
            return this.deleted;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "service", "com/intellij/lang/javascript/linter/MultiRootJSLinterLanguageServiceManager$ServiceInfo", "<init>"));
        }
    }

    @FunctionalInterface
    public static interface Callback<TService, TResult, TThrowable extends Throwable> {
        public TResult fun(@Nullable TService var1) throws TThrowable;
    }
}

