/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.changeSignature;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.parsing.JavaScriptParserBase;
import com.intellij.lang.javascript.psi.JSElementFactory;
import com.intellij.lang.javascript.psi.JSExpressionCodeFragment;
import com.intellij.lang.javascript.refactoring.changeSignature.JSChangeSignatureDialog;
import com.intellij.lang.javascript.refactoring.changeSignature.JSParameterInfo;
import com.intellij.lang.javascript.refactoring.changeSignature.JSParameterTableModelItem;
import com.intellij.lang.javascript.refactoring.ui.JSEditorTextField;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.IntentionFilterOwner;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.ProjectScope;
import com.intellij.refactoring.changeSignature.ParameterTableModelBase;
import com.intellij.refactoring.changeSignature.ParameterTableModelItemBase;
import com.intellij.refactoring.ui.CodeFragmentTableCellEditorBase;
import com.intellij.refactoring.ui.CodeFragmentTableCellRenderer;
import com.intellij.refactoring.ui.StringTableCellEditor;
import com.intellij.ui.BooleanTableCellEditor;
import com.intellij.ui.BooleanTableCellRenderer;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ComboBoxCellEditor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSParameterTableModel
extends ParameterTableModelBase<JSParameterInfo, JSParameterTableModelItem> {
    private static final IntentionFilterOwner.IntentionActionsFilter intentionsNotAvailable = intentionAction -> false;

    public JSParameterTableModel(@NotNull PsiElement defaultValueContext, @NlsContexts.ColumnName @Nullable String defaultValueColumnTitle, @NlsContexts.ColumnName @Nullable String initializerColumnTitle, boolean showTypeColumn, boolean showOptionalColumn, boolean isParameterProperty) {
        if (defaultValueContext == null) {
            JSParameterTableModel.$$$reportNull$$$0(0);
        }
        super(defaultValueContext, defaultValueContext, JSParameterTableModel.getColumns(defaultValueContext.getProject(), defaultValueColumnTitle, initializerColumnTitle, showTypeColumn, showOptionalColumn, isParameterProperty, JSChangeSignatureDialog.getFileTypeFromContext(defaultValueContext)));
    }

    private static ColumnInfo[] getColumns(Project project, @NlsContexts.ColumnName @Nullable String defaultValueColumnTitle, @NlsContexts.ColumnName @Nullable String initializerColumnTitle, boolean showTypeColumn, boolean showOptionalColumn, boolean isParameterProperty, @NotNull LanguageFileType fileType) {
        if (fileType == null) {
            JSParameterTableModel.$$$reportNull$$$0(1);
        }
        ArrayList<Object> result2 = new ArrayList<Object>();
        if (isParameterProperty) {
            result2.add((Object)new JSParameterModifierColumn());
        }
        if (showTypeColumn) {
            result2.add((Object)new DeclarationColumn(project));
            result2.add((Object)new JSTypeColumn(project, fileType));
        } else {
            result2.add((Object)new DeclarationColumn(project));
        }
        if (initializerColumnTitle != null) {
            result2.add((Object)new InitializerColumn(project, fileType, initializerColumnTitle));
        }
        if (defaultValueColumnTitle != null) {
            result2.add(new ParameterTableModelBase.DefaultValueColumn(project, (FileType)fileType, defaultValueColumnTitle));
        }
        if (showOptionalColumn) {
            result2.add((Object)new OptionalFlagColumn());
        }
        return result2.toArray(ColumnInfo.EMPTY_ARRAY);
    }

    protected JSParameterTableModelItem createRowItem(@Nullable JSParameterInfo parameterInfo) {
        if (parameterInfo == null) {
            parameterInfo = new JSParameterInfo("", "", "", "", -1, false, DialectDetector.dialectOfElement(this.myDefaultValueContext));
        }
        JSExpressionCodeFragment paramTypeCodeFragment = JSParameterTableModel.createParameterTypeCellFragment(parameterInfo.getTypeText(), this.myDefaultValueContext);
        JSExpressionCodeFragment defaultValueCodeFragment = JSParameterTableModel.createDefaultValueCellFragment(parameterInfo.getDefaultValue(), this.myDefaultValueContext);
        JSExpressionCodeFragment initializerCodeFragment = JSParameterTableModel.createInitializerCellFragment(parameterInfo.getInitializer(), this.myDefaultValueContext);
        return new JSParameterTableModelItem(parameterInfo, paramTypeCodeFragment, defaultValueCodeFragment, initializerCodeFragment);
    }

    @NotNull
    public static JSExpressionCodeFragment createParameterTypeCellFragment(@Nullable String text, @NotNull PsiElement context2) {
        if (context2 == null) {
            JSParameterTableModel.$$$reportNull$$$0(2);
        }
        JSLanguageDialect dialect = JSChangeSignatureDialog.getDialectFromContext(context2);
        JavaScriptParserBase.ForceContext codeFragmentType = dialect.getOptionHolder().isECMA4 ? JavaScriptParserBase.ForceContext.Type : JavaScriptParserBase.ForceContext.TypeAllowEmpty;
        JSExpressionCodeFragment fragment = JSElementFactory.createExpressionCodeFragment(context2.getProject(), StringUtil.notNullize((String)text), context2, dialect, ProjectScope.getAllScope((Project)context2.getProject()), JSElementFactory.TopLevelCompletion.YES, codeFragmentType);
        fragment.setIntentionActionsFilter(intentionsNotAvailable);
        JSExpressionCodeFragment jSExpressionCodeFragment = fragment;
        if (jSExpressionCodeFragment == null) {
            JSParameterTableModel.$$$reportNull$$$0(3);
        }
        return jSExpressionCodeFragment;
    }

    public static JSExpressionCodeFragment createDefaultValueCellFragment(String text, PsiElement context2) {
        return JSParameterTableModel.createInitializerCellFragment(StringUtil.notNullize((String)text), context2);
    }

    public static JSExpressionCodeFragment createInitializerCellFragment(String text, PsiElement context2) {
        JSExpressionCodeFragment fragment = JSElementFactory.createExpressionCodeFragment(context2.getProject(), StringUtil.notNullize((String)text), context2, JSChangeSignatureDialog.getDialectFromContext(context2), ProjectScope.getProjectScope((Project)context2.getProject()), JSElementFactory.TopLevelCompletion.LITERAL_VALUES, null);
        fragment.setIntentionActionsFilter(intentionsNotAvailable);
        return fragment;
    }

    private static boolean isDeclaredOptional(@Nullable JSParameterInfo parameter) {
        if (parameter == null) {
            return false;
        }
        DialectOptionHolder dialect = parameter.getDialect();
        if (dialect != null && dialect.isTypeScript) {
            return StringUtil.endsWith((CharSequence)parameter.getDeclarationText(), (CharSequence)"?");
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValueContext";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/refactoring/changeSignature/JSParameterTableModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/refactoring/changeSignature/JSParameterTableModel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createParameterTypeCellFragment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getColumns";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createParameterTypeCellFragment";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }

    private static class JSParameterModifierColumn
    extends ColumnInfo<ParameterTableModelItemBase<JSParameterInfo>, String> {
        private static final List<String> ITEMS = Arrays.asList("", "public", "private", "protected", "public readonly", "private readonly", "protected readonly");

        JSParameterModifierColumn() {
            super(JavaScriptBundle.message("change.signature.column.name.modifier", new Object[0]));
        }

        public boolean isCellEditable(ParameterTableModelItemBase<JSParameterInfo> base) {
            return true;
        }

        @Nullable
        public String valueOf(ParameterTableModelItemBase<JSParameterInfo> base) {
            return ((JSParameterInfo)base.parameter).getModifiersText();
        }

        public void setValue(ParameterTableModelItemBase<JSParameterInfo> base, String value) {
            ((JSParameterInfo)base.parameter).setModifiersText(value);
        }

        @Nullable
        public TableCellEditor getEditor(ParameterTableModelItemBase<JSParameterInfo> base) {
            return new ComboBoxCellEditor(){

                protected List<String> getComboBoxItems() {
                    return ITEMS;
                }
            };
        }

        public int getWidth(JTable table) {
            return 180;
        }
    }

    private static class DeclarationColumn
    extends ParameterTableModelBase.ColumnInfoBase<JSParameterInfo, JSParameterTableModelItem, String> {
        private final Project myProject;

        DeclarationColumn(Project project) {
            super(JavaScriptBundle.message("change.signature.column.name", new Object[0]));
            this.myProject = project;
        }

        protected TableCellRenderer doCreateRenderer(JSParameterTableModelItem item) {
            return new ColoredTableCellRenderer(){

                public void customizeCellRenderer(@NotNull JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    if (table == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (value == null) {
                        return;
                    }
                    if (isSelected || hasFocus) {
                        this.acquireState(table, true, false, row, column);
                        this.getCellState().updateRenderer((JComponent)((Object)this));
                        this.setPaintFocusBorder(false);
                    }
                    this.append((String)value, new SimpleTextAttributes(0, null));
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/lang/javascript/refactoring/changeSignature/JSParameterTableModel$DeclarationColumn$1", "customizeCellRenderer"));
                }
            };
        }

        @Nullable
        public String valueOf(JSParameterTableModelItem item) {
            return ((JSParameterInfo)item.parameter).getDeclarationText();
        }

        public void setValue(JSParameterTableModelItem item, String value) {
            ((JSParameterInfo)item.parameter).setDeclarationText(value);
            ((JSParameterInfo)item.parameter).setOptional(JSParameterTableModel.isDeclaredOptional((JSParameterInfo)item.parameter));
        }

        public boolean isCellEditable(JSParameterTableModelItem item) {
            return !((JSParameterInfo)item.parameter).isDestructuringParameter();
        }

        public TableCellEditor doCreateEditor(JSParameterTableModelItem o) {
            return new StringTableCellEditor(this.myProject){};
        }
    }

    private static class JSTypeColumn
    extends ParameterTableModelBase.TypeColumn<JSParameterInfo, JSParameterTableModelItem> {
        private final LanguageFileType myLanguageFileType;

        JSTypeColumn(Project project, LanguageFileType myLanguageFileType) {
            super(project, (FileType)myLanguageFileType, JavaScriptBundle.message("change.signature.column.type", new Object[0]));
            this.myLanguageFileType = myLanguageFileType;
        }

        public TableCellEditor doCreateEditor(JSParameterTableModelItem o) {
            return new CodeFragmentTableCellEditorBase(this.myProject, (FileType)this.myLanguageFileType){

                protected EditorTextField createEditorField(Document document) {
                    return new JSEditorTextField(myProject, document, false, null);
                }
            };
        }
    }

    private static class InitializerColumn
    extends ParameterTableModelBase.ColumnInfoBase<JSParameterInfo, JSParameterTableModelItem, PsiCodeFragment> {
        private final Project myProject;
        private final LanguageFileType myLanguageFileType;

        InitializerColumn(Project project, LanguageFileType languageFileType, @NlsContexts.ColumnName @NotNull String initializerColumnTitle) {
            if (initializerColumnTitle == null) {
                InitializerColumn.$$$reportNull$$$0(0);
            }
            super(initializerColumnTitle);
            this.myProject = project;
            this.myLanguageFileType = languageFileType;
        }

        public boolean isCellEditable(JSParameterTableModelItem item) {
            return !((JSParameterInfo)item.parameter).isRest() && !JSParameterTableModel.isDeclaredOptional((JSParameterInfo)item.parameter);
        }

        public PsiCodeFragment valueOf(JSParameterTableModelItem item) {
            return item.initializerCodeFragment;
        }

        public TableCellRenderer doCreateRenderer(JSParameterTableModelItem item) {
            return new CodeFragmentTableCellRenderer(this.myProject, (FileType)this.myLanguageFileType);
        }

        public TableCellEditor doCreateEditor(JSParameterTableModelItem item) {
            return new CodeFragmentTableCellEditorBase(this.myProject, (FileType)this.myLanguageFileType){

                protected EditorTextField createEditorField(Document document) {
                    return new JSEditorTextField(myProject, document, false, null);
                }
            };
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initializerColumnTitle", "com/intellij/lang/javascript/refactoring/changeSignature/JSParameterTableModel$InitializerColumn", "<init>"));
        }
    }

    private static class OptionalFlagColumn
    extends ColumnInfo<ParameterTableModelItemBase<JSParameterInfo>, Boolean> {
        OptionalFlagColumn() {
            super(JavaScriptBundle.message("change.signature.column.name.optional.flag", new Object[0]));
        }

        public boolean isCellEditable(ParameterTableModelItemBase<JSParameterInfo> item) {
            return !item.isEllipsisType() && ((JSParameterInfo)item.parameter).isNew();
        }

        public Boolean valueOf(ParameterTableModelItemBase<JSParameterInfo> item) {
            return ((JSParameterInfo)item.parameter).isOptional();
        }

        public void setValue(ParameterTableModelItemBase<JSParameterInfo> item, Boolean value) {
            ((JSParameterInfo)item.parameter).setOptional(value);
        }

        public TableCellRenderer getRenderer(ParameterTableModelItemBase<JSParameterInfo> jsParameterInfoParameterTableModelItemBase) {
            return new BooleanTableCellRenderer();
        }

        public TableCellEditor getEditor(ParameterTableModelItemBase<JSParameterInfo> o) {
            return new BooleanTableCellEditor();
        }

        public int getWidth(JTable table) {
            return 55;
        }
    }
}

