/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.memberPushDown;

import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.presentable.Capitalization;
import com.intellij.lang.javascript.presentable.JSNamedElementPresenter;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.refactoring.BaseJSRefactoringHandler;
import com.intellij.lang.javascript.refactoring.memberPushDown.JSPushDownDialog;
import com.intellij.lang.javascript.refactoring.util.JSMemberInfo;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class JSPushDownHandler
extends BaseJSRefactoringHandler {
    public JSPushDownHandler() {
        super(JSPushDownHandler.getRefactoringName(), JSPushDownHandler.getCannotRefactorReason());
    }

    @Override
    public boolean isEnabledOnElements(PsiElement[] elements) {
        return super.isEnabledOnElements(elements) && JSPushDownHandler.doCheckEcma(elements[0]);
    }

    public void invoke(@NotNull Project project, PsiElement @NotNull [] elements, DataContext dataContext) {
        if (project == null) {
            JSPushDownHandler.$$$reportNull$$$0(0);
        }
        if (elements == null) {
            JSPushDownHandler.$$$reportNull$$$0(1);
        }
        if (elements.length != 1) {
            return;
        }
        PsiElement element = elements[0];
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (!this.checkEcma(element, editor)) {
            return;
        }
        JSClass aClass = JSPushDownHandler.getClass(element);
        if (aClass == null) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)JSPushDownHandler.getCannotRefactorReason());
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)JSPushDownHandler.getRefactoringName(), null);
            return;
        }
        Collection<JSClass> subClasses = JSInheritanceUtil.findDirectSubClasses(aClass, false);
        if (subClasses.isEmpty()) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)JavaScriptBundle.message("class.does.not.have.inheritors.in.current.project", new JSNamedElementPresenter(aClass, Capitalization.UpperCase).describeWithQualifiedName()));
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)JSPushDownHandler.getRefactoringName(), null);
            return;
        }
        if (!JSRefactoringUtil.checkReadOnlyStatus(aClass, editor, JSPushDownHandler.getRefactoringName())) {
            return;
        }
        ArrayList<JSMemberInfo> memberInfos = new ArrayList<JSMemberInfo>();
        JSMemberInfo.extractClassMembers(aClass, memberInfos, (MemberInfoBase.Filter<? super JSAttributeListOwner>)new MemberInfoBase.EmptyFilter());
        if (element instanceof JSElement) {
            for (JSMemberInfo memberInfo : memberInfos) {
                memberInfo.setChecked(Collections.singletonList((JSElement)element));
            }
        }
        JSPushDownDialog dialog = new JSPushDownDialog(project, memberInfos, aClass, subClasses);
        dialog.show();
    }

    @NlsContexts.DialogMessage
    @NotNull
    private static String getCannotRefactorReason() {
        String string = RefactoringBundle.message((String)"the.caret.should.be.positioned.inside.a.class.to.push.members.from");
        if (string == null) {
            JSPushDownHandler.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NlsContexts.DialogTitle
    @NotNull
    public static String getRefactoringName() {
        String string = RefactoringBundle.message((String)"push.members.down.title");
        if (string == null) {
            JSPushDownHandler.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/refactoring/memberPushDown/JSPushDownHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/refactoring/memberPushDown/JSPushDownHandler";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCannotRefactorReason";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRefactoringName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }
}

