/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.ui;

import com.intellij.icons.AllIcons;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterField;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageField;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerService;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettings;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettingsTracker;
import com.intellij.lang.typescript.compiler.TypeScriptServiceRestarter;
import com.intellij.lang.typescript.compiler.ui.TypeScriptDeprecatedSettingsPanel;
import com.intellij.lang.typescript.compiler.ui.TypeScriptExternalSettingsPanel;
import com.intellij.lang.typescript.compiler.ui.TypeScriptNodePackageWrapper;
import com.intellij.lang.typescript.compiler.ui.TypeScriptServiceRestartService;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.EditorNotifications;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.util.Consumer;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.util.text.SemVer;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 \u001a2\u00020\u0001:\u0002\u0019\u001aB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\f\u001a\u00020\rH\u0016J\r\u0010\u000e\u001a\u00070\r\u00a2\u0006\u0002\b\u000fH\u0016J\n\u0010\u0010\u001a\u0004\u0018\u00010\rH\u0016J\n\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0014H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0014H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0018\u00010\u000bR\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/lang/typescript/compiler/ui/TypeScriptConfigurable;", "Lcom/intellij/openapi/options/SearchableConfigurable;", "myProject", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "myServiceSettings", "Lcom/intellij/lang/typescript/compiler/TypeScriptCompilerSettings;", "myDeprecatedSettingsPanel", "Lcom/intellij/lang/typescript/compiler/ui/TypeScriptDeprecatedSettingsPanel;", "myUIHolder", "Lcom/intellij/lang/typescript/compiler/ui/TypeScriptConfigurable$UIHolder;", "getId", "", "getDisplayName", "Lorg/jetbrains/annotations/Nls;", "getHelpTopic", "createComponent", "Ljavax/swing/JComponent;", "apply", "", "reset", "isModified", "", "disposeUIResources", "UIHolder", "Companion", "intellij.javascript.impl"})
public final class TypeScriptConfigurable
implements SearchableConfigurable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project myProject;
    @NotNull
    private final TypeScriptCompilerSettings myServiceSettings;
    @Nullable
    private TypeScriptDeprecatedSettingsPanel myDeprecatedSettingsPanel;
    @Nullable
    private volatile UIHolder myUIHolder;
    @NotNull
    public static final String TYPESCRIPT_CONFIG_ID = "settings.typescriptcompiler";

    public TypeScriptConfigurable(@NotNull Project myProject) {
        Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
        this.myProject = myProject;
        TypeScriptCompilerSettings typeScriptCompilerSettings = TypeScriptCompilerSettings.getSettings(this.myProject);
        Intrinsics.checkNotNullExpressionValue((Object)typeScriptCompilerSettings, (String)"getSettings(...)");
        this.myServiceSettings = typeScriptCompilerSettings;
    }

    @NotNull
    public String getId() {
        return TYPESCRIPT_CONFIG_ID;
    }

    @NotNull
    public String getDisplayName() {
        String string = JavaScriptBundle.message("typescript.compiler.configurable.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @Nullable
    public String getHelpTopic() {
        return "reference.settings.typescript";
    }

    @Nullable
    public JComponent createComponent() {
        if (this.myUIHolder == null) {
            this.myUIHolder = new UIHolder();
        }
        UIHolder uIHolder = this.myUIHolder;
        Intrinsics.checkNotNull((Object)uIHolder);
        return uIHolder.getMyWrapperPanel();
    }

    public void apply() throws ConfigurationException {
        if (this.myUIHolder == null) {
            return;
        }
        if (this.myProject.isDefault()) {
            UIHolder uIHolder = this.myUIHolder;
            Intrinsics.checkNotNull((Object)uIHolder);
            uIHolder.apply();
            return;
        }
        WriteAction.run(() -> TypeScriptConfigurable.apply$lambda$0(this));
        ApplicationManager.getApplication().invokeLater(() -> TypeScriptConfigurable.apply$lambda$1(this), this.myProject.getDisposed());
    }

    public void reset() {
        if (this.myUIHolder == null) {
            return;
        }
        UIHolder uIHolder = this.myUIHolder;
        Intrinsics.checkNotNull((Object)uIHolder);
        uIHolder.reset();
    }

    public boolean isModified() {
        if (this.myUIHolder == null) {
            return false;
        }
        UIHolder uIHolder = this.myUIHolder;
        Intrinsics.checkNotNull((Object)uIHolder);
        return uIHolder.isModified();
    }

    public void disposeUIResources() {
        UIHolder holder = this.myUIHolder;
        if (holder == null) {
            return;
        }
        UIHolder uIHolder = this.myUIHolder;
        Intrinsics.checkNotNull((Object)uIHolder);
        uIHolder.dispose();
    }

    private static final void apply$lambda$0(TypeScriptConfigurable this$0) {
        UIHolder uIHolder = this$0.myUIHolder;
        Intrinsics.checkNotNull((Object)uIHolder);
        uIHolder.apply();
        TypeScriptServiceRestarter.restartServices(this$0.myProject);
    }

    private static final void apply$lambda$1(TypeScriptConfigurable this$0) {
        if (this$0.myProject.isDisposed()) {
            return;
        }
        EditorNotifications.getInstance((Project)this$0.myProject).updateAllNotifications();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/lang/typescript/compiler/ui/TypeScriptConfigurable$Companion;", "", "<init>", "()V", "TYPESCRIPT_CONFIG_ID", "", "intellij.javascript.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u001a\u001a\u00020\u001bJ\u0006\u0010\u001c\u001a\u00020\u001bJ\u0006\u0010\u001d\u001a\u00020\u001bJ\u0006\u0010\u001e\u001a\u00020\u001bJ\u0006\u0010\u001f\u001a\u00020\u001bJ\u000e\u0010 \u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\"J\u0006\u0010#\u001a\u00020\u001bJ\u0006\u0010$\u001a\u00020\u001bJ\u000e\u0010(\u001a\u00020\u001b2\u0006\u0010)\u001a\u00020\tJ\u0006\u0010.\u001a\u00020\u001bJ\u0015\u0010/\u001a\u00020\u00052\u000b\u00100\u001a\u00070+\u00a2\u0006\u0002\b1H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010%\u001a\u00020&8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010'R\u0013\u0010*\u001a\u0004\u0018\u00010+8F\u00a2\u0006\u0006\u001a\u0004\b,\u0010-\u00a8\u00062"}, d2={"Lcom/intellij/lang/typescript/compiler/ui/TypeScriptConfigurable$UIHolder;", "", "<init>", "(Lcom/intellij/lang/typescript/compiler/ui/TypeScriptConfigurable;)V", "myServiceRelatedOptions", "Ljavax/swing/JPanel;", "myDefaultOptions", "Lcom/intellij/ui/components/JBTextField;", "myNodeInterpreterTextField", "Lcom/intellij/javascript/nodejs/interpreter/NodeJsInterpreterField;", "myWrapperPanel", "getMyWrapperPanel", "()Ljavax/swing/JPanel;", "myExternalSettingsPanel", "Lcom/intellij/lang/typescript/compiler/ui/TypeScriptExternalSettingsPanel;", "myRecompileOnChanges", "Ljavax/swing/JCheckBox;", "myTypeScriptNodePackageWrapper", "Lcom/intellij/lang/typescript/compiler/ui/TypeScriptNodePackageWrapper;", "myUseService", "Lcom/intellij/ui/components/JBCheckBox;", "myShowProjectErrors", "myShowSuggestions", "myUseTypesFromServer", "myCmdWarningPanel", "myUseTypesFromServerWarningPanel", "updateVisibility", "", "addCmdValidation", "runCmdValidation", "addUseTypesFromServerValidation", "runUseTypesFromServerValidation", "appendScopeAndRecompileOnChanges", "parentBuilder", "Lcom/intellij/util/ui/FormBuilder;", "apply", "reset", "isModified", "", "()Z", "setNodeInterpreterField", "nodeInterpreterTextField", "nodeInterpreterRefNameForStore", "", "getNodeInterpreterRefNameForStore", "()Ljava/lang/String;", "dispose", "createWarningPanel", "message", "Lcom/intellij/openapi/util/NlsContexts$Label;", "intellij.javascript.impl"})
    @SourceDebugExtension(value={"SMAP\nTypeScriptConfigurable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TypeScriptConfigurable.kt\ncom/intellij/lang/typescript/compiler/ui/TypeScriptConfigurable$UIHolder\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,360:1\n31#2,2:361\n*S KotlinDebug\n*F\n+ 1 TypeScriptConfigurable.kt\ncom/intellij/lang/typescript/compiler/ui/TypeScriptConfigurable$UIHolder\n*L\n236#1:361,2\n*E\n"})
    private final class UIHolder {
        @NotNull
        private final JPanel myServiceRelatedOptions;
        @NotNull
        private final JBTextField myDefaultOptions;
        @NotNull
        private final NodeJsInterpreterField myNodeInterpreterTextField;
        @NotNull
        private final JPanel myWrapperPanel;
        @NotNull
        private final TypeScriptExternalSettingsPanel myExternalSettingsPanel;
        @Nullable
        private JCheckBox myRecompileOnChanges;
        @NotNull
        private final TypeScriptNodePackageWrapper myTypeScriptNodePackageWrapper;
        @NotNull
        private final JBCheckBox myUseService;
        @NotNull
        private final JBCheckBox myShowProjectErrors;
        @NotNull
        private final JBCheckBox myShowSuggestions;
        @NotNull
        private final JBCheckBox myUseTypesFromServer;
        @NotNull
        private final JPanel myCmdWarningPanel;
        @NotNull
        private final JPanel myUseTypesFromServerWarningPanel;

        public UIHolder() {
            this.myNodeInterpreterTextField = new NodeJsInterpreterField(TypeScriptConfigurable.this.myProject);
            this.myNodeInterpreterTextField.setInterpreterRef(NodeJsInterpreterRef.createProjectRef());
            this.myTypeScriptNodePackageWrapper = new TypeScriptNodePackageWrapper(TypeScriptConfigurable.this.myProject, this.myNodeInterpreterTextField, TypeScriptConfigurable.this.myServiceSettings);
            this.myUseService = new JBCheckBox(JavaScriptBundle.message("action.TypeScript.Enable.Service.text", new Object[0]));
            this.myUseService.setBorder((Border)JBUI.Borders.empty());
            FormBuilder serviceNestedOptionsBuilder = FormBuilder.createFormBuilder();
            this.myShowProjectErrors = new JBCheckBox(JavaScriptBundle.message("status.text.javascript.language.service.default.project.errors", new Object[0]));
            this.myShowProjectErrors.setBorder((Border)JBUI.Borders.empty());
            serviceNestedOptionsBuilder.addComponent((JComponent)this.myShowProjectErrors);
            this.myShowSuggestions = new JBCheckBox(JavaScriptBundle.message("status.text.javascript.language.service.suggestions", new Object[0]));
            this.myShowSuggestions.setBorder((Border)JBUI.Borders.empty());
            serviceNestedOptionsBuilder.addComponent((JComponent)this.myShowSuggestions);
            this.myUseTypesFromServer = new JBCheckBox(JavaScriptBundle.message("typescript.compiler.configurable.options.use.servicePoweredTypeEngine", new Object[0]));
            this.myUseTypesFromServer.setToolTipText(JavaScriptBundle.message("typescript.compiler.configurable.options.use.servicePoweredTypeEngine.comment", new Object[0]));
            this.myUseTypesFromServer.setBorder((Border)JBUI.Borders.empty());
            serviceNestedOptionsBuilder.addComponent((JComponent)this.myUseTypesFromServer);
            this.myExternalSettingsPanel = new TypeScriptExternalSettingsPanel(TypeScriptCompilerSettingsTracker.getAdditionalSettings(TypeScriptConfigurable.this.myProject), serviceNestedOptionsBuilder);
            Intrinsics.checkNotNull((Object)serviceNestedOptionsBuilder);
            this.appendScopeAndRecompileOnChanges(serviceNestedOptionsBuilder);
            this.myDefaultOptions = new JBTextField();
            LabeledComponent labeledComponent = LabeledComponent.create((JComponent)((JComponent)this.myDefaultOptions), (String)JavaScriptBundle.message("typescript.compiler.configurable.options.command.line", new Object[0]), (String)"West");
            Intrinsics.checkNotNullExpressionValue((Object)labeledComponent, (String)"create(...)");
            LabeledComponent defaultOptionsComponent = labeledComponent;
            serviceNestedOptionsBuilder.addComponent((JComponent)defaultOptionsComponent);
            String string = JavaScriptBundle.message("typescript.compiler.configurable.options.command.line.localeNotSupportedForBundled", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            this.myCmdWarningPanel = this.createWarningPanel(string);
            this.addCmdValidation();
            serviceNestedOptionsBuilder.addComponent((JComponent)this.myCmdWarningPanel);
            String string2 = JavaScriptBundle.message("typescript.compiler.configurable.options.use.types.from.server.versionWarning", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            this.myUseTypesFromServerWarningPanel = this.createWarningPanel(string2);
            this.addUseTypesFromServerValidation();
            serviceNestedOptionsBuilder.addComponent((JComponent)this.myUseTypesFromServerWarningPanel);
            TypeScriptConfigurable.this.myDeprecatedSettingsPanel = new TypeScriptDeprecatedSettingsPanel(TypeScriptConfigurable.this.myProject, TypeScriptConfigurable.this.myServiceSettings);
            TypeScriptDeprecatedSettingsPanel typeScriptDeprecatedSettingsPanel = TypeScriptConfigurable.this.myDeprecatedSettingsPanel;
            Intrinsics.checkNotNull((Object)typeScriptDeprecatedSettingsPanel);
            typeScriptDeprecatedSettingsPanel.buildUIFor(serviceNestedOptionsBuilder);
            this.myServiceRelatedOptions = serviceNestedOptionsBuilder.getPanel();
            this.myServiceRelatedOptions.setBorder((Border)JBUI.Borders.emptyLeft((int)25));
            JPanel compilerOptionsWrapper = new JPanel(new BorderLayout());
            compilerOptionsWrapper.add((Component)this.myServiceRelatedOptions, "North");
            this.myUseService.addChangeListener(arg_0 -> UIHolder._init_$lambda$0(this, arg_0));
            DialogPanel serviceSettingsPanel = BuilderKt.panel(arg_0 -> UIHolder._init_$lambda$5(this, compilerOptionsWrapper, arg_0));
            String string3 = JavaScriptBundle.message("javascript.service.is.disabled.in.safe.mode", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
            String safeModeMessage = string3;
            JBLabel safeModeLabel = new JBLabel(safeModeMessage, AllIcons.General.Warning, 2);
            this.myWrapperPanel = (JPanel)BuilderKt.panel(arg_0 -> UIHolder._init_$lambda$8(safeModeLabel, serviceSettingsPanel, arg_0));
            this.updateVisibility();
            boolean isTrusted = TypeScriptCompilerSettings.isTrustedProjectForTypeScriptService(TypeScriptConfigurable.this.myProject);
            if (!isTrusted) {
                UIUtil.setEnabled((Component)((Component)serviceSettingsPanel), (boolean)false, (boolean)true);
            }
            safeModeLabel.setVisible(!isTrusted);
        }

        @NotNull
        public final JPanel getMyWrapperPanel() {
            return this.myWrapperPanel;
        }

        public final void updateVisibility() {
            boolean isServiceEnabled = this.myUseService.isSelected();
            UIUtil.setEnabled((Component)this.myServiceRelatedOptions, (boolean)isServiceEnabled, (boolean)true);
            TypeScriptDeprecatedSettingsPanel typeScriptDeprecatedSettingsPanel = TypeScriptConfigurable.this.myDeprecatedSettingsPanel;
            Intrinsics.checkNotNull((Object)typeScriptDeprecatedSettingsPanel);
            typeScriptDeprecatedSettingsPanel.updateUI(!isServiceEnabled);
            this.runUseTypesFromServerValidation();
        }

        public final void addCmdValidation() {
            this.myCmdWarningPanel.setVisible(false);
            this.myTypeScriptNodePackageWrapper.getField().addSelectionListener((Consumer<NodePackage>)((Consumer)arg_0 -> UIHolder.addCmdValidation$lambda$9(this, arg_0)));
            this.myDefaultOptions.getDocument().addDocumentListener(new DocumentListener(this){
                final /* synthetic */ UIHolder this$0;
                {
                    this.this$0 = $receiver;
                }

                public void insertUpdate(DocumentEvent event) {
                    this.this$0.runCmdValidation();
                }

                public void removeUpdate(DocumentEvent event) {
                    this.this$0.runCmdValidation();
                }

                public void changedUpdate(DocumentEvent event) {
                    this.this$0.runCmdValidation();
                }
            });
        }

        public final void runCmdValidation() {
            CharSequence charSequence;
            String cmdText = this.myDefaultOptions.getText();
            this.myCmdWarningPanel.setVisible(this.myTypeScriptNodePackageWrapper.getField().getSelected().isBundled() && !((charSequence = (CharSequence)cmdText) == null || StringsKt.isBlank((CharSequence)charSequence)) && ParametersListUtil.parse((String)cmdText).contains("--locale"));
        }

        public final void addUseTypesFromServerValidation() {
            this.myUseTypesFromServerWarningPanel.setVisible(false);
            this.myUseTypesFromServer.addChangeListener(arg_0 -> UIHolder.addUseTypesFromServerValidation$lambda$10(this, arg_0));
            this.myTypeScriptNodePackageWrapper.getField().addSelectionListener((Consumer<NodePackage>)((Consumer)arg_0 -> UIHolder.addUseTypesFromServerValidation$lambda$11(this, arg_0)));
        }

        public final void runUseTypesFromServerValidation() {
            SemVer semVer = this.myTypeScriptNodePackageWrapper.getField().getSelected().getVersion(TypeScriptConfigurable.this.myProject);
            boolean validSemVer = semVer != null && semVer.isGreaterOrEqualThan(TypeScriptCompilerService.typeEvaluationMinVersion);
            boolean valid = !this.myUseTypesFromServer.isSelected() || validSemVer;
            boolean enabledGroup = this.myUseService.isSelected();
            this.myUseTypesFromServerWarningPanel.setVisible(enabledGroup && !valid);
        }

        /*
         * WARNING - void declaration
         */
        public final void appendScopeAndRecompileOnChanges(@NotNull FormBuilder parentBuilder) {
            void it;
            JCheckBox jCheckBox;
            Intrinsics.checkNotNullParameter((Object)parentBuilder, (String)"parentBuilder");
            JCheckBox jCheckBox2 = jCheckBox = new JCheckBox(JavaScriptBundle.message("typescript.compiler.configurable.options.track.file.system", new Object[0]));
            UIHolder uIHolder = this;
            boolean bl = false;
            it.setBorder((Border)JBUI.Borders.empty());
            parentBuilder.addComponent((JComponent)it);
            uIHolder.myRecompileOnChanges = jCheckBox;
        }

        public final void apply() throws ConfigurationException {
            TypeScriptConfigurable.this.myServiceSettings.setDefaultServiceOptions(this.myDefaultOptions.getText());
            TypeScriptConfigurable.this.myServiceSettings.setNodeInterpreterRefName(this.getNodeInterpreterRefNameForStore());
            TypeScriptConfigurable.this.myServiceSettings.setShowAllProjectErrors(this.myShowProjectErrors.isSelected());
            TypeScriptConfigurable.this.myServiceSettings.setShowSuggestions(this.myShowSuggestions.isSelected());
            boolean useTypesFromServer = this.myUseTypesFromServer.isSelected();
            boolean prevUseTypesFromServer = TypeScriptConfigurable.this.myServiceSettings.isUseTypesFromServer();
            TypeScriptConfigurable.this.myServiceSettings.setUseTypesFromServer(useTypesFromServer);
            TypeScriptCompilerSettings typeScriptCompilerSettings = TypeScriptConfigurable.this.myServiceSettings;
            JCheckBox jCheckBox = this.myRecompileOnChanges;
            Intrinsics.checkNotNull((Object)jCheckBox);
            typeScriptCompilerSettings.setRecompileOnChanges(jCheckBox.isSelected());
            this.myTypeScriptNodePackageWrapper.apply();
            this.myExternalSettingsPanel.apply();
            boolean useService = this.myUseService.isSelected();
            boolean prevUseService = TypeScriptConfigurable.this.myServiceSettings.useService();
            TypeScriptConfigurable.this.myServiceSettings.setUseService(useService);
            TypeScriptDeprecatedSettingsPanel typeScriptDeprecatedSettingsPanel = TypeScriptConfigurable.this.myDeprecatedSettingsPanel;
            Intrinsics.checkNotNull((Object)typeScriptDeprecatedSettingsPanel);
            typeScriptDeprecatedSettingsPanel.apply();
            if (TypeScriptCompilerSettings.isEffectiveUseTypesFromServer(prevUseService, prevUseTypesFromServer) != TypeScriptCompilerSettings.isEffectiveUseTypesFromServer(useService, useTypesFromServer)) {
                ComponentManager $this$service$iv = (ComponentManager)TypeScriptConfigurable.this.myProject;
                boolean $i$f$service = false;
                Class<TypeScriptServiceRestartService> serviceClass$iv = TypeScriptServiceRestartService.class;
                Object object = $this$service$iv.getService(serviceClass$iv);
                if (object == null) {
                    throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                }
                ((TypeScriptServiceRestartService)object).restartServices(true);
            }
        }

        public final void reset() {
            this.myDefaultOptions.setText(TypeScriptConfigurable.this.myServiceSettings.getDefaultServiceOptions());
            this.setNodeInterpreterField(this.myNodeInterpreterTextField);
            this.myShowProjectErrors.setSelected(TypeScriptConfigurable.this.myServiceSettings.isShowAllProjectErrors());
            this.myShowSuggestions.setSelected(TypeScriptConfigurable.this.myServiceSettings.isShowSuggestions());
            this.myUseTypesFromServer.setSelected(TypeScriptConfigurable.this.myServiceSettings.isUseTypesFromServer());
            TypeScriptDeprecatedSettingsPanel typeScriptDeprecatedSettingsPanel = TypeScriptConfigurable.this.myDeprecatedSettingsPanel;
            Intrinsics.checkNotNull((Object)typeScriptDeprecatedSettingsPanel);
            typeScriptDeprecatedSettingsPanel.reset();
            this.myDefaultOptions.setText(TypeScriptConfigurable.this.myServiceSettings.getDefaultServiceOptions());
            JCheckBox jCheckBox = this.myRecompileOnChanges;
            Intrinsics.checkNotNull((Object)jCheckBox);
            jCheckBox.setSelected(TypeScriptConfigurable.this.myServiceSettings.isRecompileOnChanges());
            this.myTypeScriptNodePackageWrapper.reset();
            this.myUseService.setSelected(TypeScriptConfigurable.this.myServiceSettings.useService());
            this.myExternalSettingsPanel.reset();
            this.updateVisibility();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean isModified() {
            TypeScriptDeprecatedSettingsPanel typeScriptDeprecatedSettingsPanel = TypeScriptConfigurable.this.myDeprecatedSettingsPanel;
            Intrinsics.checkNotNull((Object)typeScriptDeprecatedSettingsPanel);
            if (typeScriptDeprecatedSettingsPanel.isModified()) return true;
            if (this.myExternalSettingsPanel.isModified()) return true;
            if (this.myUseService.isSelected() != TypeScriptConfigurable.this.myServiceSettings.useService()) return true;
            if (this.myShowProjectErrors.isSelected() != TypeScriptConfigurable.this.myServiceSettings.isShowAllProjectErrors()) return true;
            if (this.myShowSuggestions.isSelected() != TypeScriptConfigurable.this.myServiceSettings.isShowSuggestions()) return true;
            if (this.myUseTypesFromServer.isSelected() != TypeScriptConfigurable.this.myServiceSettings.isUseTypesFromServer()) return true;
            JCheckBox jCheckBox = this.myRecompileOnChanges;
            Intrinsics.checkNotNull((Object)jCheckBox);
            if (jCheckBox.isSelected() != TypeScriptConfigurable.this.myServiceSettings.isRecompileOnChanges()) return true;
            if (this.myTypeScriptNodePackageWrapper.isModified()) return true;
            if (!StringUtil.equals((CharSequence)StringUtil.nullize((String)this.myDefaultOptions.getText()), (CharSequence)TypeScriptConfigurable.this.myServiceSettings.getDefaultServiceOptions())) return true;
            if (StringUtil.equals((CharSequence)StringUtil.nullize((String)this.getNodeInterpreterRefNameForStore()), (CharSequence)TypeScriptConfigurable.this.myServiceSettings.getNodeInterpreterRefName())) return false;
            return true;
        }

        public final void setNodeInterpreterField(@NotNull NodeJsInterpreterField nodeInterpreterTextField) {
            Intrinsics.checkNotNullParameter((Object)((Object)nodeInterpreterTextField), (String)"nodeInterpreterTextField");
            nodeInterpreterTextField.setInterpreterRef(NodeJsInterpreterRef.create(TypeScriptConfigurable.this.myServiceSettings.getNodeInterpreterRefName()));
        }

        @Nullable
        public final String getNodeInterpreterRefNameForStore() {
            NodeJsInterpreterRef nodeJsInterpreterRef = this.myNodeInterpreterTextField.getInterpreterRef();
            Intrinsics.checkNotNullExpressionValue((Object)nodeJsInterpreterRef, (String)"getInterpreterRef(...)");
            NodeJsInterpreterRef interpreterRef = nodeJsInterpreterRef;
            return interpreterRef.isProjectRef() ? null : interpreterRef.getReferenceName();
        }

        public final void dispose() {
            block0: {
                TypeScriptDeprecatedSettingsPanel typeScriptDeprecatedSettingsPanel = TypeScriptConfigurable.this.myDeprecatedSettingsPanel;
                if (typeScriptDeprecatedSettingsPanel == null) break block0;
                typeScriptDeprecatedSettingsPanel.dispose();
            }
        }

        private final JPanel createWarningPanel(String message) {
            JPanel warningPanel = new JPanel(new FlowLayout(0));
            JLabel warningIcon = new JLabel();
            warningIcon.setIcon(AllIcons.General.Warning);
            warningPanel.add(warningIcon);
            warningPanel.add(Box.createRigidArea((Dimension)new JBDimension(5, 0)));
            warningPanel.add((Component)new JBLabel(message));
            return warningPanel;
        }

        private static final void _init_$lambda$0(UIHolder this$0, ChangeEvent el) {
            this$0.updateVisibility();
        }

        private static final Unit lambda$5$lambda$1(UIHolder this$0, Row $this$row) {
            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
            $this$row.cell((JComponent)((Object)this$0.myNodeInterpreterTextField)).align((Align)AlignX.FILL.INSTANCE);
            return Unit.INSTANCE;
        }

        private static final Unit lambda$5$lambda$2(UIHolder this$0, Row $this$row) {
            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
            NodePackageField nodePackageField = this$0.myTypeScriptNodePackageWrapper.getField();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)nodePackageField), (String)"getField(...)");
            $this$row.cell((JComponent)((Object)nodePackageField)).align((Align)AlignX.FILL.INSTANCE);
            return Unit.INSTANCE;
        }

        private static final Unit lambda$5$lambda$3(UIHolder this$0, Row $this$row) {
            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
            $this$row.cell((JComponent)this$0.myUseService);
            return Unit.INSTANCE;
        }

        private static final Unit lambda$5$lambda$4(JPanel $compilerOptionsWrapper, Row $this$row) {
            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
            $this$row.cell((JComponent)$compilerOptionsWrapper).align((Align)AlignX.FILL.INSTANCE);
            return Unit.INSTANCE;
        }

        private static final Unit _init_$lambda$5(UIHolder this$0, JPanel $compilerOptionsWrapper, Panel $this$panel) {
            Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
            String string = NodeJsInterpreterField.getLabelTextForComponent();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLabelTextForComponent(...)");
            $this$panel.row(string, arg_0 -> UIHolder.lambda$5$lambda$1(this$0, arg_0));
            String string2 = JavaScriptBundle.message("typescript.compiler.configurable.options.version", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            $this$panel.row(string2, arg_0 -> UIHolder.lambda$5$lambda$2(this$0, arg_0));
            Panel.row$default((Panel)$this$panel, null, arg_0 -> UIHolder.lambda$5$lambda$3(this$0, arg_0), (int)1, null);
            Panel.row$default((Panel)$this$panel, null, arg_0 -> UIHolder.lambda$5$lambda$4($compilerOptionsWrapper, arg_0), (int)1, null);
            return Unit.INSTANCE;
        }

        private static final Unit lambda$8$lambda$6(Row $this$row) {
            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
            return Unit.INSTANCE;
        }

        private static final Unit lambda$8$lambda$7(DialogPanel $serviceSettingsPanel, Row $this$row) {
            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
            $this$row.cell((JComponent)$serviceSettingsPanel).align((Align)AlignX.FILL.INSTANCE);
            return Unit.INSTANCE;
        }

        private static final Unit _init_$lambda$8(JBLabel $safeModeLabel, DialogPanel $serviceSettingsPanel, Panel $this$panel) {
            Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
            $this$panel.row((JLabel)$safeModeLabel, UIHolder::lambda$8$lambda$6);
            Panel.row$default((Panel)$this$panel, null, arg_0 -> UIHolder.lambda$8$lambda$7($serviceSettingsPanel, arg_0), (int)1, null);
            return Unit.INSTANCE;
        }

        private static final void addCmdValidation$lambda$9(UIHolder this$0, NodePackage it) {
            this$0.runCmdValidation();
        }

        private static final void addUseTypesFromServerValidation$lambda$10(UIHolder this$0, ChangeEvent it) {
            this$0.runUseTypesFromServerValidation();
        }

        private static final void addUseTypesFromServerValidation$lambda$11(UIHolder this$0, NodePackage it) {
            this$0.runUseTypesFromServerValidation();
        }
    }
}

