/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.control;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.javascript.psi.JSConditionalExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.util.ControlFlowUtils;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.InspectionJSFix;
import com.sixrr.inspectjs.JavaScriptInspection;
import org.jetbrains.annotations.NotNull;

public final class ConstantConditionalExpressionJSInspection
extends JavaScriptInspection {
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ConstantConditionalExpressionVisitor();
    }

    @Override
    @NotNull
    @InspectionMessage
    public String buildErrorString(Object ... args) {
        String string = InspectionJSBundle.message("constant.conditional.expression.error.string", new Object[0]);
        if (string == null) {
            ConstantConditionalExpressionJSInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    static String calculateReplacementExpression(JSConditionalExpression exp) {
        JSExpression thenExpression = (JSExpression)exp.getThenBranch();
        JSExpression elseExpression = (JSExpression)exp.getElseBranch();
        JSExpression condition = exp.getCondition();
        assert (thenExpression != null);
        assert (elseExpression != null);
        if (ControlFlowUtils.isTrue(condition)) {
            return thenExpression.getText();
        }
        return elseExpression.getText();
    }

    @Override
    public InspectionJSFix buildFix(PsiElement location) {
        return new ConstantConditionalFix();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/control/ConstantConditionalExpressionJSInspection", "buildErrorString"));
    }

    private static class ConstantConditionalExpressionVisitor
    extends BaseInspectionVisitor {
        private ConstantConditionalExpressionVisitor() {
        }

        @Override
        public void visitJSConditionalExpression(@NotNull JSConditionalExpression expression) {
            if (expression == null) {
                ConstantConditionalExpressionVisitor.$$$reportNull$$$0(0);
            }
            super.visitJSConditionalExpression(expression);
            JSExpression condition = expression.getCondition();
            JSExpression thenExpression = (JSExpression)expression.getThenBranch();
            if (thenExpression == null) {
                return;
            }
            JSExpression elseExpression = (JSExpression)expression.getElseBranch();
            if (elseExpression == null) {
                return;
            }
            if (ControlFlowUtils.isTrueOrFalse(condition)) {
                this.registerError((PsiElement)expression, expression);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/sixrr/inspectjs/control/ConstantConditionalExpressionJSInspection$ConstantConditionalExpressionVisitor", "visitJSConditionalExpression"));
        }
    }

    private static class ConstantConditionalFix
    extends InspectionJSFix {
        private ConstantConditionalFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionJSBundle.message("simplify.fix", new Object[0]);
            if (string == null) {
                ConstantConditionalFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            JSConditionalExpression expression = (JSConditionalExpression)descriptor.getPsiElement();
            String newExpression = ConstantConditionalExpressionJSInspection.calculateReplacementExpression(expression);
            ConstantConditionalFix.replaceExpression(expression, newExpression);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/control/ConstantConditionalExpressionJSInspection$ConstantConditionalFix", "getFamilyName"));
        }
    }
}

