/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal.frontend;

import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.editor.CharacterSequences;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.FocusChangeListener;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.terminal.TerminalUiSettingsManager;
import com.intellij.terminal.frontend.TerminalCursorPainter;
import com.intellij.terminal.session.TerminalState;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.CoroutineScopeKt;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.jediterm.terminal.CursorShape;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineStart;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.flow.FlowCollector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.block.reworked.TerminalOutputModel;
import org.jetbrains.plugins.terminal.block.reworked.TerminalOutputModelListener;
import org.jetbrains.plugins.terminal.block.reworked.TerminalSessionModel;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\b\u0000\u0018\u0000 &2\u00020\u0001:\t\u001e\u001f !\"#$%&B)\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000fH\u0003J\u0016\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000fH\u0083@\u00a2\u0006\u0002\u0010\u0014J\u001e\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0082@\u00a2\u0006\u0002\u0010\u001aJ\u001e\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0082@\u00a2\u0006\u0002\u0010\u001aJ\b\u0010\u001c\u001a\u00020\u001dH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/intellij/terminal/frontend/TerminalCursorPainter;", "", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "outputModel", "Lorg/jetbrains/plugins/terminal/block/reworked/TerminalOutputModel;", "sessionModel", "Lorg/jetbrains/plugins/terminal/block/reworked/TerminalSessionModel;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/editor/ex/EditorEx;Lorg/jetbrains/plugins/terminal/block/reworked/TerminalOutputModel;Lorg/jetbrains/plugins/terminal/block/reworked/TerminalSessionModel;Lkotlinx/coroutines/CoroutineScope;)V", "cursorPaintingJob", "Lkotlinx/coroutines/Job;", "curCursorState", "Lcom/intellij/terminal/frontend/TerminalCursorPainter$CursorState;", "updateCursor", "", "state", "paintCursor", "(Lcom/intellij/terminal/frontend/TerminalCursorPainter$CursorState;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "paintBlinkingCursor", "renderer", "Lcom/intellij/terminal/frontend/TerminalCursorPainter$CursorRenderer;", "offset", "", "(Lcom/intellij/terminal/frontend/TerminalCursorPainter$CursorRenderer;ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "paintStaticCursor", "getDefaultCursorShape", "Lcom/jediterm/terminal/CursorShape;", "CursorState", "CursorRenderer", "CursorRendererBase", "BlockCursorRenderer", "EmptyBlockCursorRenderer", "LineCursorRenderer", "UnderlineCursorRenderer", "VerticalBarCursorRenderer", "Companion", "intellij.terminal.frontend"})
public final class TerminalCursorPainter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EditorEx editor;
    @NotNull
    private final TerminalOutputModel outputModel;
    @NotNull
    private final TerminalSessionModel sessionModel;
    @NotNull
    private final CoroutineScope coroutineScope;
    @Nullable
    private Job cursorPaintingJob;
    @NotNull
    private CursorState curCursorState;
    @NotNull
    private static final Color CURSOR_LIGHT;
    @NotNull
    private static final Color CURSOR_DARK;

    private TerminalCursorPainter(EditorEx editor, TerminalOutputModel outputModel, TerminalSessionModel sessionModel, CoroutineScope coroutineScope) {
        this.editor = editor;
        this.outputModel = outputModel;
        this.sessionModel = sessionModel;
        this.coroutineScope = coroutineScope;
        this.curCursorState = new CursorState(((Number)this.outputModel.getCursorOffsetState().getValue()).intValue(), this.editor.getContentComponent().hasFocus(), ((TerminalState)this.sessionModel.getTerminalState().getValue()).isCursorVisible(), ((TerminalState)this.sessionModel.getTerminalState().getValue()).getCursorShape());
        this.updateCursor(this.curCursorState);
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, (CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ TerminalCursorPainter this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = this.this$0.outputModel.getCursorOffsetState().collect(new FlowCollector(){

                            public final Object emit(int offset, Continuation<? super Unit> $completion) {
                                this$0.curCursorState = CursorState.copy$default(this$0.curCursorState, offset, false, false, null, 14, null);
                                this$0.updateCursor(this$0.curCursorState);
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (object3 != object2) throw new KotlinNothingValueException();
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        throw new KotlinNothingValueException();
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, (CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ TerminalCursorPainter this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = this.this$0.sessionModel.getTerminalState().collect(new FlowCollector(){

                            public final Object emit(TerminalState state, Continuation<? super Unit> $completion) {
                                boolean stateChanged = false;
                                if (state.getCursorShape() != this$0.curCursorState.getCursorShape()) {
                                    this$0.curCursorState = CursorState.copy$default(this$0.curCursorState, 0, false, false, state.getCursorShape(), 7, null);
                                    stateChanged = true;
                                }
                                if (state.isCursorVisible() != this$0.curCursorState.isCursorVisible()) {
                                    this$0.curCursorState = CursorState.copy$default(this$0.curCursorState, 0, false, state.isCursorVisible(), null, 11, null);
                                    stateChanged = true;
                                }
                                if (stateChanged) {
                                    this$0.updateCursor(this$0.curCursorState);
                                }
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (object3 != object2) throw new KotlinNothingValueException();
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        throw new KotlinNothingValueException();
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
        this.editor.addFocusListener(new FocusChangeListener(){

            public void focusGained(Editor editor) {
                Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                curCursorState = CursorState.copy$default(curCursorState, 0, true, false, null, 13, null);
                this.updateCursor(curCursorState);
            }

            public void focusLost(Editor editor) {
                Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                curCursorState = CursorState.copy$default(curCursorState, 0, false, false, null, 13, null);
                this.updateCursor(curCursorState);
            }
        }, CoroutineScopeKt.asDisposable((CoroutineScope)this.coroutineScope));
        this.outputModel.addListener(CoroutineScopeKt.asDisposable((CoroutineScope)this.coroutineScope), new TerminalOutputModelListener(){

            @Override
            public void afterContentChanged(int startOffset) {
                curCursorState = CursorState.copy$default(curCursorState, ((Number)outputModel.getCursorOffsetState().getValue()).intValue(), false, false, null, 14, null);
                this.updateCursor(curCursorState);
            }
        });
    }

    @RequiresEdt
    private final void updateCursor(CursorState state) {
        Job job2 = this.cursorPaintingJob;
        if (job2 != null) {
            Job.DefaultImpls.cancel$default((Job)job2, null, (int)1, null);
        }
        this.cursorPaintingJob = BuildersKt.launch((CoroutineScope)this.coroutineScope, (CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (CoroutineStart)CoroutineStart.UNDISPATCHED, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, state, null){
            int label;
            final /* synthetic */ TerminalCursorPainter this$0;
            final /* synthetic */ CursorState $state;
            {
                this.this$0 = $receiver;
                this.$state = $state;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = TerminalCursorPainter.access$paintCursor(this.this$0, this.$state, (Continuation)this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    @RequiresEdt
    private final Object paintCursor(CursorState state, Continuation<? super Unit> $completion) {
        if (!state.isCursorVisible()) {
            return Unit.INSTANCE;
        }
        CursorShape cursorShape = state.getCursorShape();
        if (cursorShape == null) {
            cursorShape = this.getDefaultCursorShape();
        }
        CursorShape cursorShape2 = cursorShape;
        boolean shouldBlink = state.isFocused() && cursorShape2.isBlinking();
        CursorRendererBase renderer = switch (WhenMappings.$EnumSwitchMapping$0[cursorShape2.ordinal()]) {
            case 1, 2 -> {
                if (state.isFocused()) {
                    yield new BlockCursorRenderer(this.editor);
                }
                yield new EmptyBlockCursorRenderer(this.editor);
            }
            case 3, 4 -> new UnderlineCursorRenderer(this.editor);
            case 5, 6 -> new VerticalBarCursorRenderer(this.editor);
            default -> throw new NoWhenBranchMatchedException();
        };
        if (shouldBlink) {
            Object object = this.paintBlinkingCursor(renderer, state.getOffset(), $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        Object object = this.paintStaticCursor(renderer, state.getOffset(), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final Object paintBlinkingCursor(CursorRenderer var1_1, int var2_2, Continuation<? super Unit> $completion) {
        if (!($completion instanceof paintBlinkingCursor.1)) ** GOTO lbl-1000
        var9_4 = $completion;
        if ((var9_4.label & -2147483648) != 0) {
            var9_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                int I$0;
                int I$1;
                long J$0;
                /* synthetic */ Object result;
                final /* synthetic */ TerminalCursorPainter this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return TerminalCursorPainter.access$paintBlinkingCursor(this.this$0, null, 0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var10_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                highlighter = renderer.installCursorHighlighter(offset);
                try {
                    blinkingPeriod = this.editor.getSettings().getCaretBlinkPeriod();
                    shouldPaint = 0;
                }
                catch (Throwable var5_9) {
                    v0 = highlighter;
                    if (v0 == null) throw var5_9;
                    v0.dispose();
                    throw var5_9;
                }
lbl24:
                // 2 sources

                while (true) {
                    $continuation.L$0 = renderer;
                    $continuation.L$1 = highlighter;
                    $continuation.I$0 = offset;
                    $continuation.J$0 = blinkingPeriod;
                    $continuation.I$1 = shouldPaint;
                    $continuation.label = 1;
                    v1 = DelayKt.delay((long)blinkingPeriod, (Continuation)$continuation);
                    if (v1 == var10_6) {
                        return var10_6;
                    }
                    ** GOTO lbl44
                    break;
                }
            }
            case 1: {
                shouldPaint = $continuation.I$1;
                blinkingPeriod = $continuation.J$0;
                offset = $continuation.I$0;
                highlighter = (RangeHighlighter)$continuation.L$1;
                renderer = (CursorRenderer)$continuation.L$0;
                {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl44:
                    // 2 sources

                    if (shouldPaint != 0) {
                        highlighter = renderer.installCursorHighlighter(offset);
                    } else {
                        v2 = highlighter;
                        if (v2 != null) {
                            v2.dispose();
                        }
                        highlighter = null;
                    }
                    var7_10 = shouldPaint == 0;
                    ** continue;
                }
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private final Object paintStaticCursor(CursorRenderer var1_1, int var2_2, Continuation<? super Unit> $completion) {
        if (!($completion instanceof paintStaticCursor.1)) ** GOTO lbl-1000
        var7_4 = $completion;
        if ((var7_4.label & -2147483648) != 0) {
            var7_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ TerminalCursorPainter this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return TerminalCursorPainter.access$paintStaticCursor(this.this$0, null, 0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var8_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                highlighter = renderer.installCursorHighlighter((int)offset);
                $continuation.L$0 = highlighter;
                $continuation.label = 1;
                v0 = DelayKt.awaitCancellation((Continuation)$continuation);
                ** if (v0 != var8_6) goto lbl20
lbl19:
                // 1 sources

                return var8_6;
lbl20:
                // 1 sources

                ** GOTO lbl27
            }
            case 1: {
                highlighter = (RangeHighlighter)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl27:
                    // 2 sources

                    throw new KotlinNothingValueException();
                }
                catch (Throwable var5_8) {
                    highlighter.dispose();
                    throw var5_8;
                }
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final CursorShape getDefaultCursorShape() {
        EditorSettings editorSettings = this.editor.getSettings();
        Intrinsics.checkNotNullExpressionValue((Object)editorSettings, (String)"getSettings(...)");
        EditorSettings editorSettings2 = editorSettings;
        TerminalUiSettingsManager.CursorShape shapeFromSettings = TerminalUiSettingsManager.Companion.getInstance().getCursorShape();
        switch (WhenMappings.$EnumSwitchMapping$1[shapeFromSettings.ordinal()]) {
            case 1: {
                return editorSettings2.isBlinkCaret() ? CursorShape.BLINK_BLOCK : CursorShape.STEADY_BLOCK;
            }
            case 2: {
                return editorSettings2.isBlinkCaret() ? CursorShape.BLINK_UNDERLINE : CursorShape.STEADY_UNDERLINE;
            }
        }
        return editorSettings2.isBlinkCaret() ? CursorShape.BLINK_VERTICAL_BAR : CursorShape.STEADY_VERTICAL_BAR;
    }

    public static final /* synthetic */ Object access$paintCursor(TerminalCursorPainter $this, CursorState state, Continuation $completion) {
        return $this.paintCursor(state, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$paintBlinkingCursor(TerminalCursorPainter $this, CursorRenderer renderer, int offset, Continuation $completion) {
        return $this.paintBlinkingCursor(renderer, offset, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$paintStaticCursor(TerminalCursorPainter $this, CursorRenderer renderer, int offset, Continuation $completion) {
        return $this.paintStaticCursor(renderer, offset, (Continuation<? super Unit>)$completion);
    }

    public /* synthetic */ TerminalCursorPainter(EditorEx editor, TerminalOutputModel outputModel, TerminalSessionModel sessionModel, CoroutineScope coroutineScope, DefaultConstructorMarker $constructor_marker) {
        this(editor, outputModel, sessionModel, coroutineScope);
    }

    static {
        Gray gray = Gray._255;
        Intrinsics.checkNotNullExpressionValue((Object)gray, (String)"_255");
        CURSOR_LIGHT = (Color)gray;
        Gray gray2 = Gray._0;
        Intrinsics.checkNotNullExpressionValue((Object)gray2, (String)"_0");
        CURSOR_DARK = (Color)gray2;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0010"}, d2={"Lcom/intellij/terminal/frontend/TerminalCursorPainter$BlockCursorRenderer;", "Lcom/intellij/terminal/frontend/TerminalCursorPainter$CursorRendererBase;", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "<init>", "(Lcom/intellij/openapi/editor/ex/EditorEx;)V", "cursorForeground", "Ljava/awt/Color;", "getCursorForeground", "()Ljava/awt/Color;", "paintCursor", "", "g", "Ljava/awt/Graphics2D;", "rect", "Ljava/awt/geom/Rectangle2D$Double;", "intellij.terminal.frontend"})
    @SourceDebugExtension(value={"SMAP\nTerminalCursorPainter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalCursorPainter.kt\ncom/intellij/terminal/frontend/TerminalCursorPainter$BlockCursorRenderer\n+ 2 TerminalCursorPainter.kt\ncom/intellij/terminal/frontend/TerminalCursorPainter$CursorRendererBase\n*L\n1#1,299:1\n212#2,9:300\n*S KotlinDebug\n*F\n+ 1 TerminalCursorPainter.kt\ncom/intellij/terminal/frontend/TerminalCursorPainter$BlockCursorRenderer\n*L\n250#1:300,9\n*E\n"})
    private static final class BlockCursorRenderer
    extends CursorRendererBase {
        public BlockCursorRenderer(@NotNull EditorEx editor) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            super(editor, null);
        }

        @Override
        @NotNull
        public Color getCursorForeground() {
            return ColorUtil.isDark((Color)this.getEditorCursorColor()) ? CURSOR_LIGHT : CURSOR_DARK;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public void paintCursor(@NotNull Graphics2D g, @NotNull Rectangle2D.Double rect) {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
            CursorRendererBase cursorRendererBase = this;
            Graphics2D $this$withCursorColor$iv = g;
            boolean $i$f$withCursorColor = false;
            Color oldColor$iv = $this$withCursorColor$iv.getColor();
            try {
                void this_$iv;
                $this$withCursorColor$iv.setColor(this_$iv.getEditorCursorColor());
                boolean bl = false;
                g.fill(rect);
            }
            finally {
                $this$withCursorColor$iv.setColor(oldColor$iv);
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/terminal/frontend/TerminalCursorPainter$Companion;", "", "<init>", "()V", "CURSOR_LIGHT", "Ljava/awt/Color;", "CURSOR_DARK", "install", "", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "outputModel", "Lorg/jetbrains/plugins/terminal/block/reworked/TerminalOutputModel;", "sessionModel", "Lorg/jetbrains/plugins/terminal/block/reworked/TerminalSessionModel;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "intellij.terminal.frontend"})
    public static final class Companion {
        private Companion() {
        }

        @RequiresEdt
        public final void install(@NotNull EditorEx editor, @NotNull TerminalOutputModel outputModel, @NotNull TerminalSessionModel sessionModel, @NotNull CoroutineScope coroutineScope) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)outputModel, (String)"outputModel");
            Intrinsics.checkNotNullParameter((Object)sessionModel, (String)"sessionModel");
            Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
            new TerminalCursorPainter(editor, outputModel, sessionModel, coroutineScope, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\br\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H'\u0082\u0001\u0001\u0006\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0007\u00c0\u0006\u0001"}, d2={"Lcom/intellij/terminal/frontend/TerminalCursorPainter$CursorRenderer;", "", "installCursorHighlighter", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "offset", "", "Lcom/intellij/terminal/frontend/TerminalCursorPainter$CursorRendererBase;", "intellij.terminal.frontend"})
    private static interface CursorRenderer {
        @RequiresEdt
        @NotNull
        public RangeHighlighter installCursorHighlighter(int var1);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u00020\u0001B\u0011\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H&J\u001e\u0010\u0012\u001a\u00020\r*\u00020\u000f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\r0\u0014H\u0084\b\u00f8\u0001\u0000J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u0004\u0018\u00010\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\t\u0082\u0001\u0003\u0019\u001a\u001b\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u001c"}, d2={"Lcom/intellij/terminal/frontend/TerminalCursorPainter$CursorRendererBase;", "Lcom/intellij/terminal/frontend/TerminalCursorPainter$CursorRenderer;", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "<init>", "(Lcom/intellij/openapi/editor/ex/EditorEx;)V", "editorCursorColor", "Ljava/awt/Color;", "getEditorCursorColor", "()Ljava/awt/Color;", "cursorForeground", "getCursorForeground", "paintCursor", "", "g", "Ljava/awt/Graphics2D;", "rect", "Ljava/awt/geom/Rectangle2D$Double;", "withCursorColor", "block", "Lkotlin/Function0;", "installCursorHighlighter", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "offset", "", "Lcom/intellij/terminal/frontend/TerminalCursorPainter$BlockCursorRenderer;", "Lcom/intellij/terminal/frontend/TerminalCursorPainter$EmptyBlockCursorRenderer;", "Lcom/intellij/terminal/frontend/TerminalCursorPainter$LineCursorRenderer;", "intellij.terminal.frontend"})
    private static abstract class CursorRendererBase
    implements CursorRenderer {
        @NotNull
        private final EditorEx editor;

        private CursorRendererBase(EditorEx editor) {
            this.editor = editor;
        }

        @NotNull
        public final Color getEditorCursorColor() {
            Color color = this.editor.getColorsScheme().getColor(EditorColors.CARET_COLOR);
            if (color == null) {
                color = (Color)new JBColor(CURSOR_DARK, CURSOR_LIGHT);
            }
            return color;
        }

        @Nullable
        public abstract Color getCursorForeground();

        public abstract void paintCursor(@NotNull Graphics2D var1, @NotNull Rectangle2D.Double var2);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final void withCursorColor(@NotNull Graphics2D $this$withCursorColor, @NotNull Function0<Unit> block) {
            Intrinsics.checkNotNullParameter((Object)$this$withCursorColor, (String)"<this>");
            Intrinsics.checkNotNullParameter(block, (String)"block");
            boolean $i$f$withCursorColor = false;
            Color oldColor = $this$withCursorColor.getColor();
            try {
                $this$withCursorColor.setColor(this.getEditorCursorColor());
                block.invoke();
            }
            finally {
                InlineMarker.finallyStart((int)1);
                $this$withCursorColor.setColor(oldColor);
                InlineMarker.finallyEnd((int)1);
            }
        }

        @Override
        @NotNull
        public final RangeHighlighter installCursorHighlighter(int offset) {
            TextAttributes attributes = new TextAttributes(this.getCursorForeground(), null, null, null, 0);
            int startOffset = RangesKt.coerceIn((int)offset, (ClosedRange)((ClosedRange)new IntRange(0, this.editor.getDocument().getTextLength())));
            int endOffset = RangesKt.coerceIn((int)(offset + 1), (ClosedRange)((ClosedRange)new IntRange(0, this.editor.getDocument().getTextLength())));
            RangeHighlighter rangeHighlighter = this.editor.getMarkupModel().addRangeHighlighter(startOffset, endOffset, 6000, attributes, HighlighterTargetArea.EXACT_RANGE);
            Intrinsics.checkNotNullExpressionValue((Object)rangeHighlighter, (String)"addRangeHighlighter(...)");
            RangeHighlighter highlighter = rangeHighlighter;
            highlighter.setCustomRenderer((arg_0, arg_1, arg_2) -> CursorRendererBase.installCursorHighlighter$lambda$0(highlighter, this, arg_0, arg_1, arg_2));
            return highlighter;
        }

        private static final void installCursorHighlighter$lambda$0(RangeHighlighter $highlighter, CursorRendererBase this$0, Editor editor, RangeHighlighter rangeHighlighter, Graphics g) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"<unused var>");
            Intrinsics.checkNotNullParameter((Object)rangeHighlighter, (String)"<unused var>");
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            int offset = $highlighter.getStartOffset();
            Point2D point2D = this$0.editor.offsetToPoint2D(offset);
            Intrinsics.checkNotNullExpressionValue((Object)point2D, (String)"offsetToPoint2D(...)");
            Point2D point = point2D;
            CharSequence charSequence = this$0.editor.getDocument().getImmutableCharSequence();
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getImmutableCharSequence(...)");
            CharSequence text = charSequence;
            int codePoint = (0 <= offset ? offset < text.length() : false) ? CharacterSequences.codePointAt((CharSequence)text, (int)offset) : 87;
            EditorEx editorEx = this$0.editor;
            Intrinsics.checkNotNull((Object)editorEx, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.impl.EditorImpl");
            float cursorWidth = ((EditorImpl)editorEx).getView().getCodePointWidth(codePoint);
            int cursorHeight = ((EditorImpl)this$0.editor).getLineHeight();
            Rectangle2D.Double rect = new Rectangle2D.Double(point.getX(), point.getY(), cursorWidth, cursorHeight);
            Graphics2D cfr_ignored_0 = (Graphics2D)g;
            this$0.paintCursor((Graphics2D)g, rect);
        }

        public /* synthetic */ CursorRendererBase(EditorEx editor, DefaultConstructorMarker $constructor_marker) {
            this(editor);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\t\u0010\nJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u0013\u001a\u0004\u0018\u00010\bH\u00c6\u0003J3\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\bH\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00052\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\rR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001a"}, d2={"Lcom/intellij/terminal/frontend/TerminalCursorPainter$CursorState;", "", "offset", "", "isFocused", "", "isCursorVisible", "cursorShape", "Lcom/jediterm/terminal/CursorShape;", "<init>", "(IZZLcom/jediterm/terminal/CursorShape;)V", "getOffset", "()I", "()Z", "getCursorShape", "()Lcom/jediterm/terminal/CursorShape;", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "toString", "", "intellij.terminal.frontend"})
    private static final class CursorState {
        private final int offset;
        private final boolean isFocused;
        private final boolean isCursorVisible;
        @Nullable
        private final CursorShape cursorShape;

        public CursorState(int offset, boolean isFocused, boolean isCursorVisible, @Nullable CursorShape cursorShape) {
            this.offset = offset;
            this.isFocused = isFocused;
            this.isCursorVisible = isCursorVisible;
            this.cursorShape = cursorShape;
        }

        public final int getOffset() {
            return this.offset;
        }

        public final boolean isFocused() {
            return this.isFocused;
        }

        public final boolean isCursorVisible() {
            return this.isCursorVisible;
        }

        @Nullable
        public final CursorShape getCursorShape() {
            return this.cursorShape;
        }

        public final int component1() {
            return this.offset;
        }

        public final boolean component2() {
            return this.isFocused;
        }

        public final boolean component3() {
            return this.isCursorVisible;
        }

        @Nullable
        public final CursorShape component4() {
            return this.cursorShape;
        }

        @NotNull
        public final CursorState copy(int offset, boolean isFocused, boolean isCursorVisible, @Nullable CursorShape cursorShape) {
            return new CursorState(offset, isFocused, isCursorVisible, cursorShape);
        }

        public static /* synthetic */ CursorState copy$default(CursorState cursorState, int n, boolean bl, boolean bl2, CursorShape cursorShape, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = cursorState.offset;
            }
            if ((n2 & 2) != 0) {
                bl = cursorState.isFocused;
            }
            if ((n2 & 4) != 0) {
                bl2 = cursorState.isCursorVisible;
            }
            if ((n2 & 8) != 0) {
                cursorShape = cursorState.cursorShape;
            }
            return cursorState.copy(n, bl, bl2, cursorShape);
        }

        @NotNull
        public String toString() {
            return "CursorState(offset=" + this.offset + ", isFocused=" + this.isFocused + ", isCursorVisible=" + this.isCursorVisible + ", cursorShape=" + this.cursorShape + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.offset);
            result = result * 31 + Boolean.hashCode(this.isFocused);
            result = result * 31 + Boolean.hashCode(this.isCursorVisible);
            result = result * 31 + (this.cursorShape == null ? 0 : this.cursorShape.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CursorState)) {
                return false;
            }
            CursorState cursorState = (CursorState)other;
            if (this.offset != cursorState.offset) {
                return false;
            }
            if (this.isFocused != cursorState.isFocused) {
                return false;
            }
            if (this.isCursorVisible != cursorState.isCursorVisible) {
                return false;
            }
            return this.cursorShape == cursorState.cursorShape;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0010"}, d2={"Lcom/intellij/terminal/frontend/TerminalCursorPainter$EmptyBlockCursorRenderer;", "Lcom/intellij/terminal/frontend/TerminalCursorPainter$CursorRendererBase;", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "<init>", "(Lcom/intellij/openapi/editor/ex/EditorEx;)V", "cursorForeground", "Ljava/awt/Color;", "getCursorForeground", "()Ljava/awt/Color;", "paintCursor", "", "g", "Ljava/awt/Graphics2D;", "rect", "Ljava/awt/geom/Rectangle2D$Double;", "intellij.terminal.frontend"})
    @SourceDebugExtension(value={"SMAP\nTerminalCursorPainter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalCursorPainter.kt\ncom/intellij/terminal/frontend/TerminalCursorPainter$EmptyBlockCursorRenderer\n+ 2 TerminalCursorPainter.kt\ncom/intellij/terminal/frontend/TerminalCursorPainter$CursorRendererBase\n*L\n1#1,299:1\n212#2,9:300\n*S KotlinDebug\n*F\n+ 1 TerminalCursorPainter.kt\ncom/intellij/terminal/frontend/TerminalCursorPainter$EmptyBlockCursorRenderer\n*L\n260#1:300,9\n*E\n"})
    private static final class EmptyBlockCursorRenderer
    extends CursorRendererBase {
        @Nullable
        private final Color cursorForeground;

        public EmptyBlockCursorRenderer(@NotNull EditorEx editor) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            super(editor, null);
        }

        @Override
        @Nullable
        public Color getCursorForeground() {
            return this.cursorForeground;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public void paintCursor(@NotNull Graphics2D g, @NotNull Rectangle2D.Double rect) {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
            CursorRendererBase cursorRendererBase = this;
            Graphics2D $this$withCursorColor$iv = g;
            boolean $i$f$withCursorColor = false;
            Color oldColor$iv = $this$withCursorColor$iv.getColor();
            try {
                void this_$iv;
                $this$withCursorColor$iv.setColor(this_$iv.getEditorCursorColor());
                boolean bl = false;
                g.draw(rect);
            }
            finally {
                $this$withCursorColor$iv.setColor(oldColor$iv);
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\"\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH$J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u000fH\u0016R\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0015"}, d2={"Lcom/intellij/terminal/frontend/TerminalCursorPainter$LineCursorRenderer;", "Lcom/intellij/terminal/frontend/TerminalCursorPainter$CursorRendererBase;", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "<init>", "(Lcom/intellij/openapi/editor/ex/EditorEx;)V", "cursorForeground", "Ljava/awt/Color;", "getCursorForeground", "()Ljava/awt/Color;", "lineThickness", "", "getLineThickness", "()D", "shape", "Ljava/awt/geom/Rectangle2D$Double;", "rect", "paintCursor", "", "g", "Ljava/awt/Graphics2D;", "intellij.terminal.frontend"})
    @SourceDebugExtension(value={"SMAP\nTerminalCursorPainter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalCursorPainter.kt\ncom/intellij/terminal/frontend/TerminalCursorPainter$LineCursorRenderer\n+ 2 TerminalCursorPainter.kt\ncom/intellij/terminal/frontend/TerminalCursorPainter$CursorRendererBase\n*L\n1#1,299:1\n212#2,9:300\n*S KotlinDebug\n*F\n+ 1 TerminalCursorPainter.kt\ncom/intellij/terminal/frontend/TerminalCursorPainter$LineCursorRenderer\n*L\n274#1:300,9\n*E\n"})
    private static abstract class LineCursorRenderer
    extends CursorRendererBase {
        @Nullable
        private final Color cursorForeground;

        public LineCursorRenderer(@NotNull EditorEx editor) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            super(editor, null);
        }

        @Override
        @Nullable
        public Color getCursorForeground() {
            return this.cursorForeground;
        }

        protected final double getLineThickness() {
            return JBUIScale.scale((float)2.0f);
        }

        @NotNull
        protected abstract Rectangle2D.Double shape(@NotNull Rectangle2D.Double var1);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public void paintCursor(@NotNull Graphics2D g, @NotNull Rectangle2D.Double rect) {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
            CursorRendererBase cursorRendererBase = this;
            Graphics2D $this$withCursorColor$iv = g;
            boolean $i$f$withCursorColor = false;
            Color oldColor$iv = $this$withCursorColor$iv.getColor();
            try {
                void this_$iv;
                $this$withCursorColor$iv.setColor(this_$iv.getEditorCursorColor());
                boolean bl = false;
                g.fill(this.shape(rect));
            }
            finally {
                $this$withCursorColor$iv.setColor(oldColor$iv);
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0014\u00a8\u0006\t"}, d2={"Lcom/intellij/terminal/frontend/TerminalCursorPainter$UnderlineCursorRenderer;", "Lcom/intellij/terminal/frontend/TerminalCursorPainter$LineCursorRenderer;", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "<init>", "(Lcom/intellij/openapi/editor/ex/EditorEx;)V", "shape", "Ljava/awt/geom/Rectangle2D$Double;", "rect", "intellij.terminal.frontend"})
    private static final class UnderlineCursorRenderer
    extends LineCursorRenderer {
        public UnderlineCursorRenderer(@NotNull EditorEx editor) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            super(editor);
        }

        @Override
        @NotNull
        protected Rectangle2D.Double shape(@NotNull Rectangle2D.Double rect) {
            Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
            return new Rectangle2D.Double(rect.x, rect.y + rect.height - this.getLineThickness(), rect.width, this.getLineThickness());
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0014\u00a8\u0006\t"}, d2={"Lcom/intellij/terminal/frontend/TerminalCursorPainter$VerticalBarCursorRenderer;", "Lcom/intellij/terminal/frontend/TerminalCursorPainter$LineCursorRenderer;", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "<init>", "(Lcom/intellij/openapi/editor/ex/EditorEx;)V", "shape", "Ljava/awt/geom/Rectangle2D$Double;", "rect", "intellij.terminal.frontend"})
    private static final class VerticalBarCursorRenderer
    extends LineCursorRenderer {
        public VerticalBarCursorRenderer(@NotNull EditorEx editor) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            super(editor);
        }

        @Override
        @NotNull
        protected Rectangle2D.Double shape(@NotNull Rectangle2D.Double rect) {
            Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
            return new Rectangle2D.Double(rect.x, rect.y, this.getLineThickness(), rect.height);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[CursorShape.values().length];
            try {
                nArray[CursorShape.BLINK_BLOCK.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CursorShape.STEADY_BLOCK.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CursorShape.BLINK_UNDERLINE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CursorShape.STEADY_UNDERLINE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CursorShape.BLINK_VERTICAL_BAR.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CursorShape.STEADY_VERTICAL_BAR.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[TerminalUiSettingsManager.CursorShape.values().length];
            try {
                nArray[TerminalUiSettingsManager.CursorShape.BLOCK.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TerminalUiSettingsManager.CursorShape.UNDERLINE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

