/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.block.reworked;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.terminal.TerminalColorPalette;
import com.intellij.terminal.session.StyleRange;
import com.intellij.terminal.session.TerminalOutputModelState;
import com.intellij.util.EventDispatcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.plugins.terminal.block.output.HighlightingInfo;
import org.jetbrains.plugins.terminal.block.output.TerminalOutputHighlightingsSnapshot;
import org.jetbrains.plugins.terminal.block.output.TextStyleAdapter;
import org.jetbrains.plugins.terminal.block.reworked.TerminalDocumentChangesApplier;
import org.jetbrains.plugins.terminal.block.reworked.TerminalOutputModel;
import org.jetbrains.plugins.terminal.block.reworked.TerminalOutputModelListener;
import org.jetbrains.plugins.terminal.block.ui.BlockTerminalColorPalette;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001:\u0001>B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ&\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u00052\u0006\u0010&\u001a\u00020'2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)H\u0016J\u0018\u0010+\u001a\u00020$2\u0006\u0010%\u001a\u00020\u00052\u0006\u0010,\u001a\u00020\u0005H\u0016J&\u0010-\u001a\u00020\u00052\u0006\u0010.\u001a\u00020\u00052\u0006\u0010&\u001a\u00020'2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)H\u0002J\b\u0010/\u001a\u00020\u0005H\u0002J\u0010\u0010/\u001a\u00020\u00052\u0006\u00100\u001a\u00020\u0005H\u0002J\u0016\u00101\u001a\u00020$2\f\u00102\u001a\b\u0012\u0004\u0012\u00020\u000503H\u0002J\b\u00104\u001a\u000205H\u0016J\u0018\u00106\u001a\u00020$2\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u00020\u0016H\u0016J\b\u0010:\u001a\u00020;H\u0016J\u0010\u0010<\u001a\u00020$2\u0006\u0010=\u001a\u00020;H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0012\u0010\u0012\u001a\u00060\u0013R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0014\u001a\u0015\u0012\f\u0012\n \u0017*\u0004\u0018\u00010\u00160\u00160\u0015\u00a2\u0006\u0002\b\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0019\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001e\u0010\u001e\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u001b\"\u0004\b \u0010\u001dR\u000e\u0010!\u001a\u00020\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lorg/jetbrains/plugins/terminal/block/reworked/TerminalOutputModelImpl;", "Lorg/jetbrains/plugins/terminal/block/reworked/TerminalOutputModel;", "document", "Lcom/intellij/openapi/editor/Document;", "maxOutputLength", "", "changesApplier", "Lorg/jetbrains/plugins/terminal/block/reworked/TerminalDocumentChangesApplier;", "<init>", "(Lcom/intellij/openapi/editor/Document;ILorg/jetbrains/plugins/terminal/block/reworked/TerminalDocumentChangesApplier;)V", "getDocument", "()Lcom/intellij/openapi/editor/Document;", "mutableCursorOffsetState", "Lkotlinx/coroutines/flow/MutableStateFlow;", "cursorOffsetState", "Lkotlinx/coroutines/flow/StateFlow;", "getCursorOffsetState", "()Lkotlinx/coroutines/flow/StateFlow;", "highlightingsModel", "Lorg/jetbrains/plugins/terminal/block/reworked/TerminalOutputModelImpl$HighlightingsModel;", "dispatcher", "Lcom/intellij/util/EventDispatcher;", "Lorg/jetbrains/plugins/terminal/block/reworked/TerminalOutputModelListener;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "trimmedLinesCount", "getTrimmedLinesCount", "()I", "setTrimmedLinesCount", "(I)V", "trimmedCharsCount", "getTrimmedCharsCount", "setTrimmedCharsCount", "contentUpdateInProgress", "", "updateContent", "", "absoluteLineIndex", "text", "", "styles", "", "Lcom/intellij/terminal/session/StyleRange;", "updateCursorPosition", "columnIndex", "doUpdateContent", "documentLineIndex", "trimToSize", "maxLength", "changeDocumentContent", "block", "Lkotlin/Function0;", "getHighlightings", "Lorg/jetbrains/plugins/terminal/block/output/TerminalOutputHighlightingsSnapshot;", "addListener", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "listener", "dumpState", "Lcom/intellij/terminal/session/TerminalOutputModelState;", "restoreFromState", "state", "HighlightingsModel", "intellij.terminal"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nTerminalOutputModelImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalOutputModelImpl.kt\norg/jetbrains/plugins/terminal/block/reworked/TerminalOutputModelImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,284:1\n1#2:285\n*E\n"})
public final class TerminalOutputModelImpl
implements TerminalOutputModel {
    @NotNull
    private final Document document;
    private final int maxOutputLength;
    @NotNull
    private final TerminalDocumentChangesApplier changesApplier;
    @NotNull
    private final MutableStateFlow<Integer> mutableCursorOffsetState;
    @NotNull
    private final StateFlow<Integer> cursorOffsetState;
    @NotNull
    private final HighlightingsModel highlightingsModel;
    @NotNull
    private final EventDispatcher<TerminalOutputModelListener> dispatcher;
    @VisibleForTesting
    private int trimmedLinesCount;
    @VisibleForTesting
    private int trimmedCharsCount;
    private boolean contentUpdateInProgress;

    public TerminalOutputModelImpl(@NotNull Document document, int maxOutputLength, @NotNull TerminalDocumentChangesApplier changesApplier) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)changesApplier, (String)"changesApplier");
        this.document = document;
        this.maxOutputLength = maxOutputLength;
        this.changesApplier = changesApplier;
        this.mutableCursorOffsetState = StateFlowKt.MutableStateFlow((Object)0);
        this.cursorOffsetState = FlowKt.asStateFlow(this.mutableCursorOffsetState);
        this.highlightingsModel = new HighlightingsModel();
        EventDispatcher eventDispatcher2 = EventDispatcher.create(TerminalOutputModelListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)eventDispatcher2, (String)"create(...)");
        this.dispatcher = eventDispatcher2;
    }

    @Override
    @NotNull
    public Document getDocument() {
        return this.document;
    }

    @Override
    @NotNull
    public StateFlow<Integer> getCursorOffsetState() {
        return this.cursorOffsetState;
    }

    public final int getTrimmedLinesCount() {
        return this.trimmedLinesCount;
    }

    public final void setTrimmedLinesCount(int n) {
        this.trimmedLinesCount = n;
    }

    public final int getTrimmedCharsCount() {
        return this.trimmedCharsCount;
    }

    public final void setTrimmedCharsCount(int n) {
        this.trimmedCharsCount = n;
    }

    @Override
    public void updateContent(int absoluteLineIndex, @NotNull String text, @NotNull List<StyleRange> styles) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter(styles, (String)"styles");
        this.changeDocumentContent((Function0<Integer>)((Function0)() -> TerminalOutputModelImpl.updateContent$lambda$0(absoluteLineIndex, this, text, styles)));
    }

    @Override
    public void updateCursorPosition(int absoluteLineIndex, int columnIndex) {
        int documentLineIndex = absoluteLineIndex - this.trimmedLinesCount;
        int lineStartOffset = this.getDocument().getLineStartOffset(documentLineIndex);
        int lineEndOffset = this.getDocument().getLineEndOffset(documentLineIndex);
        int lineLength = lineEndOffset - lineStartOffset;
        if (columnIndex > lineLength) {
            int spacesToAdd = columnIndex - lineLength;
            String spaces = StringsKt.repeat((CharSequence)" ", (int)spacesToAdd);
            this.changeDocumentContent((Function0<Integer>)((Function0)() -> TerminalOutputModelImpl.updateCursorPosition$lambda$1(this, lineEndOffset, spaces, spacesToAdd)));
        }
        this.mutableCursorOffsetState.setValue((Object)(lineStartOffset + columnIndex));
    }

    private final int doUpdateContent(int documentLineIndex, String text, List<StyleRange> styles) {
        if (documentLineIndex > 0 && documentLineIndex >= this.getDocument().getLineCount()) {
            String newLines = StringsKt.repeat((CharSequence)"\n", (int)(documentLineIndex - this.getDocument().getLineCount() + 1));
            this.getDocument().insertString(this.getDocument().getTextLength(), (CharSequence)newLines);
        }
        int replaceStartOffset = this.getDocument().getLineStartOffset(documentLineIndex);
        this.getDocument().replaceString(replaceStartOffset, this.getDocument().getTextLength(), (CharSequence)text);
        int newLength = this.getDocument().getTextLength();
        if (((Number)this.mutableCursorOffsetState.getValue()).intValue() > newLength) {
            this.mutableCursorOffsetState.setValue((Object)newLength);
        }
        this.highlightingsModel.removeAfter(replaceStartOffset);
        this.highlightingsModel.addHighlightings(replaceStartOffset, styles);
        int trimmedCount = this.trimToSize();
        return Math.max(0, replaceStartOffset - trimmedCount);
    }

    private final int trimToSize() {
        return this.maxOutputLength > 0 && this.getDocument().getTextLength() > this.maxOutputLength ? this.trimToSize(this.maxOutputLength) : 0;
    }

    private final int trimToSize(int maxLength) {
        int textLength = this.getDocument().getTextLength();
        if (!(textLength > maxLength)) {
            boolean $i$a$-check-TerminalOutputModelImpl$trimToSize$22 = false;
            String $i$a$-check-TerminalOutputModelImpl$trimToSize$22 = "This method should be called only if text length " + textLength + " is greater than max length " + maxLength;
            throw new IllegalStateException($i$a$-check-TerminalOutputModelImpl$trimToSize$22.toString());
        }
        int lineCountBefore = this.getDocument().getLineCount();
        int removeUntilOffset = textLength - maxLength;
        this.getDocument().deleteString(0, removeUntilOffset);
        this.highlightingsModel.removeBefore(removeUntilOffset);
        this.trimmedCharsCount += removeUntilOffset;
        this.trimmedLinesCount += lineCountBefore - this.getDocument().getLineCount();
        return removeUntilOffset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void changeDocumentContent(Function0<Integer> block) {
        int n;
        ((TerminalOutputModelListener)this.dispatcher.getMulticaster()).beforeContentChanged();
        this.contentUpdateInProgress = true;
        try {
            Ref.IntRef result = new Ref.IntRef();
            this.changesApplier.applyChange((Function0<Unit>)((Function0)() -> TerminalOutputModelImpl.changeDocumentContent$lambda$3(result, block)));
            n = result.element;
        }
        finally {
            this.contentUpdateInProgress = false;
        }
        int changeStartOffset = n;
        ((TerminalOutputModelListener)this.dispatcher.getMulticaster()).afterContentChanged(changeStartOffset);
    }

    @Override
    @NotNull
    public TerminalOutputHighlightingsSnapshot getHighlightings() {
        return this.contentUpdateInProgress ? new TerminalOutputHighlightingsSnapshot(this.getDocument(), CollectionsKt.emptyList()) : this.highlightingsModel.getHighlightingsSnapshot();
    }

    @Override
    public void addListener(@NotNull Disposable parentDisposable, @NotNull TerminalOutputModelListener listener2) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.dispatcher.addListener((EventListener)listener2, parentDisposable);
    }

    @Override
    @NotNull
    public TerminalOutputModelState dumpState() {
        String string = this.getDocument().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return new TerminalOutputModelState(string, this.trimmedLinesCount, this.trimmedCharsCount, ((Number)this.getCursorOffsetState().getValue()).intValue(), this.highlightingsModel.dumpState());
    }

    @Override
    public void restoreFromState(@NotNull TerminalOutputModelState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.changeDocumentContent((Function0<Integer>)((Function0)() -> TerminalOutputModelImpl.restoreFromState$lambda$4(this, state)));
    }

    private static final int updateContent$lambda$0(int $absoluteLineIndex, TerminalOutputModelImpl this$0, String $text, List $styles) {
        if ($absoluteLineIndex < this$0.trimmedLinesCount) {
            this$0.trimmedLinesCount = 0;
            this$0.trimmedCharsCount = 0;
        }
        int documentLineIndex = $absoluteLineIndex - this$0.trimmedLinesCount;
        return this$0.doUpdateContent(documentLineIndex, $text, $styles);
    }

    private static final int updateCursorPosition$lambda$1(TerminalOutputModelImpl this$0, int $lineEndOffset, String $spaces, int $spacesToAdd) {
        this$0.getDocument().insertString($lineEndOffset, (CharSequence)$spaces);
        this$0.highlightingsModel.insertEmptyHighlightings($lineEndOffset, $spacesToAdd);
        return $lineEndOffset;
    }

    private static final Unit changeDocumentContent$lambda$3(Ref.IntRef $result, Function0 $block) {
        $result.element = ((Number)$block.invoke()).intValue();
        return Unit.INSTANCE;
    }

    private static final int restoreFromState$lambda$4(TerminalOutputModelImpl this$0, TerminalOutputModelState $state) {
        this$0.trimmedLinesCount = $state.getTrimmedLinesCount();
        this$0.trimmedCharsCount = $state.getTrimmedCharsCount();
        this$0.getDocument().setText((CharSequence)$state.getText());
        this$0.highlightingsModel.restoreFromState($state.getHighlightings());
        this$0.mutableCursorOffsetState.setValue((Object)$state.getCursorOffset());
        return 0;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\b\b\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u000b\u001a\u00020\nJ\u001c\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u0011J\u0016\u0010\u0012\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u000fJ\u000e\u0010\u0014\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0015\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\b0\u0011J\u0014\u0010\u0017\u001a\u00020\r2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\b0\u0011R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/plugins/terminal/block/reworked/TerminalOutputModelImpl$HighlightingsModel;", "", "<init>", "(Lorg/jetbrains/plugins/terminal/block/reworked/TerminalOutputModelImpl;)V", "colorPalette", "Lcom/intellij/terminal/TerminalColorPalette;", "styleRanges", "", "Lcom/intellij/terminal/session/StyleRange;", "highlightingsSnapshot", "Lorg/jetbrains/plugins/terminal/block/output/TerminalOutputHighlightingsSnapshot;", "getHighlightingsSnapshot", "addHighlightings", "", "documentOffset", "", "styles", "", "insertEmptyHighlightings", "length", "removeAfter", "removeBefore", "dumpState", "restoreFromState", "state", "intellij.terminal"})
    @SourceDebugExtension(value={"SMAP\nTerminalOutputModelImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalOutputModelImpl.kt\norg/jetbrains/plugins/terminal/block/reworked/TerminalOutputModelImpl$HighlightingsModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,284:1\n1557#2:285\n1628#2,3:286\n1557#2:290\n1628#2,3:291\n1#3:289\n*S KotlinDebug\n*F\n+ 1 TerminalOutputModelImpl.kt\norg/jetbrains/plugins/terminal/block/reworked/TerminalOutputModelImpl$HighlightingsModel\n*L\n210#1:285\n210#1:286,3\n223#1:290\n223#1:291,3\n*E\n"})
    private final class HighlightingsModel {
        @NotNull
        private final TerminalColorPalette colorPalette = new BlockTerminalColorPalette();
        @NotNull
        private final List<StyleRange> styleRanges = (List)new ArrayDeque();
        @Nullable
        private TerminalOutputHighlightingsSnapshot highlightingsSnapshot;

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final TerminalOutputHighlightingsSnapshot getHighlightingsSnapshot() {
            TerminalOutputHighlightingsSnapshot snapshot;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            if (this.highlightingsSnapshot != null) {
                TerminalOutputHighlightingsSnapshot terminalOutputHighlightingsSnapshot = this.highlightingsSnapshot;
                Intrinsics.checkNotNull((Object)terminalOutputHighlightingsSnapshot);
                return terminalOutputHighlightingsSnapshot;
            }
            Iterable iterable = this.styleRanges;
            TerminalOutputModelImpl terminalOutputModelImpl = TerminalOutputModelImpl.this;
            boolean $i$f$map = false;
            void var5_4 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                StyleRange styleRange = (StyleRange)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new HighlightingInfo(it.getStartOffset() - terminalOutputModelImpl.getTrimmedCharsCount(), it.getEndOffset() - terminalOutputModelImpl.getTrimmedCharsCount(), new TextStyleAdapter(it.getStyle(), this.colorPalette)));
            }
            List documentRelativeHighlightings = (List)destination$iv$iv;
            this.highlightingsSnapshot = snapshot = new TerminalOutputHighlightingsSnapshot(TerminalOutputModelImpl.this.getDocument(), documentRelativeHighlightings);
            return snapshot;
        }

        /*
         * WARNING - void declaration
         */
        public final void addHighlightings(int documentOffset, @NotNull List<StyleRange> styles) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(styles, (String)"styles");
            int absoluteOffset = documentOffset + TerminalOutputModelImpl.this.getTrimmedCharsCount();
            if (!(this.styleRanges.isEmpty() || ((StyleRange)CollectionsKt.last(this.styleRanges)).getEndOffset() <= absoluteOffset)) {
                boolean $i$a$-check-TerminalOutputModelImpl$HighlightingsModel$addHighlightings$22 = false;
                String $i$a$-check-TerminalOutputModelImpl$HighlightingsModel$addHighlightings$22 = "New highlightings overlap with existing";
                throw new IllegalStateException($i$a$-check-TerminalOutputModelImpl$HighlightingsModel$addHighlightings$22.toString());
            }
            Iterable $this$map$iv = styles;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                StyleRange styleRange = (StyleRange)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new StyleRange(absoluteOffset + it.getStartOffset(), absoluteOffset + it.getEndOffset(), it.getStyle()));
            }
            List adjustedStyles = (List)destination$iv$iv;
            this.styleRanges.addAll(adjustedStyles);
            this.highlightingsSnapshot = null;
        }

        public final void insertEmptyHighlightings(int documentOffset, int length) {
            int updateFromIndex;
            int absoluteOffset = documentOffset + TerminalOutputModelImpl.this.getTrimmedCharsCount();
            int styleIndex = CollectionsKt.binarySearch$default(this.styleRanges, (int)0, (int)0, arg_0 -> HighlightingsModel.insertEmptyHighlightings$lambda$3(absoluteOffset, arg_0), (int)3, null);
            int n = updateFromIndex = styleIndex < 0 ? -styleIndex - 1 : styleIndex;
            if (updateFromIndex < this.styleRanges.size()) {
                int n2 = this.styleRanges.size();
                for (int ind = updateFromIndex; ind < n2; ++ind) {
                    StyleRange cur = this.styleRanges.get(ind);
                    this.styleRanges.set(ind, new StyleRange(cur.getStartOffset() + length, cur.getEndOffset() + length, cur.getStyle()));
                }
                this.highlightingsSnapshot = null;
            }
        }

        public final void removeAfter(int documentOffset) {
            int ind;
            int absoluteOffset = documentOffset + TerminalOutputModelImpl.this.getTrimmedCharsCount();
            int styleIndex = CollectionsKt.binarySearch$default(this.styleRanges, (int)0, (int)0, arg_0 -> HighlightingsModel.removeAfter$lambda$4(absoluteOffset, arg_0), (int)3, null);
            int removeFromIndex = styleIndex < 0 ? -styleIndex - 1 : styleIndex + 1;
            if (removeFromIndex <= (ind = this.styleRanges.size() - 1)) {
                while (true) {
                    this.styleRanges.remove(ind);
                    if (ind == removeFromIndex) break;
                    --ind;
                }
            }
            this.highlightingsSnapshot = null;
        }

        public final void removeBefore(int documentOffset) {
            int absoluteOffset = documentOffset + TerminalOutputModelImpl.this.getTrimmedCharsCount();
            int styleIndex = CollectionsKt.binarySearch$default(this.styleRanges, (int)0, (int)0, arg_0 -> HighlightingsModel.removeBefore$lambda$5(absoluteOffset, arg_0), (int)3, null);
            int removeUntilHighlightingIndex = styleIndex < 0 ? -styleIndex - 1 : styleIndex;
            int n = 0;
            while (n < removeUntilHighlightingIndex) {
                int it = n++;
                boolean bl = false;
                this.styleRanges.remove(0);
            }
            this.highlightingsSnapshot = null;
        }

        @NotNull
        public final List<StyleRange> dumpState() {
            return CollectionsKt.toList((Iterable)this.styleRanges);
        }

        public final void restoreFromState(@NotNull List<StyleRange> state) {
            Intrinsics.checkNotNullParameter(state, (String)"state");
            this.styleRanges.clear();
            this.styleRanges.addAll((Collection<StyleRange>)state);
            this.highlightingsSnapshot = null;
        }

        private static final int insertEmptyHighlightings$lambda$3(int $absoluteOffset, StyleRange it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return Intrinsics.compare((int)it.getStartOffset(), (int)$absoluteOffset);
        }

        private static final int removeAfter$lambda$4(int $absoluteOffset, StyleRange it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return Intrinsics.compare((int)it.getEndOffset(), (int)$absoluteOffset);
        }

        private static final int removeBefore$lambda$5(int $absoluteOffset, StyleRange it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return Intrinsics.compare((int)it.getStartOffset(), (int)$absoluteOffset);
        }
    }
}

