/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.autoconfig.DataSourceDetector;
import com.intellij.database.autoconfig.DataSourceRegistry;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class ImportDataSourceAction
extends AnAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            ImportDataSourceAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public boolean isDumbAware() {
        return false;
    }

    public void update(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            ImportDataSourceAction.$$$reportNull$$$0(1);
        }
        boolean enabled = (project = e.getProject()) != null && DataSourceDetector.EP_NAME.hasAnyExtensions();
        e.getPresentation().setEnabledAndVisible(enabled);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            ImportDataSourceAction.$$$reportNull$$$0(2);
        }
        if ((project = e.getProject()) == null) {
            return;
        }
        ImportDataSourceAction.doImportAction(project, false);
    }

    public static boolean doImportAction(@NotNull Project project, boolean newOnly) {
        if (project == null) {
            ImportDataSourceAction.$$$reportNull$$$0(3);
        }
        DataSourceRegistry registry = new DataSourceRegistry(project);
        List detectors = DataSourceDetector.EP_NAME.getExtensionList();
        ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
            indicator.setIndeterminate(false);
            indicator.setText(DatabaseBundle.message("message.import.datasources.detecting", new Object[0]));
            double totalProgress = detectors.size();
            double curProgress = 0.0;
            for (DataSourceDetector detector : detectors) {
                indicator.setFraction((curProgress += 1.0) / totalProgress);
                String simpleName = StringUtil.trimEnd((String)detector.getClass().getSimpleName(), (String)DataSourceDetector.class.getSimpleName());
                indicator.setText2(DatabaseBundle.message("message.import.datasources.processing.0.configs", simpleName));
                boolean isAvailable = (Boolean)ReadAction.compute(() -> detector.isApplicable(project));
                if (!isAvailable) continue;
                ReadAction.run(() -> detector.collectDataSources(project, registry.getBuilder()));
            }
        }, DatabaseBundle.message("dialog.title.import.datasources", new Object[0]), true, project);
        if (newOnly) {
            registry.retainNewOnly();
        }
        if (registry.isEmpty()) {
            Messages.showMessageDialog((Project)project, (String)DatabaseBundle.message("message.import.datasources.nothing.found", new Object[0]), (String)DatabaseBundle.message("dialog.title.import.datasources", new Object[0]), (Icon)Messages.getWarningIcon());
            return true;
        }
        return registry.showDialog();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/actions/ImportDataSourceAction";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/actions/ImportDataSourceAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doImportAction";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3 -> new IllegalArgumentException(string);
        };
    }
}

