/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.maria;

import com.intellij.database.Dbms;
import com.intellij.database.data.types.ConversionPoint;
import com.intellij.database.data.types.domain.OperationSupport;
import com.intellij.database.data.types.domain.TextDomain;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.mutating.ColumnDescriptor;
import com.intellij.database.dialects.mysqlbase.MysqlBaseDomains;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;

public final class MariaDomains
extends MysqlBaseDomains {
    public MariaDomains(@NotNull Dbms dbms) {
        if (dbms == null) {
            MariaDomains.$$$reportNull$$$0(0);
        }
        super(dbms, true, false);
        this.add(new TextDomain("tinytext", ConversionPoint.VARCHAR, 255L));
        this.add(new TextDomain("text", ConversionPoint.TEXT, 65535L){

            @Override
            public boolean isSuitable(@NotNull ColumnDescriptor descriptor2) {
                if (descriptor2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (descriptor2 instanceof DataConsumer.Column) {
                    int precision = ((DataConsumer.Column)descriptor2).getSize();
                    return StringUtil.equalsIgnoreCase((CharSequence)"text", (CharSequence)descriptor2.getTypeName()) || StringUtil.equalsIgnoreCase((CharSequence)"varchar", (CharSequence)descriptor2.getTypeName()) && (long)precision == this.getLength();
                }
                return super.isSuitable(descriptor2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/database/dialects/maria/MariaDomains$1", "isSuitable"));
            }
        });
        this.add(new TextDomain("mediumtext", ConversionPoint.CLOB, 0xFFFFFFL){

            @Override
            public boolean isSuitable(@NotNull ColumnDescriptor descriptor2) {
                if (descriptor2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (descriptor2 instanceof DataConsumer.Column) {
                    int precision = ((DataConsumer.Column)descriptor2).getSize();
                    return StringUtil.equalsIgnoreCase((CharSequence)"mediumtext", (CharSequence)descriptor2.getTypeName()) || StringUtil.equalsIgnoreCase((CharSequence)"varchar", (CharSequence)descriptor2.getTypeName()) && (long)precision == this.getLength();
                }
                return super.isSuitable(descriptor2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/database/dialects/maria/MariaDomains$2", "isSuitable"));
            }
        }.withOperationSupport(OperationSupport.SUPPORTS_LIKE));
        this.add(new TextDomain("longtext", ConversionPoint.CLOB, 0xFFFFFFFFL){

            @Override
            public boolean isSuitable(@NotNull ColumnDescriptor descriptor2) {
                if (descriptor2 == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (descriptor2 instanceof DataConsumer.Column) {
                    return descriptor2.getType() == -1;
                }
                return super.isSuitable(descriptor2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/database/dialects/maria/MariaDomains$3", "isSuitable"));
            }
        }.withOperationSupport(OperationSupport.SUPPORTS_LIKE));
        this.add(new TextDomain("char", ConversionPoint.CHAR, 255L, 1L, true, false));
        this.add(new TextDomain("varchar", ConversionPoint.VARCHAR, 21844L, TextDomain.Length.mandatory(4368L, true)){

            @Override
            public boolean isSuitable(@NotNull ColumnDescriptor descriptor2) {
                if (descriptor2 == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (descriptor2 instanceof DataConsumer.Column) {
                    return super.isSuitable(descriptor2) && descriptor2.getType() == 12 && (long)((DataConsumer.Column)descriptor2).getSize() <= this.getLength();
                }
                return super.isSuitable(descriptor2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/database/dialects/maria/MariaDomains$4", "isSuitable"));
            }
        });
        this.add(new TextDomain("nvarchar", ConversionPoint.NVARCHAR, 21844L, TextDomain.Length.mandatory(4368L, true)));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dbms", "com/intellij/database/dialects/maria/MariaDomains", "<init>"));
    }
}

