/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mssql.inspections;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.connection.throwable.KnownDatabaseException;
import com.intellij.database.connection.throwable.info.ErrorInfo;
import com.intellij.database.connection.throwable.info.SimpleErrorInfo;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DatabaseDriverUtils;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.artifacts.DatabaseArtifactList;
import com.intellij.database.dataSource.artifacts.DatabaseArtifactManager;
import com.intellij.database.dialects.DatabaseFixFactory;
import com.intellij.database.dialects.mssql.MsUtils;
import com.intellij.database.dialects.mssql.inspections.MSSQLDotNetDriverParametersTunerKt;
import com.intellij.database.run.ConsoleRunContextParametersTuner;
import com.intellij.database.util.Version;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.openapi.project.Project;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\r"}, d2={"Lcom/intellij/database/dialects/mssql/inspections/MSSQLDotNetDriverParametersTuner;", "Lcom/intellij/database/run/ConsoleRunContextParametersTuner;", "<init>", "()V", "tuneParams", "", "project", "Lcom/intellij/openapi/project/Project;", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "params", "Lcom/intellij/execution/configurations/SimpleJavaParameters;", "Companion", "intellij.database.dialects.mssql.ex"})
public final class MSSQLDotNetDriverParametersTuner
implements ConsoleRunContextParametersTuner {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    public void tuneParams(@NotNull Project project, @NotNull LocalDataSource dataSource, @NotNull SimpleJavaParameters params) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        DatabaseDriver driver = dataSource.getDatabaseDriver();
        if (!MsUtils.isJbMsDriver(driver)) {
            return;
        }
        if (driver == null) {
            throw new IllegalArgumentException("Driver not found");
        }
        ParametersList vmParams = params.getVMParametersList();
        List<Path> nativeLibraries = DatabaseDriverUtils.getNativeLibrariesPaths(driver, DatabaseArtifactList.Item.Arch.ANY);
        Intrinsics.checkNotNull(nativeLibraries);
        vmParams.addProperty("jetbrains.sqlserver.driver.dotnet.path", ((Object)MSSQLDotNetDriverParametersTuner.Companion.getDotNet(driver, nativeLibraries).toAbsolutePath()).toString());
        vmParams.addProperty("jetbrains.sqlserver.driver.backend.path", ((Object)MSSQLDotNetDriverParametersTuner.Companion.getMsDriverBackend(driver, nativeLibraries).toAbsolutePath()).toString());
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\tH\u0002J\u001e\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\tH\u0002J&\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u000eH\u0002J \u0010\u0012\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0013\u001a\u00020\u000e2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\tH\u0002J$\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\u0017\u001a\u0004\u0018\u00010\f2\b\b\u0001\u0010\u0018\u001a\u00020\u000eH\u0002\u00a8\u0006\u0019"}, d2={"Lcom/intellij/database/dialects/mssql/inspections/MSSQLDotNetDriverParametersTuner$Companion;", "", "<init>", "()V", "getDotNet", "Ljava/nio/file/Path;", "driver", "Lcom/intellij/database/dataSource/DatabaseDriver;", "nativeLibraries", "", "getMsDriverBackend", "resolveArtifact", "Lcom/intellij/database/dataSource/artifacts/DatabaseArtifactList$ArtifactVersion;", "artifactId", "", "version", "Lcom/intellij/database/util/Version;", "chanelId", "findFile", "fileName", "paths", "createErrorInfoForArtifact", "Lcom/intellij/database/connection/throwable/info/ErrorInfo;", "artifact", "message", "intellij.database.dialects.mssql.ex"})
    public static final class Companion {
        private Companion() {
        }

        private final Path getDotNet(DatabaseDriver driver, List<? extends Path> nativeLibraries) {
            Path dotNet = this.findFile(MSSQLDotNetDriverParametersTunerKt.access$getDOT_NET_FILE_NAME$p(), nativeLibraries);
            if (dotNet == null) {
                DatabaseArtifactList.ArtifactVersion dotNetArtifact = this.resolveArtifact("DotNet", Version.of("9.0.0"), null);
                String string = DatabaseBundle.message("path.to.net.does.not.exist", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                throw new KnownDatabaseException(this.createErrorInfoForArtifact(driver, dotNetArtifact, string));
            }
            return dotNet;
        }

        private final Path getMsDriverBackend(DatabaseDriver driver, List<? extends Path> nativeLibraries) {
            Path backend = this.findFile("JdbcDriver.Backend.Host.dll", nativeLibraries);
            if (backend == null) {
                DatabaseArtifactList.ArtifactVersion driverArtifact = this.resolveArtifact("JetBrains SQL Server", null, "stable");
                String string = DatabaseBundle.message("path.to.net.driver.backend.does.not.exist", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                throw new KnownDatabaseException(this.createErrorInfoForArtifact(driver, driverArtifact, string));
            }
            return backend;
        }

        private final DatabaseArtifactList.ArtifactVersion resolveArtifact(String artifactId, Version version, String chanelId) {
            DatabaseArtifactList.ArtifactVersion artifact = DatabaseArtifactManager.getArtifacts().resolveVersion(artifactId, version, chanelId, null);
            if (artifact == null) {
                MSSQLDotNetDriverParametersTunerKt.access$getLOG$p().error(artifactId + " artifact not found");
            }
            return artifact;
        }

        private final Path findFile(String fileName, List<? extends Path> paths) {
            for (Path path : paths) {
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (!Files.exists(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) continue;
                LinkOption[] linkOptionArray2 = new LinkOption[]{};
                if (Files.isDirectory(path, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
                    Path file = path.resolve(fileName);
                    Intrinsics.checkNotNull((Object)file);
                    LinkOption[] linkOptionArray3 = new LinkOption[]{};
                    if (!Files.exists(file, Arrays.copyOf(linkOptionArray3, linkOptionArray3.length))) continue;
                    return file;
                }
                LinkOption[] linkOptionArray4 = new LinkOption[]{};
                if (!Files.isRegularFile(path, Arrays.copyOf(linkOptionArray4, linkOptionArray4.length))) continue;
                Path path2 = path.getFileName();
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"getFileName(...)");
                if (!Intrinsics.areEqual((Object)PathsKt.getName((Path)path2), (Object)fileName)) continue;
                return path;
            }
            return null;
        }

        private final ErrorInfo createErrorInfoForArtifact(DatabaseDriver driver, DatabaseArtifactList.ArtifactVersion artifact, @Nls String message) {
            DatabaseFixFactory fixFactory;
            DatabaseFixFactory databaseFixFactory = fixFactory = DatabaseFixFactory.getInstance();
            ErrorInfo errorInfo = SimpleErrorInfo.create((String)message, null, (List)CollectionsKt.listOf(databaseFixFactory != null ? databaseFixFactory.setUpArtifact(driver, true, () -> Companion.createErrorInfoForArtifact$lambda$0(artifact)) : null));
            Intrinsics.checkNotNullExpressionValue((Object)errorInfo, (String)"create(...)");
            return errorInfo;
        }

        private static final DatabaseArtifactList.ArtifactVersion createErrorInfoForArtifact$lambda$0(DatabaseArtifactList.ArtifactVersion $artifact) {
            return $artifact;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

