/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle.model;

import com.intellij.credentialStore.OneTimeString;
import com.intellij.database.dialects.oracle.model.OraCluster;
import com.intellij.database.dialects.oracle.model.OraClusterColumn;
import com.intellij.database.dialects.oracle.model.OraCollectionType;
import com.intellij.database.dialects.oracle.model.OraDbLink;
import com.intellij.database.dialects.oracle.model.OraModel;
import com.intellij.database.dialects.oracle.model.OraSingleRoutine;
import com.intellij.database.dialects.oracle.model.OraSourceAware;
import com.intellij.database.dialects.oracle.model.OraTable;
import com.intellij.database.dialects.oracle.model.OraUser;
import com.intellij.database.dialects.oracle.types.OraTypeSystem;
import com.intellij.database.model.ClusterType;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ModelHelper;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.meta.BasicMetaField;
import com.intellij.database.model.meta.BasicMetaId;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.types.DasTypeUtilsKt;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.ui.LayeredIcon;
import icons.DatabaseIcons;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u0005H\u0016J4\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J4\u0010\u001a\u001a\u00020\n\"\b\b\u0000\u0010\u001b*\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\u001b0\u001e2\u0012\u0010\u001f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u001b0!0 H\u0016\u00a8\u0006\""}, d2={"Lcom/intellij/database/dialects/oracle/model/OraModelHelper;", "Lcom/intellij/database/model/ModelHelper;", "<init>", "()V", "handleJdbcComment", "", "obj", "Lcom/intellij/database/model/basic/BasicModNamedElement;", "comment", "fillPropertiesWithExamples", "", "e", "Lcom/intellij/database/model/basic/BasicModElement;", "variant", "Lcom/intellij/database/model/ModelHelper$ObjectKindVariant;", "vars", "", "modifyParent", "", "getIcon", "Ljavax/swing/Icon;", "c", "Lcom/intellij/database/model/DasObject;", "invalidateIntrospectionCache", "model", "Lcom/intellij/database/model/basic/BasicModModel;", "reorderProperties", "E", "Lcom/intellij/database/model/basic/BasicElement;", "meta", "Lcom/intellij/database/model/meta/BasicMetaObject;", "fields", "", "Lcom/intellij/database/model/meta/BasicMetaField;", "intellij.database.dialects.oracle"})
public final class OraModelHelper
extends ModelHelper {
    @Override
    @Nullable
    public String handleJdbcComment(@NotNull BasicModNamedElement obj2, @Nullable String comment) {
        Intrinsics.checkNotNullParameter((Object)obj2, (String)"obj");
        return obj2 instanceof OraSingleRoutine && comment != null && StringsKt.startsWith$default((String)comment, (String)"Standalone", (boolean)false, (int)2, null) ? null : comment;
    }

    @Override
    public void fillPropertiesWithExamples(@NotNull BasicModElement e, @NotNull ModelHelper.ObjectKindVariant variant, @NotNull Map<String, String> vars, boolean modifyParent) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        Intrinsics.checkNotNullParameter(vars, (String)"vars");
        super.fillPropertiesWithExamples(e, variant, vars, modifyParent);
        if (e instanceof OraCluster) {
            Object e2 = ((OraCluster)e).getColumns().createNewOne();
            Intrinsics.checkNotNullExpressionValue(e2, (String)"createNewOne(...)");
            OraClusterColumn col = (OraClusterColumn)e2;
            this.setTemplateName(col, "cluster_column");
            col.setStoredType(DasTypeUtilsKt.withName(OraTypeSystem.INTEGER, "int"));
            vars.put("cluster_column", "cluster_column int");
        }
        if (e instanceof OraCollectionType) {
            ((OraCollectionType)e).setElementStoredType(DasTypeUtilsKt.withName(OraTypeSystem.VARCHAR, "varchar"));
            vars.put("element_type", "varchar");
        }
        if (e instanceof OraDbLink) {
            ((OraDbLink)e).setRemoteDatabaseString("remote_database");
            vars.put("remote_database", "remote_database");
            ((OraDbLink)e).setShared(true);
            ((OraDbLink)e).setConnectUserName("user_name");
            ((OraDbLink)e).setAuthUserName("user_name");
            vars.put("user_name", "user_name");
            ((OraDbLink)e).setConnectUserPassword("user_password");
            ((OraDbLink)e).setAuthUserPassword("user_password");
            vars.put("user_password", "user_password");
        }
        if (e instanceof OraUser) {
            ((OraUser)e).setPassword(new OneTimeString(""));
            vars.put("password", "\"\"");
        }
    }

    @Override
    @Nullable
    public Icon getIcon(@NotNull DasObject c2) {
        BasicElement element;
        Icon originalIcon;
        Intrinsics.checkNotNullParameter((Object)c2, (String)"c");
        Icon icon = originalIcon = super.getIcon(c2);
        BasicElement basicElement = c2 instanceof BasicElement ? (BasicElement)c2 : null;
        if (basicElement == null) {
            basicElement = DbImplUtilCore.getMaybeBasicElement(c2);
        }
        if ((element = basicElement) instanceof OraSourceAware && ((OraSourceAware)element).isWithDebugInfo()) {
            Icon[] iconArray = new Icon[2];
            Intrinsics.checkNotNull((Object)originalIcon);
            iconArray[1] = DatabaseIcons.GreenBugOverlap;
            icon = (Icon)LayeredIcon.Companion.layeredIcon(iconArray);
        }
        if (c2 instanceof OraCluster) {
            return switch (WhenMappings.$EnumSwitchMapping$0[((OraCluster)c2).getClusterType().ordinal()]) {
                case 1 -> DatabaseIcons.IndexCluster;
                case 2 -> DatabaseIcons.HashCluster;
                default -> DatabaseIcons.UnspecifiedCluster;
            };
        }
        return icon;
    }

    @Override
    public void invalidateIntrospectionCache(@NotNull BasicModModel model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        OraModel oraModel = model instanceof OraModel ? (OraModel)model : null;
        if (oraModel == null) {
            return;
        }
        OraModel m = oraModel;
        m.getRoot().setCatalogAccessPermissions(null);
    }

    @Override
    public <E extends BasicElement> void reorderProperties(@NotNull BasicMetaObject<E> meta, @NotNull List<BasicMetaField<E>> fields) {
        Intrinsics.checkNotNullParameter(meta, (String)"meta");
        Intrinsics.checkNotNullParameter(fields, (String)"fields");
        super.reorderProperties(meta, fields);
        if (meta.kindOf(OraUser.class)) {
            BasicMetaId[] basicMetaIdArray = new BasicMetaId[]{OraUser.PASSWORD, OraUser.EXPIRED, OraUser.LOCKED, OraUser.PROFILE};
            ModelHelper.moveTo(fields, ModelHelper.indexOf(fields, OraUser.NAME) + 1, basicMetaIdArray);
        } else if (meta.kindOf(OraTable.class)) {
            ModelHelper.moveTo(fields, ModelHelper.indexOf(fields, OraTable.TEMPORARY) + 1, (BasicMetaId)OraTable.TEMPORARY_PRESERVE);
            BasicMetaId[] basicMetaIdArray = new BasicMetaId[]{OraTable.CLUSTER_REF, OraTable.CLUSTER_COL_NAMES};
            ModelHelper.moveTo(fields, fields.size(), basicMetaIdArray);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ClusterType.values().length];
            try {
                nArray[ClusterType.INDEX.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClusterType.HASH.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

