/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.GridUtil;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.NestedTable;
import com.intellij.database.run.ui.DataAccessType;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u000b\u00a8\u0006\u0012"}, d2={"Lcom/intellij/database/run/actions/DataGridUrlNavigationActionHelper;", "", "<init>", "()V", "isMouseEventWithModifiers", "", "event", "Ljava/awt/event/InputEvent;", "modifiersExpected", "", "getSelectedValue", "", "dataGrid", "Lcom/intellij/database/datagrid/DataGrid;", "isMultipleValuesSelected", "buildUrlIfValid", "Ljava/net/URL;", "rawUrl", "intellij.database.impl"})
public final class DataGridUrlNavigationActionHelper {
    @NotNull
    public static final DataGridUrlNavigationActionHelper INSTANCE = new DataGridUrlNavigationActionHelper();

    private DataGridUrlNavigationActionHelper() {
    }

    public final boolean isMouseEventWithModifiers(@Nullable InputEvent event, int modifiersExpected) {
        if (!(event instanceof MouseEvent)) {
            return false;
        }
        boolean hasExpectedModifiers = (((MouseEvent)event).getModifiersEx() & modifiersExpected) != 0;
        return hasExpectedModifiers;
    }

    @Nullable
    public final String getSelectedValue(@NotNull DataGrid dataGrid) {
        Intrinsics.checkNotNullParameter((Object)dataGrid, (String)"dataGrid");
        if (this.isMultipleValuesSelected(dataGrid)) {
            return null;
        }
        GridColumn selectedColumn = (GridColumn)dataGrid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS).getColumn(dataGrid.getSelectionModel().getLeadSelectionColumn());
        GridRow selectedRow = (GridRow)dataGrid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS).getRow(dataGrid.getSelectionModel().getLeadSelectionRow());
        if (selectedColumn == null || selectedRow == null) {
            return null;
        }
        Object cellValue = selectedColumn.getValue(selectedRow);
        if (cellValue instanceof NestedTable || cellValue instanceof Iterable || cellValue instanceof Map || cellValue instanceof Object[]) {
            return null;
        }
        return GridUtil.getText((DataGrid)dataGrid, (ModelIndex)dataGrid.getSelectionModel().getLeadSelectionRow(), (ModelIndex)dataGrid.getSelectionModel().getLeadSelectionColumn());
    }

    public final boolean isMultipleValuesSelected(@NotNull DataGrid dataGrid) {
        Intrinsics.checkNotNullParameter((Object)dataGrid, (String)"dataGrid");
        return dataGrid.getSelectionModel().getSelectedRowCount() > 1 || dataGrid.getSelectionModel().getSelectedColumnCount() > 1;
    }

    @Nullable
    public final URL buildUrlIfValid(@NotNull String rawUrl) {
        URL uRL;
        Intrinsics.checkNotNullParameter((Object)rawUrl, (String)"rawUrl");
        try {
            URL url = new URL(rawUrl);
            url.toURI();
        }
        catch (MalformedURLException e) {
            uRL = null;
        }
        catch (URISyntaxException e) {
            uRL = null;
        }
        return uRL;
    }
}

