/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid.editors;

import com.intellij.database.DataGridBundle;
import com.intellij.database.data.types.ConversionPoint;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.GridUtil;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.extractors.BinaryDisplayType;
import com.intellij.database.extractors.DatabaseObjectFormatterConfig;
import com.intellij.database.extractors.DisplayType;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.extractors.ObjectFormatterConfig;
import com.intellij.database.extractors.ObjectFormatterUtil;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.grid.editors.FactoryWithDomainSupport;
import com.intellij.database.run.ui.grid.editors.FormatBasedGridCellEditorFactory;
import com.intellij.database.run.ui.grid.editors.Formatter;
import com.intellij.database.run.ui.grid.editors.FormatterImpl;
import com.intellij.database.run.ui.grid.editors.GridCellEditorFactory;
import com.intellij.database.run.ui.grid.editors.GridCellEditorHelper;
import com.intellij.database.run.ui.grid.editors.GridCellEditorsUtil;
import com.intellij.database.run.ui.grid.editors.UnparsedValue;
import com.intellij.database.run.ui.grid.editors.UnparsedValueWithDomain;
import com.intellij.database.run.ui.grid.editors.ValueParserWrapper;
import java.text.ParsePosition;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J,\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u000eH\u0016J\u001c\u0010\u0012\u001a\u00020\b2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J,\u0010\u0017\u001a\u00020\u00182\u0006\u0010\t\u001a\u00020\n2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u000eH\u0014J:\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u00112\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/database/run/ui/grid/editors/UuidEditorFactory;", "Lcom/intellij/database/run/ui/grid/editors/FormatBasedGridCellEditorFactory;", "Lcom/intellij/database/run/ui/grid/editors/FactoryWithDomainSupport;", "<init>", "()V", "UUID_PATTERN", "Ljava/util/regex/Pattern;", "getSuitability", "", "grid", "Lcom/intellij/database/datagrid/DataGrid;", "domain", "Lcom/intellij/database/data/types/domain/Domain;", "rowIdx", "Lcom/intellij/database/datagrid/ModelIndex;", "Lcom/intellij/database/datagrid/GridRow;", "columnIdx", "Lcom/intellij/database/datagrid/GridColumn;", "getSuitabilityInner", "displayType", "Lcom/intellij/database/extractors/DisplayType;", "getValueParser", "Lcom/intellij/database/run/ui/grid/editors/GridCellEditorFactory$ValueParser;", "getFormatInner", "Lcom/intellij/database/run/ui/grid/editors/Formatter;", "createFormat", "Lcom/intellij/database/run/ui/grid/editors/FormatterImpl;", "formatter", "Lcom/intellij/database/extractors/ObjectFormatter;", "column", "config", "Lcom/intellij/database/extractors/DatabaseObjectFormatterConfig$DatabaseDisplayObjectFormatterConfig;", "intellij.database.impl"})
public final class UuidEditorFactory
extends FormatBasedGridCellEditorFactory
implements FactoryWithDomainSupport {
    @NotNull
    private final Pattern UUID_PATTERN;

    public UuidEditorFactory() {
        Pattern pattern = Pattern.compile("(?>new\\s+)?(?>UUID\\(\")?([0-9a-fA-F-]+)(\"\\))?");
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
        this.UUID_PATTERN = pattern;
    }

    @Override
    public int getSuitability(@NotNull DataGrid grid, @NotNull Domain domain) {
        Intrinsics.checkNotNullParameter((Object)grid, (String)"grid");
        Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
        return this.getSuitabilityInner(null, domain);
    }

    public int getSuitability(@NotNull DataGrid grid, @NotNull ModelIndex<GridRow> rowIdx, @NotNull ModelIndex<GridColumn> columnIdx) {
        Intrinsics.checkNotNullParameter((Object)grid, (String)"grid");
        Intrinsics.checkNotNullParameter(rowIdx, (String)"rowIdx");
        Intrinsics.checkNotNullParameter(columnIdx, (String)"columnIdx");
        return this.getSuitabilityInner(grid.getDisplayType(columnIdx), GridCellEditorsUtil.guessDomainForEditing((CoreGrid<GridRow, GridColumn>)((CoreGrid)grid), rowIdx, columnIdx));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final int getSuitabilityInner(DisplayType displayType, Domain domain) {
        if (displayType == BinaryDisplayType.UUID) return 10;
        if (displayType == BinaryDisplayType.UUID_SWAP) return 10;
        Domain domain2 = domain;
        if (Intrinsics.areEqual((Object)(domain2 != null ? domain2.getPoint() : null), (Object)ConversionPoint.UUID)) return 10;
        Domain domain3 = domain;
        if (!Intrinsics.areEqual((Object)(domain3 != null ? domain3.getPoint() : null), (Object)ConversionPoint.UUID_TEXT)) return 0;
        return 10;
    }

    @Override
    @NotNull
    public GridCellEditorFactory.ValueParser getValueParser(@NotNull DataGrid grid, @NotNull Domain domain) {
        Intrinsics.checkNotNullParameter((Object)grid, (String)"grid");
        Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
        return (GridCellEditorFactory.ValueParser)new ValueParserWrapper((Formatter)this.createFormat(null, null, null, null, domain), true, GridCellEditorHelper.get((CoreGrid)((CoreGrid)grid)).getDefaultNullValue((CoreGrid)grid, null), (arg_0, arg_1) -> UuidEditorFactory.getValueParser$lambda$0(domain, arg_0, arg_1));
    }

    @NotNull
    protected Formatter getFormatInner(@NotNull DataGrid grid, @NotNull ModelIndex<GridRow> rowIdx, @NotNull ModelIndex<GridColumn> columnIdx) {
        Intrinsics.checkNotNullParameter((Object)grid, (String)"grid");
        Intrinsics.checkNotNullParameter(rowIdx, (String)"rowIdx");
        Intrinsics.checkNotNullParameter(columnIdx, (String)"columnIdx");
        GridModel gridModel = grid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS);
        Intrinsics.checkNotNullExpressionValue((Object)gridModel, (String)"getDataModel(...)");
        GridModel model = gridModel;
        DisplayType displayType = grid.getDisplayType(columnIdx);
        Intrinsics.checkNotNullExpressionValue((Object)displayType, (String)"getDisplayType(...)");
        DisplayType displayType2 = displayType;
        Domain domain = GridCellEditorsUtil.guessDomainForEditing((CoreGrid<GridRow, GridColumn>)((CoreGrid)grid), rowIdx, columnIdx);
        return (Formatter)this.createFormat(grid.getObjectFormatter(), (GridColumn)model.getColumn(columnIdx), GridUtil.createFormatterConfig((DataGrid)grid, columnIdx), displayType2, domain);
    }

    private final FormatterImpl createFormat(ObjectFormatter formatter, GridColumn column2, DatabaseObjectFormatterConfig.DatabaseDisplayObjectFormatterConfig config, DisplayType displayType, Domain domain) {
        return new FormatterImpl(this, domain, displayType, formatter, config, column2){
            final /* synthetic */ UuidEditorFactory this$0;
            final /* synthetic */ Domain $domain;
            final /* synthetic */ DisplayType $displayType;
            final /* synthetic */ ObjectFormatter $formatter;
            final /* synthetic */ DatabaseObjectFormatterConfig.DatabaseDisplayObjectFormatterConfig $config;
            final /* synthetic */ GridColumn $column;
            {
                this.this$0 = $receiver;
                this.$domain = $domain;
                this.$displayType = $displayType;
                this.$formatter = $formatter;
                this.$config = $config;
                this.$column = $column;
            }

            public Object parse(String value, ParsePosition position) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                Intrinsics.checkNotNullParameter((Object)position, (String)"position");
                String $this$trim$iv = value;
                boolean $i$f$trim = false;
                CharSequence $this$trim$iv$iv = $this$trim$iv;
                boolean $i$f$trim2 = false;
                int startIndex$iv$iv = 0;
                int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                boolean startFound$iv$iv = false;
                while (startIndex$iv$iv <= endIndex$iv$iv) {
                    boolean match$iv$iv;
                    int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                    char it = $this$trim$iv$iv.charAt(index$iv$iv);
                    boolean bl = false;
                    boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                    if (!startFound$iv$iv) {
                        if (!match$iv$iv) {
                            startFound$iv$iv = true;
                            continue;
                        }
                        ++startIndex$iv$iv;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv;
                }
                String text2 = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
                Matcher matcher = UuidEditorFactory.access$getUUID_PATTERN$p(this.this$0).matcher(text2);
                Intrinsics.checkNotNullExpressionValue((Object)matcher, (String)"matcher(...)");
                Matcher matcher2 = matcher;
                if (!matcher2.matches()) {
                    position.setErrorIndex(0);
                    return null;
                }
                try {
                    UUID uuid = UUID.fromString(matcher2.group(1));
                    position.setIndex(value.length());
                    Domain domain = this.$domain;
                    if (Intrinsics.areEqual((Object)(domain != null && (domain = domain.getPoint()) != null ? domain.getObjectClass() : null), String.class)) {
                        return uuid.toString();
                    }
                    Domain domain2 = this.$domain;
                    if (Intrinsics.areEqual((Object)(domain2 != null && (domain2 = domain2.getPoint()) != null ? domain2.getObjectClass() : null), byte[].class)) {
                        return ObjectFormatterUtil.UUIDtoBytes((UUID)uuid, (this.$displayType == BinaryDisplayType.UUID_SWAP ? 1 : 0) != 0);
                    }
                    Domain domain3 = this.$domain;
                    if (Intrinsics.areEqual((Object)(domain3 != null && (domain3 = domain3.getPoint()) != null ? domain3.getObjectClass() : null), UUID.class)) {
                        return uuid;
                    }
                    return null;
                }
                catch (Exception e) {
                    position.setErrorIndex(0);
                    return null;
                }
            }

            public String format(Object value) {
                String string;
                if (this.$formatter == null || this.$config == null) {
                    Object object = value;
                    string = object != null ? object.toString() : null;
                } else {
                    string = this.$formatter.objectToString(value, this.$column, (ObjectFormatterConfig)this.$config);
                }
                return string;
            }

            protected String getErrorMessage() {
                String string = DataGridBundle.message((String)"UuidBinaryEditorFactory.error", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                return string;
            }
        };
    }

    private static final UnparsedValue getValueParser$lambda$0(Domain $domain, String text2, UnparsedValue.ParsingError e) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        UnparsedValue unparsedValue = UnparsedValueWithDomain.create(text2, $domain, e);
        Intrinsics.checkNotNullExpressionValue((Object)unparsedValue, (String)"create(...)");
        return unparsedValue;
    }

    public static final /* synthetic */ Pattern access$getUUID_PATTERN$p(UuidEditorFactory $this) {
        return $this.UUID_PATTERN;
    }
}

