/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.completion.providers;

import com.google.common.collect.Iterables;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.database.Dbms;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasExternal;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasNamed;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.ModelRelationManager;
import com.intellij.database.model.MultiRef;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.script.generator.NamingService;
import com.intellij.database.script.generator.NamingServices;
import com.intellij.database.symbols.DasSymbol;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeCategory;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.DbUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.NameChecker;
import com.intellij.database.util.QNameUtil;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UnorderedPair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveState;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.SqlNamesGenerator;
import com.intellij.sql.completion.SqlCompletionContributor;
import com.intellij.sql.completion.SqlCompletionUtil;
import com.intellij.sql.completion.options.SqlCodeCompletionSettings;
import com.intellij.sql.completion.providers.SqlCompletionProviderBase;
import com.intellij.sql.dialects.SqlDialectImplUtilCore;
import com.intellij.sql.dialects.SqlImportState;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.editor.SqlEditorOptions;
import com.intellij.sql.intentions.UtilsKt;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlBinaryExpression;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlJoinConditionClause;
import com.intellij.sql.psi.SqlJoinExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlReferenceList;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlUsingClause;
import com.intellij.sql.psi.impl.SqlFileImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlReferenceExpressionImpl;
import com.intellij.sql.psi.impl.SqlReferenceImpl;
import com.intellij.sql.psi.impl.SqlScopeProcessorBase;
import com.intellij.sql.symbols.DasSymbolUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.containers.FilteredTraverserBase;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBIterator;
import com.intellij.util.containers.MultiMap;
import icons.DatabaseIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlJoinSmartCompletionProvider
extends SqlCompletionProviderBase {
    public static final String ID_POSTFIX = "_id";

    private static JoinKind detectJoinKind(@NotNull String joinOp) {
        String s;
        if (joinOp == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(0);
        }
        if ((s = StringUtil.toLowerCase((String)joinOp)).contains("left")) {
            return JoinKind.LEFT;
        }
        if (s.contains("right")) {
            return JoinKind.RIGHT;
        }
        return JoinKind.OTHER;
    }

    private static JoinKind detectJoinKind(@Nullable SqlJoinExpression joinExpression) {
        if (joinExpression == null) {
            return JoinKind.OTHER;
        }
        if (joinExpression.isLeft()) {
            return JoinKind.LEFT;
        }
        if (joinExpression.isRight()) {
            return JoinKind.RIGHT;
        }
        return JoinKind.OTHER;
    }

    @NotNull
    private static Icon getIcon(int priority) {
        Icon icon = priority < 140 ? DatabaseIcons.ColGreyKey : DatabaseIcons.ColBlueKey;
        if (icon == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(1);
        }
        return icon;
    }

    private static boolean hasTableNameWithId(@NotNull DasForeignKey key2) {
        if (key2 == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(2);
        }
        String refTable = key2.getRefTableName();
        for (DasTypedObject dasTypedObject : key2.getColumnsRef().resolveObjects()) {
            String name2 = dasTypedObject.getName();
            DasObject parent = dasTypedObject.getDasParent();
            if (!StringUtil.containsIgnoreCase((String)name2, (String)"id") || !StringUtil.containsIgnoreCase((String)name2, (String)refTable) && (parent == null || !StringUtil.containsIgnoreCase((String)name2, (String)parent.getName()))) continue;
            return true;
        }
        return false;
    }

    private static int getPriority(@NotNull DasForeignKey key2) {
        int priority;
        if (key2 == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(3);
        }
        if ((priority = key2 instanceof FuzzyKey ? ((FuzzyKey)key2).priority : (key2 instanceof DasExternal ? 130 : 140)) == 130 && SqlJoinSmartCompletionProvider.hasTableNameWithId(key2)) {
            return priority + 5;
        }
        DasTypeCategory category = DasTypeCategory.UNKNOWN;
        for (DasTypedObject dasTypedObject : key2.getColumnsRef().resolveObjects()) {
            Dbms dbms = DbImplUtilCore.getDbms(dasTypedObject);
            SqlLanguageDialectEx dialect = (SqlLanguageDialectEx)ObjectUtils.notNull((Object)((SqlLanguageDialectEx)SqlLanguageDialect.EP.forDbms(dbms)), (Object)SqlDialectImplUtilCore.getDefaultSqlDialect());
            DasTypeCategory curCategory = dialect.getTypeSystem().getTypeCategory(dasTypedObject.getDasType().toDataType());
            if (category == DasTypeCategory.UNKNOWN) {
                category = curCategory;
                continue;
            }
            if (category == curCategory) continue;
            category = DasTypeCategory.UNKNOWN;
            break;
        }
        return priority -= (switch (category) {
            case DasTypeCategory.INTEGER -> 0;
            case DasTypeCategory.STRING -> 5;
            default -> 10;
        });
    }

    @Override
    protected void doAddCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result2) {
        if (parameters == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(4);
        }
        if (context == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(5);
        }
        if (result2 == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(6);
        }
        SqlJoinSmartCompletionProvider.suggestJoinStuff(parameters, result2, true);
    }

    public static void suggestForPredictedJoin(@NotNull String joinOp, @NotNull CompletionParameters parameters, @NotNull CompletionResultSet result2) {
        PsiFile file;
        if (joinOp == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(7);
        }
        if (parameters == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(8);
        }
        if (result2 == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(9);
        }
        if (!((file = parameters.getOriginalFile()) instanceof SqlFile)) {
            return;
        }
        PsiElement position = parameters.getPosition();
        PsiElement parent = position.getParent();
        SqlLanguageDialectEx dialect = SqlImplUtil.getSqlDialectSafe((PsiElement)file);
        ResultConsumer consumer = (priority, statement2) -> SqlJoinSmartCompletionProvider.addFkItem(result2, priority, joinOp + " " + statement2);
        JoinKind joinKind = SqlJoinSmartCompletionProvider.detectJoinKind(joinOp);
        PsiElement token = PsiTreeUtil.prevVisibleLeaf((PsiElement)position);
        SqlJoinExpression joinExpression = (SqlJoinExpression)PsiTreeUtil.getParentOfType((PsiElement)token, SqlJoinExpression.class);
        FilteredTraverserBase tableRefs = joinExpression != null ? ((SyntaxTraverser)SqlImplUtil.sqlTraverser((PsiElement)joinExpression).expand(e -> e instanceof SqlJoinExpression)).filter(e -> e instanceof SqlReferenceExpression || e instanceof SqlAsExpression) : JBIterable.of((Object)PsiTreeUtil.getParentOfType((PsiElement)token, (Class[])new Class[]{SqlReferenceExpression.class, SqlAsExpression.class}));
        for (PsiElement tableRef : tableRefs) {
            TableInfo leftTable = SqlJoinSmartCompletionProvider.retrieveTable((SqlExpression)tableRef);
            if (leftTable == null) continue;
            Collection<TableInfo> tables = SqlJoinSmartCompletionProvider.collectTablesForPredictedJoin(parent, leftTable, dialect);
            SqlJoinSmartCompletionProvider.suggestJoinConditions(parent, joinKind, dialect, tables, consumer, Collections.singleton(leftTable));
        }
        SqlJoinSmartCompletionProvider.suggestJoinUsing(parent, dialect, result2);
    }

    public static boolean suggestJoinStuff(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result2, boolean smartMode) {
        PsiElement context;
        if (parameters == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(10);
        }
        if (result2 == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(11);
        }
        if ((context = SqlJoinSmartCompletionProvider.getCompletionContextIfApplicable(parameters)) == null) {
            return true;
        }
        SqlLanguageDialectEx dialect = SqlImplUtil.getSqlDialectSafe(context);
        LinkedHashSet<TableInfo> tables = new LinkedHashSet<TableInfo>(SqlJoinSmartCompletionProvider.collectTablesForJoin(context, dialect));
        Project project = context.getProject();
        if (smartMode) {
            for (TableInfo table : tables) {
                SqlCompletionUtil.addLookupElement(dialect, DasSymbolUtil.wrapObjectToSymbol((DasObject)table.table, project), project, (Consumer<? super LookupElement>)result2, false, table.getPriority(), dialect.getDbms());
            }
        }
        SqlJoinExpression joinExpression = (SqlJoinExpression)PsiTreeUtil.getParentOfType((PsiElement)parameters.getPosition(), SqlJoinExpression.class);
        JoinKind joinKind = SqlJoinSmartCompletionProvider.detectJoinKind(joinExpression);
        ResultConsumer consumer = (priority, statement2) -> SqlJoinSmartCompletionProvider.addFkItem(result2, priority, statement2);
        SqlJoinSmartCompletionProvider.suggestJoinConditions(context, joinKind, dialect, tables, consumer, null);
        SqlJoinSmartCompletionProvider.suggestJoinUsing(context, dialect, result2);
        return false;
    }

    private static Collection<TableInfo> collectTablesForPredictedJoin(@NotNull PsiElement position, @NotNull TableInfo leftTable, @NotNull SqlLanguageDialectEx dialect) {
        SqlExpression place;
        if (position == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(12);
        }
        if (leftTable == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(13);
        }
        if (dialect == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(14);
        }
        if (!((place = leftTable.place) instanceof SqlReferenceExpressionImpl)) {
            return Collections.emptyList();
        }
        return SqlJoinSmartCompletionProvider.collectTablesForJoin(dialect, position, ((SqlReferenceExpressionImpl)place).getReference(), Collections.singleton(leftTable.table), null);
    }

    @Nullable
    private static PsiElement getCompletionContextIfApplicable(@NotNull CompletionParameters parameters) {
        PsiFile file;
        if (parameters == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(15);
        }
        if (!((file = parameters.getOriginalFile()) instanceof SqlFile)) {
            return null;
        }
        PsiElement position = parameters.getPosition();
        PsiElement parent = position.getParent();
        if (parent.getNextSibling() != null) {
            return null;
        }
        PsiElement grandPa = parent.getParent();
        if (grandPa instanceof SqlReferenceExpression && ((SqlReferenceExpression)grandPa).getQualifierExpression() != null) {
            return null;
        }
        return parent;
    }

    @NotNull
    public static Collection<TableInfo> collectTablesForJoinIfAny(@NotNull CompletionParameters parameters) {
        PsiElement context;
        if (parameters == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(16);
        }
        if ((context = SqlJoinSmartCompletionProvider.getCompletionContextIfApplicable(parameters)) == null) {
            List<TableInfo> list = Collections.emptyList();
            if (list == null) {
                SqlJoinSmartCompletionProvider.$$$reportNull$$$0(17);
            }
            return list;
        }
        return SqlJoinSmartCompletionProvider.collectTablesForJoin(context, SqlImplUtil.getSqlDialectSafe(context));
    }

    @NotNull
    private static Collection<TableInfo> collectTablesForJoin(@NotNull PsiElement position, @NotNull SqlLanguageDialectEx dialect) {
        SqlJoinExpression join2;
        if (position == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(18);
        }
        if (dialect == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(19);
        }
        if ((join2 = (SqlJoinExpression)PsiTreeUtil.getParentOfType((PsiElement)position, SqlJoinExpression.class)) == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                SqlJoinSmartCompletionProvider.$$$reportNull$$$0(20);
            }
            return list;
        }
        PsiElement parent = position.getParent();
        if (parent == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                SqlJoinSmartCompletionProvider.$$$reportNull$$$0(21);
            }
            return list;
        }
        ASTNode joinNode = FormatterUtil.getPreviousNonWhitespaceSibling((ASTNode)parent.getNode());
        if (joinNode == null || joinNode.getElementType() != SqlCommonKeywords.SQL_JOIN && joinNode.getElementType() != SqlCommonTokens.SQL_COMMA) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                SqlJoinSmartCompletionProvider.$$$reportNull$$$0(22);
            }
            return list;
        }
        if (!(parent instanceof SqlReferenceExpression)) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                SqlJoinSmartCompletionProvider.$$$reportNull$$$0(23);
            }
            return list;
        }
        PsiReference reference = parent.getReference();
        if (!(reference instanceof SqlReferenceImpl)) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                SqlJoinSmartCompletionProvider.$$$reportNull$$$0(24);
            }
            return list;
        }
        HashSet<DasTable> fromLeft = new HashSet<DasTable>();
        SqlJoinExpression topmost = (SqlJoinExpression)PsiTreeUtil.getTopmostParentOfType((PsiElement)join2, SqlJoinExpression.class);
        SqlJoinExpression mainJoin = topmost == null ? join2 : topmost;
        return SqlJoinSmartCompletionProvider.collectTablesForJoin(dialect, parent, (SqlReferenceImpl)reference, fromLeft, (PsiElement)mainJoin);
    }

    @NotNull
    public static Collection<TableInfo> collectTablesForJoin(final @NotNull SqlLanguageDialectEx dialect, final @NotNull PsiElement context, @NotNull SqlReferenceImpl reference, final @NotNull Collection<DasTable> fromLeft, @Nullable PsiElement mainJoin) {
        if (dialect == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(25);
        }
        if (context == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(26);
        }
        if (reference == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(27);
        }
        if (fromLeft == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(28);
        }
        if (mainJoin != null) {
            mainJoin.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

                public void visitElement(@NotNull PsiElement element) {
                    if (element == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    ContainerUtil.addAllNotNull((Collection)fromLeft, (Object[])new DasTable[]{SqlCompletionContributor.retrieveTable(element)});
                    super.visitElement(element);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/completion/providers/SqlJoinSmartCompletionProvider$1", "visitElement"));
                }
            });
        }
        final boolean findFuzzyKeys = SqlCodeCompletionSettings.getInstance().isSupportNonStrictForeignKeys();
        final HashSet fks = new HashSet();
        final MultiMap leftColumnsByName = new MultiMap();
        final ArrayList<DasColumn> leftIdColumns = new ArrayList<DasColumn>();
        for (DasTable table : fromLeft) {
            Iterables.addAll(fks, ModelRelationManager.getForeignKeys(context.getProject(), table));
            if (!findFuzzyKeys) continue;
            for (DasColumn column2 : DasUtil.getColumns(table)) {
                String name2 = StringUtil.toLowerCase((String)column2.getName());
                leftColumnsByName.putValue((Object)name2, (Object)column2);
                if (!name2.endsWith(ID_POSTFIX)) continue;
                leftIdColumns.add(column2);
            }
        }
        final PsiElement aliasContext = mainJoin != null ? mainJoin : reference.getElement();
        final ArrayList<TableInfo> result2 = new ArrayList<TableInfo>();
        reference.processResolveVariants(new SqlScopeProcessorBase(null, dialect, SqlImplUtil.getDataSources(context), context){

            public boolean shouldIncludeAllNamespaces() {
                return true;
            }

            public boolean suppressQualifier() {
                return true;
            }

            public boolean isResultEmpty() {
                return false;
            }

            public boolean executeTarget(@NotNull DasSymbol symbol, @Nullable DasType dasType, Boolean forcedCaseSens, @NotNull ResolveState state) {
                DasObject dasObject;
                if (symbol == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (state == null) {
                    2.$$$reportNull$$$0(1);
                }
                if ((dasObject = symbol.getDasObject()) instanceof DasTable) {
                    this.addLookupElement((DasTable)dasObject);
                }
                return true;
            }

            private void addLookupElement(@NotNull DasTable table) {
                if (table == null) {
                    2.$$$reportNull$$$0(2);
                }
                for (DasForeignKey fk : fks) {
                    if (!SqlJoinSmartCompletionProvider.cheapEquals(table, fk) || !table.equals(fk.getRefTable())) continue;
                    result2.add(new TableInfo(table, ObjectName.plain(this.suggestAlias(table, aliasContext)), null));
                    return;
                }
                for (DasTable info2 : fromLeft) {
                    if (!ModelRelationManager.getForeignKeys(context.getProject(), table, info2).isNotEmpty()) continue;
                    result2.add(new TableInfo(table, ObjectName.plain(this.suggestAlias(table, aliasContext)), null));
                    return;
                }
                if (fromLeft.contains(table)) {
                    return;
                }
                List<FuzzyKey> fuzzyKeys = this.addFuzzyKeys(table);
                if (!fuzzyKeys.isEmpty()) {
                    String alias = this.suggestAlias(table, aliasContext);
                    ObjectName aliasName = null;
                    if (alias != null) {
                        NamingService namingService = NamingServices.getNamingService(dialect.getDbms());
                        boolean isQuoted = namingService.isQuoted(alias);
                        alias = namingService.unquoteIdentifier(alias);
                        aliasName = ObjectName.create(alias, isQuoted);
                    }
                    result2.add(new TableInfo(table, aliasName, null, fuzzyKeys));
                }
            }

            @NotNull
            private List<FuzzyKey> addFuzzyKeys(@NotNull DasTable table) {
                if (table == null) {
                    2.$$$reportNull$$$0(3);
                }
                if (!findFuzzyKeys) {
                    List<FuzzyKey> list = Collections.emptyList();
                    if (list == null) {
                        2.$$$reportNull$$$0(4);
                    }
                    return list;
                }
                String tableNameKey = this.getNormalizedName(table);
                ArrayList<FuzzyKey> fuzzyKeys = new ArrayList<FuzzyKey>();
                for (DasColumn column2 : DasUtil.getColumns(table)) {
                    String name2 = StringUtil.toLowerCase((String)column2.getName());
                    if (name2.equals("id")) {
                        for (DasColumn refColumn : leftIdColumns) {
                            String prefix = StringUtil.trimEnd((String)refColumn.getName(), (String)SqlJoinSmartCompletionProvider.ID_POSTFIX);
                            if (!tableNameKey.endsWith(prefix)) continue;
                            fuzzyKeys.add(new FuzzyKey(column2, refColumn, 125));
                        }
                        continue;
                    }
                    for (DasColumn refColumn : leftColumnsByName.get((Object)name2)) {
                        fuzzyKeys.add(new FuzzyKey(column2, refColumn, 130));
                    }
                    if (!name2.endsWith(SqlJoinSmartCompletionProvider.ID_POSTFIX)) continue;
                    String prefix = StringUtil.trimEnd((String)name2, (String)SqlJoinSmartCompletionProvider.ID_POSTFIX);
                    for (DasColumn refColumn : leftColumnsByName.get((Object)"id")) {
                        DasTable refTable = refColumn.getTable();
                        String refTableName = refTable != null ? this.getNormalizedName(refTable) : null;
                        if (refTableName == null || !StringUtil.endsWith((CharSequence)refTableName, (CharSequence)prefix)) continue;
                        fuzzyKeys.add(new FuzzyKey(column2, refColumn, 125));
                    }
                }
                ArrayList<FuzzyKey> arrayList = fuzzyKeys;
                if (arrayList == null) {
                    2.$$$reportNull$$$0(5);
                }
                return arrayList;
            }

            @NotNull
            private String getNormalizedName(@NotNull DasTable table) {
                if (table == null) {
                    2.$$$reportNull$$$0(6);
                }
                String lowerCased = StringUtil.toLowerCase((String)table.getName());
                String string = (String)ObjectUtils.notNull((Object)StringUtil.unpluralize((String)lowerCased), (Object)lowerCased);
                if (string == null) {
                    2.$$$reportNull$$$0(7);
                }
                return string;
            }

            @Nullable
            private String suggestAlias(@NotNull DasTable table, @NotNull PsiElement element) {
                if (table == null) {
                    2.$$$reportNull$$$0(8);
                }
                if (element == null) {
                    2.$$$reportNull$$$0(9);
                }
                if (!SqlCodeCompletionSettings.getInstance().isUseAliasInJoinCompletion()) {
                    return null;
                }
                String tableName = table.getName();
                Collection<String> existingNames = SqlNamesGenerator.collectExistingNamesForContainingStatement(element);
                existingNames.add(tableName);
                return SqlNamesGenerator.suggestAliasName(element, existingNames, tableName);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 4, 5, 7 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "symbol";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "state";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 6: 
                    case 8: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "table";
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/sql/completion/providers/SqlJoinSmartCompletionProvider$2";
                        break;
                    }
                    case 9: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/sql/completion/providers/SqlJoinSmartCompletionProvider$2";
                        break;
                    }
                    case 4: 
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "addFuzzyKeys";
                        break;
                    }
                    case 7: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getNormalizedName";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "executeTarget";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "addLookupElement";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "addFuzzyKeys";
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 7: {
                        break;
                    }
                    case 6: {
                        objectArray = objectArray;
                        objectArray[2] = "getNormalizedName";
                        break;
                    }
                    case 8: 
                    case 9: {
                        objectArray = objectArray;
                        objectArray[2] = "suggestAlias";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 4, 5, 7 -> new IllegalStateException(string);
                };
            }
        });
        ArrayList<TableInfo> arrayList = result2;
        if (arrayList == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(29);
        }
        return arrayList;
    }

    private static boolean cheapEquals(@NotNull DasTable table, @NotNull DasForeignKey fk) {
        if (table == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(30);
        }
        if (fk == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(31);
        }
        return !(!Comparing.strEqual((String)table.getName(), (String)fk.getRefTableName(), (boolean)false) || !StringUtil.isEmpty((String)DasUtil.getSchema(table)) && !StringUtil.isEmpty((String)fk.getRefTableSchema()) && !Comparing.strEqual((String)DasUtil.getSchema(table), (String)fk.getRefTableSchema(), (boolean)false) || !StringUtil.isEmpty((String)DasUtil.getCatalog(table)) && !StringUtil.isEmpty((String)fk.getRefTableCatalog()) && !Comparing.strEqual((String)DasUtil.getCatalog(table), (String)fk.getRefTableCatalog(), (boolean)false));
    }

    private static void collectTables(@Nullable SqlExpression e, @NotNull Collection<TableInfo> tables) {
        if (tables == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(32);
        }
        if (e instanceof SqlJoinExpression) {
            SqlJoinSmartCompletionProvider.collectTables(((SqlJoinExpression)e).getLOperand(), tables);
            SqlJoinSmartCompletionProvider.collectTables(((SqlJoinExpression)e).getROperand(), tables);
            return;
        }
        ContainerUtil.addAllNotNull(tables, (Object[])new TableInfo[]{SqlJoinSmartCompletionProvider.retrieveTable(e)});
    }

    private static TableInfo retrieveTable(@Nullable SqlExpression o) {
        SqlAsExpression asExpr = (SqlAsExpression)ObjectUtils.tryCast((Object)o, SqlAsExpression.class);
        if (asExpr != null) {
            ObjectName name2 = DbSqlUtilCore.getName((DasObject)asExpr);
            if (name2.name.contains("IntellijIdeaRulezzz")) {
                name2 = null;
            }
            return SqlJoinSmartCompletionProvider.retrieveTable(asExpr.getExpression(), name2);
        }
        ObjectName aliasName = o instanceof SqlReferenceExpression ? DbSqlUtilCore.getName((SqlReferenceExpression)o) : null;
        return SqlJoinSmartCompletionProvider.retrieveTable(o, aliasName);
    }

    @Nullable
    private static TableInfo retrieveTable(@Nullable SqlExpression place, @Nullable ObjectName alias) {
        DasTable table = SqlCompletionContributor.retrieveTable((PsiElement)place);
        return table == null ? null : new TableInfo(table, alias, place);
    }

    @Nullable
    private static ColumnQName getColumnQName(@Nullable SqlExpression place) {
        if (!(place instanceof SqlReferenceExpression)) {
            return null;
        }
        String columnName = ((SqlReferenceExpression)place).getName();
        SqlExpression qualifierExpression = ((SqlReferenceExpression)place).getQualifierExpression();
        String tableName = qualifierExpression != null ? qualifierExpression.getText() : "";
        return new ColumnQName(tableName, columnName);
    }

    public static void suggestJoinConditions(@NotNull PsiElement position, @NotNull JoinKind joinKind, @NotNull SqlLanguageDialectEx sqlDialect, @NotNull Collection<TableInfo> right, @NotNull ResultConsumer result2, @Nullable Collection<TableInfo> left) {
        boolean appendTable;
        PsiElement parent;
        if (position == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(33);
        }
        if (joinKind == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(34);
        }
        if (sqlDialect == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(35);
        }
        if (right == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(36);
        }
        if (result2 == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(37);
        }
        if ((parent = position.getParent()) == null) {
            return;
        }
        ASTNode sibling = FormatterUtil.getPreviousNonWhitespaceSibling((ASTNode)parent.getNode());
        IElementType type = sibling == null ? null : sibling.getElementType();
        SqlJoinConditionClause conditionClause = (SqlJoinConditionClause)PsiTreeUtil.getParentOfType((PsiElement)position, SqlJoinConditionClause.class);
        boolean appendCondition = conditionClause != null;
        boolean bl = appendTable = left != null || type == SqlCommonKeywords.SQL_JOIN;
        if (!appendCondition && !appendTable) {
            return;
        }
        SqlJoinExpression join2 = (SqlJoinExpression)PsiTreeUtil.getParentOfType((PsiElement)position, SqlJoinExpression.class);
        if (left == null && join2 == null) {
            return;
        }
        if (join2 != null) {
            left = new LinkedHashSet<TableInfo>();
            SqlJoinSmartCompletionProvider.collectTables(join2.getLOperand(), left);
        }
        if (!appendTable) {
            SqlJoinSmartCompletionProvider.collectTables(join2.getROperand(), right);
        }
        Project project = position.getProject();
        HashSet<UnorderedPair<ColumnQName>> usedColumns = new HashSet<UnorderedPair<ColumnQName>>();
        Dbms dbms = sqlDialect.getDbms();
        for (SqlBinaryExpression equality : SqlImplUtil.sqlTraverser((PsiElement)conditionClause).filter(SqlBinaryExpression.class)) {
            if (!UtilsKt.isEquality(equality, dbms)) continue;
            ColumnQName qName1 = SqlJoinSmartCompletionProvider.getColumnQName(equality.getLOperand());
            ColumnQName qName2 = SqlJoinSmartCompletionProvider.getColumnQName(equality.getROperand());
            if (qName1 == null || qName2 == null) continue;
            usedColumns.add((UnorderedPair<ColumnQName>)new UnorderedPair((Object)qName1, (Object)qName2));
        }
        SqlJoinSmartCompletionProvider.processTables(project, position, left, right, sqlDialect, joinKind, usedColumns, result2, join2 == null ? null : join2.getLOperand());
    }

    @Nullable
    public static String collectUsingCandidatesAndGetStatement(@NotNull PsiElement position, @NotNull SqlLanguageDialectEx sqlDialect, @NotNull Map<String, DasSymbol> toColumn, @NotNull List<String> usingCandidates) {
        String name2;
        int i2;
        SqlUsingClause using;
        SqlJoinExpression join2;
        if (position == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(38);
        }
        if (sqlDialect == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(39);
        }
        if (toColumn == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(40);
        }
        if (usingCandidates == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(41);
        }
        SqlJoinExpression sqlJoinExpression = join2 = (using = (SqlUsingClause)PsiTreeUtil.getParentOfType((PsiElement)position, SqlUsingClause.class)) == null ? null : (SqlJoinExpression)ObjectUtils.tryCast((Object)using.getParent(), SqlJoinExpression.class);
        if (join2 == null) {
            return null;
        }
        SqlReferenceList refs = using.getReferenceList();
        if (refs == null || !PsiTreeUtil.isContextAncestor((PsiElement)refs, (PsiElement)position, (boolean)false)) {
            return null;
        }
        SqlExpression right = join2.getROperand();
        SqlTableType ltype = (SqlTableType)ObjectUtils.tryCast((Object)join2.getLOperand().getDasType(), SqlTableType.class);
        SqlTableType rtype = (SqlTableType)ObjectUtils.tryCast((Object)(right == null ? null : right.getDasType()), SqlTableType.class);
        if (ltype == null || rtype == null) {
            return null;
        }
        Set<String> lnames = DasUtil.newCaseAwareSet(false);
        Set<String> rnames = DasUtil.newCaseAwareSet(false);
        HashSet<String> excluded = new HashSet<String>();
        for (i2 = 0; i2 < ltype.getColumnCount(); ++i2) {
            name2 = ltype.getColumnName(i2);
            DasSymbol columnSymbol = DasSymbolUtil.getSymbolByPsi(ltype.getColumnElement(i2));
            if (columnSymbol != null) {
                toColumn.put(name2, columnSymbol);
            }
            if (lnames.add(name2)) continue;
            excluded.add(name2);
        }
        for (i2 = 0; i2 < rtype.getColumnCount(); ++i2) {
            name2 = rtype.getColumnName(i2);
            if (rnames.add(name2)) continue;
            excluded.add(name2);
        }
        for (i2 = 0; i2 < ltype.getColumnCount(); ++i2) {
            name2 = ltype.getColumnName(i2);
            if (!rnames.contains(name2) || excluded.contains(name2)) continue;
            usingCandidates.add(name2);
        }
        if (usingCandidates.size() >= 2 || refs.getReferenceList().size() > 1) {
            DdlBuilder builder = SqlJoinSmartCompletionProvider.newBuilder(position.getProject(), sqlDialect);
            for (String candidate2 : usingCandidates) {
                if (!builder.isEmpty()) {
                    builder.symbol(", ");
                }
                builder.columnRef(candidate2);
            }
            return builder.getStatement();
        }
        return null;
    }

    private static void suggestJoinUsing(@NotNull PsiElement position, @NotNull SqlLanguageDialectEx sqlDialect, @NotNull CompletionResultSet result2) {
        ArrayList<String> usingCandidates;
        HashMap<String, DasSymbol> toColumn;
        String statement2;
        if (position == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(42);
        }
        if (sqlDialect == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(43);
        }
        if (result2 == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(44);
        }
        if (!StringUtil.isEmptyOrSpaces((String)(statement2 = SqlJoinSmartCompletionProvider.collectUsingCandidatesAndGetStatement(position, sqlDialect, toColumn = new HashMap<String, DasSymbol>(), usingCandidates = new ArrayList<String>())))) {
            result2.addElement(PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create((String)statement2).withIcon(DatabaseIcons.ColBlueKey), (double)90.0));
        }
        Dbms dbms = SqlImplUtil.getDbms(position);
        for (String candidate2 : usingCandidates) {
            SqlCompletionUtil.addLookupElement(sqlDialect, dbms, (DasSymbol)toColumn.get(candidate2), null, position.getProject(), (Consumer<? super LookupElement>)result2, false, 90.0, PsiTreeUtil.getParentOfType((PsiElement)position, SqlReferenceExpression.class));
        }
    }

    private static void processForeignKeys(@NotNull Project project, @NotNull SqlLanguageDialectEx sqlDialect, @NotNull TableInfo first2, @NotNull TableInfo second, @NotNull Set<UnorderedPair<ColumnQName>> usedColumns, @NotNull KeyConsumer result2, @Nullable SqlExpression lOperand) {
        if (project == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(45);
        }
        if (sqlDialect == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(46);
        }
        if (first2 == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(47);
        }
        if (second == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(48);
        }
        if (usedColumns == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(49);
        }
        if (result2 == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(50);
        }
        SqlJoinSmartCompletionProvider.foreignKeyStatements(project, sqlDialect, first2, second, lOperand, usedColumns, result2);
    }

    private static void addFkItem(@NotNull CompletionResultSet result2, int priority, String s) {
        if (result2 == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(51);
        }
        Icon icon = SqlJoinSmartCompletionProvider.getIcon(priority);
        result2.addElement(PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create((String)s).withIcon(icon), (double)priority));
    }

    private static void foreignKeyStatements(@NotNull Project project, @NotNull SqlLanguageDialectEx sqlDialect, @NotNull TableInfo firstTable, @NotNull TableInfo secondTable, @Nullable SqlExpression lOperand, @NotNull Set<UnorderedPair<ColumnQName>> usedColumns, @NotNull KeyConsumer result2) {
        if (project == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(52);
        }
        if (sqlDialect == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(53);
        }
        if (firstTable == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(54);
        }
        if (secondTable == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(55);
        }
        if (usedColumns == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(56);
        }
        if (result2 == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(57);
        }
        boolean ancestor = secondTable.place != null && PsiTreeUtil.isContextAncestor((PsiElement)lOperand, (PsiElement)secondTable.place, (boolean)false);
        boolean leftToRight = ancestor ^ SqlCodeCompletionSettings.getInstance().isInvertOrderInOnClause();
        for (DasForeignKey key2 : ModelRelationManager.getForeignKeys(project, secondTable.table, firstTable.table)) {
            SqlJoinSmartCompletionProvider.foreignKeyStatement(project, sqlDialect, firstTable, secondTable, leftToRight, key2, usedColumns, result2);
        }
        for (DasForeignKey key2 : secondTable.fuzzyKeys) {
            SqlJoinSmartCompletionProvider.foreignKeyStatement(project, sqlDialect, firstTable, secondTable, leftToRight, key2, usedColumns, result2);
        }
    }

    private static void foreignKeyStatement(@NotNull Project project, @NotNull SqlLanguageDialectEx sqlDialect, @NotNull TableInfo firstTable, @NotNull TableInfo secondTable, boolean leftToRight, DasForeignKey key2, @NotNull Set<UnorderedPair<ColumnQName>> usedColumns, @NotNull KeyConsumer result2) {
        if (project == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(58);
        }
        if (sqlDialect == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(59);
        }
        if (firstTable == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(60);
        }
        if (secondTable == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(61);
        }
        if (usedColumns == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(62);
        }
        if (result2 == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(63);
        }
        if (firstTable.table.equals(key2.getRefTable())) {
            MultiRef<? extends DasTypedObject> cols = key2.getColumnsRef();
            MultiRef<? extends DasTypedObject> refCols = key2.getRefColumns();
            if (cols.size() == refCols.size()) {
                DdlBuilder builder = SqlJoinSmartCompletionProvider.newBuilder(project, sqlDialect);
                boolean first2 = true;
                Iterator<ObjectName> refIt = SqlJoinSmartCompletionProvider.iterateNames(refCols);
                for (ObjectName name2 : JBIterable.once(SqlJoinSmartCompletionProvider.iterateNames(cols))) {
                    ColumnQName refColQName;
                    ColumnQName colQName;
                    if (first2) {
                        first2 = false;
                    } else {
                        builder.space().keyword("and").space();
                    }
                    ObjectName refName = refIt.next();
                    DasTable table = key2.getTable();
                    DasTable refTable = key2.getRefTable();
                    if (table == null || refTable == null) {
                        return;
                    }
                    if (!usedColumns.isEmpty() && usedColumns.contains(new UnorderedPair((Object)(colQName = new ColumnQName(SqlJoinSmartCompletionProvider.getJoinRefQualifier(name2, secondTable, firstTable, table, sqlDialect), name2.name)), (Object)(refColQName = new ColumnQName(SqlJoinSmartCompletionProvider.getJoinRefQualifier(refName, firstTable, secondTable, refTable, sqlDialect), refName.name))))) {
                        return;
                    }
                    Runnable leftPart = () -> SqlJoinSmartCompletionProvider.appendJoinPart(name2, secondTable, firstTable, table, builder, sqlDialect);
                    Runnable rightPart = () -> SqlJoinSmartCompletionProvider.appendJoinPart(refName, firstTable, secondTable, refTable, builder, sqlDialect);
                    (leftToRight ? leftPart : rightPart).run();
                    builder.space().symbol("=").space();
                    (leftToRight ? rightPart : leftPart).run();
                }
                result2.consume(key2, builder.getStatement());
            }
        }
    }

    @NotNull
    private static DdlBuilder newBuilder(@NotNull Project project, @NotNull SqlLanguageDialectEx sqlDialect) {
        if (project == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(64);
        }
        if (sqlDialect == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(65);
        }
        DdlBuilder ddlBuilder = new DdlBuilder().withDialect(sqlDialect.getDatabaseDialect()).applyCodeStyle(project, sqlDialect);
        if (ddlBuilder == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(66);
        }
        return ddlBuilder;
    }

    private static Iterator<ObjectName> iterateNames(MultiRef<? extends DasObject> ref2) {
        final MultiRef.It<? extends DasObject> it = ref2.iterate();
        return new JBIterator<ObjectName>(){

            protected ObjectName nextImpl() {
                if (!it.hasNext()) {
                    return (ObjectName)this.stop();
                }
                String name2 = (String)it.next();
                DasObject obj2 = (DasObject)it.resolve();
                return obj2 == null ? ObjectName.plain(name2) : DbSqlUtilCore.getName(obj2);
            }
        };
    }

    private static boolean shouldQualifyJoinRef(@NotNull ObjectName columnName, @NotNull TableInfo pairedInfo, @NotNull SqlLanguageDialectEx sqlDialect) {
        if (columnName == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(67);
        }
        if (pairedInfo == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(68);
        }
        if (sqlDialect == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(69);
        }
        SqlEditorOptions options = SqlEditorOptions.getInstance();
        SqlEditorOptions.QualificationType qualification = options.getTableQualification().and(options.getJoinConditionQualification());
        NameChecker nameChecker = new NameChecker(columnName.name, columnName.quoted, sqlDialect, sqlDialect);
        DasColumn sameColumnInPairedTable = (DasColumn)DasUtil.getColumns(pairedInfo.table).find(c2 -> nameChecker.checkName((DasNamed)c2, null));
        return qualification.shouldQualify(sameColumnInPairedTable != null ? 2 : 1);
    }

    @NotNull
    private static String getJoinRefQualifier(@NotNull ObjectName columnName, @NotNull TableInfo info2, @NotNull TableInfo pairedInfo, @NotNull DasTable relatedTable, @NotNull SqlLanguageDialectEx sqlDialect) {
        if (columnName == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(70);
        }
        if (info2 == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(71);
        }
        if (pairedInfo == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(72);
        }
        if (relatedTable == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(73);
        }
        if (sqlDialect == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(74);
        }
        if (!SqlJoinSmartCompletionProvider.shouldQualifyJoinRef(columnName, pairedInfo, sqlDialect)) {
            return "";
        }
        String string = info2.alias == null ? relatedTable.getName() : info2.alias.name;
        if (string == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(75);
        }
        return string;
    }

    private static void appendJoinPart(@NotNull ObjectName columnName, @NotNull TableInfo info2, @NotNull TableInfo pairedInfo, @NotNull DasTable relatedTable, @NotNull DdlBuilder builder, @NotNull SqlLanguageDialectEx sqlDialect) {
        if (columnName == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(76);
        }
        if (info2 == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(77);
        }
        if (pairedInfo == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(78);
        }
        if (relatedTable == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(79);
        }
        if (builder == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(80);
        }
        if (sqlDialect == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(81);
        }
        if (SqlJoinSmartCompletionProvider.shouldQualifyJoinRef(columnName, pairedInfo, sqlDialect)) {
            (info2.alias == null ? builder.identifier(relatedTable) : builder.identifier(info2.alias, ObjectKind.TABLE)).symbol(".");
        }
        builder.identifier(columnName, ObjectKind.COLUMN);
    }

    private static void processTables(@NotNull Project project, @NotNull PsiElement position, @NotNull Collection<TableInfo> left, @NotNull Collection<TableInfo> right, @NotNull SqlLanguageDialectEx sqlDialect, @NotNull JoinKind joinKind, @NotNull Set<UnorderedPair<ColumnQName>> usedColumns, @NotNull ResultConsumer result2, @Nullable SqlExpression lOperand) {
        if (project == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(82);
        }
        if (position == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(83);
        }
        if (left == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(84);
        }
        if (right == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(85);
        }
        if (sqlDialect == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(86);
        }
        if (joinKind == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(87);
        }
        if (usedColumns == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(88);
        }
        if (result2 == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(89);
        }
        MultiMap rightByName = ContainerUtil.groupBy(right, info2 -> info2.table.getName());
        DdlBuilder builder = SqlJoinSmartCompletionProvider.newBuilder(project, sqlDialect);
        String and = builder.keyword("and").getStatement();
        MultiMap allStatements = new MultiMap(new TreeMap(Comparator.reverseOrder()));
        Map<DasTable, Boolean> shouldQualifyCache = SqlJoinSmartCompletionProvider.createShouldQualifyCache(position, sqlDialect);
        SqlEditorOptions options = SqlEditorOptions.getInstance();
        SqlEditorOptions.QualificationType qualification = DbSqlUtilCore.getQualification(ObjectKind.TABLE, sqlDialect.getDbms()).and(options.getJoinConditionQualification());
        for (String candidateName : rightByName.keySet()) {
            Collection candidates2 = rightByName.get((Object)candidateName);
            boolean shouldQualify = false;
            block0 : switch (qualification) {
                case SMART: {
                    int candidateCount = candidates2.size();
                    if (candidateCount > 1) {
                        Iterator iterator = candidates2.iterator();
                        TableInfo first2 = (TableInfo)iterator.next();
                        NameChecker nameChecker = new NameChecker(first2.table, sqlDialect);
                        while (iterator.hasNext()) {
                            TableInfo next = (TableInfo)iterator.next();
                            if (!shouldQualifyCache.get(next.table).booleanValue() && !nameChecker.checkName(next.table, null)) continue;
                            shouldQualify = true;
                            break block0;
                        }
                        break;
                    }
                    if (candidateCount != 1) break;
                    shouldQualify = shouldQualifyCache.get(((TableInfo)ContainerUtil.getFirstItem((Collection)candidates2)).table);
                    break;
                }
                case ALWAYS: {
                    shouldQualify = true;
                }
            }
            for (TableInfo r : candidates2) {
                if (left.contains(r)) continue;
                builder.clear();
                if (shouldQualify) {
                    SqlJoinSmartCompletionProvider.addParentQualifier(r.table, builder);
                }
                builder.identifier(r.table).space();
                if (r.alias != null) {
                    builder.identifier(r.alias, ObjectKind.TABLE).space();
                }
                String tableRef = r.place == null ? builder.keyword("on").space().getStatement() : "";
                ArrayList currentStatements = new ArrayList();
                KeyConsumer keyConsumer = (key2, statement2) -> {
                    DasTable fromTable = key2.getTable();
                    DasTable toTable = key2.getRefTable();
                    int priority = SqlJoinSmartCompletionProvider.getPriority(key2);
                    if (joinKind == JoinKind.LEFT && fromTable == r.table || joinKind == JoinKind.RIGHT && toTable == r.table) {
                        ++priority;
                    }
                    currentStatements.add(Pair.create((Object)priority, (Object)statement2));
                };
                for (TableInfo l : left) {
                    SqlJoinSmartCompletionProvider.processForeignKeys(project, sqlDialect, r, l, usedColumns, keyConsumer, lOperand);
                    SqlJoinSmartCompletionProvider.processForeignKeys(project, sqlDialect, l, r, usedColumns, keyConsumer, lOperand);
                }
                if (currentStatements.size() == 2) {
                    Pair statement1 = (Pair)currentStatements.get(0);
                    Pair statement22 = (Pair)currentStatements.get(1);
                    String text2 = tableRef + (String)statement1.second + " " + and + " " + (String)statement22.second;
                    int priority = Math.min((Integer)statement1.first, (Integer)statement22.first);
                    allStatements.putValue((Object)priority, (Object)text2);
                }
                for (Pair statement3 : currentStatements) {
                    allStatements.putValue((Object)((Integer)statement3.first), (Object)(tableRef + (String)statement3.second));
                }
            }
        }
        for (Map.Entry entry : allStatements.entrySet()) {
            int priority = (Integer)entry.getKey();
            for (String statements2 : (Collection)entry.getValue()) {
                result2.consume(priority, statements2);
            }
        }
    }

    @NotNull
    private static Map<DasTable, Boolean> createShouldQualifyCache(@NotNull PsiElement position, @NotNull SqlLanguageDialectEx sqlDialect) {
        if (position == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(90);
        }
        if (sqlDialect == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(91);
        }
        Map map2 = FactoryMap.create(table -> {
            PsiFile psiFile = position.getContainingFile();
            if (!(psiFile instanceof SqlFile)) {
                return false;
            }
            SqlFile sqlFile = (SqlFile)psiFile;
            SqlScopeProcessorBase processor2 = new SqlScopeProcessorBase(null, sqlDialect, (List)SqlImplUtil.getDataSources((PsiElement)sqlFile), position){

                public boolean isResultEmpty() {
                    return false;
                }
            };
            SqlImportState importState = SqlDialectImplUtilCore.getImportCheckerAt(sqlFile, position);
            if (processor2.getDataSources().isEmpty()) {
                Condition<DasObject> condition = SqlFileImpl.importedCondition(importState, null, false);
                return !(condition = SqlFileImpl.getFullExpandConditon(condition, null, processor2, position)).value((Object)table.getDasParent());
            }
            return !SqlImplUtil.traverseDataSources(processor2.getDataSources(), importState, dataSource -> {
                Condition<DasObject> condition = SqlFileImpl.importedCondition(importState, dataSource.getDelegate(), false);
                DbDataSource dataSourceForExpand = DbUtil.getDasObject(table) instanceof BasicElement ? dataSource : null;
                condition = SqlFileImpl.getFullExpandConditon(condition, dataSourceForExpand, processor2, position);
                return condition.value((Object)table.getDasParent());
            });
        });
        if (map2 == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(92);
        }
        return map2;
    }

    private static void addParentQualifier(@NotNull DasTable table, @NotNull DdlBuilder builder) {
        DasObject parent;
        if (table == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(93);
        }
        if (builder == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(94);
        }
        if ((parent = table.getDasParent()) != null && StringUtil.isNotEmpty((String)parent.getName())) {
            builder.identifier(parent).symbol(".");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 17, 20, 21, 22, 23, 24, 29, 66, 75, 92 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "joinOp";
                break;
            }
            case 1: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 29: 
            case 66: 
            case 75: 
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/completion/providers/SqlJoinSmartCompletionProvider";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 4: 
            case 8: 
            case 10: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 5: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: 
            case 9: 
            case 11: 
            case 37: 
            case 44: 
            case 50: 
            case 51: 
            case 57: 
            case 63: 
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 12: 
            case 18: 
            case 33: 
            case 38: 
            case 42: 
            case 83: 
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leftTable";
                break;
            }
            case 14: 
            case 19: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromLeft";
                break;
            }
            case 30: 
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fk";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tables";
                break;
            }
            case 34: 
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "joinKind";
                break;
            }
            case 35: 
            case 39: 
            case 43: 
            case 46: 
            case 53: 
            case 59: 
            case 65: 
            case 69: 
            case 74: 
            case 81: 
            case 86: 
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqlDialect";
                break;
            }
            case 36: 
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "right";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toColumn";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usingCandidates";
                break;
            }
            case 45: 
            case 52: 
            case 58: 
            case 64: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "second";
                break;
            }
            case 49: 
            case 56: 
            case 62: 
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usedColumns";
                break;
            }
            case 54: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "firstTable";
                break;
            }
            case 55: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "secondTable";
                break;
            }
            case 67: 
            case 70: 
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnName";
                break;
            }
            case 68: 
            case 72: 
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pairedInfo";
                break;
            }
            case 71: 
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 73: 
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relatedTable";
                break;
            }
            case 80: 
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "left";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/completion/providers/SqlJoinSmartCompletionProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "collectTablesForJoinIfAny";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "collectTablesForJoin";
                break;
            }
            case 66: {
                objectArray = objectArray2;
                objectArray2[1] = "newBuilder";
                break;
            }
            case 75: {
                objectArray = objectArray2;
                objectArray2[1] = "getJoinRefQualifier";
                break;
            }
            case 92: {
                objectArray = objectArray2;
                objectArray2[1] = "createShouldQualifyCache";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "detectJoinKind";
                break;
            }
            case 1: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 29: 
            case 66: 
            case 75: 
            case 92: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "hasTableNameWithId";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPriority";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "doAddCompletions";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "suggestForPredictedJoin";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "suggestJoinStuff";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "collectTablesForPredictedJoin";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getCompletionContextIfApplicable";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "collectTablesForJoinIfAny";
                break;
            }
            case 18: 
            case 19: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "collectTablesForJoin";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "cheapEquals";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "collectTables";
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "suggestJoinConditions";
                break;
            }
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "collectUsingCandidatesAndGetStatement";
                break;
            }
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "suggestJoinUsing";
                break;
            }
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "processForeignKeys";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "addFkItem";
                break;
            }
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "foreignKeyStatements";
                break;
            }
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "foreignKeyStatement";
                break;
            }
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "newBuilder";
                break;
            }
            case 67: 
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "shouldQualifyJoinRef";
                break;
            }
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "getJoinRefQualifier";
                break;
            }
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "appendJoinPart";
                break;
            }
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "processTables";
                break;
            }
            case 90: 
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "createShouldQualifyCache";
                break;
            }
            case 93: 
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "addParentQualifier";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 17, 20, 21, 22, 23, 24, 29, 66, 75, 92 -> new IllegalStateException(string);
        };
    }

    public static enum JoinKind {
        LEFT,
        RIGHT,
        OTHER;

    }

    private static final class FuzzyKey
    implements DasForeignKey {
        @NotNull
        private final DasColumn column;
        @NotNull
        private final DasColumn refColumn;
        final int priority;

        private FuzzyKey(@NotNull DasColumn column2, @NotNull DasColumn refColumn, int priority) {
            if (column2 == null) {
                FuzzyKey.$$$reportNull$$$0(0);
            }
            if (refColumn == null) {
                FuzzyKey.$$$reportNull$$$0(1);
            }
            this.column = column2;
            this.refColumn = refColumn;
            this.priority = priority;
        }

        @Override
        public String getRefTableName() {
            return this.getRefTable().getName();
        }

        @Override
        public String getRefTableSchema() {
            return DasUtil.getSchema(this.getRefTable());
        }

        @Override
        public String getRefTableCatalog() {
            return DasUtil.getCatalog(this.getRefTable());
        }

        @Override
        @NotNull
        public DasTable getRefTable() {
            DasTable dasTable = Objects.requireNonNull(this.refColumn.getTable());
            if (dasTable == null) {
                FuzzyKey.$$$reportNull$$$0(2);
            }
            return dasTable;
        }

        @Override
        @NotNull
        public MultiRef<? extends DasTypedObject> getRefColumns() {
            MultiRef<DasColumn> multiRef = DasUtil.asRef(Collections.singleton(this.refColumn));
            if (multiRef == null) {
                FuzzyKey.$$$reportNull$$$0(3);
            }
            return multiRef;
        }

        @Override
        public DasForeignKey.RuleAction getDeleteRule() {
            return null;
        }

        @Override
        public DasForeignKey.RuleAction getUpdateRule() {
            return null;
        }

        @Override
        public DasForeignKey.Deferrability getDeferrability() {
            return null;
        }

        @Override
        @NotNull
        public MultiRef<? extends DasTypedObject> getColumnsRef() {
            MultiRef<DasColumn> multiRef = DasUtil.asRef(Collections.singleton(this.column));
            if (multiRef == null) {
                FuzzyKey.$$$reportNull$$$0(4);
            }
            return multiRef;
        }

        @Override
        @NotNull
        public DasTable getTable() {
            DasTable dasTable = Objects.requireNonNull(this.column.getTable());
            if (dasTable == null) {
                FuzzyKey.$$$reportNull$$$0(5);
            }
            return dasTable;
        }

        @Override
        @NotNull
        public ObjectKind getKind() {
            ObjectKind objectKind = ObjectKind.FOREIGN_KEY;
            if (objectKind == null) {
                FuzzyKey.$$$reportNull$$$0(6);
            }
            return objectKind;
        }

        @Override
        @NotNull
        public String getName() {
            return "";
        }

        @Override
        public boolean isQuoted() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3, 4, 5, 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "column";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "refColumn";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/completion/providers/SqlJoinSmartCompletionProvider$FuzzyKey";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/completion/providers/SqlJoinSmartCompletionProvider$FuzzyKey";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRefTable";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRefColumns";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getColumnsRef";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTable";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKind";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3, 4, 5, 6 -> new IllegalStateException(string);
            };
        }
    }

    @FunctionalInterface
    public static interface ResultConsumer
    extends KeyConsumer {
        public void consume(int var1, @NotNull String var2);

        @Override
        default public void consume(@NotNull DasForeignKey key2, @NotNull String text2) {
            if (key2 == null) {
                ResultConsumer.$$$reportNull$$$0(0);
            }
            if (text2 == null) {
                ResultConsumer.$$$reportNull$$$0(1);
            }
            this.consume(SqlJoinSmartCompletionProvider.getPriority(key2), text2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "key";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "text";
                    break;
                }
            }
            objectArray[1] = "com/intellij/sql/completion/providers/SqlJoinSmartCompletionProvider$ResultConsumer";
            objectArray[2] = "consume";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class TableInfo {
        final DasTable table;
        final ObjectName alias;
        final SqlExpression place;
        @NotNull
        private final String qualifiedName;
        @NotNull
        final Collection<FuzzyKey> fuzzyKeys;

        public TableInfo(@NotNull DasTable table, @Nullable ObjectName alias, @Nullable SqlExpression place) {
            if (table == null) {
                TableInfo.$$$reportNull$$$0(0);
            }
            this(table, alias, place, Collections.emptyList());
        }

        public TableInfo(@NotNull DasTable table, @Nullable ObjectName alias, @Nullable SqlExpression place, @NotNull Collection<FuzzyKey> fuzzyKeys) {
            if (table == null) {
                TableInfo.$$$reportNull$$$0(1);
            }
            if (fuzzyKeys == null) {
                TableInfo.$$$reportNull$$$0(2);
            }
            this.table = table;
            this.alias = alias;
            this.place = place;
            this.qualifiedName = QNameUtil.getQualifiedName(table);
            this.fuzzyKeys = fuzzyKeys;
        }

        public int getPriority() {
            if (this.fuzzyKeys.isEmpty()) {
                return 90;
            }
            int max = 0;
            for (FuzzyKey key2 : this.fuzzyKeys) {
                if (key2.priority <= max) continue;
                max = key2.priority;
            }
            int diff = 140 - max;
            return 90 - diff;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TableInfo info2 = (TableInfo)o;
            return this.qualifiedName.equals(info2.qualifiedName);
        }

        public int hashCode() {
            return Objects.hash(this.qualifiedName);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "table";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "fuzzyKeys";
                    break;
                }
            }
            objectArray[1] = "com/intellij/sql/completion/providers/SqlJoinSmartCompletionProvider$TableInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class ColumnQName {
        @NotNull
        final String tableName;
        @NotNull
        final String columnName;

        private ColumnQName(@NotNull String tableName, @NotNull String columnName) {
            if (tableName == null) {
                ColumnQName.$$$reportNull$$$0(0);
            }
            if (columnName == null) {
                ColumnQName.$$$reportNull$$$0(1);
            }
            this.tableName = StringUtil.toLowerCase((String)tableName);
            this.columnName = StringUtil.toLowerCase((String)columnName);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ColumnQName name2 = (ColumnQName)o;
            return this.tableName.equals(name2.tableName) && this.columnName.equals(name2.columnName);
        }

        public int hashCode() {
            return Objects.hash(this.tableName, this.columnName);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "tableName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "columnName";
                    break;
                }
            }
            objectArray[1] = "com/intellij/sql/completion/providers/SqlJoinSmartCompletionProvider$ColumnQName";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    @FunctionalInterface
    public static interface KeyConsumer {
        public void consume(@NotNull DasForeignKey var1, @NotNull String var2);
    }
}

