/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter.model;

import com.intellij.formatting.Spacing;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.formatter.model.SqlBlock;
import com.intellij.sql.formatter.model.SqlFormattingContext;
import com.intellij.sql.formatter.model.SqlFormattingModelFun;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlTokens;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0016\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u001b\u0010\b\u001a\n \t*\u0004\u0018\u00010\u00030\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\n\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"KEEP_BLANK_LINES", "", "makeSpacingBeforeStatementDelimiter", "Lcom/intellij/formatting/Spacing;", "context", "Lcom/intellij/sql/formatter/model/SqlFormattingContext;", "delimiterBlock", "Lcom/intellij/sql/formatter/model/SqlBlock;", "makeSpacingBetweenStatements", "kotlin.jvm.PlatformType", "(Lcom/intellij/sql/formatter/model/SqlFormattingContext;)Lcom/intellij/formatting/Spacing;", "intellij.database.sql.core.impl"})
public final class SqlFileBlockKt {
    private static final int KEEP_BLANK_LINES = 3;

    @NotNull
    public static final Spacing makeSpacingBeforeStatementDelimiter(@NotNull SqlFormattingContext context, @NotNull SqlBlock delimiterBlock) {
        Spacing spacing;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)delimiterBlock, (String)"delimiterBlock");
        IElementType t2 = SqlFormattingModelFun.primaryElementType(delimiterBlock);
        if (t2 == null) {
            return context.makeAutoSpacing(true);
        }
        IElementType iElementType = t2;
        if (Intrinsics.areEqual((Object)iElementType, (Object)SqlTokens.ORAP_SLASH_DELIMITER_TOKEN) || Intrinsics.areEqual((Object)iElementType, (Object)SqlCommonKeywords.SQL_GO)) {
            spacing = SqlFormattingContext.makeBreak$default(context, false, 1, null);
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)SqlCommonTokens.SQL_SEMICOLON)) {
            switch (context.getSql().SCRIPT_STMT_SEMICOLON_WRAP) {
                case 1: {
                    spacing = SqlFormattingContext.makeBreak$default(context, false, 1, null);
                    break;
                }
                case 2: {
                    spacing = context.makeNoSpace(false);
                    break;
                }
                default: {
                    spacing = context.makeNoSpace(true);
                    break;
                }
            }
        } else {
            spacing = context.makeAutoSpacing(true);
        }
        return spacing;
    }

    public static final Spacing makeSpacingBetweenStatements(@NotNull SqlFormattingContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return switch (context.getSql().SCRIPT_STMT_FOLLOWS_BLANK_LINE) {
            case 1 -> Spacing.createSpacing((int)0, (int)0, (int)2, (boolean)true, (int)3);
            case 2 -> Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)false, (int)0);
            default -> Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)true, (int)3);
        };
    }
}

