/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.intentions;

import com.intellij.codeInsight.intention.PriorityAction;
import com.intellij.database.Dbms;
import com.intellij.database.model.ObjectKind;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.intentions.SqlBaseElementAtCaretIntentionAction;
import com.intellij.sql.intentions.SqlIntentionUtil;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.impl.SqlImplUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0012\u0010\u0007\u001a\f0\b\u00a2\u0006\u0002\b\t\u00a2\u0006\u0002\b\nH\u0016J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J!\u0010\u0013\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0096\u0002\u00a8\u0006\u0015"}, d2={"Lcom/intellij/sql/intentions/SqlQuoteIdentifierIntention;", "Lcom/intellij/sql/intentions/SqlBaseElementAtCaretIntentionAction;", "Lcom/intellij/codeInsight/intention/PriorityAction;", "<init>", "()V", "getPriority", "Lcom/intellij/codeInsight/intention/PriorityAction$Priority;", "getFamilyName", "", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "isAvailable", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "Lcom/intellij/psi/PsiElement;", "invoke", "", "intellij.database.sql.impl"})
public final class SqlQuoteIdentifierIntention
extends SqlBaseElementAtCaretIntentionAction
implements PriorityAction {
    @NotNull
    public PriorityAction.Priority getPriority() {
        return PriorityAction.Priority.TOP;
    }

    @NotNull
    public String getFamilyName() {
        String string = SqlBundle.message((String)"quickfix.name.quote.identifier", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor2, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiFile file = element.getContainingFile();
        if (!(file instanceof SqlFile)) {
            return false;
        }
        SqlIdentifier sqlIdentifier = SqlIntentionUtil.getIdentifier(element);
        if (sqlIdentifier == null) {
            return false;
        }
        SqlIdentifier identifier = sqlIdentifier;
        ObjectKind kind = SqlImplUtil.getIdentifierKind(identifier);
        if (Intrinsics.areEqual((Object)kind, (Object)ObjectKind.OPERATOR)) {
            return false;
        }
        Dbms dbms = SqlImplUtil.getSqlDialectDbms((PsiElement)identifier);
        if (dbms.isTransactSql() && Intrinsics.areEqual((Object)kind, (Object)SqlDbElementType.LABEL)) {
            return false;
        }
        return !identifier.isQuotedIdentifier();
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor2, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        SqlIdentifier sqlIdentifier = SqlIntentionUtil.getIdentifier(element);
        if (sqlIdentifier == null) {
            return;
        }
        SqlIdentifier identifier = sqlIdentifier;
        SqlImplUtil.quoteIdentifier(project, identifier, SqlImplUtil.getSqlDialectSafe((PsiElement)identifier));
    }
}

