/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.io.xml;

import com.thoughtworks.xstream.io.naming.NameCoder;
import com.thoughtworks.xstream.io.xml.AbstractDocumentReader;
import com.thoughtworks.xstream.io.xml.XmlFriendlyReplacer;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.Node;
import nu.xom.Text;

public class XomReader
extends AbstractDocumentReader {
    private Element currentElement;

    public XomReader(Element rootElement) {
        super(rootElement);
    }

    public XomReader(Document document) {
        super(document.getRootElement());
    }

    public XomReader(Element rootElement, NameCoder nameCoder) {
        super((Object)rootElement, nameCoder);
    }

    public XomReader(Document document, NameCoder nameCoder) {
        super((Object)document.getRootElement(), nameCoder);
    }

    public XomReader(Element rootElement, XmlFriendlyReplacer replacer) {
        this(rootElement, (NameCoder)replacer);
    }

    public XomReader(Document document, XmlFriendlyReplacer replacer) {
        this(document.getRootElement(), (NameCoder)replacer);
    }

    public String getNodeName() {
        return this.decodeNode(this.currentElement.getLocalName());
    }

    public String getValue() {
        StringBuffer result2 = new StringBuffer();
        int childCount = this.currentElement.getChildCount();
        for (int i2 = 0; i2 < childCount; ++i2) {
            Node child = this.currentElement.getChild(i2);
            if (!(child instanceof Text)) continue;
            Text text2 = (Text)child;
            result2.append(text2.getValue());
        }
        return result2.toString();
    }

    public String getAttribute(String name2) {
        return this.currentElement.getAttributeValue(this.encodeAttribute(name2));
    }

    public String getAttribute(int index) {
        return this.currentElement.getAttribute(index).getValue();
    }

    public int getAttributeCount() {
        return this.currentElement.getAttributeCount();
    }

    public String getAttributeName(int index) {
        return this.decodeAttribute(this.currentElement.getAttribute(index).getQualifiedName());
    }

    protected int getChildCount() {
        return this.currentElement.getChildElements().size();
    }

    protected Object getParent() {
        return this.currentElement.getParent();
    }

    protected Object getChild(int index) {
        return this.currentElement.getChildElements().get(index);
    }

    protected void reassignCurrentElement(Object current) {
        this.currentElement = (Element)current;
    }

    public String peekNextChild() {
        Elements children2 = this.currentElement.getChildElements();
        if (null == children2 || children2.size() == 0) {
            return null;
        }
        return this.decodeNode(children2.get(0).getLocalName());
    }
}

