/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.valid;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.locationtech.jts.algorithm.BoundaryNodeRule;
import org.locationtech.jts.algorithm.LineIntersector;
import org.locationtech.jts.algorithm.RobustLineIntersector;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateArrays;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygonal;
import org.locationtech.jts.geom.util.LinearComponentExtracter;
import org.locationtech.jts.noding.BasicSegmentString;
import org.locationtech.jts.noding.MCIndexNoder;
import org.locationtech.jts.noding.SegmentIntersector;
import org.locationtech.jts.noding.SegmentString;

public class IsSimpleOp {
    private final Geometry inputGeom;
    private final boolean isClosedEndpointsInInterior;
    private boolean isFindAllLocations;
    private boolean isSimple = false;
    private List<Coordinate> nonSimplePts;

    public static boolean isSimple(Geometry geom) {
        IsSimpleOp op = new IsSimpleOp(geom);
        return op.isSimple();
    }

    public static Coordinate getNonSimpleLocation(Geometry geom) {
        IsSimpleOp op = new IsSimpleOp(geom);
        return op.getNonSimpleLocation();
    }

    public IsSimpleOp(Geometry geom) {
        this(geom, BoundaryNodeRule.MOD2_BOUNDARY_RULE);
    }

    public IsSimpleOp(Geometry geom, BoundaryNodeRule boundaryNodeRule) {
        this.inputGeom = geom;
        this.isClosedEndpointsInInterior = !boundaryNodeRule.isInBoundary(2);
    }

    public void setFindAllLocations(boolean isFindAll) {
        this.isFindAllLocations = isFindAll;
    }

    public boolean isSimple() {
        this.compute();
        return this.isSimple;
    }

    public Coordinate getNonSimpleLocation() {
        this.compute();
        if (this.nonSimplePts.size() == 0) {
            return null;
        }
        return this.nonSimplePts.get(0);
    }

    public List<Coordinate> getNonSimpleLocations() {
        this.compute();
        return this.nonSimplePts;
    }

    private void compute() {
        if (this.nonSimplePts != null) {
            return;
        }
        this.nonSimplePts = new ArrayList<Coordinate>();
        this.isSimple = this.computeSimple(this.inputGeom);
    }

    private boolean computeSimple(Geometry geom) {
        if (geom.isEmpty()) {
            return true;
        }
        if (geom instanceof Point) {
            return true;
        }
        if (geom instanceof LineString) {
            return this.isSimpleLinearGeometry(geom);
        }
        if (geom instanceof MultiLineString) {
            return this.isSimpleLinearGeometry(geom);
        }
        if (geom instanceof MultiPoint) {
            return this.isSimpleMultiPoint((MultiPoint)geom);
        }
        if (geom instanceof Polygonal) {
            return this.isSimplePolygonal(geom);
        }
        if (geom instanceof GeometryCollection) {
            return this.isSimpleGeometryCollection(geom);
        }
        return true;
    }

    private boolean isSimpleMultiPoint(MultiPoint mp) {
        if (mp.isEmpty()) {
            return true;
        }
        boolean isSimple = true;
        HashSet<Coordinate> points = new HashSet<Coordinate>();
        for (int i2 = 0; i2 < mp.getNumGeometries(); ++i2) {
            Point pt = (Point)mp.getGeometryN(i2);
            Coordinate p2 = pt.getCoordinate();
            if (points.contains(p2)) {
                this.nonSimplePts.add(p2);
                isSimple = false;
                if (this.isFindAllLocations) continue;
                break;
            }
            points.add(p2);
        }
        return isSimple;
    }

    private boolean isSimplePolygonal(Geometry geom) {
        boolean isSimple = true;
        List rings = LinearComponentExtracter.getLines(geom);
        for (Geometry ring : rings) {
            if (this.isSimpleLinearGeometry(ring)) continue;
            isSimple = false;
            if (this.isFindAllLocations) continue;
            break;
        }
        return isSimple;
    }

    private boolean isSimpleGeometryCollection(Geometry geom) {
        boolean isSimple = true;
        for (int i2 = 0; i2 < geom.getNumGeometries(); ++i2) {
            Geometry comp = geom.getGeometryN(i2);
            if (this.computeSimple(comp)) continue;
            isSimple = false;
            if (!this.isFindAllLocations) break;
        }
        return isSimple;
    }

    private boolean isSimpleLinearGeometry(Geometry geom) {
        if (geom.isEmpty()) {
            return true;
        }
        List<SegmentString> segStrings = IsSimpleOp.extractSegmentStrings(geom);
        NonSimpleIntersectionFinder segInt = new NonSimpleIntersectionFinder(this.isClosedEndpointsInInterior, this.isFindAllLocations, this.nonSimplePts);
        MCIndexNoder noder = new MCIndexNoder();
        noder.setSegmentIntersector(segInt);
        noder.computeNodes(segStrings);
        return !segInt.hasIntersection();
    }

    private static List<SegmentString> extractSegmentStrings(Geometry geom) {
        ArrayList<SegmentString> segStrings = new ArrayList<SegmentString>();
        for (int i2 = 0; i2 < geom.getNumGeometries(); ++i2) {
            LineString line = (LineString)geom.getGeometryN(i2);
            Coordinate[] trimPts = IsSimpleOp.trimRepeatedPoints(line.getCoordinates());
            if (trimPts == null) continue;
            BasicSegmentString ss = new BasicSegmentString(trimPts, null);
            segStrings.add(ss);
        }
        return segStrings;
    }

    private static Coordinate[] trimRepeatedPoints(Coordinate[] pts) {
        int endIndex;
        int startIndex;
        if (pts.length <= 2) {
            return pts;
        }
        int len = pts.length;
        boolean hasRepeatedStart = pts[0].equals2D(pts[1]);
        boolean hasRepeatedEnd = pts[len - 1].equals2D(pts[len - 2]);
        if (!hasRepeatedStart && !hasRepeatedEnd) {
            return pts;
        }
        Coordinate startPt = pts[0];
        for (startIndex = 0; startIndex < len - 1 && startPt.equals2D(pts[startIndex + 1]); ++startIndex) {
        }
        Coordinate endPt = pts[endIndex];
        for (endIndex = len - 1; endIndex > 0 && endPt.equals2D(pts[endIndex - 1]); --endIndex) {
        }
        if (endIndex - startIndex < 1) {
            return null;
        }
        Coordinate[] trimPts = CoordinateArrays.extract(pts, startIndex, endIndex);
        return trimPts;
    }

    private static class NonSimpleIntersectionFinder
    implements SegmentIntersector {
        private final boolean isClosedEndpointsInInterior;
        private final boolean isFindAll;
        LineIntersector li = new RobustLineIntersector();
        private final List<Coordinate> intersectionPts;

        public NonSimpleIntersectionFinder(boolean isClosedEndpointsInInterior, boolean isFindAll, List<Coordinate> intersectionPts) {
            this.isClosedEndpointsInInterior = isClosedEndpointsInInterior;
            this.isFindAll = isFindAll;
            this.intersectionPts = intersectionPts;
        }

        public boolean hasIntersection() {
            return this.intersectionPts.size() > 0;
        }

        @Override
        public void processIntersections(SegmentString ss0, int segIndex0, SegmentString ss1, int segIndex1) {
            boolean isSameSegment;
            boolean isSameSegString = ss0 == ss1;
            boolean bl = isSameSegment = isSameSegString && segIndex0 == segIndex1;
            if (isSameSegment) {
                return;
            }
            boolean hasInt = this.findIntersection(ss0, segIndex0, ss1, segIndex1);
            if (hasInt) {
                this.intersectionPts.add(this.li.getIntersection(0));
            }
        }

        private boolean findIntersection(SegmentString ss0, int segIndex0, SegmentString ss1, int segIndex1) {
            boolean hasInteriorVertexInt;
            boolean isAdjacentSegment;
            boolean hasEqualSegments;
            Coordinate p00 = ss0.getCoordinate(segIndex0);
            Coordinate p01 = ss0.getCoordinate(segIndex0 + 1);
            Coordinate p10 = ss1.getCoordinate(segIndex1);
            Coordinate p11 = ss1.getCoordinate(segIndex1 + 1);
            this.li.computeIntersection(p00, p01, p10, p11);
            if (!this.li.hasIntersection()) {
                return false;
            }
            boolean hasInteriorInt = this.li.isInteriorIntersection();
            if (hasInteriorInt) {
                return true;
            }
            boolean bl = hasEqualSegments = this.li.getIntersectionNum() >= 2;
            if (hasEqualSegments) {
                return true;
            }
            boolean isSameSegString = ss0 == ss1;
            boolean bl2 = isAdjacentSegment = isSameSegString && Math.abs(segIndex1 - segIndex0) <= 1;
            if (isAdjacentSegment) {
                return false;
            }
            boolean isIntersectionEndpt0 = NonSimpleIntersectionFinder.isIntersectionEndpoint(ss0, segIndex0, this.li, 0);
            boolean isIntersectionEndpt1 = NonSimpleIntersectionFinder.isIntersectionEndpoint(ss1, segIndex1, this.li, 1);
            boolean bl3 = hasInteriorVertexInt = !isIntersectionEndpt0 || !isIntersectionEndpt1;
            if (hasInteriorVertexInt) {
                return true;
            }
            if (this.isClosedEndpointsInInterior && !isSameSegString) {
                boolean hasInteriorEndpointInt;
                boolean bl4 = hasInteriorEndpointInt = ss0.isClosed() || ss1.isClosed();
                if (hasInteriorEndpointInt) {
                    return true;
                }
            }
            return false;
        }

        private static boolean isIntersectionEndpoint(SegmentString ss, int ssIndex, LineIntersector li, int liSegmentIndex) {
            int vertexIndex = NonSimpleIntersectionFinder.intersectionVertexIndex(li, liSegmentIndex);
            if (vertexIndex == 0) {
                return ssIndex == 0;
            }
            return ssIndex + 2 == ss.size();
        }

        private static int intersectionVertexIndex(LineIntersector li, int segmentIndex) {
            Coordinate endPt0;
            Coordinate intPt = li.getIntersection(0);
            return intPt.equals2D(endPt0 = li.getEndpoint(segmentIndex, 0)) ? 0 : 1;
        }

        @Override
        public boolean isDone() {
            if (this.isFindAll) {
                return false;
            }
            return this.intersectionPts.size() > 0;
        }
    }
}

