/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.structure;

import com.intellij.httpClient.execution.RestClientBundle;
import com.intellij.httpClient.http.request.HttpRequestNameSupport;
import com.intellij.httpClient.http.request.psi.HttpRequest;
import com.intellij.httpClient.http.request.structure.HttpMethodIcons;
import com.intellij.httpClient.http.request.structure.IconsKt;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0001\u001a$\u0010\t\u001a\u00020\u00012\b\u0010\n\u001a\u0004\u0018\u00010\u00012\b\u0010\u000b\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"GRAPHQL_METHOD", "", "GRPC_METHOD", "WEBSOCKET_METHOD", "provideIcon", "Ljavax/swing/Icon;", "request", "Lcom/intellij/httpClient/http/request/psi/HttpRequest;", "httpMethod", "provideStructureText", "originalHost", "path", "intellij.restClient"})
public final class StructureHelperKt {
    @NotNull
    public static final String GRAPHQL_METHOD = "GRAPHQL";
    @NotNull
    public static final String GRPC_METHOD = "GRPC";
    @NotNull
    public static final String WEBSOCKET_METHOD = "WEBSOCKET";

    @NotNull
    public static final Icon provideIcon(@NotNull HttpRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        String string = request.getHttpMethod();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getHttpMethod(...)");
        return StructureHelperKt.provideIcon(string);
    }

    @NotNull
    public static final Icon provideIcon(@NotNull String httpMethod) {
        Intrinsics.checkNotNullParameter((Object)httpMethod, (String)"httpMethod");
        return switch (httpMethod) {
            case "DELETE" -> HttpMethodIcons.INSTANCE.getDELETE_ICON$intellij_restClient();
            case "GET" -> HttpMethodIcons.INSTANCE.getGET_ICON$intellij_restClient();
            case "POST" -> HttpMethodIcons.INSTANCE.getPOST_ICON$intellij_restClient();
            case "PUT" -> HttpMethodIcons.INSTANCE.getPUT_ICON$intellij_restClient();
            case GRAPHQL_METHOD -> HttpMethodIcons.INSTANCE.getGRAPHQL_ICON$intellij_restClient();
            case GRPC_METHOD -> HttpMethodIcons.INSTANCE.getGRPC_ICON$intellij_restClient();
            case WEBSOCKET_METHOD -> HttpMethodIcons.INSTANCE.getWEBSOCKET_ICON$intellij_restClient();
            default -> IconsKt.generateGreyIcon(httpMethod);
        };
    }

    @NotNull
    public static final String provideStructureText(@Nullable String originalHost, @Nullable String path, @NotNull HttpRequest request) {
        Object object;
        String declaredName;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        String string = declaredName = HttpRequestNameSupport.getDeclaredName(request);
        if (string != null) {
            return string;
        }
        CharSequence charSequence = path;
        if (charSequence == null || charSequence.length() == 0) {
            object = originalHost;
            if (object == null) {
                String string2 = RestClientBundle.message("http.client.structure.request.host.undefined", new Object[0]);
                object = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            }
        } else {
            object = "/" + path;
        }
        return object;
    }
}

