/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.postman.converter;

import com.intellij.httpClient.execution.RestClientBundle;
import com.intellij.httpClient.postman.converter.BodyProviderKt;
import com.intellij.httpClient.postman.converter.dto.httpClient.HttpClientHeader;
import com.intellij.httpClient.postman.converter.dto.httpClient.HttpClientRequest;
import com.intellij.httpClient.postman.converter.dto.httpClient.HttpClientRequestBody;
import com.intellij.httpClient.postman.converter.dto.httpClient.HttpResponse;
import com.intellij.httpClient.postman.converter.dto.httpClient.HttpScript;
import com.intellij.httpClient.postman.converter.dto.postman.collection.PostmanBody;
import com.intellij.httpClient.postman.converter.dto.postman.collection.PostmanDescription;
import com.intellij.httpClient.postman.converter.dto.postman.collection.PostmanHeader;
import com.intellij.httpClient.postman.converter.dto.postman.collection.PostmanHeaderItem;
import com.intellij.httpClient.postman.converter.dto.postman.collection.PostmanMethod;
import com.intellij.httpClient.postman.converter.dto.postman.collection.PostmanResponse;
import io.netty.handler.codec.http.HttpMethod;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000d\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u001c\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\n2\n\u0010\u000b\u001a\u00060\fj\u0002`\rH\u0000\u001a\"\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\n\u0010\u000b\u001a\u00060\fj\u0002`\rH\u0002\u001a\"\u0010\u0013\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\n\u0010\u000b\u001a\u00060\fj\u0002`\rH\u0002\u001a,\u0010\u0014\u001a\u00020\u000f2\n\u0010\u000b\u001a\u00060\fj\u0002`\r2\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00012\u0006\u0010\u0017\u001a\u00020\u0018H\u0002\u001a\u0012\u0010\u0019\u001a\u00020\u0018*\b\u0012\u0004\u0012\u00020\u00010\u0011H\u0002\u001a$\u0010\u001a\u001a\u00020\u000f2\n\u0010\u000b\u001a\u00060\fj\u0002`\r2\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0018H\u0002\u001a\u001c\u0010\u001b\u001a\u00020\u000f2\n\u0010\u000b\u001a\u00060\fj\u0002`\r2\u0006\u0010\u0015\u001a\u00020\u0012H\u0002\u001a\u0010\u0010\u001c\u001a\u00020\u00012\u0006\u0010\u001d\u001a\u00020\u0001H\u0002\u001a\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00020 0\u00112\u0006\u0010\"\u001a\u00020#H\u0000\u001a\u0010\u0010$\u001a\u00020 2\u0006\u0010\"\u001a\u00020\u0001H\u0002\u001a\u0012\u0010%\u001a\u0004\u0018\u00010\u00012\u0006\u0010&\u001a\u00020'H\u0000\u001a\u001c\u0010(\u001a\u00020\u00012\b\u0010)\u001a\u0004\u0018\u00010*2\b\u0010+\u001a\u0004\u0018\u00010,H\u0000\u001a\u0010\u0010-\u001a\u00020\u00012\u0006\u0010.\u001a\u00020/H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0002\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"NEW_LINE", "", "INDENT", "getINDENT", "()Ljava/lang/String;", "AMPERSAND", "GRAPHQL", "COMMENTED", "addRequestView", "request", "Lcom/intellij/httpClient/postman/converter/dto/httpClient/HttpClientRequest;", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "writePreRequestScripts", "", "scripts", "", "Lcom/intellij/httpClient/postman/converter/dto/httpClient/HttpScript;", "writeResponseScripts", "writeScriptBody", "script", "apiName", "enabled", "", "hasEmptyContent", "writePreRequestScript", "writeResponseScript", "getDescription", "description", "getHeaders", "", "Lcom/intellij/httpClient/postman/converter/dto/httpClient/HttpClientHeader;", "retrieveHeaders", "header", "Lcom/intellij/httpClient/postman/converter/dto/postman/collection/PostmanHeader;", "getHeaderFromString", "retrieveDescription", "postmanDescription", "Lcom/intellij/httpClient/postman/converter/dto/postman/collection/PostmanDescription;", "retrieveMethod", "method", "Lcom/intellij/httpClient/postman/converter/dto/postman/collection/PostmanMethod;", "body", "Lcom/intellij/httpClient/postman/converter/dto/postman/collection/PostmanBody;", "getExtension", "response", "Lcom/intellij/httpClient/postman/converter/dto/postman/collection/PostmanResponse;", "intellij.restClient"})
@SourceDebugExtension(value={"SMAP\nConverterHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConverterHelper.kt\ncom/intellij/httpClient/postman/converter/ConverterHelperKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,246:1\n1#2:247\n827#3:248\n855#3,2:249\n3193#3,10:251\n1863#3,2:261\n1863#3,2:263\n3193#3,10:265\n1863#3,2:275\n1863#3,2:277\n1734#3,3:279\n774#3:284\n865#3,2:285\n295#3,2:287\n1557#3:289\n1628#3,3:290\n1557#3:293\n1628#3,3:294\n295#3,2:297\n52#4:282\n52#4:283\n*S KotlinDebug\n*F\n+ 1 ConverterHelper.kt\ncom/intellij/httpClient/postman/converter/ConverterHelperKt\n*L\n37#1:248\n37#1:249,2\n73#1:251,10\n75#1:261,2\n76#1:263,2\n80#1:265,10\n82#1:275,2\n83#1:277,2\n137#1:279,3\n169#1:284\n169#1:285,2\n178#1:287,2\n195#1:289\n195#1:290,3\n196#1:293\n196#1:294,3\n231#1:297,2\n145#1:282\n151#1:283\n*E\n"})
public final class ConverterHelperKt {
    @NotNull
    public static final String NEW_LINE = "\n";
    @NotNull
    private static final String INDENT;
    @NotNull
    public static final String AMPERSAND = "&";
    @NotNull
    private static final String GRAPHQL = "GRAPHQL";
    @NotNull
    private static final String COMMENTED = "//";

    @NotNull
    public static final String getINDENT() {
        return INDENT;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String addRequestView(@NotNull HttpClientRequest request, @NotNull StringBuilder builder2) {
        block10: {
            Object it;
            void $this$filterNotTo$iv$iv;
            Object it2;
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
            builder2.append("\n\n");
            builder2.append("###").append(NEW_LINE);
            String string = request.getGroup();
            if (string != null) {
                it2 = string;
                boolean bl = false;
                builder2.append("# group: " + ((Object)StringsKt.trim((CharSequence)((CharSequence)it2))).toString()).append(NEW_LINE);
            }
            String string2 = request.getName();
            if (string2 != null) {
                it2 = string2;
                boolean bl = false;
                builder2.append("# @name " + ((Object)StringsKt.trim((CharSequence)((CharSequence)it2))).toString()).append(NEW_LINE);
            }
            String string3 = request.getDescription();
            if (string3 != null) {
                it2 = string3;
                boolean bl = false;
                builder2.append(ConverterHelperKt.getDescription((String)it2)).append(NEW_LINE);
            }
            List<HttpScript> list2 = request.getPreRequestScripts();
            it2 = list2;
            boolean bl = false;
            List<HttpScript> list3 = !((Collection)it2).isEmpty() ? list2 : null;
            if (list3 != null) {
                List<HttpScript> scripts = list3;
                boolean bl2 = false;
                ConverterHelperKt.writePreRequestScripts(scripts, builder2);
                builder2.append(NEW_LINE);
            }
            String url = request.getUrl().toFullUrl(true);
            builder2.append(request.getHttpMethod() + " " + url);
            Iterable $this$filterNot$iv = ConverterHelperKt.getHeaders(request);
            boolean $i$f$filterNot = false;
            Iterable iterable = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                HttpClientHeader it3 = (HttpClientHeader)element$iv$iv;
                boolean bl3 = false;
                if (((CharSequence)it3.getKey()).length() == 0) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List headers2 = (List)destination$iv$iv;
            if (!((Collection)headers2).isEmpty()) {
                String headerString = CollectionsKt.joinToString$default((Iterable)headers2, (CharSequence)NEW_LINE, (CharSequence)NEW_LINE, null, (int)0, null, ConverterHelperKt::addRequestView$lambda$6, (int)28, null);
                builder2.append(headerString);
            }
            HttpClientRequestBody httpClientRequestBody = request.getBody();
            if (httpClientRequestBody != null) {
                it = httpClientRequestBody;
                boolean bl4 = false;
                if (((CharSequence)((HttpClientRequestBody)it).getRawBody()).length() > 0) {
                    builder2.append("\n\n");
                    builder2.append(((HttpClientRequestBody)it).getRawBody());
                }
            }
            List<HttpScript> list4 = request.getResponseScripts();
            it = list4;
            boolean bl5 = false;
            List<HttpScript> list5 = !((Collection)it).isEmpty() ? list4 : null;
            if (list5 != null) {
                List<HttpScript> scripts = list5;
                boolean bl6 = false;
                builder2.append(NEW_LINE).append(NEW_LINE);
                ConverterHelperKt.writeResponseScripts(scripts, builder2);
            }
            List<HttpResponse> list6 = request.getResponses();
            String responses = list6 != null ? CollectionsKt.joinToString$default((Iterable)list6, (CharSequence)NEW_LINE, null, null, (int)0, null, ConverterHelperKt::addRequestView$lambda$10, (int)30, null) : null;
            Iterable iterable2 = responses;
            if (iterable2 == null) break block10;
            iterable = iterable2;
            Object it4 = iterable;
            boolean bl7 = false;
            iterable2 = ((CharSequence)it4).length() > 0 ? iterable : null;
            if (iterable2 != null) {
                it4 = iterable2;
                boolean bl8 = false;
                builder2.append(NEW_LINE).append(NEW_LINE);
                builder2.append((String)it4);
            }
        }
        return ((Object)StringsKt.trim((CharSequence)builder2)).toString();
    }

    private static final void writePreRequestScripts(List<HttpScript> scripts, StringBuilder builder2) {
        HttpScript it;
        Iterable $this$partition$iv = scripts;
        boolean $i$f$partition = false;
        ArrayList first$iv = new ArrayList();
        ArrayList second$iv = new ArrayList();
        for (Object element$iv : $this$partition$iv) {
            it = (HttpScript)element$iv;
            boolean bl = false;
            boolean bl2 = it.getEnabled() ? first$iv.add(element$iv) : second$iv.add(element$iv);
        }
        Pair pair = new Pair(first$iv, second$iv);
        List enabled = (List)pair.component1();
        List disabled = (List)pair.component2();
        Iterable $this$forEach$iv = enabled;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (HttpScript)element$iv;
            boolean bl = false;
            ConverterHelperKt.writePreRequestScript(builder2, it, true);
        }
        $this$forEach$iv = disabled;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (HttpScript)element$iv;
            boolean bl = false;
            ConverterHelperKt.writePreRequestScript(builder2, it, false);
        }
    }

    private static final void writeResponseScripts(List<HttpScript> scripts, StringBuilder builder2) {
        HttpScript it;
        Iterable $this$partition$iv = scripts;
        boolean $i$f$partition = false;
        ArrayList first$iv = new ArrayList();
        ArrayList second$iv = new ArrayList();
        for (Object element$iv : $this$partition$iv) {
            it = (HttpScript)element$iv;
            boolean bl = false;
            boolean bl2 = it.getEnabled() ? first$iv.add(element$iv) : second$iv.add(element$iv);
        }
        Pair pair = new Pair(first$iv, second$iv);
        List enabled = (List)pair.component1();
        List disabled = (List)pair.component2();
        Iterable $this$forEach$iv = enabled;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (HttpScript)element$iv;
            boolean bl = false;
            ConverterHelperKt.writeResponseScript(builder2, it);
        }
        $this$forEach$iv = disabled;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (HttpScript)element$iv;
            boolean bl = false;
            ConverterHelperKt.writeResponseScript(builder2, it);
        }
    }

    private static final void writeScriptBody(StringBuilder builder2, HttpScript script, String apiName, boolean enabled) {
        String body2;
        List<String> scriptBody = script.getScriptBody();
        boolean isEmptyBody = ConverterHelperKt.hasEmptyContent(scriptBody);
        if (!enabled && script.getShouldBeMigrated()) {
            if (isEmptyBody) {
                Object[] objectArray = new Object[]{apiName};
                String string = RestClientBundle.message("http.client.postman.converter.convert.suggest.http.client.api", objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                String todo = string;
                v1 = builder2.append(StringsKt.prependIndent((String)("// " + todo), (String)INDENT));
            } else {
                Object[] objectArray = new Object[]{apiName};
                String string = RestClientBundle.message("http.client.postman.converter.convert.suggest.migrate.to.http.client.api", objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                String migrationText = string;
                v1 = builder2.append(StringsKt.prependIndent((String)("// " + migrationText), (String)INDENT)).append(NEW_LINE);
            }
        }
        String string = body2 = isEmptyBody ? "" : (enabled ? CollectionsKt.joinToString$default((Iterable)scriptBody, (CharSequence)NEW_LINE, null, null, (int)0, null, ConverterHelperKt::writeScriptBody$lambda$19, (int)30, null) : CollectionsKt.joinToString$default((Iterable)scriptBody, (CharSequence)NEW_LINE, null, null, (int)0, null, ConverterHelperKt::writeScriptBody$lambda$20, (int)30, null));
        if (((CharSequence)body2).length() > 0) {
            builder2.append(body2);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean hasEmptyContent(List<String> $this$hasEmptyContent) {
        boolean bl;
        if ($this$hasEmptyContent.isEmpty()) return true;
        Iterable $this$all$iv = $this$hasEmptyContent;
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        Iterator iterator = $this$all$iv.iterator();
        do {
            if (!iterator.hasNext()) return true;
            Object element$iv = iterator.next();
            String it = (String)element$iv;
            boolean bl2 = false;
            if (((CharSequence)it).length() != 0) return false;
            bl = true;
        } while (bl);
        return false;
    }

    private static final void writePreRequestScript(StringBuilder builder2, HttpScript script, boolean enabled) {
        String string;
        String string2;
        String string3 = "< {%";
        boolean condition$iv22 = !enabled;
        boolean $i$f$applyIf = false;
        if (condition$iv22) {
            void $this$writePreRequestScript_u24lambda_u2422 = $this$applyIf$iv;
            boolean bl = false;
            string2 = COMMENTED + (String)$this$writePreRequestScript_u24lambda_u2422;
        } else {
            string2 = $this$applyIf$iv;
        }
        void beginning = string2;
        builder2.append((String)beginning).append(NEW_LINE);
        ConverterHelperKt.writeScriptBody(builder2, script, "Pre-request", enabled);
        builder2.append(NEW_LINE);
        String condition$iv22 = "%}";
        boolean condition$iv = !enabled;
        boolean $i$f$applyIf2 = false;
        if (condition$iv) {
            void $this$writePreRequestScript_u24lambda_u2423 = $this$applyIf$iv;
            boolean bl = false;
            string = COMMENTED + (String)$this$writePreRequestScript_u24lambda_u2423;
        } else {
            string = $this$applyIf$iv;
        }
        void ending = string;
        builder2.append((String)ending);
    }

    private static final void writeResponseScript(StringBuilder builder2, HttpScript script) {
        builder2.append("> {%").append(NEW_LINE);
        ConverterHelperKt.writeScriptBody(builder2, script, "Response", script.getEnabled());
        builder2.append(NEW_LINE);
        builder2.append("%}");
    }

    /*
     * WARNING - void declaration
     */
    private static final String getDescription(String description) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = StringsKt.lines((CharSequence)description);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = ((CharSequence)it).length() > 0;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)NEW_LINE, null, null, (int)0, null, ConverterHelperKt::getDescription$lambda$25, (int)30, null);
    }

    private static final Set<HttpClientHeader> getHeaders(HttpClientRequest request) {
        Set headers2;
        block2: {
            HttpClientHeader existing;
            HttpClientHeader bodyHeader;
            block3: {
                Object v2;
                block1: {
                    HttpClientHeader bodyContentTypeHeader;
                    headers2 = CollectionsKt.toMutableSet((Iterable)request.getHeaders());
                    HttpClientRequestBody httpClientRequestBody = request.getBody();
                    HttpClientHeader httpClientHeader = bodyContentTypeHeader = httpClientRequestBody != null ? httpClientRequestBody.getContentTypeHeader() : null;
                    if (httpClientHeader == null) break block2;
                    bodyHeader = httpClientHeader;
                    boolean bl = false;
                    Iterable $this$firstOrNull$iv = headers2;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        HttpClientHeader it = (HttpClientHeader)element$iv;
                        boolean bl2 = false;
                        if (!StringsKt.equals((String)it.getKey(), (String)bodyHeader.getKey(), (boolean)true)) continue;
                        v2 = element$iv;
                        break block1;
                    }
                    v2 = null;
                }
                existing = v2;
                if (existing != null) break block3;
                headers2.add(bodyHeader);
                break block2;
            }
            if (!Intrinsics.areEqual((Object)existing.getValue(), (Object)"application/x-www-form-urlencoded") || Intrinsics.areEqual((Object)existing.getValue(), (Object)bodyHeader.getValue())) break block2;
            headers2.add(new HttpClientHeader(bodyHeader.getKey(), bodyHeader.getValue(), !existing.getDisabled(), null, 8, null));
        }
        return headers2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<HttpClientHeader> retrieveHeaders(@NotNull PostmanHeader header) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)header, (String)"header");
        PostmanHeader postmanHeader = header;
        if (postmanHeader instanceof PostmanHeader.PostmanHeaderString) {
            list2 = CollectionsKt.listOf((Object)ConverterHelperKt.getHeaderFromString(((PostmanHeader.PostmanHeaderString)header).getValue()));
        } else if (postmanHeader instanceof PostmanHeader.PostmanHeaderList) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = ((PostmanHeader.PostmanHeaderList)header).getItems();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void headerItem;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(ConverterHelperKt.getHeaderFromString((String)headerItem));
            }
            list2 = (List)destination$iv$iv;
        } else if (postmanHeader instanceof PostmanHeader.PostmanHeaderObject) {
            Iterable $this$map$iv = ((PostmanHeader.PostmanHeaderObject)header).getItems();
            boolean $i$f$map = false;
            Iterable $this$mapTo$iv$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                PostmanHeaderItem headerItem = (PostmanHeaderItem)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new HttpClientHeader(headerItem.getKey(), headerItem.getValue(), headerItem.getDisabled(), null, 8, null));
            }
            list2 = (List)destination$iv$iv;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return list2;
    }

    private static final HttpClientHeader getHeaderFromString(String header) {
        String[] stringArray = new String[]{":"};
        List list2 = StringsKt.split$default((CharSequence)header, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        String before = (String)list2.get(0);
        String after = (String)list2.get(1);
        return new HttpClientHeader(before, after, false, null, 12, null);
    }

    @Nullable
    public static final String retrieveDescription(@NotNull PostmanDescription postmanDescription) {
        String string;
        Intrinsics.checkNotNullParameter((Object)postmanDescription, (String)"postmanDescription");
        PostmanDescription postmanDescription2 = postmanDescription;
        if (postmanDescription2 instanceof PostmanDescription.DescriptionString) {
            string = ((PostmanDescription.DescriptionString)postmanDescription).getValue();
        } else if (postmanDescription2 instanceof PostmanDescription.DescriptionObject) {
            string = ((PostmanDescription.DescriptionObject)postmanDescription).getContent();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    @NotNull
    public static final String retrieveMethod(@Nullable PostmanMethod method, @Nullable PostmanBody body2) {
        String string;
        PostmanMethod postmanMethod;
        PostmanBody postmanBody = body2;
        if (postmanBody != null) {
            PostmanBody it = postmanBody;
            boolean bl = false;
            if (BodyProviderKt.isGraphql(body2)) {
                return GRAPHQL;
            }
        }
        if ((postmanMethod = method) == null) {
            String string2 = HttpMethod.GET.name();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"name(...)");
        } else if (postmanMethod instanceof PostmanMethod.MethodString) {
            string = ((PostmanMethod.MethodString)method).getValue();
        } else if (postmanMethod instanceof PostmanMethod.MethodObject) {
            string = ((PostmanMethod.MethodObject)method).getValue().name();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public static final String getExtension(@NotNull PostmanResponse response) {
        block3: {
            Intrinsics.checkNotNullParameter((Object)response, (String)"response");
            var2_1 = response.getHeader();
            if (var2_1 == null) ** GOTO lbl-1000
            it = var2_1;
            $i$a$-let-ConverterHelperKt$getExtension$contentType$1 = false;
            var3_4 = ConverterHelperKt.retrieveHeaders((PostmanHeader)it);
            if (var3_4 == null) ** GOTO lbl-1000
            it = var3_4;
            $i$f$firstOrNull = false;
            for (T element$iv : $this$firstOrNull$iv) {
                it = (HttpClientHeader)element$iv;
                $i$a$-firstOrNull-ConverterHelperKt$getExtension$contentType$2 = false;
                if (!StringsKt.equals((String)it.getKey(), (String)"content-type", (boolean)true)) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        var4_9 = v0;
        if (var4_9 != null && (var5_2 = var4_9.getValue()) != null) {
            v1 = var5_2;
        } else lbl-1000:
        // 3 sources

        {
            v1 = "";
        }
        contentType = v1;
        return StringsKt.startsWith$default((String)contentType, (String)"application/json", (boolean)false, (int)2, null) != false ? "json" : (StringsKt.startsWith$default((String)contentType, (String)"application/pdf", (boolean)false, (int)2, null) != false ? "pdf" : (StringsKt.startsWith$default((String)contentType, (String)"text/css", (boolean)false, (int)2, null) != false ? "css" : (StringsKt.startsWith$default((String)contentType, (String)"text/csv", (boolean)false, (int)2, null) != false ? "csv" : (StringsKt.startsWith$default((String)contentType, (String)"text/html", (boolean)false, (int)2, null) != false ? "html" : (StringsKt.startsWith$default((String)contentType, (String)"image/jpeg", (boolean)false, (int)2, null) != false ? "jpeg" : (StringsKt.startsWith$default((String)contentType, (String)"image/png", (boolean)false, (int)2, null) != false ? "png" : (StringsKt.startsWith$default((String)contentType, (String)"image/svg+xml", (boolean)false, (int)2, null) != false ? "svg" : (StringsKt.contains$default((CharSequence)contentType, (CharSequence)"xml", (boolean)false, (int)2, null) != false ? "xml" : "txt"))))))));
    }

    private static final CharSequence addRequestView$lambda$6(HttpClientHeader header) {
        Intrinsics.checkNotNullParameter((Object)header, (String)"header");
        return (header.getDisabled() ? "#" : "") + header.getKey() + ": " + header.getValue();
    }

    private static final CharSequence addRequestView$lambda$10(HttpResponse it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return StringsKt.trimMargin((String)("\n     |<> ./" + it.getPath() + "\n     |// " + it.getOriginalUrl().toFullUrl(false) + "\n    "), (String)"|");
    }

    private static final CharSequence writeScriptBody$lambda$19(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return StringsKt.prependIndent((String)it, (String)INDENT);
    }

    private static final CharSequence writeScriptBody$lambda$20(String line) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        Object text2 = ((CharSequence)line).length() == 0 ? COMMENTED : "// " + line;
        return StringsKt.prependIndent((String)text2, (String)INDENT);
    }

    private static final CharSequence getDescription$lambda$25(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "# " + it;
    }

    static {
        String string = "%1$4s";
        Object[] objectArray = new Object[]{""};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        INDENT = string2;
    }
}

