/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.function;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Idempotent;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.function.JSLoadNodeGen;
import com.oracle.truffle.js.nodes.interop.ImportValueNode;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;

public abstract class JSLoadNode
extends JavaScriptBaseNode {
    protected final JSContext context;

    @NeverDefault
    public static JSLoadNode create(JSContext context2) {
        return JSLoadNodeGen.create(context2);
    }

    protected JSLoadNode(JSContext context2) {
        this.context = context2;
    }

    public abstract Object executeLoad(Source var1, JSRealm var2);

    protected static CallTarget loadScript(Source source, JSRealm realm) {
        return realm.getEnv().parsePublic(source, new String[0]);
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    static boolean equals(Source source, Source cachedSource) {
        return source.equals(cachedSource);
    }

    @Specialization(guards={"isCached(cachedSource)", "equals(source, cachedSource)"}, limit="1")
    static Object cachedLoad(Source source, JSRealm realm, @Cached @Cached.Shared(value="importValue") ImportValueNode importValue, @Cached(value="source") Source cachedSource, @Cached(value="create(loadScript(source, realm))") DirectCallNode callNode) {
        return importValue.executeWithTarget(callNode.call(JSArguments.EMPTY_ARGUMENTS_ARRAY));
    }

    @Specialization(replaces={"cachedLoad"})
    static Object uncachedLoad(Source source, JSRealm realm, @Cached @Cached.Shared(value="importValue") ImportValueNode importValue, @Cached IndirectCallNode callNode) {
        return importValue.executeWithTarget(callNode.call(JSLoadNode.loadScript(source, realm), JSArguments.EMPTY_ARGUMENTS_ARRAY));
    }

    @Idempotent
    static boolean isCached(Source source) {
        return source.isCached();
    }
}

