/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins.temporal;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.builtins.temporal.TemporalPlainDateFunctionBuiltins;
import com.oracle.truffle.js.builtins.temporal.TemporalPlainDatePrototypeBuiltins;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.builtins.JSConstructor;
import com.oracle.truffle.js.runtime.builtins.JSConstructorFactory;
import com.oracle.truffle.js.runtime.builtins.JSDate;
import com.oracle.truffle.js.runtime.builtins.JSFunctionObject;
import com.oracle.truffle.js.runtime.builtins.JSNonProxy;
import com.oracle.truffle.js.runtime.builtins.JSObjectFactory;
import com.oracle.truffle.js.runtime.builtins.PrototypeSupplier;
import com.oracle.truffle.js.runtime.builtins.temporal.ISODateRecord;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDurationRecord;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDateObject;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import com.oracle.truffle.js.runtime.util.TemporalErrors;
import com.oracle.truffle.js.runtime.util.TemporalUtil;

public final class JSTemporalPlainDate
extends JSNonProxy
implements JSConstructorFactory.WithFunctions,
PrototypeSupplier {
    public static final JSTemporalPlainDate INSTANCE = new JSTemporalPlainDate();
    public static final TruffleString CLASS_NAME = Strings.constant("PlainDate");
    public static final TruffleString PROTOTYPE_NAME = Strings.constant("PlainDate.prototype");
    public static final TruffleString TO_STRING_TAG = Strings.constant("Temporal.PlainDate");

    private JSTemporalPlainDate() {
    }

    @Override
    public TruffleString getClassName(JSDynamicObject object) {
        return TO_STRING_TAG;
    }

    @Override
    public TruffleString getClassName() {
        return CLASS_NAME;
    }

    @Override
    public JSDynamicObject createPrototype(JSRealm realm, JSFunctionObject constructor) {
        JSObject prototype = JSObjectUtil.createOrdinaryPrototypeObject(realm);
        JSObjectUtil.putConstructorProperty(prototype, constructor);
        JSObjectUtil.putAccessorsFromContainer(realm, prototype, TemporalPlainDatePrototypeBuiltins.BUILTINS);
        JSObjectUtil.putFunctionsFromContainer(realm, prototype, TemporalPlainDatePrototypeBuiltins.BUILTINS);
        JSObjectUtil.putToStringTag(prototype, TO_STRING_TAG);
        return prototype;
    }

    @Override
    public Shape makeInitialShape(JSContext context2, JSDynamicObject prototype) {
        return JSObjectUtil.getProtoChildShape(prototype, INSTANCE, context2);
    }

    @Override
    public JSDynamicObject getIntrinsicDefaultProto(JSRealm realm) {
        return realm.getTemporalPlainDatePrototype();
    }

    public static JSConstructor createConstructor(JSRealm realm) {
        return INSTANCE.createConstructorAndPrototype(realm, TemporalPlainDateFunctionBuiltins.BUILTINS);
    }

    public static boolean isJSTemporalPlainDate(Object obj) {
        return obj instanceof JSTemporalPlainDateObject;
    }

    public static JSTemporalPlainDateObject create(JSContext context2, JSRealm realm, int year, int month, int day, JSDynamicObject calendar, Node node, InlinedBranchProfile errorBranch) {
        return JSTemporalPlainDate.create(context2, realm, INSTANCE.getIntrinsicDefaultProto(realm), year, month, day, calendar, node, errorBranch);
    }

    public static JSTemporalPlainDateObject create(JSContext context2, JSRealm realm, JSDynamicObject proto, int year, int month, int day, JSDynamicObject calendar, Node node, InlinedBranchProfile errorBranch) {
        if (!TemporalUtil.isValidISODate(year, month, day)) {
            errorBranch.enter(node);
            throw TemporalErrors.createRangeErrorDateTimeOutsideRange();
        }
        if (!TemporalUtil.isoDateTimeWithinLimits(year, month, day, 12, 0, 0, 0, 0, 0)) {
            errorBranch.enter(node);
            throw TemporalErrors.createRangeErrorDateOutsideRange();
        }
        return JSTemporalPlainDate.createIntl(context2, realm, proto, year, month, day, calendar);
    }

    private static JSTemporalPlainDateObject createIntl(JSContext context2, JSRealm realm, JSDynamicObject proto, int year, int month, int day, JSDynamicObject calendar) {
        JSObjectFactory factory = context2.getTemporalPlainDateFactory();
        Shape shape = factory.getShape(realm, proto);
        JSTemporalPlainDateObject newObj = factory.initProto(new JSTemporalPlainDateObject(shape, proto, year, month, day, calendar), realm, proto);
        return factory.trackAllocation(newObj);
    }

    public static JSTemporalDurationRecord differenceISODate(int y1, int m1, int d1, int y2, int m2, int d2, TemporalUtil.Unit largestUnit) {
        assert (largestUnit == TemporalUtil.Unit.YEAR || largestUnit == TemporalUtil.Unit.MONTH || largestUnit == TemporalUtil.Unit.WEEK || largestUnit == TemporalUtil.Unit.DAY);
        if (largestUnit == TemporalUtil.Unit.YEAR || largestUnit == TemporalUtil.Unit.MONTH) {
            int sign = -TemporalUtil.compareISODate(y1, m1, d1, y2, m2, d2);
            if (sign == 0) {
                return JSTemporalPlainDate.toRecordWeeksPlural(0L, 0L, 0L, 0L);
            }
            ISODateRecord start2 = new ISODateRecord(y1, m1, d1);
            ISODateRecord end = new ISODateRecord(y2, m2, d2);
            int years = end.year() - start2.year();
            ISODateRecord mid = TemporalUtil.addISODate(y1, m1, d1, years, 0, 0, 0, TemporalUtil.Overflow.CONSTRAIN);
            int midSign = -TemporalUtil.compareISODate(mid.year(), mid.month(), mid.day(), y2, m2, d2);
            if (midSign == 0) {
                if (largestUnit == TemporalUtil.Unit.YEAR) {
                    return JSTemporalPlainDate.toRecordWeeksPlural(years, 0L, 0L, 0L);
                }
                return JSTemporalPlainDate.toRecordWeeksPlural(0L, years * 12, 0L, 0L);
            }
            int months = end.month() - start2.month();
            if (midSign != sign) {
                years -= sign;
                months += sign * 12;
            }
            if ((midSign = -TemporalUtil.compareISODate((mid = TemporalUtil.addISODate(y1, m1, d1, years, months, 0, 0, TemporalUtil.Overflow.CONSTRAIN)).year(), mid.month(), mid.day(), y2, m2, d2)) == 0) {
                if (largestUnit == TemporalUtil.Unit.YEAR) {
                    return JSTemporalPlainDate.toRecordPlural(years, months, 0L);
                }
                return JSTemporalPlainDate.toRecordWeeksPlural(0L, months + years * 12, 0L, 0L);
            }
            if (midSign != sign) {
                if ((months -= sign) == -sign) {
                    years -= sign;
                    months = 11 * sign;
                }
                mid = TemporalUtil.addISODate(y1, m1, d1, years, months, 0, 0, TemporalUtil.Overflow.CONSTRAIN);
                midSign = -TemporalUtil.compareISODate(mid.year(), mid.month(), mid.day(), y2, m2, d2);
            }
            int days = 0;
            days = mid.month() == end.month() && mid.year() == end.year() ? end.day() - mid.day() : (sign < 0 ? -mid.day() - (TemporalUtil.isoDaysInMonth(end.year(), end.month()) - end.day()) : end.day() + (TemporalUtil.isoDaysInMonth(mid.year(), mid.month()) - mid.day()));
            if (largestUnit == TemporalUtil.Unit.MONTH) {
                months += years * 12;
                years = 0;
            }
            return JSTemporalPlainDate.toRecordWeeksPlural(years, months, 0L, days);
        }
        if (largestUnit == TemporalUtil.Unit.DAY || largestUnit == TemporalUtil.Unit.WEEK) {
            double epochDays1 = JSDate.makeDay(y1, m1 - 1, d1);
            double epochDays2 = JSDate.makeDay(y2, m2 - 1, d2);
            int days = TemporalUtil.dtoi(epochDays2 - epochDays1);
            int weeks = 0;
            if (largestUnit == TemporalUtil.Unit.WEEK) {
                weeks = (int)TemporalUtil.roundTowardsZero((double)days / 7.0);
                days %= 7;
            }
            return JSTemporalPlainDate.toRecordWeeksPlural(0L, 0L, weeks, days);
        }
        CompilerDirectives.transferToInterpreter();
        throw Errors.shouldNotReachHere("unexpected largest unit: " + String.valueOf((Object)largestUnit));
    }

    private static JSTemporalDurationRecord toRecordPlural(long year, long month, long day) {
        return JSTemporalDurationRecord.create(year, month, day, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    }

    private static JSTemporalDurationRecord toRecordWeeksPlural(long year, long month, long weeks, long day) {
        return JSTemporalDurationRecord.createWeeks(year, month, weeks, day, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    }

    @CompilerDirectives.TruffleBoundary
    public static TruffleString temporalDateToString(JSTemporalPlainDateObject date, TemporalUtil.ShowCalendar showCalendar) {
        TruffleString yearString = TemporalUtil.padISOYear(date.getYear());
        TruffleString monthString = TemporalUtil.toZeroPaddedDecimalString(date.getMonth(), 2);
        TruffleString dayString = TemporalUtil.toZeroPaddedDecimalString(date.getDay(), 2);
        TruffleString calendarID = JSRuntime.toString(date.getCalendar());
        TruffleString calendar = TemporalUtil.formatCalendarAnnotation(calendarID, showCalendar);
        return Strings.format("%s-%s-%s%s", yearString, monthString, dayString, calendar);
    }
}

