/*
 * Decompiled with CFR 0.152.
 */
package org.jrubyparser.ast;

import java.util.List;
import org.jrubyparser.NodeVisitor;
import org.jrubyparser.SourcePosition;
import org.jrubyparser.StaticScope;
import org.jrubyparser.ast.Colon3Node;
import org.jrubyparser.ast.ILocalScope;
import org.jrubyparser.ast.ILocalVariable;
import org.jrubyparser.ast.IModuleScope;
import org.jrubyparser.ast.IScopingNode;
import org.jrubyparser.ast.MethodDefNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;
import org.jrubyparser.util.ILocalVariableVisitor;
import org.jrubyparser.util.MethodDefVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassNode
extends Node
implements IScopingNode,
ILocalScope,
IModuleScope {
    private Colon3Node cpath;
    private StaticScope scope;
    private Node bodyNode;
    private Node superNode;

    public ClassNode(SourcePosition position, Colon3Node cpath, StaticScope scope, Node bodyNode, Node superNode) {
        super(position);
        assert (cpath != null) : "cpath is not null";
        assert (scope != null) : "scope is not null";
        this.cpath = (Colon3Node)this.adopt(cpath);
        this.scope = scope;
        this.bodyNode = this.adopt(bodyNode);
        this.superNode = this.adopt(superNode);
    }

    @Override
    public boolean isSame(Node node) {
        if (!super.isSame(node)) {
            return false;
        }
        ClassNode other = (ClassNode)node;
        if (this.getSuper() == null && other.getSuper() == null) {
            return this.getCPath().isSame(other.getCPath());
        }
        if (this.getSuper() == null || other.getSuper() == null) {
            return false;
        }
        return this.getSuper().isSame(other.getSuper()) && this.getCPath().isSame(other.getCPath());
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.CLASSNODE;
    }

    @Override
    public Object accept(NodeVisitor iVisitor) {
        return iVisitor.visitClassNode(this);
    }

    public Node getBody() {
        return this.bodyNode;
    }

    @Deprecated
    public Node getBodyNode() {
        return this.getBody();
    }

    public StaticScope getScope() {
        return this.scope;
    }

    @Override
    public Colon3Node getCPath() {
        return this.cpath;
    }

    public Node getSuper() {
        return this.superNode;
    }

    @Deprecated
    public Node getSuperNode() {
        return this.getSuper();
    }

    @Override
    public List<MethodDefNode> getMethodDefs() {
        return MethodDefVisitor.findMethodsIn(this);
    }

    @Override
    public List<ILocalVariable> getVariableReferencesNamed(String name) {
        return ILocalVariableVisitor.findOccurrencesIn(this, name);
    }
}

