/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dataframe.impl.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.PublishedApi;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.dataframe.DataColumn;
import org.jetbrains.kotlinx.dataframe.DataFrame;
import org.jetbrains.kotlinx.dataframe.api.CastKt;
import org.jetbrains.kotlinx.dataframe.api.ToDataFrameKt;
import org.jetbrains.kotlinx.dataframe.columns.BaseColumn;
import org.jetbrains.kotlinx.dataframe.columns.ColumnGroup;
import org.jetbrains.kotlinx.dataframe.columns.ColumnPath;
import org.jetbrains.kotlinx.dataframe.impl.api.ColumnToInsert;
import org.jetbrains.kotlinx.dataframe.impl.columns.tree.ReadonlyTreeNode;
import org.jetbrains.kotlinx.dataframe.impl.columns.tree.ReferenceData;
import org.jetbrains.kotlinx.dataframe.impl.columns.tree.UtilsKt;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u001c\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0000\u001a2\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0001\"\u0004\b\u0000\u0010\u00072\u000e\u0010\b\u001a\n\u0012\u0004\u0012\u0002H\u0007\u0018\u00010\u00012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0000\u001aJ\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0001\"\u0004\b\u0000\u0010\u00072\u000e\u0010\b\u001a\n\u0012\u0004\u0012\u0002H\u0007\u0018\u00010\u00012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u000e\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n2\u0006\u0010\f\u001a\u00020\rH\u0000\u001a1\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0001\"\u0004\b\u0000\u0010\u0007*\b\u0012\u0004\u0012\u0002H\u00070\u00012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0001\u00a2\u0006\u0002\b\u000e\u001a6\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0001\"\u0004\b\u0000\u0010\u0007*\b\u0012\u0004\u0012\u0002H\u00070\u00012\u0006\u0010\u000f\u001a\u00020\u00102\u000e\u0010\u0011\u001a\n\u0012\u0002\b\u00030\u0012j\u0002`\u0013H\u0001\u00a8\u0006\u0014"}, d2={"dataFrameOf", "Lorg/jetbrains/kotlinx/dataframe/DataFrame;", "", "columns", "", "Lorg/jetbrains/kotlinx/dataframe/impl/api/ColumnToInsert;", "insertImpl", "T", "df", "treeNode", "Lorg/jetbrains/kotlinx/dataframe/impl/columns/tree/ReadonlyTreeNode;", "Lorg/jetbrains/kotlinx/dataframe/impl/columns/tree/ReferenceData;", "depth", "", "insertImplT", "path", "Lorg/jetbrains/kotlinx/dataframe/columns/ColumnPath;", "column", "Lorg/jetbrains/kotlinx/dataframe/DataColumn;", "Lorg/jetbrains/kotlinx/dataframe/AnyCol;", "core"})
@SourceDebugExtension(value={"SMAP\ninsert.kt\nKotlin\n*S Kotlin\n*F\n+ 1 insert.kt\norg/jetbrains/kotlinx/dataframe/impl/api/InsertKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,136:1\n1477#2:137\n1502#2,3:138\n1505#2,3:148\n1855#2:151\n288#2,2:152\n1856#2:155\n1603#2,9:156\n1855#2:165\n1856#2:167\n1612#2:168\n1045#2:169\n1855#2:170\n288#2,2:171\n1774#2,4:173\n766#2:177\n857#2,2:178\n1856#2:180\n372#3,7:141\n1#4:154\n1#4:166\n*S KotlinDebug\n*F\n+ 1 insert.kt\norg/jetbrains/kotlinx/dataframe/impl/api/InsertKt\n*L\n46#1:137\n46#1:138,3\n46#1:148,3\n51#1:151\n55#1:152,2\n51#1:155\n67#1:156,9\n67#1:165\n67#1:167\n67#1:168\n89#1:169\n95#1:170\n107#1:171,2\n111#1:173,4\n115#1:177\n115#1:178,2\n95#1:180\n46#1:141,7\n67#1:166\n*E\n"})
public final class InsertKt {
    @PublishedApi
    @NotNull
    public static final <T> DataFrame<T> insertImpl(@NotNull DataFrame<? extends T> $this$insertImpl, @NotNull ColumnPath path, @NotNull DataColumn<?> column2) {
        Intrinsics.checkNotNullParameter($this$insertImpl, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(column2, (String)"column");
        return InsertKt.insertImpl($this$insertImpl, CollectionsKt.listOf((Object)new ColumnToInsert(path, column2, null, 4, null)));
    }

    @JvmName(name="insertImplT")
    @NotNull
    public static final <T> DataFrame<T> insertImplT(@NotNull DataFrame<? extends T> $this$insertImpl, @NotNull List<ColumnToInsert> columns2) {
        Intrinsics.checkNotNullParameter($this$insertImpl, (String)"<this>");
        Intrinsics.checkNotNullParameter(columns2, (String)"columns");
        return InsertKt.insertImpl($this$insertImpl, columns2);
    }

    @NotNull
    public static final <T> DataFrame<T> insertImpl(@Nullable DataFrame<? extends T> df2, @NotNull List<ColumnToInsert> columns2) {
        Intrinsics.checkNotNullParameter(columns2, (String)"columns");
        Object object = (ColumnToInsert)CollectionsKt.firstOrNull(columns2);
        return InsertKt.insertImpl(df2, columns2, object != null && (object = ((ColumnToInsert)object).getReferenceNode()) != null ? object.getRoot() : null, 0);
    }

    @NotNull
    public static final DataFrame<Unit> dataFrameOf(@NotNull List<ColumnToInsert> columns2) {
        Intrinsics.checkNotNullParameter(columns2, (String)"columns");
        Object object = (ColumnToInsert)CollectionsKt.firstOrNull(columns2);
        return InsertKt.insertImpl(null, columns2, object != null && (object = ((ColumnToInsert)object).getReferenceNode()) != null ? object.getRoot() : null, 0);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <T> DataFrame<T> insertImpl(@Nullable DataFrame<? extends T> df2, @NotNull List<ColumnToInsert> columns2, @Nullable ReadonlyTreeNode<? extends ReferenceData> treeNode, int depth) {
        void $this$sortedBy$iv;
        void $this$mapNotNullTo$iv$iv;
        ColumnToInsert it;
        void $this$groupByTo$iv$iv;
        Intrinsics.checkNotNullParameter(columns2, (String)"columns");
        if (columns2.isEmpty()) {
            DataFrame<Object> dataFrame = df2;
            if (dataFrame == null) {
                dataFrame = CastKt.cast(DataFrame.Companion.empty$default(DataFrame.Companion, 0, 1, null));
            }
            return dataFrame;
        }
        int childDepth = depth + 1;
        Iterable $this$groupBy$iv = columns2;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo22 = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            ColumnToInsert it2 = (ColumnToInsert)element$iv$iv;
            boolean bl = false;
            String key$iv$iv = it2.getInsertionPath().get(depth);
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map columnsMap = MapsKt.toMutableMap((Map)destination$iv$iv);
        List newColumns2 = new ArrayList();
        DataFrame<? extends T> dataFrame = df2;
        if (dataFrame != null && (dataFrame = dataFrame.columns()) != null) {
            Iterable $this$forEach$iv = (Iterable)((Object)dataFrame);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                DataColumn it3 = (DataColumn)element$iv;
                boolean bl = false;
                List subTree = (List)columnsMap.get(it3.name());
                if (subTree != null) {
                    Object v3;
                    block38: {
                        Iterable $this$firstOrNull$iv = subTree;
                        boolean $i$f$firstOrNull = false;
                        for (Object element$iv2 : $this$firstOrNull$iv) {
                            it = (ColumnToInsert)element$iv2;
                            boolean bl3 = false;
                            if (!(it.getInsertionPath().size() == childDepth)) continue;
                            v3 = element$iv2;
                            break block38;
                        }
                        v3 = null;
                    }
                    ColumnToInsert invalidPath = v3;
                    if (!(invalidPath == null)) {
                        boolean $i$a$-check-InsertKt$insertImpl$1$32 = false;
                        StringBuilder stringBuilder = new StringBuilder().append("Can not insert column '");
                        ColumnToInsert columnToInsert = invalidPath;
                        Intrinsics.checkNotNull((Object)columnToInsert);
                        String $i$a$-check-InsertKt$insertImpl$1$32 = stringBuilder.append(columnToInsert.getInsertionPath().joinToString(".")).append("' because column with this path already exists in DataFrame").toString();
                        throw new IllegalStateException($i$a$-check-InsertKt$insertImpl$1$32.toString());
                    }
                    ColumnGroup group2 = it3 instanceof ColumnGroup ? (ColumnGroup)((Object)it3) : null;
                    if (!(group2 != null)) {
                        boolean $i$a$-check-InsertKt$insertImpl$1$42 = false;
                        String $i$a$-check-InsertKt$insertImpl$1$42 = "Can not insert columns under a column '" + it3.name() + "', because it is not a column group";
                        throw new IllegalStateException($i$a$-check-InsertKt$insertImpl$1$42.toString());
                    }
                    ReadonlyTreeNode<? extends ReferenceData> readonlyTreeNode = treeNode;
                    DataFrame<T> newDf = InsertKt.insertImpl(group2, subTree, readonlyTreeNode != null ? readonlyTreeNode.get(it3.name()) : null, childDepth);
                    ColumnGroup<T> newCol = org.jetbrains.kotlinx.dataframe.impl.columns.UtilsKt.withDf(group2, newDf);
                    newColumns2.add(newCol);
                    columnsMap.remove(it3.name());
                    continue;
                }
                newColumns2.add(it3);
            }
        }
        Iterable $this$mapNotNull$iv = columns2;
        boolean $i$f$mapNotNull = false;
        Iterable $i$f$groupByTo22 = $this$mapNotNull$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Pair pair = $this$forEach$iv$iv$iv.iterator();
        while (pair.hasNext()) {
            Pair pair2;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = pair.next();
            boolean bl = false;
            it = (ColumnToInsert)element$iv$iv;
            boolean bl4 = false;
            String name = it.getInsertionPath().get(depth);
            List subTree = (List)columnsMap.get(name);
            if (subTree != null) {
                int n;
                columnsMap.remove(name);
                Iterator iterator2 = ((Iterable)subTree).iterator();
                if (!iterator2.hasNext()) {
                    throw new NoSuchElementException();
                }
                ColumnToInsert it22 = (ColumnToInsert)iterator2.next();
                boolean bl5 = false;
                if (it22.getReferenceNode() == null) {
                    n = Integer.MAX_VALUE;
                } else {
                    ReadonlyTreeNode<ReferenceData> col2 = it22.getReferenceNode();
                    if (col2.getDepth() > depth) {
                        col2 = UtilsKt.getAncestor(col2, depth + 1);
                    }
                    n = col2.getParent() == treeNode ? (col2.getData().getWasRemoved() ? col2.getData().getOriginalIndex() : col2.getData().getOriginalIndex() + 1) : Integer.MAX_VALUE;
                }
                int it22 = n;
                while (iterator2.hasNext()) {
                    int n2;
                    ColumnToInsert it4 = (ColumnToInsert)iterator2.next();
                    $i$a$-minOf-InsertKt$insertImpl$columnsToAdd$1$minIndex$1 = false;
                    if (it4.getReferenceNode() == null) {
                        n2 = Integer.MAX_VALUE;
                    } else {
                        ReadonlyTreeNode<ReferenceData> col3 = it4.getReferenceNode();
                        if (col3.getDepth() > depth) {
                            col3 = UtilsKt.getAncestor(col3, depth + 1);
                        }
                        n2 = col3.getParent() == treeNode ? (col3.getData().getWasRemoved() ? col3.getData().getOriginalIndex() : col3.getData().getOriginalIndex() + 1) : Integer.MAX_VALUE;
                    }
                    if (it22 <= (it4 = n2)) continue;
                    it22 = it4;
                }
                int minIndex = it22;
                pair2 = TuplesKt.to((Object)minIndex, (Object)TuplesKt.to((Object)name, (Object)subTree));
            } else {
                pair2 = null;
            }
            if (pair2 == null) continue;
            Pair it$iv$iv = pair2;
            boolean bl6 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv2;
        boolean $i$f$sortedBy = false;
        List columnsToAdd = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Pair it = (Pair)a;
                boolean bl = false;
                Comparable comparable = (Integer)it.getFirst();
                it = (Pair)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Integer)it.getFirst()));
            }
        });
        ReadonlyTreeNode<? extends ReferenceData> readonlyTreeNode = treeNode;
        List<ReadonlyTreeNode<? extends ReferenceData>> removedSiblings = readonlyTreeNode != null ? readonlyTreeNode.getChildren() : null;
        int k = 0;
        int insertionIndexOffset = 0;
        Iterable $this$forEach$iv = columnsToAdd;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            BaseColumn newCol;
            BaseColumn baseColumn;
            Object v11;
            List columns3;
            String name;
            int insertionIndex;
            block39: {
                pair = (Pair)element$iv;
                boolean bl = false;
                insertionIndex = ((Number)pair.component1()).intValue();
                Pair pair3 = (Pair)pair.component2();
                name = (String)pair3.component1();
                columns3 = (List)pair3.component2();
                if (removedSiblings != null) {
                    while (k < removedSiblings.size() && removedSiblings.get(k).getData().getOriginalIndex() < insertionIndex) {
                        if (removedSiblings.get(k).getData().getWasRemoved()) {
                            insertionIndexOffset += -1;
                        }
                        ++k;
                    }
                }
                Iterable $this$firstOrNull$iv = columns3;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv3 : $this$firstOrNull$iv) {
                    ColumnToInsert it5 = (ColumnToInsert)element$iv3;
                    boolean bl7 = false;
                    if (!(it5.getInsertionPath().size() == childDepth)) continue;
                    v11 = element$iv3;
                    break block39;
                }
                v11 = null;
            }
            ColumnToInsert nodeToInsert = v11;
            if (nodeToInsert != null) {
                BaseColumn<?> column2 = nodeToInsert.getColumn();
                if (columns3.size() > 1) {
                    void $this$filterTo$iv$iv;
                    void $this$filter$iv;
                    int n;
                    Iterable $this$count$iv = columns3;
                    boolean $i$f$count = false;
                    if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                        n = 0;
                    } else {
                        int count$iv = 0;
                        for (Object element$iv4 : $this$count$iv) {
                            ColumnToInsert it6 = (ColumnToInsert)element$iv4;
                            boolean bl = false;
                            if (!(it6.getInsertionPath().size() == childDepth) || ++count$iv >= 0) continue;
                            CollectionsKt.throwCountOverflow();
                        }
                        n = count$iv;
                    }
                    if (!(n == 1)) {
                        boolean $i$a$-check-InsertKt$insertImpl$2$newCol$32 = false;
                        String $i$a$-check-InsertKt$insertImpl$2$newCol$32 = "Can not insert more than one column into the path " + nodeToInsert.getInsertionPath();
                        throw new IllegalStateException($i$a$-check-InsertKt$insertImpl$2$newCol$32.toString());
                    }
                    if (!(column2 instanceof ColumnGroup)) {
                        String $i$a$-check-InsertKt$insertImpl$2$newCol$32 = "Check failed.";
                        throw new IllegalStateException($i$a$-check-InsertKt$insertImpl$2$newCol$32.toString());
                    }
                    Iterable $i$a$-check-InsertKt$insertImpl$2$newCol$32 = columns3;
                    DataFrame dataFrame2 = (DataFrame)((Object)column2);
                    boolean $i$f$filter = false;
                    void bl7 = $this$filter$iv;
                    Collection destination$iv$iv3 = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        ColumnToInsert it7 = (ColumnToInsert)element$iv$iv;
                        boolean bl = false;
                        if (!(it7.getInsertionPath().size() > childDepth)) continue;
                        destination$iv$iv3.add(element$iv$iv);
                    }
                    ReadonlyTreeNode<? extends ReferenceData> readonlyTreeNode2 = treeNode;
                    DataFrame<T> newDf = InsertKt.insertImpl(dataFrame2, (List)destination$iv$iv3, readonlyTreeNode2 != null ? readonlyTreeNode2.get(name) : null, childDepth);
                    baseColumn = org.jetbrains.kotlinx.dataframe.impl.columns.UtilsKt.withDf((ColumnGroup)column2, newDf);
                } else {
                    baseColumn = column2.rename(name);
                }
            } else {
                ReadonlyTreeNode<? extends ReferenceData> readonlyTreeNode3 = treeNode;
                DataFrame<T> newDf = InsertKt.insertImpl(null, columns3, readonlyTreeNode3 != null ? readonlyTreeNode3.get(name) : null, childDepth);
                baseColumn = newCol = (BaseColumn)DataColumn.Companion.createColumnGroup(name, newDf);
            }
            if (insertionIndex == Integer.MAX_VALUE) {
                newColumns2.add(newCol);
                continue;
            }
            newColumns2.add(insertionIndex + insertionIndexOffset, newCol);
            ++insertionIndexOffset;
        }
        return CastKt.cast(ToDataFrameKt.toDataFrameAnyColumn(newColumns2));
    }
}

