/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.ast;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.ast.PyAstElement;
import com.jetbrains.python.ast.PyAstElementVisitor;
import com.jetbrains.python.ast.PyAstExpression;
import com.jetbrains.python.ast.PyAstTypedElement;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public interface PyAstTypeParameter
extends PyAstElement,
PsiNameIdentifierOwner,
PyAstTypedElement {
    @Nullable
    default public PyAstExpression getBoundExpression() {
        PsiElement element = StreamEx.of((Object[])this.getChildren()).findFirst(child -> {
            PsiElement e = PsiTreeUtil.skipWhitespacesBackward((PsiElement)child);
            return e != null && e.getNode().getElementType() == PyTokenTypes.COLON;
        }).orElse(null);
        if (element instanceof PyAstExpression) {
            PyAstExpression expression = (PyAstExpression)element;
            return expression;
        }
        return null;
    }

    @Nullable
    default public PyAstExpression getDefaultExpression() {
        PsiElement element = StreamEx.of((Object[])this.getChildren()).findFirst(child -> {
            PsiElement e = PsiTreeUtil.skipWhitespacesBackward((PsiElement)child);
            return e != null && e.getNode().getElementType() == PyTokenTypes.EQ;
        }).orElse(null);
        if (element instanceof PyAstExpression) {
            PyAstExpression expression = (PyAstExpression)element;
            return expression;
        }
        return null;
    }

    @Nullable
    default public String getBoundExpressionText() {
        PyAstExpression boundExpression = this.getBoundExpression();
        if (boundExpression != null) {
            return boundExpression.getText();
        }
        return null;
    }

    @Nullable
    default public String getDefaultExpressionText() {
        PyAstExpression defaultExpression = this.getDefaultExpression();
        if (defaultExpression != null) {
            return defaultExpression.getText();
        }
        return null;
    }

    @NotNull
    default public Kind getKind() {
        String paramText = this.getText();
        if (paramText.startsWith("**")) {
            Kind kind = Kind.ParamSpec;
            if (kind == null) {
                PyAstTypeParameter.$$$reportNull$$$0(0);
            }
            return kind;
        }
        if (paramText.startsWith("*")) {
            Kind kind = Kind.TypeVarTuple;
            if (kind == null) {
                PyAstTypeParameter.$$$reportNull$$$0(1);
            }
            return kind;
        }
        Kind kind = Kind.TypeVar;
        if (kind == null) {
            PyAstTypeParameter.$$$reportNull$$$0(2);
        }
        return kind;
    }

    @Nullable
    default public String getName() {
        PsiElement identifier = this.getNameIdentifier();
        return identifier != null ? identifier.getText() : null;
    }

    @Nullable
    default public PsiElement getNameIdentifier() {
        ASTNode nameNode = this.getNode().findChildByType((IElementType)PyTokenTypes.IDENTIFIER);
        return nameNode != null ? nameNode.getPsi() : null;
    }

    @Override
    default public void acceptPyVisitor(PyAstElementVisitor pyVisitor) {
        pyVisitor.visitPyTypeParameter(this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/ast/PyAstTypeParameter", "getKind"));
    }

    public static enum Kind {
        TypeVar(0),
        TypeVarTuple(1),
        ParamSpec(2);

        private final int myIndex;

        private Kind(int index) {
            this.myIndex = index;
        }

        public int getIndex() {
            return this.myIndex;
        }

        public static Kind fromIndex(int index) {
            return switch (index) {
                case 1 -> TypeVarTuple;
                case 2 -> ParamSpec;
                default -> TypeVar;
            };
        }
    }
}

