/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent.devcontainers;

import com.intellij.docker.agent.devcontainers.Devcontainer;
import com.intellij.docker.agent.remote.DockerRemoteUtilsKt;
import java.nio.file.Path;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u000eJ\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u000eJ\u0012\u0010\u0011\u001a\u00020\u0012*\u00020\u0013H\u0086@\u00a2\u0006\u0002\u0010\u0014J\u0012\u0010\u0015\u001a\u00020\u0012*\u00020\u0013H\u0086@\u00a2\u0006\u0002\u0010\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u001d\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0016"}, d2={"Lcom/intellij/docker/agent/devcontainers/DevcontainerPaths;", "", "<init>", "()V", "DEVCONTAINERS_XDG_CACHE", "", "DEVCONTAINERS_XDG_CONFIG", "HOST_CONFIG_PATH", "DIST_DIR", "XDG_ENVS", "", "getXDG_ENVS", "()Ljava/util/Map;", "computeSourcesMountPath", "Ljava/nio/file/Path;", "from", "traverseUpUntilDevcontainerFolder", "createDefaultDevcontainerDirs", "", "Lcom/intellij/docker/agent/devcontainers/Devcontainer;", "(Lcom/intellij/docker/agent/devcontainers/Devcontainer;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "provideFullAccessToDevcontainerDirs", "intellij.clouds.docker.agent"})
@SourceDebugExtension(value={"SMAP\nDevcontainerPaths.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DevcontainerPaths.kt\ncom/intellij/docker/agent/devcontainers/DevcontainerPaths\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,43:1\n183#2,2:44\n*S KotlinDebug\n*F\n+ 1 DevcontainerPaths.kt\ncom/intellij/docker/agent/devcontainers/DevcontainerPaths\n*L\n33#1:44,2\n*E\n"})
public final class DevcontainerPaths {
    @NotNull
    public static final DevcontainerPaths INSTANCE = new DevcontainerPaths();
    @NotNull
    private static final String DEVCONTAINERS_XDG_CACHE = "/.jbdevcontainer";
    @NotNull
    private static final String DEVCONTAINERS_XDG_CONFIG = "/.jbdevcontainer/config";
    @NotNull
    public static final String HOST_CONFIG_PATH = "/.jbdevcontainer/config/JetBrains/host-config.json";
    @NotNull
    public static final String DIST_DIR = "/.jbdevcontainer/JetBrains/RemoteDev/dist";
    @NotNull
    private static final Map<String, String> XDG_ENVS;

    private DevcontainerPaths() {
    }

    @NotNull
    public final Map<String, String> getXDG_ENVS() {
        return XDG_ENVS;
    }

    @Nullable
    public final Path computeSourcesMountPath(@NotNull Path from) {
        Path path;
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Path path2 = from.normalize();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"normalize(...)");
        if (StringsKt.startsWith$default((String)((Object)path2).toString(), (String)".devcontainer", (boolean)false, (int)2, null)) {
            path = null;
        } else if (Intrinsics.areEqual((Object)PathsKt.getName((Path)from), (Object)".devcontainer.json")) {
            path = from.getParent();
        } else {
            path = this.traverseUpUntilDevcontainerFolder(from);
            if (path == null || (path = path.getParent()) == null) {
                Path path3 = from.getParent();
                if (path3 != null) {
                    Path path4;
                    Path path5 = path4 = path3;
                    boolean bl = false;
                    path = !Intrinsics.areEqual((Object)PathsKt.getName((Path)path5), (Object)".devcontainer") ? path4 : null;
                } else {
                    path = null;
                }
            }
        }
        return path;
    }

    @Nullable
    public final Path traverseUpUntilDevcontainerFolder(@NotNull Path from) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)from, (String)"from");
            Sequence $this$firstOrNull$iv = SequencesKt.generateSequence((Object)from, DevcontainerPaths::traverseUpUntilDevcontainerFolder$lambda$1);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Path it = (Path)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)PathsKt.getName((Path)it), (Object)".devcontainer")) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @Nullable
    public final Object createDefaultDevcontainerDirs(@NotNull Devcontainer $this$createDefaultDevcontainerDirs, @NotNull Continuation<? super Unit> $completion) {
        String[] stringArray = new String[]{"mkdir", "-p", DEVCONTAINERS_XDG_CACHE};
        Object object = DockerRemoteUtilsKt.awaitAndThrowExceptionOnError(DockerRemoteUtilsKt.execCommandAsRoot$default($this$createDefaultDevcontainerDirs.getAgentContainer(), stringArray, false, false, null, null, 30, null), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public final Object provideFullAccessToDevcontainerDirs(@NotNull Devcontainer $this$provideFullAccessToDevcontainerDirs, @NotNull Continuation<? super Unit> $completion) {
        String[] stringArray = new String[]{"chmod", "-R", "777", DEVCONTAINERS_XDG_CACHE};
        Object object = DockerRemoteUtilsKt.awaitAndThrowExceptionOnError(DockerRemoteUtilsKt.execCommandAsRoot$default($this$provideFullAccessToDevcontainerDirs.getAgentContainer(), stringArray, false, false, null, null, 30, null), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private static final Path traverseUpUntilDevcontainerFolder$lambda$1(Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getParent();
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"XDG_CACHE_HOME", (Object)DEVCONTAINERS_XDG_CACHE), TuplesKt.to((Object)"XDG_DATA_HOME", (Object)"/.jbdevcontainer/data"), TuplesKt.to((Object)"XDG_CONFIG_HOME", (Object)DEVCONTAINERS_XDG_CONFIG)};
        XDG_ENVS = MapsKt.mapOf((Pair[])pairArray);
    }
}

