/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.composeFile.model;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.docker.composeFile.i18n.DockerComposeBundle;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.meta.model.YamlScalarType;
import org.jetbrains.yaml.psi.YAMLScalar;

public class ByteValueType
extends YamlScalarType {
    private static ByteValueType ourInstance;
    private static final Pattern BYTE_VALUE_WITH_SUFFIX;

    public static ByteValueType getInstance() {
        if (ourInstance == null) {
            ourInstance = new ByteValueType();
        }
        return ourInstance;
    }

    protected ByteValueType() {
        super("byte-value-type");
    }

    protected void validateScalarValue(@NotNull YAMLScalar scalarValue, @NotNull ProblemsHolder holder) {
        if (scalarValue == null) {
            ByteValueType.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            ByteValueType.$$$reportNull$$$0(1);
        }
        super.validateScalarValue(scalarValue, holder);
        String text = scalarValue.getTextValue();
        if (text.isEmpty()) {
            return;
        }
        Matcher matcher = BYTE_VALUE_WITH_SUFFIX.matcher(text);
        if (!matcher.matches()) {
            holder.registerProblem((PsiElement)scalarValue, DockerComposeBundle.message("ByteValueType.error.cant.parse.value", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
            return;
        }
        String unit = matcher.group(2);
        assert (unit != null) : "can't find unit for " + text;
        switch (StringUtil.toLowerCase((String)unit)) {
            case "": {
                break;
            }
            case "b": 
            case "k": 
            case "kb": 
            case "m": 
            case "mb": 
            case "g": 
            case "gb": {
                break;
            }
            default: {
                holder.registerProblem((PsiElement)scalarValue, DockerComposeBundle.message("ByteValueType.error.unknown.unit", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
            }
        }
    }

    static {
        BYTE_VALUE_WITH_SUFFIX = Pattern.compile("([-+]?\\d+)([a-zA-Z]*)");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "scalarValue";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
        }
        objectArray[1] = "com/intellij/docker/composeFile/model/ByteValueType";
        objectArray[2] = "validateScalarValue";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

