/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.settings;

import com.intellij.docker.agent.settings.DockerVolumeBindingImpl;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.settings.ConfigurableAwareTableWithCardEditor;
import com.intellij.docker.settings.DockerVolumeBindingConfigurable;
import com.intellij.openapi.options.Configurable;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.util.Column;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class DockerVolumeBindingsEditor
extends ConfigurableAwareTableWithCardEditor<DockerVolumeBindingImpl, ColumnBase> {
    private final RemoteServer myServer;

    public DockerVolumeBindingsEditor(RemoteServer server) {
        super((Column[])new ColumnBase[]{new HostPathColumn(), new ContainerPathColumn(), new ReadOnlyColumn()});
        this.myServer = server;
    }

    @Override
    protected DockerVolumeBindingImpl createItem() {
        return new DockerVolumeBindingImpl();
    }

    @Override
    protected DockerVolumeBindingImpl cloneItem(DockerVolumeBindingImpl item) {
        return new DockerVolumeBindingImpl(item);
    }

    @Override
    @NotNull
    protected Configurable createItemConfigurable(DockerVolumeBindingImpl item) {
        return new DockerVolumeBindingConfigurable(item, this.myServer);
    }

    @Override
    protected boolean isEditable(int row) {
        return ((DockerVolumeBindingImpl)this.getItems().get(row)).isEditable();
    }

    public static abstract class ColumnBase
    extends Column<DockerVolumeBindingImpl> {
        public ColumnBase(@Nls String name2) {
            super(name2);
        }
    }

    private static class HostPathColumn
    extends ColumnBase {
        HostPathColumn() {
            super(DockerBundle.message("DockerVolumeBindingsEditor.HostPath.title", new Object[0]));
        }

        public Object getColumnValue(DockerVolumeBindingImpl row) {
            return row.getHostPath();
        }
    }

    private static class ContainerPathColumn
    extends ColumnBase {
        ContainerPathColumn() {
            super(DockerBundle.message("DockerVolumeBindingsEditor.ContainerPath.title", new Object[0]));
        }

        public Object getColumnValue(DockerVolumeBindingImpl row) {
            return row.getContainerPath();
        }
    }

    private static class ReadOnlyColumn
    extends ColumnBase {
        ReadOnlyColumn() {
            super(DockerBundle.message("DockerVolumeBindingsEditor.ReadOnly.title", new Object[0]));
        }

        public Object getColumnValue(DockerVolumeBindingImpl row) {
            return row.isReadOnly();
        }

        public Class<?> getValueClass() {
            return Boolean.class;
        }

        public boolean needPack() {
            return true;
        }
    }
}

