"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Messages = void 0;
var react_1 = __importDefault(require("react"));
var Message_1 = require("./Message");
var contexts_1 = require("../../contexts");
var helpers_1 = require("../../helpers");
var constants_1 = require("../../constants");
var Messages = function () {
    var asyncapi = (0, contexts_1.useSpec)();
    var config = (0, contexts_1.useConfig)();
    var messages = asyncapi.hasComponents() && asyncapi.components().messages();
    if (!messages || Object.keys(messages).length === 0) {
        return null;
    }
    return (react_1.default.createElement("section", { id: "".concat(helpers_1.CommonHelpers.getIdentifier('messages', config)), className: "mt-16" },
        react_1.default.createElement("h2", { className: "2xl:w-7/12 text-3xl font-light mb-4 px-8" }, constants_1.MESSAGES_TEXT),
        react_1.default.createElement("ul", null, Object.entries(messages).map(function (_a, idx) {
            var messageName = _a[0], message = _a[1];
            return (react_1.default.createElement("li", { className: "mb-4", key: messageName, id: helpers_1.CommonHelpers.getIdentifier("message-".concat(messageName), config) },
                react_1.default.createElement(Message_1.Message, { messageName: messageName, message: message, index: idx + 1, key: messageName })));
        }))));
};
exports.Messages = Messages;
//# sourceMappingURL=Messages.js.map