Notebook[{Cell[
CellGroupData[{Cell[
BoxData[StyleBox[RowBox[{StyleBox[RowBox[{"(*"," ",RowBox[
{RowBox[{"List"," ","of"," ","fast"," ","Lagarias"}],"-","Miller","-",RowBox[{"Odlyzko"," ","alpha"," ","factors"," ","found"," ","by"," ","running"," ","pi",RowBox[
{"(","x",")"}]," ",RowBox[{"benchmarks","."}]}]}]," ","*)"}],FontColor -> GrayLevel[
0.5]],"\[IndentingNewLine]","\[IndentingNewLine]",RowBox[{"alphaLMO"," ","="," ",RowBox[
{"{",StyleBox[RowBox[{"(*"," ",RowBox[{"{",RowBox[{"x",","," ","alpha"}],"}"}]," ","*)"}],
FontColor -> GrayLevel[0.5]]," ",RowBox[{RowBox[{"{",RowBox[{"1",","," ","1"}],"}"}],","," ",RowBox[
{"{",RowBox[{RowBox[{"10","^","10"}],","," ","1.410"}],"}"}],","," ",RowBox[{"{",RowBox[
{RowBox[{"10","^","11"}],","," ","1.499"}],"}"}],","," "," ",RowBox[{"{",RowBox[{RowBox[
{"10","^","12"}],",","1.597"}],"}"}],",",RowBox[{"{",RowBox[{RowBox[{"10","^","13"}],","," ","1.681"}],"}"}],",",RowBox[
{"{",RowBox[{RowBox[{"10","^","14"}],","," ","1.856"}],"}"}],",",RowBox[{"{",RowBox[
{RowBox[{"10","^","15"}],",","2.027"}],"}"}],",",RowBox[{"{",RowBox[{RowBox[{"10","^","16"}],","," ","2.152"}],"}"}],",",RowBox[
{"{",RowBox[{RowBox[{"10","^","17"}],","," ","2.329"}],"}"}],",",RowBox[{"{",RowBox[
{RowBox[{"10","^","18"}],","," ","2.556"}],"}"}]}],"}"}]}]}]]],"Input",ExpressionUUID -> "98e07a75-ba0c-4e32-ac60-ce3dcb649c89",
CellChangeTimes -> {{3634213444.9403696`,3634213445.624035`},{3634215431.555122`,3634215513.2840934`},{3634215600.175366`,3634215619.788096`},3634215656.990878`,3634215720.8094654`,{3634215766.7969522`,3634215767.1650066`},{3634215844.568947`,3634215848.768384`},{3634215892.499003`,3634215899.1052933`},{3634215948.6720448`,3634215967.4688087`},{3634216242.103594`,3634216251.921739`},3634217349.492552`,{3634314695.950554`,3634314708.6478233`},3634322609.691835`,{3634323167.2555017`,3634323170.063471`},3634323273.8673983`,{3634323441.217924`,3634323444.9257107`},{3634404012.629353`,3634404027.9052`},{3634405024.424403`,3634405024.582734`},{3634581315.4704723`,3634581326.85883`},{3652340017.483922`,3652340090.0428767`},{3652340122.6925707`,3652340163.1045513`},{3652340205.1790833`,3652340257.8472652`},{3652340388.683112`,3652340400.128792`},3652340486.932126`,{3652343296.0802717`,3652343320.5731187`},{3652343353.095994`,3652343375.283201`},{3652358670.776546`,3652358671.261818`},{3652359327.963564`,3652359357.5432653`},{3652799391.654447`,3652799407.7294073`},{3652799459.199575`,3652799460.1652946`},{3652894051.835206`,3652894053.576467`}}],Cell[
BoxData[
RowBox[{"{",RowBox[{RowBox[{"{",RowBox[{"1",",","1"}],"}"}],",",RowBox[{"{",RowBox[
{"10000000000",",","1.41`"}],"}"}],",",RowBox[{"{",RowBox[{"100000000000",",","1.499`"}],"}"}],",",RowBox[
{"{",RowBox[{"1000000000000",",","1.597`"}],"}"}],",",RowBox[{"{",RowBox[{"10000000000000",",","1.681`"}],"}"}],",",RowBox[
{"{",RowBox[{"100000000000000",",","1.856`"}],"}"}],",",RowBox[{"{",RowBox[{"1000000000000000",",","2.027`"}],"}"}],",",RowBox[
{"{",RowBox[{"10000000000000000",",","2.152`"}],"}"}],",",RowBox[{"{",RowBox[{"100000000000000000",",","2.329`"}],"}"}],",",RowBox[
{"{",RowBox[{"1000000000000000000",",","2.556`"}],"}"}]}],"}"}],StandardForm],"Output",
ExpressionUUID -> "20e5e83c-d3ed-4840-a249-7e601d10f9fd",CellLabel -> "Out[17]= "]},
Open],ExpressionUUID -> "e63575d3-0890-43ae-bbe5-d6b07c74c92c"],Cell[
CellGroupData[
{Cell[
BoxData[RowBox[{"ListLogLinearPlot","[",RowBox[{"alphaLMO",",",RowBox[{"Filling","\[Rule]","Bottom"}],","," ",RowBox[
{"Joined","\[Rule]"," ","True"}]}],"]"}]],"Input",CellChangeTimes -> {{3.6343148187325907`*^9,3.6343148346924543`*^9},3.634323448934331*^9,3.634403977189968*^9},
ExpressionUUID -> "381aa3c9-7179-4b58-b173-8ed7facd4779",CellLabel -> "In[18]:= "],Cell[
BoxData[
GraphicsBox[{{},GraphicsComplexBox[CompressedData["1:eJxTTMoPSmViYGAQA2IQjQo+2EevWqQ1j83cof/QV42Y/m/2/0Ikk0RCLB2mOXfnPP/93X7B//6ZXQutHaJSrO/79/60d17FdpHhva2Dj3mnY8LTX/bFq+xarOUcHCRZwvh0N/21P/L/5/xvLo4O894vP+ZtzuAgFrp198ZsJyif0SF9VcH1nEnODvlCzQdOLWRy2PFf+7P6TheHZbOPKGwoYnFAdyFMHsPpg9T9AL5qjfc="],
{{{},{EdgeForm[],Directive[RGBColor[0.368417,0.506779,0.709798],Opacity[0.2]],GraphicsGroupBox[
{PolygonBox[CompressedData["1:eJxTTMoPSmNkYGAoZgESPpnFJWk8yDxPkJyhJxOIhFJGEMoALGUJJi3ApDmYNAOTpmDSBEwag0kjADmBDMI="]]}]},{},{}},{{},{},{Hue[
0.67,0.6,0.6],Directive[PointSize[0.012833333333333334],RGBColor[0.368417,0.506779,
0.709798],AbsoluteThickness[1.6]],LineBox[CompressedData["1:eJxTTMoPSuNiYGAoZgESPpnFJZ6MQIYhmDQCk8Zg0gRMmoJJMzBpDiYtwKSlJxNIlwEApm8I6w=="]]}},{{Directive[
PointSize[0.012833333333333334],RGBColor[0.368417,0.506779,0.709798],AbsoluteThickness[
1.6]]}},{{Directive[PointSize[0.012833333333333334],RGBColor[0.368417,0.506779,0.709798],
AbsoluteThickness[1.6]]},{}},{{Directive[PointSize[0.012833333333333334],RGBColor[
0.368417,0.506779,0.709798],AbsoluteThickness[1.6]]},{}}}],{{},{}}},DisplayFunction -> Identity,
GridLines -> {None,None},DisplayFunction -> Identity,DisplayFunction -> Identity,
DisplayFunction -> Identity,DisplayFunction -> Identity,AspectRatio -> NCache[Power[
GoldenRatio,-1],0.6180339887498948],Axes -> {True,True},AxesLabel -> {None,None},
AxesOrigin -> {-1.7449277657845506,0},RuleDelayed[DisplayFunction,Identity],Frame -> {{False,False},{False,False}},
FrameLabel -> {{None,None},{None,None}},FrameTicks -> {{Automatic,Automatic},{Charting`ScaledTicks[
{Log,Exp}],Charting`ScaledFrameTicks[{Log,Exp}]}},GridLines -> {None,None},GridLinesStyle -> Directive[
GrayLevel[0.5,0.4]],Method -> CompressedData["1:eJzlUEEKwjAQrNWDNw+Cd99SFQTF0hbv0W5hMWZDsgHr600qRCrVg1cvw+xkZjbs8kRFkyZJYicedmj5NRVOQjn35KAZr3iHXBLvhbmAsZ2hMg7e7AtPMiJToxIMtiKSIU3Kft0y82SFVkvRbpw6h0AzCo6ph6j0G8L7gKlTxh7WN/0cQqL0X8cuEUtyYXjAgLH3U3lQtjUoRm5/2pD2XPHMGWmE+iikgz85wgPGMIEC"],
PlotRange -> {{-1.7449277657845506,41.44653167389282},{0,2.556}},PlotRangeClipping -> True,
PlotRangePadding -> {{Scaled[0.02],Scaled[0.02]},{Scaled[0.02],Scaled[0.05]}},Ticks -> {Charting`ScaledTicks[
{Log,Exp}],Automatic},ExpressionUUID -> "64ecbbf5-3cfc-440b-9399-8cfc9a53340c"],StandardForm],
"Output",ExpressionUUID -> "838637a4-6965-45bc-a6ba-fbbeac4cccc3",CellLabel -> "Out[18]= "]},
Open],ExpressionUUID -> "fc5b7cf8-5f11-4393-a6e7-c90c3aa4247b"],Cell[
BoxData[RowBox[
{"\[IndentingNewLine]",StyleBox[RowBox[{"(*"," ",RowBox[{"alpha"," ","is"," ","a"," ","tuning"," ","factor"," ","that"," ","balances"," ","the"," ","compuation"," ","of"," ","the"," ","easy"," ","special"," ","leaves"," ","and"," ","the"," ","hard"," ","special"," ",RowBox[
{"leaves","."," ","The"}]," ","formula"," ","below"," ","is"," ","used"," ","in"," ","the"," ","file"," ",RowBox[
{"src","/",RowBox[{"common",".","cpp"}]}]," ","to"," ","calculate"," ","a"," ","fast"," ","alpha"," ","factor"," ","for"," ","the"," ","computation"," ","of"," ","pi",RowBox[
{RowBox[{"(","x",")"}],"."}]}]," ","*)"}],FontColor -> GrayLevel[0.5]]}]],"Input",
ExpressionUUID -> "395d2b11-0885-4260-8798-56cd1cf28627",CellChangeTimes -> {{3652359107.254675`,3652359108.209537`},{3652893880.0309653`,3652893884.6280956`},3652894058.9063597`}],Cell[
CellGroupData[
{Cell[
BoxData[RowBox[{"NonlinearModelFit","[",RowBox[{"alphaLMO",","," ",RowBox[
{RowBox[{"a",RowBox[{RowBox[{"(",RowBox[{"Log","[","x","]"}],")"}],"^","2"}]}]," ","+"," ",RowBox[
{"b","  ",RowBox[{"Log","[","x","]"}]}]," ","+"," ","c"}],","," ",RowBox[{"{",RowBox[
{"a",",","b",","," ","c"}],"}"}],","," ","x"}],"]"}]],"Input",CellChangeTimes -> {{3.634216277450708*^9,3.63421631260785*^9},{3.634216345523642*^9,3.634216356164029*^9},{3.6343148016652737`*^9,3.6343148100460567`*^9},3.634322645710272*^9,{3.634323063590989*^9,3.634323065777611*^9},3.634323459263245*^9,{3.634323494476931*^9,3.634323495748851*^9}},
ExpressionUUID -> "4ac9bd14-2037-4ad0-a96d-768fc4d12dd4",CellLabel -> "In[19]:= "],Cell[
BoxData[
TagBox[RowBox[{"FittedModel","[",TagBox[PanelBox[TagBox[RowBox[{RowBox[{"1.0040359757103035`","\[VeryThinSpace]"}],"-",RowBox[
{"0.008962111240803877`"," ",RowBox[{"Log","[","x","]"}]}],"+",RowBox[{"0.0011030040203473623`"," ",SuperscriptBox[
RowBox[{"Log","[","x","]"}],"2"]}]}],Function[Short[Slot[1],2]]],FrameMargins -> 5],
Editable -> False],"]"}],InterpretTemplate[Function[FittedModel[{"Nonlinear",{a -> 0.0011030040203473623,b -> -0.008962111240803877,c -> 1.0040359757103035},{{x},Plus[
c,Times[b,Log[x]],Times[a,Power[Log[x],2]]]}},{1},{{1,1},{10000000000,1.41},{100000000000,1.499},{1000000000000,1.597},{10000000000000,1.681},{100000000000000,1.856},{1000000000000000,2.027},{10000000000000000,2.152},{100000000000000000,2.329},{1000000000000000000,2.556}},
Function[Null,Internal`LocalizedBlock[{a,b,c,x},Slot[1]],{HoldAll}]]]],Editable -> False,
Selectable -> True,SelectWithContents -> True],StandardForm],"Output",ExpressionUUID -> "ecfae3a4-4b49-4eb8-ae4f-f70f35d38fa8",
CellLabel -> "Out[19]= "]},Open],ExpressionUUID -> "a04b1dbf-200e-4d24-ad03-91431e2d7694"]},
WindowSize -> {1216,756},WindowMargins -> {{0,Automatic},{Automatic,0}},PrintingCopies -> 1,
PrintingPageRange -> {1,Automatic},StyleDefinitions -> "Default.nb",FrontEndVersion -> "12. for Wolfram Cloud 1.54.0.1 (January 17, 2020)"]