/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	context "context"
	json "encoding/json"
	fmt "fmt"

	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	gentype "k8s.io/client-go/gentype"
	testing "k8s.io/client-go/testing"
	v1 "k8s.io/code-generator/examples/crd/apis/extensions/v1"
	extensionsv1 "k8s.io/code-generator/examples/crd/applyconfiguration/extensions/v1"
	typedextensionsv1 "k8s.io/code-generator/examples/crd/clientset/versioned/typed/extensions/v1"
)

// fakeTestTypes implements TestTypeInterface
type fakeTestTypes struct {
	*gentype.FakeClientWithListAndApply[*v1.TestType, *v1.TestTypeList, *extensionsv1.TestTypeApplyConfiguration]
	Fake *FakeExtensionsExampleV1
}

func newFakeTestTypes(fake *FakeExtensionsExampleV1, namespace string) typedextensionsv1.TestTypeInterface {
	return &fakeTestTypes{
		gentype.NewFakeClientWithListAndApply[*v1.TestType, *v1.TestTypeList, *extensionsv1.TestTypeApplyConfiguration](
			fake.Fake,
			namespace,
			v1.SchemeGroupVersion.WithResource("testtypes"),
			v1.SchemeGroupVersion.WithKind("TestType"),
			func() *v1.TestType { return &v1.TestType{} },
			func() *v1.TestTypeList { return &v1.TestTypeList{} },
			func(dst, src *v1.TestTypeList) { dst.ListMeta = src.ListMeta },
			func(list *v1.TestTypeList) []*v1.TestType { return gentype.ToPointerSlice(list.Items) },
			func(list *v1.TestTypeList, items []*v1.TestType) { list.Items = gentype.FromPointerSlice(items) },
		),
		fake,
	}
}

// GetExtended takes name of the testType, and returns the corresponding testType object, and an error if there is any.
func (c *fakeTestTypes) GetExtended(ctx context.Context, name string, options metav1.GetOptions) (result *v1.TestType, err error) {
	emptyResult := &v1.TestType{}
	obj, err := c.Fake.
		Invokes(testing.NewGetActionWithOptions(c.Resource(), c.Namespace(), name, options), emptyResult)

	if obj == nil {
		return emptyResult, err
	}
	return obj.(*v1.TestType), err
}

// ListExtended takes label and field selectors, and returns the list of TestTypes that match those selectors.
func (c *fakeTestTypes) ListExtended(ctx context.Context, opts metav1.ListOptions) (result *v1.TestTypeList, err error) {
	emptyResult := &v1.TestTypeList{}
	obj, err := c.Fake.
		Invokes(testing.NewListActionWithOptions(c.Resource(), c.Kind(), c.Namespace(), opts), emptyResult)

	if obj == nil {
		return emptyResult, err
	}
	return obj.(*v1.TestTypeList), err
}

// CreateExtended takes the representation of a testType and creates it.  Returns the server's representation of the testType, and an error, if there is any.
func (c *fakeTestTypes) CreateExtended(ctx context.Context, testType *v1.TestType, opts metav1.CreateOptions) (result *v1.TestType, err error) {
	emptyResult := &v1.TestType{}
	obj, err := c.Fake.
		Invokes(testing.NewCreateActionWithOptions(c.Resource(), c.Namespace(), testType, opts), emptyResult)

	if obj == nil {
		return emptyResult, err
	}
	return obj.(*v1.TestType), err
}

// UpdateExtended takes the representation of a testType and updates it. Returns the server's representation of the testType, and an error, if there is any.
func (c *fakeTestTypes) UpdateExtended(ctx context.Context, testType *v1.TestType, opts metav1.UpdateOptions) (result *v1.TestType, err error) {
	emptyResult := &v1.TestType{}
	obj, err := c.Fake.
		Invokes(testing.NewUpdateActionWithOptions(c.Resource(), c.Namespace(), testType, opts), emptyResult)

	if obj == nil {
		return emptyResult, err
	}
	return obj.(*v1.TestType), err
}

// PatchExtended applies the patch and returns the patched testType.
func (c *fakeTestTypes) PatchExtended(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.TestType, err error) {
	emptyResult := &v1.TestType{}
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceActionWithOptions(c.Resource(), c.Namespace(), name, pt, data, opts, subresources...), emptyResult)

	if obj == nil {
		return emptyResult, err
	}
	return obj.(*v1.TestType), err
}

// ApplyExtended takes the given apply declarative configuration, applies it and returns the applied testType.
func (c *fakeTestTypes) ApplyExtended(ctx context.Context, testType *extensionsv1.TestTypeApplyConfiguration, opts metav1.ApplyOptions) (result *v1.TestType, err error) {
	if testType == nil {
		return nil, fmt.Errorf("testType provided to ApplyExtended must not be nil")
	}
	data, err := json.Marshal(testType)
	if err != nil {
		return nil, err
	}
	name := testType.Name
	if name == nil {
		return nil, fmt.Errorf("testType.Name must be provided to ApplyExtended")
	}
	emptyResult := &v1.TestType{}
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceActionWithOptions(c.Resource(), c.Namespace(), *name, types.ApplyPatchType, data, opts.ToPatchOptions()), emptyResult)

	if obj == nil {
		return emptyResult, err
	}
	return obj.(*v1.TestType), err
}

// GetSubresource takes name of the testType, and returns the corresponding testSubresource object, and an error if there is any.
func (c *fakeTestTypes) GetSubresource(ctx context.Context, testTypeName string, options metav1.GetOptions) (result *v1.TestSubresource, err error) {
	emptyResult := &v1.TestSubresource{}
	obj, err := c.Fake.
		Invokes(testing.NewGetSubresourceActionWithOptions(c.Resource(), c.Namespace(), "testsubresource", testTypeName, options), emptyResult)

	if obj == nil {
		return emptyResult, err
	}
	return obj.(*v1.TestSubresource), err
}

// CreateSubresource takes the representation of a testSubresource and creates it.  Returns the server's representation of the testSubresource, and an error, if there is any.
func (c *fakeTestTypes) CreateSubresource(ctx context.Context, testTypeName string, testSubresource *v1.TestSubresource, opts metav1.CreateOptions) (result *v1.TestSubresource, err error) {
	emptyResult := &v1.TestSubresource{}
	obj, err := c.Fake.
		Invokes(testing.NewCreateSubresourceActionWithOptions(c.Resource(), testTypeName, "testsubresource", c.Namespace(), testSubresource, opts), emptyResult)

	if obj == nil {
		return emptyResult, err
	}
	return obj.(*v1.TestSubresource), err
}

// UpdateSubresource takes the representation of a testSubresource and updates it. Returns the server's representation of the testSubresource, and an error, if there is any.
func (c *fakeTestTypes) UpdateSubresource(ctx context.Context, testTypeName string, testSubresource *v1.TestSubresource, opts metav1.UpdateOptions) (result *v1.TestSubresource, err error) {
	emptyResult := &v1.TestSubresource{}
	obj, err := c.Fake.
		Invokes(testing.NewUpdateSubresourceActionWithOptions(c.Resource(), "subresource", c.Namespace(), testSubresource, opts), &v1.TestSubresource{})

	if obj == nil {
		return emptyResult, err
	}
	return obj.(*v1.TestSubresource), err
}

// ApplySubresource takes top resource name and the apply declarative configuration for subresource,
// applies it and returns the applied testSubresource, and an error, if there is any.
func (c *fakeTestTypes) ApplySubresource(ctx context.Context, testTypeName string, testSubresource *extensionsv1.TestSubresourceApplyConfiguration, opts metav1.ApplyOptions) (result *v1.TestSubresource, err error) {
	if testSubresource == nil {
		return nil, fmt.Errorf("testSubresource provided to ApplySubresource must not be nil")
	}
	data, err := json.Marshal(testSubresource)
	if err != nil {
		return nil, err
	}
	emptyResult := &v1.TestSubresource{}
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceActionWithOptions(c.Resource(), c.Namespace(), testTypeName, types.ApplyPatchType, data, opts.ToPatchOptions(), "testSubresource"), emptyResult)

	if obj == nil {
		return emptyResult, err
	}
	return obj.(*v1.TestSubresource), err
}
