/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.mock.runtime;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import org.spockframework.gentyref.GenericTypeReflector;
import org.spockframework.mock.IMockMethod;
import org.spockframework.util.ReflectionUtil;

public class StaticMockMethod
implements IMockMethod {
    private final Method method;
    private final Type mockType;

    public StaticMockMethod(Method method, Type mockType) {
        this.method = method;
        this.mockType = mockType;
    }

    @Override
    public String getName() {
        return this.method.getName();
    }

    @Override
    public List<Class<?>> getParameterTypes() {
        return ReflectionUtil.eraseTypes(this.getExactParameterTypes());
    }

    @Override
    public List<Type> getExactParameterTypes() {
        return Arrays.asList(GenericTypeReflector.getExactParameterTypes(this.method, this.mockType));
    }

    @Override
    public Class<?> getReturnType() {
        return GenericTypeReflector.erase(this.getExactReturnType());
    }

    @Override
    public Type getExactReturnType() {
        return GenericTypeReflector.getExactReturnType(this.method, this.mockType);
    }

    @Override
    public boolean isStatic() {
        return Modifier.isStatic(this.method.getModifiers());
    }
}

