/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime.extension.builtin;

import java.lang.reflect.Method;
import org.spockframework.runtime.InvalidSpecException;
import org.spockframework.runtime.extension.AbstractAnnotationDrivenExtension;
import org.spockframework.runtime.extension.builtin.FailsWithInterceptor;
import org.spockframework.runtime.model.FeatureInfo;
import org.spockframework.runtime.model.MethodInfo;
import org.spockframework.runtime.model.SpecInfo;
import spock.lang.FailsWith;

public class FailsWithExtension
extends AbstractAnnotationDrivenExtension<FailsWith> {
    @Override
    public void visitSpecAnnotation(FailsWith failsWith, SpecInfo spec) {
        this.checkRefersToException(failsWith);
        for (FeatureInfo feature : spec.getFeatures()) {
            if (((Method)feature.getFeatureMethod().getReflection()).isAnnotationPresent(FailsWith.class)) continue;
            feature.getFeatureMethod().addInterceptor(new FailsWithInterceptor(failsWith));
        }
    }

    @Override
    public void visitFeatureAnnotation(FailsWith failsWith, FeatureInfo feature) {
        this.checkRefersToException(failsWith);
        feature.getFeatureMethod().addInterceptor(new FailsWithInterceptor(failsWith));
    }

    @Override
    public void visitFixtureAnnotation(FailsWith failsWith, MethodInfo fixtureMethod) {
        this.checkRefersToException(failsWith);
        fixtureMethod.addInterceptor(new FailsWithInterceptor(failsWith));
    }

    private void checkRefersToException(FailsWith failsWith) {
        if (Throwable.class.isAssignableFrom(failsWith.value())) {
            return;
        }
        throw new InvalidSpecException("@FailsWith needs to refer to an exception type, but does refer to '%s'").withArgs(failsWith.value().getName());
    }
}

