/*
 * Decompiled with CFR 0.152.
 */
package spock.util.concurrent;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.spockframework.runtime.SpockTimeoutError;
import org.spockframework.util.TimeUtil;

public class BlockingVariable<T> {
    private final double timeout;
    private T value;
    private final CountDownLatch valueReady = new CountDownLatch(1);

    public BlockingVariable() {
        this(1.0);
    }

    public BlockingVariable(double timeout) {
        this.timeout = timeout;
    }

    @Deprecated
    public BlockingVariable(int timeout, TimeUnit unit) {
        this(TimeUtil.toSeconds(timeout, unit));
    }

    public double getTimeout() {
        return this.timeout;
    }

    public T get() throws InterruptedException {
        if (!this.valueReady.await((long)(this.timeout * 1000.0), TimeUnit.MILLISECONDS)) {
            String msg = String.format("BlockingVariable.get() timed out after %1.2f seconds", this.timeout);
            throw new SpockTimeoutError(this.timeout, msg);
        }
        return this.value;
    }

    public void set(T value) {
        this.value = value;
        this.valueReady.countDown();
    }
}

