/*
 * Decompiled with CFR 0.152.
 */
package spock.util.environment;

import org.spockframework.util.VersionNumber;

public class Jvm {
    private final String javaVersion = System.getProperty("java.version");
    private final String javaSpecVersion = System.getProperty("java.specification.version");
    private final VersionNumber javaSpecVersionNumber = VersionNumber.parse(this.javaSpecVersion);

    private Jvm() {
    }

    public String getJavaVersion() {
        return this.javaVersion;
    }

    public String getJavaSpecificationVersion() {
        return this.javaSpecVersion;
    }

    public boolean isJava5() {
        return this.javaSpecVersion.equals("1.5");
    }

    public boolean isJava6() {
        return this.javaSpecVersion.equals("1.6");
    }

    public boolean isJava7() {
        return this.javaSpecVersion.equals("1.7");
    }

    public boolean isJava8() {
        return this.javaSpecVersion.equals("1.8");
    }

    public boolean isJava9() {
        return this.javaSpecVersion.equals("1.9");
    }

    public boolean isJava5Compatible() {
        return this.javaSpecVersionNumber.getMajor() > 1 || this.javaSpecVersionNumber.getMinor() >= 5;
    }

    public boolean isJava6Compatible() {
        return this.javaSpecVersionNumber.getMajor() > 1 || this.javaSpecVersionNumber.getMinor() >= 6;
    }

    public boolean isJava7Compatible() {
        return this.javaSpecVersionNumber.getMajor() > 1 || this.javaSpecVersionNumber.getMinor() >= 7;
    }

    public boolean isJava8Compatible() {
        return this.javaSpecVersionNumber.getMajor() > 1 || this.javaSpecVersionNumber.getMinor() >= 8;
    }

    public boolean isJava9Compatible() {
        return this.javaSpecVersionNumber.getMajor() > 1 || this.javaSpecVersionNumber.getMinor() >= 9;
    }

    public static Jvm getCurrent() {
        return new Jvm();
    }
}

