/*
 * include/protocol.h
 *
 */
 
#ifndef __PROTOCOL_H__
#define __PROTOCOL_H__

#include <sys/time.h>

/* command codes */
#define	CM_PING		0x01	/* server calls to find clients			 */
#define	CM_PONG		0x02	/* clients answer						 */
#define	CM_SEQ_INIT	0x03	/* server initiates transaction sequence */
#define	CM_READY	0x04	/* clients are ready to receive			 */
#define	CM_TX		0x05	/* server sends data packet				 */
#define	CM_RXOK		0x06	/* clients acknowledge received packet	 */
#define	CM_RXERR	0x07	/* receive error						 */
#define	CM_ERROR	0x08	/* general error						 */
#define	CM_EOT		0x09	/* server indicates end-of-transaction	 */
#define	CM_DONE		0x0A	/* clients acknowledge eot				 */
#define	CM_ACK_PLZ	0x0B	/* tell client to answer				 */

/* transaction flags */
#define	FL_ONLYONE	0x01	/* only one client to answer			 */

/* receive error codes */
#define	RX_CRC		0x01	/* CRC error							 */
#define	RX_SEQ		0x02	/* Sequence error						 */
#define	RX_DATA		0x03	/* General data error					 */

/* general error codes */
#define	ER_UABORT	0x01	/* User abort							 */
#define	ER_ERRNO	0x02	/* Internal, see delivered errno		 */
#define	ER_TIMEOUT	0x03	/* Last packet couldn't be sent			 */

struct cm_ping {			/* ping command							 */
	unsigned char	cmd;
	struct timeval	tv;		/* timestamp */
};
#define	S_PING		sizeof(struct cm_ping)

struct cm_pong {			/* ping echo							 */
	unsigned char	cmd;
	struct timeval	tv;
};
#define	S_PONG		sizeof(struct cm_pong)

struct cm_seq_init {		/* init transaction sequence			 */
	unsigned char	cmd;
	unsigned long	flags;
};
#define	S_SEQ_INIT	sizeof(struct cm_seq_init)

struct cm_ack_plz {			/* tell client to acknowledge			 */
	unsigned char	cmd;
};
#define	S_ACK_PLZ	sizeof(struct cm_ack_plz)

struct cm_ready {			/* station is ready */
	unsigned char	cmd;	
};
#define	S_READY		sizeof(struct cm_ready)

struct cm_tx {				/* transmit */
	unsigned char	cmd;
	unsigned long	seqnum,
					len;
};
#define	S_TX		sizeof(struct cm_tx)

struct cm_rxok {			/* packet received ok */
	unsigned char	cmd;	
};
#define	S_RXOK		sizeof(struct cm_rxok)

struct cm_rxerr {			/* receive error */
	unsigned char	cmd;	
	unsigned long	error;
};
#define	S_RXERR		sizeof(struct cm_rxerr)

struct cm_error {			/* general error */
	unsigned char	cmd;	
	unsigned long	error;
	int				er_no;
};
#define	S_ERROR		sizeof(struct cm_error)

struct cm_eot {				/* end of transmission */
	unsigned char	cmd;
};
#define	S_EOT		sizeof(struct cm_eot)

struct cm_done {
	unsigned char	cmd;
};
#define	S_DONE		sizeof(struct cm_done)

union packet {
	unsigned char		cmd;
	struct cm_ping		ping;
	struct cm_pong		pong;
	struct cm_seq_init	seq_init;
	struct cm_ack_plz	ack_plz;
	struct cm_ready		ready;
	struct cm_tx		tx;
	struct cm_rxok		rxok;
	struct cm_rxerr		rxerr;
	struct cm_error		error;
	struct cm_eot		eot;
	struct cm_done		done;
};
#define	S_PACKET	sizeof(union packet)

#endif
