/*
 * include/utime.h
 */
 
#ifndef __INCLUDE_UTIME_H__
#define __INCLUDE_UTIME_H__

struct timeval utimer;

int tvdiff(struct timeval tv1, struct timeval tv2) {
	int d;
	
	d=tv2.tv_sec-tv1.tv_sec;
	if(tv2.tv_usec-tv1.tv_usec<0) d--;
	
	return d;
}

long udiff(struct timeval tv1, struct timeval tv2) {
	return (tv2.tv_sec-tv1.tv_sec)*1000+(tv2.tv_usec-tv1.tv_usec)/1000;
}

void start_timer(void) {
	gettimeofday(&utimer,NULL);
}

int timer_sec(void) {
	struct timeval tv;
	
	gettimeofday(&tv,NULL);
	return tvdiff(utimer,tv);
}

#endif
