package das

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetAsyncErrorRequestStatResult invokes the das.GetAsyncErrorRequestStatResult API synchronously
func (client *Client) GetAsyncErrorRequestStatResult(request *GetAsyncErrorRequestStatResultRequest) (response *GetAsyncErrorRequestStatResultResponse, err error) {
	response = CreateGetAsyncErrorRequestStatResultResponse()
	err = client.DoAction(request, response)
	return
}

// GetAsyncErrorRequestStatResultWithChan invokes the das.GetAsyncErrorRequestStatResult API asynchronously
func (client *Client) GetAsyncErrorRequestStatResultWithChan(request *GetAsyncErrorRequestStatResultRequest) (<-chan *GetAsyncErrorRequestStatResultResponse, <-chan error) {
	responseChan := make(chan *GetAsyncErrorRequestStatResultResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetAsyncErrorRequestStatResult(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetAsyncErrorRequestStatResultWithCallback invokes the das.GetAsyncErrorRequestStatResult API asynchronously
func (client *Client) GetAsyncErrorRequestStatResultWithCallback(request *GetAsyncErrorRequestStatResultRequest, callback func(response *GetAsyncErrorRequestStatResultResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetAsyncErrorRequestStatResultResponse
		var err error
		defer close(result)
		response, err = client.GetAsyncErrorRequestStatResult(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetAsyncErrorRequestStatResultRequest is the request struct for api GetAsyncErrorRequestStatResult
type GetAsyncErrorRequestStatResultRequest struct {
	*requests.RpcRequest
	SqlIdList  string           `position:"Query" name:"SqlIdList"`
	Start      requests.Integer `position:"Query" name:"Start"`
	InstanceId string           `position:"Query" name:"InstanceId"`
	DbName     string           `position:"Query" name:"DbName"`
	End        requests.Integer `position:"Query" name:"End"`
	NodeId     string           `position:"Query" name:"NodeId"`
}

// GetAsyncErrorRequestStatResultResponse is the response struct for api GetAsyncErrorRequestStatResult
type GetAsyncErrorRequestStatResultResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      string `json:"Data" xml:"Data"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   string `json:"Success" xml:"Success"`
}

// CreateGetAsyncErrorRequestStatResultRequest creates a request to invoke GetAsyncErrorRequestStatResult API
func CreateGetAsyncErrorRequestStatResultRequest() (request *GetAsyncErrorRequestStatResultRequest) {
	request = &GetAsyncErrorRequestStatResultRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("DAS", "2020-01-16", "GetAsyncErrorRequestStatResult", "", "")
	request.Method = requests.POST
	return
}

// CreateGetAsyncErrorRequestStatResultResponse creates a response to parse from GetAsyncErrorRequestStatResult response
func CreateGetAsyncErrorRequestStatResultResponse() (response *GetAsyncErrorRequestStatResultResponse) {
	response = &GetAsyncErrorRequestStatResultResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
