package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteView invokes the dataworks_public.DeleteView API synchronously
func (client *Client) DeleteView(request *DeleteViewRequest) (response *DeleteViewResponse, err error) {
	response = CreateDeleteViewResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteViewWithChan invokes the dataworks_public.DeleteView API asynchronously
func (client *Client) DeleteViewWithChan(request *DeleteViewRequest) (<-chan *DeleteViewResponse, <-chan error) {
	responseChan := make(chan *DeleteViewResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteView(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteViewWithCallback invokes the dataworks_public.DeleteView API asynchronously
func (client *Client) DeleteViewWithCallback(request *DeleteViewRequest, callback func(response *DeleteViewResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteViewResponse
		var err error
		defer close(result)
		response, err = client.DeleteView(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteViewRequest is the request struct for api DeleteView
type DeleteViewRequest struct {
	*requests.RpcRequest
	ViewName string `position:"Query" name:"ViewName"`
	AppGuid  string `position:"Query" name:"AppGuid"`
}

// DeleteViewResponse is the response struct for api DeleteView
type DeleteViewResponse struct {
	*responses.BaseResponse
	RequestId string   `json:"RequestId" xml:"RequestId"`
	TaskInfo  TaskInfo `json:"TaskInfo" xml:"TaskInfo"`
}

// CreateDeleteViewRequest creates a request to invoke DeleteView API
func CreateDeleteViewRequest() (request *DeleteViewRequest) {
	request = &DeleteViewRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "DeleteView", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteViewResponse creates a response to parse from DeleteView response
func CreateDeleteViewResponse() (response *DeleteViewResponse) {
	response = &DeleteViewResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
