package dm

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteReceiverDetail invokes the dm.DeleteReceiverDetail API synchronously
// api document: https://help.aliyun.com/api/dm/deletereceiverdetail.html
func (client *Client) DeleteReceiverDetail(request *DeleteReceiverDetailRequest) (response *DeleteReceiverDetailResponse, err error) {
	response = CreateDeleteReceiverDetailResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteReceiverDetailWithChan invokes the dm.DeleteReceiverDetail API asynchronously
// api document: https://help.aliyun.com/api/dm/deletereceiverdetail.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteReceiverDetailWithChan(request *DeleteReceiverDetailRequest) (<-chan *DeleteReceiverDetailResponse, <-chan error) {
	responseChan := make(chan *DeleteReceiverDetailResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteReceiverDetail(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteReceiverDetailWithCallback invokes the dm.DeleteReceiverDetail API asynchronously
// api document: https://help.aliyun.com/api/dm/deletereceiverdetail.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteReceiverDetailWithCallback(request *DeleteReceiverDetailRequest, callback func(response *DeleteReceiverDetailResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteReceiverDetailResponse
		var err error
		defer close(result)
		response, err = client.DeleteReceiverDetail(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteReceiverDetailRequest is the request struct for api DeleteReceiverDetail
type DeleteReceiverDetailRequest struct {
	*requests.RpcRequest
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ReceiverId           string           `position:"Query" name:"ReceiverId"`
	Email                string           `position:"Query" name:"Email"`
}

// DeleteReceiverDetailResponse is the response struct for api DeleteReceiverDetail
type DeleteReceiverDetailResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteReceiverDetailRequest creates a request to invoke DeleteReceiverDetail API
func CreateDeleteReceiverDetailRequest() (request *DeleteReceiverDetailRequest) {
	request = &DeleteReceiverDetailRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dm", "2015-11-23", "DeleteReceiverDetail", "", "")
	return
}

// CreateDeleteReceiverDetailResponse creates a response to parse from DeleteReceiverDetail response
func CreateDeleteReceiverDetailResponse() (response *DeleteReceiverDetailResponse) {
	response = &DeleteReceiverDetailResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
