package oos

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RegisterDefaultPatchBaseline invokes the oos.RegisterDefaultPatchBaseline API synchronously
func (client *Client) RegisterDefaultPatchBaseline(request *RegisterDefaultPatchBaselineRequest) (response *RegisterDefaultPatchBaselineResponse, err error) {
	response = CreateRegisterDefaultPatchBaselineResponse()
	err = client.DoAction(request, response)
	return
}

// RegisterDefaultPatchBaselineWithChan invokes the oos.RegisterDefaultPatchBaseline API asynchronously
func (client *Client) RegisterDefaultPatchBaselineWithChan(request *RegisterDefaultPatchBaselineRequest) (<-chan *RegisterDefaultPatchBaselineResponse, <-chan error) {
	responseChan := make(chan *RegisterDefaultPatchBaselineResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RegisterDefaultPatchBaseline(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RegisterDefaultPatchBaselineWithCallback invokes the oos.RegisterDefaultPatchBaseline API asynchronously
func (client *Client) RegisterDefaultPatchBaselineWithCallback(request *RegisterDefaultPatchBaselineRequest, callback func(response *RegisterDefaultPatchBaselineResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RegisterDefaultPatchBaselineResponse
		var err error
		defer close(result)
		response, err = client.RegisterDefaultPatchBaseline(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RegisterDefaultPatchBaselineRequest is the request struct for api RegisterDefaultPatchBaseline
type RegisterDefaultPatchBaselineRequest struct {
	*requests.RpcRequest
	Name string `position:"Query" name:"Name"`
}

// RegisterDefaultPatchBaselineResponse is the response struct for api RegisterDefaultPatchBaseline
type RegisterDefaultPatchBaselineResponse struct {
	*responses.BaseResponse
	RequestId     string        `json:"RequestId" xml:"RequestId"`
	PatchBaseline PatchBaseline `json:"PatchBaseline" xml:"PatchBaseline"`
}

// CreateRegisterDefaultPatchBaselineRequest creates a request to invoke RegisterDefaultPatchBaseline API
func CreateRegisterDefaultPatchBaselineRequest() (request *RegisterDefaultPatchBaselineRequest) {
	request = &RegisterDefaultPatchBaselineRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("oos", "2019-06-01", "RegisterDefaultPatchBaseline", "", "")
	request.Method = requests.POST
	return
}

// CreateRegisterDefaultPatchBaselineResponse creates a response to parse from RegisterDefaultPatchBaseline response
func CreateRegisterDefaultPatchBaselineResponse() (response *RegisterDefaultPatchBaselineResponse) {
	response = &RegisterDefaultPatchBaselineResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
