package rtc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateAutoLiveStreamRule invokes the rtc.UpdateAutoLiveStreamRule API synchronously
func (client *Client) UpdateAutoLiveStreamRule(request *UpdateAutoLiveStreamRuleRequest) (response *UpdateAutoLiveStreamRuleResponse, err error) {
	response = CreateUpdateAutoLiveStreamRuleResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateAutoLiveStreamRuleWithChan invokes the rtc.UpdateAutoLiveStreamRule API asynchronously
func (client *Client) UpdateAutoLiveStreamRuleWithChan(request *UpdateAutoLiveStreamRuleRequest) (<-chan *UpdateAutoLiveStreamRuleResponse, <-chan error) {
	responseChan := make(chan *UpdateAutoLiveStreamRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateAutoLiveStreamRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateAutoLiveStreamRuleWithCallback invokes the rtc.UpdateAutoLiveStreamRule API asynchronously
func (client *Client) UpdateAutoLiveStreamRuleWithCallback(request *UpdateAutoLiveStreamRuleRequest, callback func(response *UpdateAutoLiveStreamRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateAutoLiveStreamRuleResponse
		var err error
		defer close(result)
		response, err = client.UpdateAutoLiveStreamRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateAutoLiveStreamRuleRequest is the request struct for api UpdateAutoLiveStreamRule
type UpdateAutoLiveStreamRuleRequest struct {
	*requests.RpcRequest
	RuleName          string           `position:"Query" name:"RuleName"`
	ChannelIdPrefixes *[]string        `position:"Query" name:"ChannelIdPrefixes"  type:"Repeated"`
	ShowLog           string           `position:"Query" name:"ShowLog"`
	PlayDomain        string           `position:"Query" name:"PlayDomain"`
	OwnerId           requests.Integer `position:"Query" name:"OwnerId"`
	AppId             string           `position:"Query" name:"AppId"`
	CallBack          string           `position:"Query" name:"CallBack"`
	MediaEncode       requests.Integer `position:"Query" name:"MediaEncode"`
	RuleId            requests.Integer `position:"Query" name:"RuleId"`
	ChannelIds        *[]string        `position:"Query" name:"ChannelIds"  type:"Repeated"`
}

// UpdateAutoLiveStreamRuleResponse is the response struct for api UpdateAutoLiveStreamRule
type UpdateAutoLiveStreamRuleResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateAutoLiveStreamRuleRequest creates a request to invoke UpdateAutoLiveStreamRule API
func CreateUpdateAutoLiveStreamRuleRequest() (request *UpdateAutoLiveStreamRuleRequest) {
	request = &UpdateAutoLiveStreamRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("rtc", "2018-01-11", "UpdateAutoLiveStreamRule", "", "")
	request.Method = requests.POST
	return
}

// CreateUpdateAutoLiveStreamRuleResponse creates a response to parse from UpdateAutoLiveStreamRule response
func CreateUpdateAutoLiveStreamRuleResponse() (response *UpdateAutoLiveStreamRuleResponse) {
	response = &UpdateAutoLiveStreamRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
