package servicemesh

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RemoveVmAppFromMesh invokes the servicemesh.RemoveVmAppFromMesh API synchronously
func (client *Client) RemoveVmAppFromMesh(request *RemoveVmAppFromMeshRequest) (response *RemoveVmAppFromMeshResponse, err error) {
	response = CreateRemoveVmAppFromMeshResponse()
	err = client.DoAction(request, response)
	return
}

// RemoveVmAppFromMeshWithChan invokes the servicemesh.RemoveVmAppFromMesh API asynchronously
func (client *Client) RemoveVmAppFromMeshWithChan(request *RemoveVmAppFromMeshRequest) (<-chan *RemoveVmAppFromMeshResponse, <-chan error) {
	responseChan := make(chan *RemoveVmAppFromMeshResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RemoveVmAppFromMesh(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RemoveVmAppFromMeshWithCallback invokes the servicemesh.RemoveVmAppFromMesh API asynchronously
func (client *Client) RemoveVmAppFromMeshWithCallback(request *RemoveVmAppFromMeshRequest, callback func(response *RemoveVmAppFromMeshResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RemoveVmAppFromMeshResponse
		var err error
		defer close(result)
		response, err = client.RemoveVmAppFromMesh(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RemoveVmAppFromMeshRequest is the request struct for api RemoveVmAppFromMesh
type RemoveVmAppFromMeshRequest struct {
	*requests.RpcRequest
	Namespace     string `position:"Query" name:"Namespace"`
	ServiceMeshId string `position:"Query" name:"ServiceMeshId"`
	ServiceName   string `position:"Query" name:"ServiceName"`
}

// RemoveVmAppFromMeshResponse is the response struct for api RemoveVmAppFromMesh
type RemoveVmAppFromMeshResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      string `json:"Data" xml:"Data"`
}

// CreateRemoveVmAppFromMeshRequest creates a request to invoke RemoveVmAppFromMesh API
func CreateRemoveVmAppFromMeshRequest() (request *RemoveVmAppFromMeshRequest) {
	request = &RemoveVmAppFromMeshRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("servicemesh", "2020-01-11", "RemoveVmAppFromMesh", "servicemesh", "openAPI")
	request.Method = requests.POST
	return
}

// CreateRemoveVmAppFromMeshResponse creates a response to parse from RemoveVmAppFromMesh response
func CreateRemoveVmAppFromMeshResponse() (response *RemoveVmAppFromMeshResponse) {
	response = &RemoveVmAppFromMeshResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
