/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.rules;

import java.util.List;
import net.sourceforge.pmd.AbstractRule;
import net.sourceforge.pmd.ast.ASTAdditiveExpression;
import net.sourceforge.pmd.ast.ASTLiteral;
import net.sourceforge.pmd.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.ast.SimpleNode;
import net.sourceforge.pmd.symboltable.NameOccurrence;

public abstract class AbstractPoorMethodCall
extends AbstractRule {
    protected abstract String targetTypename();

    protected abstract String[] methodNames();

    protected abstract boolean isViolationArgument(int var1, String var2);

    private boolean isNotedMethod(NameOccurrence occurrence) {
        if (occurrence == null) {
            return false;
        }
        String methodCall = occurrence.getImage();
        String[] methodNames = this.methodNames();
        for (int i = 0; i < methodNames.length; ++i) {
            if (methodCall.indexOf(methodNames[i]) == -1) continue;
            return true;
        }
        return false;
    }

    public static boolean isSingleCharAsString(String value) {
        return value.length() == 3 && value.charAt(0) == '\"';
    }

    public Object visit(ASTVariableDeclaratorId node, Object data) {
        if (!node.getNameDeclaration().getTypeImage().equals(this.targetTypename())) {
            return data;
        }
        for (NameOccurrence occ : node.getUsages()) {
            SimpleNode parent;
            if (!this.isNotedMethod(occ.getNameForWhichThisIsAQualifier()) || !((parent = (SimpleNode)occ.getLocation().jjtGetParent().jjtGetParent()) instanceof ASTPrimaryExpression)) continue;
            List<ASTAdditiveExpression> additives = parent.findChildrenOfType(ASTAdditiveExpression.class);
            if (!additives.isEmpty()) {
                return data;
            }
            List<ASTLiteral> literals = parent.findChildrenOfType(ASTLiteral.class);
            for (int l = 0; l < literals.size(); ++l) {
                ASTLiteral literal = literals.get(l);
                if (!this.isViolationArgument(l, literal.getImage())) continue;
                this.addViolation(data, occ.getLocation());
            }
        }
        return data;
    }
}

