.TH fbgrab 1 "(C) 2002 - 2020 Gunnar Monell, GPL"
.SH NAME
\fBfbgrab\fP - takes screenshots using the framebuffer device
.SH SYNOPSIS
.B fbgrab [options] filename
.SH DESCRIPTION
.B fbgrab
reads the \fBframebuffer device\fP (/dev/fb*) or a dump thereof and
saves a \fBPNG\fP image file. You can use it for making screenshots of
of virtually any application, from traditional test applications to your
X-windows desktop, as well as framebuffer applications.
.SH OPTIONS
.TP
.B -?
print usage information.
.TP
.B -a
ignore the alpha channel with drivers incorrectly setting but not 
supporting an alpha channel.
.TP
.B -b bitdepth
the number of bits per pixel used, optional when reading from device.
.TP
.B -c console
specifies which \fBconsole\fP (or virtual terminal - like other
people call this feature) to grab. Sometimes this changing is
faster then the framebuffer is refreshed (especially when grabbing
framebuffer apps). If so, you should \fBuse -C console\fP ... This
waits some time before grabbing. You can't use \fB-s\fP in this case.
.TP
.B -d device
specifies which framebuffer device you want to read. If
you do not use this option, it takes the value from the
\fBFRAMEBUFFER\fP environment variable. If no FRAMEBUFFER
environment variable is given or if its value is \fBNULL\fP, then
DEFAULT_FB is taken. (see source code), which usually is /dev/fb0.
.TP
.B -f filename
Read from from file instead of device, requires that -w (width), -h (height) and
-b (bitdepth) are specified.
.TP
.B -h height
the height of the framebuffer in pixels, optional when reading from device.
.TP
.B -i interlacing
turns \fBoff\fP interlacing. If you do not want \fBADAM7 interlacing\fP,
you should use the \fB-i\fP option.
.TP
.B -l line length, a.k.a. stride.
the length in pixels between the start of each row in the framebuffer, which might be larger or equal to width. Optional when reading from device.
.TP
.B -s seconds
specifies how many seconds to wait before grabbing. \fBfbshot\fP
does not lock console switching, so you can switch it while
waiting, if you cannot use -c requires normally that fbgrab is run as root.
.TP
.B -v verbose
be verbose
.TP
.B -w width
the width of the frambeuffer in pixels, optional when reading from device.
.TP
.B -z compression level
set png compression level 0 (fast) to 9 (best).

.SH TODO
* Low-end bit depths, eg 1, 2, 4 & 8 bits.
.TP
* Companion program fbput that would display a picture in the frambuffer.
.TP
* Better utilization of the PNG-lib, all formats are first converted to 32 bitdepth and then stored as PNG - hardly the right approach.

.SH EXAMPLES

.P
fbgrab fb.png
.P
will take a framebuffer snapshot, or if you don't have fbgrab at your machine, you can do
.P
cp /dev/fb0 framebuffer.dump
.P
and then
.P
fbgrab -w 1024 -h 768 -l 2048 -b 16 -f framebuffer.dump fb.png
.P
to convert it to a picture.

.SH AUTHOR
Written by Gunnar Monell <gunnar.monell@gmail.com>.
Basically a rewrite of fbshot by Stephan Beyer <fbshot@s-beyer.de>

.SH COPYRIGHT (C)
.P
(C) 2002-2020 Gunnar Monell <gunnar.monell@gmail.com>
.P
(C) 2000 Stephan Beyer <fbshot@s-beyer.de>
.P
This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License.
.P
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
.P
You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

