// Copyright 2021 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package alertcenter provides access to the Google Workspace Alert Center API.
//
// For product documentation, see: https://developers.google.com/admin-sdk/alertcenter/
//
// Creating a client
//
// Usage example:
//
//   import "google.golang.org/api/alertcenter/v1beta1"
//   ...
//   ctx := context.Background()
//   alertcenterService, err := alertcenter.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for authentication.
//
// For information on how to create and obtain Application Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// Other authentication options
//
// To use an API key for authentication (note: some APIs do not support API keys), use option.WithAPIKey:
//
//   alertcenterService, err := alertcenter.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth flow), use option.WithTokenSource:
//
//   config := &oauth2.Config{...}
//   // ...
//   token, err := config.Exchange(ctx, ...)
//   alertcenterService, err := alertcenter.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See https://godoc.org/google.golang.org/api/option/ for details on options.
package alertcenter // import "google.golang.org/api/alertcenter/v1beta1"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	googleapi "google.golang.org/api/googleapi"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint

const apiId = "alertcenter:v1beta1"
const apiName = "alertcenter"
const apiVersion = "v1beta1"
const basePath = "https://alertcenter.googleapis.com/"
const mtlsBasePath = "https://alertcenter.mtls.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// See and delete your domain's G Suite alerts, and send alert feedback
	AppsAlertsScope = "https://www.googleapis.com/auth/apps.alerts"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := option.WithScopes(
		"https://www.googleapis.com/auth/apps.alerts",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s, err := New(client)
	if err != nil {
		return nil, err
	}
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	s := &Service{client: client, BasePath: basePath}
	s.Alerts = NewAlertsService(s)
	s.V1beta1 = NewV1beta1Service(s)
	return s, nil
}

type Service struct {
	client    *http.Client
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Alerts *AlertsService

	V1beta1 *V1beta1Service
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewAlertsService(s *Service) *AlertsService {
	rs := &AlertsService{s: s}
	rs.Feedback = NewAlertsFeedbackService(s)
	return rs
}

type AlertsService struct {
	s *Service

	Feedback *AlertsFeedbackService
}

func NewAlertsFeedbackService(s *Service) *AlertsFeedbackService {
	rs := &AlertsFeedbackService{s: s}
	return rs
}

type AlertsFeedbackService struct {
	s *Service
}

func NewV1beta1Service(s *Service) *V1beta1Service {
	rs := &V1beta1Service{s: s}
	return rs
}

type V1beta1Service struct {
	s *Service
}

// AccountWarning: Alerts for user account warning events.
type AccountWarning struct {
	// Email: Required. The email of the user that this event belongs to.
	Email string `json:"email,omitempty"`

	// LoginDetails: Optional. Details of the login action associated with
	// the warning event. This is only available for: * Suspicious login *
	// Suspicious login (less secure app) * Suspicious programmatic login *
	// User suspended (suspicious activity)
	LoginDetails *LoginDetails `json:"loginDetails,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Email") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Email") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AccountWarning) MarshalJSON() ([]byte, error) {
	type NoMethod AccountWarning
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ActionInfo: Metadata related to the action.
type ActionInfo struct {
}

// ActivityRule: Alerts from Google Workspace Security Center rules
// service configured by an admin.
type ActivityRule struct {
	// ActionNames: List of action names associated with the rule threshold.
	ActionNames []string `json:"actionNames,omitempty"`

	// CreateTime: Rule create timestamp.
	CreateTime string `json:"createTime,omitempty"`

	// Description: Description of the rule.
	Description string `json:"description,omitempty"`

	// DisplayName: Alert display name.
	DisplayName string `json:"displayName,omitempty"`

	// Name: Rule name.
	Name string `json:"name,omitempty"`

	// Query: Query that is used to get the data from the associated source.
	Query string `json:"query,omitempty"`

	// SupersededAlerts: List of alert IDs superseded by this alert. It is
	// used to indicate that this alert is essentially extension of
	// superseded alerts and we found the relationship after creating these
	// alerts.
	SupersededAlerts []string `json:"supersededAlerts,omitempty"`

	// SupersedingAlert: Alert ID superseding this alert. It is used to
	// indicate that superseding alert is essentially extension of this
	// alert and we found the relationship after creating both alerts.
	SupersedingAlert string `json:"supersedingAlert,omitempty"`

	// Threshold: Alert threshold is for example “COUNT > 5”.
	Threshold string `json:"threshold,omitempty"`

	// TriggerSource: The trigger sources for this rule. * GMAIL_EVENTS *
	// DEVICE_EVENTS * USER_EVENTS
	TriggerSource string `json:"triggerSource,omitempty"`

	// UpdateTime: The timestamp of the last update to the rule.
	UpdateTime string `json:"updateTime,omitempty"`

	// WindowSize: Rule window size. Possible values are 1 hour or 24 hours.
	WindowSize string `json:"windowSize,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ActionNames") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ActionNames") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ActivityRule) MarshalJSON() ([]byte, error) {
	type NoMethod ActivityRule
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Alert: An alert affecting a customer.
type Alert struct {
	// AlertId: Output only. The unique identifier for the alert.
	AlertId string `json:"alertId,omitempty"`

	// CreateTime: Output only. The time this alert was created.
	CreateTime string `json:"createTime,omitempty"`

	// CustomerId: Output only. The unique identifier of the Google account
	// of the customer.
	CustomerId string `json:"customerId,omitempty"`

	// Data: Optional. The data associated with this alert, for example
	// google.apps.alertcenter.type.DeviceCompromised.
	Data googleapi.RawMessage `json:"data,omitempty"`

	// Deleted: Output only. `True` if this alert is marked for deletion.
	Deleted bool `json:"deleted,omitempty"`

	// EndTime: Optional. The time the event that caused this alert ceased
	// being active. If provided, the end time must not be earlier than the
	// start time. If not provided, it indicates an ongoing alert.
	EndTime string `json:"endTime,omitempty"`

	// Etag: Optional. `etag` is used for optimistic concurrency control as
	// a way to help prevent simultaneous updates of an alert from
	// overwriting each other. It is strongly suggested that systems make
	// use of the `etag` in the read-modify-write cycle to perform alert
	// updates in order to avoid race conditions: An `etag` is returned in
	// the response which contains alerts, and systems are expected to put
	// that etag in the request to update alert to ensure that their change
	// will be applied to the same version of the alert. If no `etag` is
	// provided in the call to update alert, then the existing alert is
	// overwritten blindly.
	Etag string `json:"etag,omitempty"`

	// Metadata: Output only. The metadata associated with this alert.
	Metadata *AlertMetadata `json:"metadata,omitempty"`

	// SecurityInvestigationToolLink: Output only. An optional Security
	// Investigation Tool (https://support.google.com/a/answer/7575955)
	// query for this alert.
	SecurityInvestigationToolLink string `json:"securityInvestigationToolLink,omitempty"`

	// Source: Required. A unique identifier for the system that reported
	// the alert. This is output only after alert is created. Supported
	// sources are any of the following: * Google Operations * Mobile device
	// management * Gmail phishing * Domain wide takeout * State sponsored
	// attack * Google identity
	Source string `json:"source,omitempty"`

	// StartTime: Required. The time the event that caused this alert was
	// started or detected.
	StartTime string `json:"startTime,omitempty"`

	// Type: Required. The type of the alert. This is output only after
	// alert is created. For a list of available alert types see Google
	// Workspace Alert types (/admin-sdk/alertcenter/reference/alert-types).
	Type string `json:"type,omitempty"`

	// UpdateTime: Output only. The time this alert was last updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "AlertId") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AlertId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Alert) MarshalJSON() ([]byte, error) {
	type NoMethod Alert
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AlertFeedback: A customer feedback about an alert.
type AlertFeedback struct {
	// AlertId: Output only. The alert identifier.
	AlertId string `json:"alertId,omitempty"`

	// CreateTime: Output only. The time this feedback was created.
	CreateTime string `json:"createTime,omitempty"`

	// CustomerId: Output only. The unique identifier of the Google account
	// of the customer.
	CustomerId string `json:"customerId,omitempty"`

	// Email: Output only. The email of the user that provided the feedback.
	Email string `json:"email,omitempty"`

	// FeedbackId: Output only. The unique identifier for the feedback.
	FeedbackId string `json:"feedbackId,omitempty"`

	// Type: Required. The type of the feedback.
	//
	// Possible values:
	//   "ALERT_FEEDBACK_TYPE_UNSPECIFIED" - The feedback type is not
	// specified.
	//   "NOT_USEFUL" - The alert report is not useful.
	//   "SOMEWHAT_USEFUL" - The alert report is somewhat useful.
	//   "VERY_USEFUL" - The alert report is very useful.
	Type string `json:"type,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "AlertId") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AlertId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AlertFeedback) MarshalJSON() ([]byte, error) {
	type NoMethod AlertFeedback
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AlertMetadata: An alert metadata.
type AlertMetadata struct {
	// AlertId: Output only. The alert identifier.
	AlertId string `json:"alertId,omitempty"`

	// Assignee: The email address of the user assigned to the alert.
	Assignee string `json:"assignee,omitempty"`

	// CustomerId: Output only. The unique identifier of the Google account
	// of the customer.
	CustomerId string `json:"customerId,omitempty"`

	// Etag: Optional. `etag` is used for optimistic concurrency control as
	// a way to help prevent simultaneous updates of an alert metadata from
	// overwriting each other. It is strongly suggested that systems make
	// use of the `etag` in the read-modify-write cycle to perform metatdata
	// updates in order to avoid race conditions: An `etag` is returned in
	// the response which contains alert metadata, and systems are expected
	// to put that etag in the request to update alert metadata to ensure
	// that their change will be applied to the same version of the alert
	// metadata. If no `etag` is provided in the call to update alert
	// metadata, then the existing alert metadata is overwritten blindly.
	Etag string `json:"etag,omitempty"`

	// Severity: The severity value of the alert. Alert Center will set this
	// field at alert creation time, default's to an empty string when it
	// could not be determined. The supported values for update actions on
	// this field are the following: * HIGH * MEDIUM * LOW
	Severity string `json:"severity,omitempty"`

	// Status: The current status of the alert. The supported values are the
	// following: * NOT_STARTED * IN_PROGRESS * CLOSED
	Status string `json:"status,omitempty"`

	// UpdateTime: Output only. The time this metadata was last updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "AlertId") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AlertId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AlertMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod AlertMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppMakerSqlSetupNotification: Alerts from App Maker to notify admins
// to set up default SQL instance.
type AppMakerSqlSetupNotification struct {
	// RequestInfo: List of applications with requests for default SQL set
	// up.
	RequestInfo []*RequestInfo `json:"requestInfo,omitempty"`

	// ForceSendFields is a list of field names (e.g. "RequestInfo") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "RequestInfo") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppMakerSqlSetupNotification) MarshalJSON() ([]byte, error) {
	type NoMethod AppMakerSqlSetupNotification
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppSettingsChanged: Alerts from AppSettingsChanged bucket Rules
// configured by Admin which contain the below rules. Calendar settings
// changed Drive settings changed Email settings changed Mobile settings
// changed
type AppSettingsChanged struct {
	// AlertDetails: Any other associated alert details, for example,
	// AlertConfiguration.
	AlertDetails string `json:"alertDetails,omitempty"`

	// Name: Rule name
	Name string `json:"name,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AlertDetails") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AlertDetails") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppSettingsChanged) MarshalJSON() ([]byte, error) {
	type NoMethod AppSettingsChanged
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Attachment: Attachment with application-specific information about an
// alert.
type Attachment struct {
	// Csv: A CSV file attachment.
	Csv *Csv `json:"csv,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Csv") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Csv") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Attachment) MarshalJSON() ([]byte, error) {
	type NoMethod Attachment
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BadWhitelist: Alert for setting the domain or IP that malicious email
// comes from as whitelisted domain or IP in Gmail advanced settings.
type BadWhitelist struct {
	// DomainId: The domain ID.
	DomainId *DomainId `json:"domainId,omitempty"`

	// MaliciousEntity: The entity whose actions triggered a Gmail phishing
	// alert.
	MaliciousEntity *MaliciousEntity `json:"maliciousEntity,omitempty"`

	// Messages: The list of messages contained by this alert.
	Messages []*GmailMessageInfo `json:"messages,omitempty"`

	// SourceIp: The source IP address of the malicious email, for example,
	// `127.0.0.1`.
	SourceIp string `json:"sourceIp,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DomainId") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DomainId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *BadWhitelist) MarshalJSON() ([]byte, error) {
	type NoMethod BadWhitelist
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BatchDeleteAlertsRequest: A request to perform batch delete on
// alerts.
type BatchDeleteAlertsRequest struct {
	// AlertId: Required. list of alert IDs.
	AlertId []string `json:"alertId,omitempty"`

	// CustomerId: Optional. The unique identifier of the Google Workspace
	// organization account of the customer the alerts are associated with.
	CustomerId string `json:"customerId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AlertId") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AlertId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *BatchDeleteAlertsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod BatchDeleteAlertsRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BatchDeleteAlertsResponse: Response to batch delete operation on
// alerts.
type BatchDeleteAlertsResponse struct {
	// FailedAlertStatus: The status details for each failed alert_id.
	FailedAlertStatus map[string]Status `json:"failedAlertStatus,omitempty"`

	// SuccessAlertIds: The successful list of alert IDs.
	SuccessAlertIds []string `json:"successAlertIds,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "FailedAlertStatus")
	// to unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FailedAlertStatus") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *BatchDeleteAlertsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod BatchDeleteAlertsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BatchUndeleteAlertsRequest: A request to perform batch undelete on
// alerts.
type BatchUndeleteAlertsRequest struct {
	// AlertId: Required. list of alert IDs.
	AlertId []string `json:"alertId,omitempty"`

	// CustomerId: Optional. The unique identifier of the Google Workspace
	// organization account of the customer the alerts are associated with.
	CustomerId string `json:"customerId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AlertId") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AlertId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *BatchUndeleteAlertsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod BatchUndeleteAlertsRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BatchUndeleteAlertsResponse: Response to batch undelete operation on
// alerts.
type BatchUndeleteAlertsResponse struct {
	// FailedAlertStatus: The status details for each failed alert_id.
	FailedAlertStatus map[string]Status `json:"failedAlertStatus,omitempty"`

	// SuccessAlertIds: The successful list of alert IDs.
	SuccessAlertIds []string `json:"successAlertIds,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "FailedAlertStatus")
	// to unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FailedAlertStatus") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *BatchUndeleteAlertsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod BatchUndeleteAlertsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// CloudPubsubTopic: A reference to a Cloud Pubsub topic. To register
// for notifications, the owner of the topic must grant
// `alerts-api-push-notifications@system.gserviceaccount.com` the
// `projects.topics.publish` permission.
type CloudPubsubTopic struct {
	// PayloadFormat: Optional. The format of the payload that would be
	// sent. If not specified the format will be JSON.
	//
	// Possible values:
	//   "PAYLOAD_FORMAT_UNSPECIFIED" - Payload format is not specified
	// (will use JSON as default).
	//   "JSON" - Use JSON.
	PayloadFormat string `json:"payloadFormat,omitempty"`

	// TopicName: The `name` field of a Cloud Pubsub [Topic]
	// (https://cloud.google.com/pubsub/docs/reference/rest/v1/projects.topics#Topic).
	TopicName string `json:"topicName,omitempty"`

	// ForceSendFields is a list of field names (e.g. "PayloadFormat") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "PayloadFormat") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *CloudPubsubTopic) MarshalJSON() ([]byte, error) {
	type NoMethod CloudPubsubTopic
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Csv: A representation of a CSV file attachment, as a list of column
// headers and a list of data rows.
type Csv struct {
	// DataRows: The list of data rows in a CSV file, as string arrays
	// rather than as a single comma-separated string.
	DataRows []*CsvRow `json:"dataRows,omitempty"`

	// Headers: The list of headers for data columns in a CSV file.
	Headers []string `json:"headers,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DataRows") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DataRows") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Csv) MarshalJSON() ([]byte, error) {
	type NoMethod Csv
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// CsvRow: A representation of a single data row in a CSV file.
type CsvRow struct {
	// Entries: The data entries in a CSV file row, as a string array rather
	// than a single comma-separated string.
	Entries []string `json:"entries,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Entries") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Entries") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *CsvRow) MarshalJSON() ([]byte, error) {
	type NoMethod CsvRow
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// DeviceCompromised: A mobile device compromised alert. Derived from
// audit logs.
type DeviceCompromised struct {
	// Email: The email of the user this alert was created for.
	Email string `json:"email,omitempty"`

	// Events: Required. The list of security events.
	Events []*DeviceCompromisedSecurityDetail `json:"events,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Email") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Email") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *DeviceCompromised) MarshalJSON() ([]byte, error) {
	type NoMethod DeviceCompromised
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// DeviceCompromisedSecurityDetail: Detailed information of a single MDM
// device compromised event.
type DeviceCompromisedSecurityDetail struct {
	// DeviceCompromisedState: The device compromised state. Possible values
	// are "Compromised" or "Not Compromised".
	DeviceCompromisedState string `json:"deviceCompromisedState,omitempty"`

	// DeviceId: Required. The device ID.
	DeviceId string `json:"deviceId,omitempty"`

	// DeviceModel: The model of the device.
	DeviceModel string `json:"deviceModel,omitempty"`

	// DeviceType: The type of the device.
	DeviceType string `json:"deviceType,omitempty"`

	// IosVendorId: Required for iOS, empty for others.
	IosVendorId string `json:"iosVendorId,omitempty"`

	// ResourceId: The device resource ID.
	ResourceId string `json:"resourceId,omitempty"`

	// SerialNumber: The serial number of the device.
	SerialNumber string `json:"serialNumber,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "DeviceCompromisedState") to unconditionally include in API requests.
	// By default, fields with empty values are omitted from API requests.
	// However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DeviceCompromisedState")
	// to include in API requests with the JSON null value. By default,
	// fields with empty values are omitted from API requests. However, any
	// field with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *DeviceCompromisedSecurityDetail) MarshalJSON() ([]byte, error) {
	type NoMethod DeviceCompromisedSecurityDetail
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// DlpRuleViolation: Alerts that get triggered on violations of Data
// Loss Prevention (DLP) rules.
type DlpRuleViolation struct {
	// RuleViolationInfo: Details about the violated DLP rule. Admins can
	// use the predefined detectors provided by Google Cloud DLP
	// https://cloud.google.com/dlp/ when setting up a DLP rule. Matched
	// Cloud DLP detectors in this violation if any will be captured in the
	// MatchInfo.predefined_detector.
	RuleViolationInfo *RuleViolationInfo `json:"ruleViolationInfo,omitempty"`

	// ForceSendFields is a list of field names (e.g. "RuleViolationInfo")
	// to unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "RuleViolationInfo") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *DlpRuleViolation) MarshalJSON() ([]byte, error) {
	type NoMethod DlpRuleViolation
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// DomainId: Domain ID of Gmail phishing alerts.
type DomainId struct {
	// CustomerPrimaryDomain: The primary domain for the customer.
	CustomerPrimaryDomain string `json:"customerPrimaryDomain,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "CustomerPrimaryDomain") to unconditionally include in API requests.
	// By default, fields with empty values are omitted from API requests.
	// However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CustomerPrimaryDomain") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *DomainId) MarshalJSON() ([]byte, error) {
	type NoMethod DomainId
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// DomainWideTakeoutInitiated: A takeout operation for the entire domain
// was initiated by an admin. Derived from audit logs.
type DomainWideTakeoutInitiated struct {
	// Email: The email of the admin who initiated the takeout.
	Email string `json:"email,omitempty"`

	// TakeoutRequestId: The takeout request ID.
	TakeoutRequestId string `json:"takeoutRequestId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Email") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Email") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *DomainWideTakeoutInitiated) MarshalJSON() ([]byte, error) {
	type NoMethod DomainWideTakeoutInitiated
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Empty: A generic empty message that you can re-use to avoid defining
// duplicated empty messages in your APIs. A typical example is to use
// it as the request or the response type of an API method. For
// instance: service Foo { rpc Bar(google.protobuf.Empty) returns
// (google.protobuf.Empty); } The JSON representation for `Empty` is
// empty JSON object `{}`.
type Empty struct {
	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`
}

// GmailMessageInfo: Details of a message in phishing spike alert.
type GmailMessageInfo struct {
	// AttachmentsSha256Hash: The `SHA256` hash of email's attachment and
	// all MIME parts.
	AttachmentsSha256Hash []string `json:"attachmentsSha256Hash,omitempty"`

	// Date: The date the malicious email was sent.
	Date string `json:"date,omitempty"`

	// Md5HashMessageBody: The hash of the message body text.
	Md5HashMessageBody string `json:"md5HashMessageBody,omitempty"`

	// Md5HashSubject: The MD5 Hash of email's subject (only available for
	// reported emails).
	Md5HashSubject string `json:"md5HashSubject,omitempty"`

	// MessageBodySnippet: The snippet of the message body text (only
	// available for reported emails).
	MessageBodySnippet string `json:"messageBodySnippet,omitempty"`

	// MessageId: The message ID.
	MessageId string `json:"messageId,omitempty"`

	// Recipient: The recipient of this email.
	Recipient string `json:"recipient,omitempty"`

	// SubjectText: The email subject text (only available for reported
	// emails).
	SubjectText string `json:"subjectText,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "AttachmentsSha256Hash") to unconditionally include in API requests.
	// By default, fields with empty values are omitted from API requests.
	// However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AttachmentsSha256Hash") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GmailMessageInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GmailMessageInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleOperations: An incident reported by Google Operations for a
// Google Workspace application.
type GoogleOperations struct {
	// AffectedUserEmails: The list of emails which correspond to the users
	// directly affected by the incident.
	AffectedUserEmails []string `json:"affectedUserEmails,omitempty"`

	// AttachmentData: Optional. Application-specific data for an incident,
	// provided when the Google Workspace application which reported the
	// incident cannot be completely restored to a valid state.
	AttachmentData *Attachment `json:"attachmentData,omitempty"`

	// Description: A detailed, freeform incident description.
	Description string `json:"description,omitempty"`

	// Header: A header to display above the incident message. Typically
	// used to attach a localized notice on the timeline for followup comms
	// translations.
	Header string `json:"header,omitempty"`

	// Title: A one-line incident description.
	Title string `json:"title,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AffectedUserEmails")
	// to unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AffectedUserEmails") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleOperations) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleOperations
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ListAlertFeedbackResponse: Response message for an alert feedback
// listing request.
type ListAlertFeedbackResponse struct {
	// Feedback: The list of alert feedback. Feedback entries for each alert
	// are ordered by creation time descending.
	Feedback []*AlertFeedback `json:"feedback,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Feedback") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Feedback") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ListAlertFeedbackResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListAlertFeedbackResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ListAlertsResponse: Response message for an alert listing request.
type ListAlertsResponse struct {
	// Alerts: The list of alerts.
	Alerts []*Alert `json:"alerts,omitempty"`

	// NextPageToken: The token for the next page. If not empty, indicates
	// that there may be more alerts that match the listing request; this
	// value can be used in a subsequent ListAlertsRequest to get alerts
	// continuing from last result of the current list call.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Alerts") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Alerts") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ListAlertsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListAlertsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// LoginDetails: The details of the login action.
type LoginDetails struct {
	// IpAddress: Optional. The human-readable IP address (for example,
	// `11.22.33.44`) that is associated with the warning event.
	IpAddress string `json:"ipAddress,omitempty"`

	// LoginTime: Optional. The successful login time that is associated
	// with the warning event. This isn't present for blocked login
	// attempts.
	LoginTime string `json:"loginTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "IpAddress") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "IpAddress") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *LoginDetails) MarshalJSON() ([]byte, error) {
	type NoMethod LoginDetails
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// MailPhishing: Proto for all phishing alerts with common payload.
// Supported types are any of the following: * User reported phishing *
// User reported spam spike * Suspicious message reported * Phishing
// reclassification * Malware reclassification * Gmail potential
// employee spoofing
type MailPhishing struct {
	// DomainId: The domain ID.
	DomainId *DomainId `json:"domainId,omitempty"`

	// IsInternal: If `true`, the email originated from within the
	// organization.
	IsInternal bool `json:"isInternal,omitempty"`

	// MaliciousEntity: The entity whose actions triggered a Gmail phishing
	// alert.
	MaliciousEntity *MaliciousEntity `json:"maliciousEntity,omitempty"`

	// Messages: The list of messages contained by this alert.
	Messages []*GmailMessageInfo `json:"messages,omitempty"`

	// SystemActionType: System actions on the messages.
	//
	// Possible values:
	//   "SYSTEM_ACTION_TYPE_UNSPECIFIED" - System action is unspecified.
	//   "NO_OPERATION" - No operation.
	//   "REMOVED_FROM_INBOX" - Messages were removed from the inbox.
	SystemActionType string `json:"systemActionType,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DomainId") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DomainId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *MailPhishing) MarshalJSON() ([]byte, error) {
	type NoMethod MailPhishing
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// MaliciousEntity: Entity whose actions triggered a Gmail phishing
// alert.
type MaliciousEntity struct {
	// DisplayName: The header from display name.
	DisplayName string `json:"displayName,omitempty"`

	// Entity: The actor who triggered a gmail phishing alert.
	Entity *User `json:"entity,omitempty"`

	// FromHeader: The sender email address.
	FromHeader string `json:"fromHeader,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DisplayName") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *MaliciousEntity) MarshalJSON() ([]byte, error) {
	type NoMethod MaliciousEntity
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// MatchInfo: Proto that contains match information from the condition
// part of the rule.
type MatchInfo struct {
	// PredefinedDetector: For matched detector predefined by Google.
	PredefinedDetector *PredefinedDetectorInfo `json:"predefinedDetector,omitempty"`

	// UserDefinedDetector: For matched detector defined by administrators.
	UserDefinedDetector *UserDefinedDetectorInfo `json:"userDefinedDetector,omitempty"`

	// ForceSendFields is a list of field names (e.g. "PredefinedDetector")
	// to unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "PredefinedDetector") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *MatchInfo) MarshalJSON() ([]byte, error) {
	type NoMethod MatchInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Notification: Settings for callback notifications. For more details
// see Google Workspace Alert Notification
// (/admin-sdk/alertcenter/guides/notifications).
type Notification struct {
	// CloudPubsubTopic: A Google Cloud Pub/sub topic destination.
	CloudPubsubTopic *CloudPubsubTopic `json:"cloudPubsubTopic,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CloudPubsubTopic") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CloudPubsubTopic") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *Notification) MarshalJSON() ([]byte, error) {
	type NoMethod Notification
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// PhishingSpike: Alert for a spike in user reported phishing.
// *Warning*: This type has been deprecated. Use MailPhishing
// (/admin-sdk/alertcenter/reference/rest/v1beta1/MailPhishing) instead.
type PhishingSpike struct {
	// DomainId: The domain ID.
	DomainId *DomainId `json:"domainId,omitempty"`

	// IsInternal: If `true`, the email originated from within the
	// organization.
	IsInternal bool `json:"isInternal,omitempty"`

	// MaliciousEntity: The entity whose actions triggered a Gmail phishing
	// alert.
	MaliciousEntity *MaliciousEntity `json:"maliciousEntity,omitempty"`

	// Messages: The list of messages contained by this alert.
	Messages []*GmailMessageInfo `json:"messages,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DomainId") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DomainId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *PhishingSpike) MarshalJSON() ([]byte, error) {
	type NoMethod PhishingSpike
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// PredefinedDetectorInfo: Detector provided by Google.
type PredefinedDetectorInfo struct {
	// DetectorName: Name that uniquely identifies the detector.
	DetectorName string `json:"detectorName,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DetectorName") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DetectorName") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *PredefinedDetectorInfo) MarshalJSON() ([]byte, error) {
	type NoMethod PredefinedDetectorInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ReportingRule: Alerts from Reporting Rules configured by Admin.
type ReportingRule struct {
	// AlertDetails: Any other associated alert details, for example,
	// AlertConfiguration.
	AlertDetails string `json:"alertDetails,omitempty"`

	// Name: Rule name
	Name string `json:"name,omitempty"`

	// Query: Alert Rule query Sample Query query { condition { filter {
	// expected_application_id: 777491262838 expected_event_name:
	// "indexable_content_change" filter_op: IN } } conjunction_operator: OR
	// }
	Query string `json:"query,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AlertDetails") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AlertDetails") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ReportingRule) MarshalJSON() ([]byte, error) {
	type NoMethod ReportingRule
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// RequestInfo: Requests for one application that needs default SQL
// setup.
type RequestInfo struct {
	// AppDeveloperEmail: List of app developers who triggered notifications
	// for above application.
	AppDeveloperEmail []string `json:"appDeveloperEmail,omitempty"`

	// AppKey: Required. The application that requires the SQL setup.
	AppKey string `json:"appKey,omitempty"`

	// NumberOfRequests: Required. Number of requests sent for this
	// application to set up default SQL instance.
	NumberOfRequests int64 `json:"numberOfRequests,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "AppDeveloperEmail")
	// to unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AppDeveloperEmail") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *RequestInfo) MarshalJSON() ([]byte, error) {
	type NoMethod RequestInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ResourceInfo: Proto that contains resource information.
type ResourceInfo struct {
	// DocumentId: Drive file ID.
	DocumentId string `json:"documentId,omitempty"`

	// ResourceTitle: Title of the resource, for example email subject, or
	// document title.
	ResourceTitle string `json:"resourceTitle,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DocumentId") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DocumentId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ResourceInfo) MarshalJSON() ([]byte, error) {
	type NoMethod ResourceInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// RuleInfo: Proto that contains rule information.
type RuleInfo struct {
	// DisplayName: User provided name of the rule.
	DisplayName string `json:"displayName,omitempty"`

	// ResourceName: Resource name that uniquely identifies the rule.
	ResourceName string `json:"resourceName,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DisplayName") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *RuleInfo) MarshalJSON() ([]byte, error) {
	type NoMethod RuleInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// RuleViolationInfo: Common alert information about violated rules that
// are configured by Google Workspace administrators.
type RuleViolationInfo struct {
	// DataSource: Source of the data.
	//
	// Possible values:
	//   "DATA_SOURCE_UNSPECIFIED" - Data source is unspecified.
	//   "DRIVE" - Drive data source.
	DataSource string `json:"dataSource,omitempty"`

	// MatchInfo: List of matches that were found in the resource content.
	MatchInfo []*MatchInfo `json:"matchInfo,omitempty"`

	// Recipients: Resource recipients. For Drive, they are grantees that
	// the Drive file was shared with at the time of rule triggering. Valid
	// values include user emails, group emails, domains, or 'anyone' if the
	// file was publicly accessible. If the file was private the recipients
	// list will be empty. For Gmail, they are emails of the users or groups
	// that the Gmail message was sent to.
	Recipients []string `json:"recipients,omitempty"`

	// ResourceInfo: Details of the resource which violated the rule.
	ResourceInfo *ResourceInfo `json:"resourceInfo,omitempty"`

	// RuleInfo: Details of the violated rule.
	RuleInfo *RuleInfo `json:"ruleInfo,omitempty"`

	// SuppressedActionTypes: Actions suppressed due to other actions with
	// higher priority.
	//
	// Possible values:
	//   "ACTION_TYPE_UNSPECIFIED" - Action type is unspecified.
	//   "DRIVE_BLOCK_EXTERNAL_SHARING" - Block sharing a file externally.
	//   "DRIVE_WARN_ON_EXTERNAL_SHARING" - Show a warning message when
	// sharing a file externally.
	//   "ALERT" - Send alert.
	//   "RULE_ACTIVATE" - Activate Rule Action
	//   "RULE_DEACTIVATE" - Deactivate Rule Action
	SuppressedActionTypes []string `json:"suppressedActionTypes,omitempty"`

	// Trigger: Trigger of the rule.
	//
	// Possible values:
	//   "TRIGGER_UNSPECIFIED" - Trigger is unspecified.
	//   "DRIVE_SHARE" - A Drive file is shared.
	Trigger string `json:"trigger,omitempty"`

	// TriggeredActionInfo: Metadata related to the triggered actions.
	TriggeredActionInfo []*ActionInfo `json:"triggeredActionInfo,omitempty"`

	// TriggeredActionTypes: Actions applied as a consequence of the rule
	// being triggered.
	//
	// Possible values:
	//   "ACTION_TYPE_UNSPECIFIED" - Action type is unspecified.
	//   "DRIVE_BLOCK_EXTERNAL_SHARING" - Block sharing a file externally.
	//   "DRIVE_WARN_ON_EXTERNAL_SHARING" - Show a warning message when
	// sharing a file externally.
	//   "ALERT" - Send alert.
	//   "RULE_ACTIVATE" - Activate Rule Action
	//   "RULE_DEACTIVATE" - Deactivate Rule Action
	TriggeredActionTypes []string `json:"triggeredActionTypes,omitempty"`

	// TriggeringUserEmail: Email of the user who caused the violation.
	// Value could be empty if not applicable, for example, a violation
	// found by drive continuous scan.
	TriggeringUserEmail string `json:"triggeringUserEmail,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DataSource") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DataSource") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *RuleViolationInfo) MarshalJSON() ([]byte, error) {
	type NoMethod RuleViolationInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Settings: Customer-level settings.
type Settings struct {
	// Notifications: The list of notifications.
	Notifications []*Notification `json:"notifications,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Notifications") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Notifications") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Settings) MarshalJSON() ([]byte, error) {
	type NoMethod Settings
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// StateSponsoredAttack: A state-sponsored attack alert. Derived from
// audit logs.
type StateSponsoredAttack struct {
	// Email: The email of the user this incident was created for.
	Email string `json:"email,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Email") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Email") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *StateSponsoredAttack) MarshalJSON() ([]byte, error) {
	type NoMethod StateSponsoredAttack
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Status: The `Status` type defines a logical error model that is
// suitable for different programming environments, including REST APIs
// and RPC APIs. It is used by gRPC (https://github.com/grpc). Each
// `Status` message contains three pieces of data: error code, error
// message, and error details. You can find out more about this error
// model and how to work with it in the API Design Guide
// (https://cloud.google.com/apis/design/errors).
type Status struct {
	// Code: The status code, which should be an enum value of
	// google.rpc.Code.
	Code int64 `json:"code,omitempty"`

	// Details: A list of messages that carry the error details. There is a
	// common set of message types for APIs to use.
	Details []googleapi.RawMessage `json:"details,omitempty"`

	// Message: A developer-facing error message, which should be in
	// English. Any user-facing error message should be localized and sent
	// in the google.rpc.Status.details field, or localized by the client.
	Message string `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Status) MarshalJSON() ([]byte, error) {
	type NoMethod Status
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// SuspiciousActivity: A mobile suspicious activity alert. Derived from
// audit logs.
type SuspiciousActivity struct {
	// Email: The email of the user this alert was created for.
	Email string `json:"email,omitempty"`

	// Events: Required. The list of security events.
	Events []*SuspiciousActivitySecurityDetail `json:"events,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Email") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Email") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *SuspiciousActivity) MarshalJSON() ([]byte, error) {
	type NoMethod SuspiciousActivity
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// SuspiciousActivitySecurityDetail: Detailed information of a single
// MDM suspicious activity event.
type SuspiciousActivitySecurityDetail struct {
	// DeviceId: Required. The device ID.
	DeviceId string `json:"deviceId,omitempty"`

	// DeviceModel: The model of the device.
	DeviceModel string `json:"deviceModel,omitempty"`

	// DeviceProperty: The device property which was changed.
	DeviceProperty string `json:"deviceProperty,omitempty"`

	// DeviceType: The type of the device.
	DeviceType string `json:"deviceType,omitempty"`

	// IosVendorId: Required for iOS, empty for others.
	IosVendorId string `json:"iosVendorId,omitempty"`

	// NewValue: The new value of the device property after the change.
	NewValue string `json:"newValue,omitempty"`

	// OldValue: The old value of the device property before the change.
	OldValue string `json:"oldValue,omitempty"`

	// ResourceId: The device resource ID.
	ResourceId string `json:"resourceId,omitempty"`

	// SerialNumber: The serial number of the device.
	SerialNumber string `json:"serialNumber,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DeviceId") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DeviceId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *SuspiciousActivitySecurityDetail) MarshalJSON() ([]byte, error) {
	type NoMethod SuspiciousActivitySecurityDetail
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// UndeleteAlertRequest: A request to undelete a specific alert that was
// marked for deletion.
type UndeleteAlertRequest struct {
	// CustomerId: Optional. The unique identifier of the Google Workspace
	// organization account of the customer the alert is associated with.
	// Inferred from the caller identity if not provided.
	CustomerId string `json:"customerId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CustomerId") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CustomerId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *UndeleteAlertRequest) MarshalJSON() ([]byte, error) {
	type NoMethod UndeleteAlertRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// User: A user.
type User struct {
	// DisplayName: Display name of the user.
	DisplayName string `json:"displayName,omitempty"`

	// EmailAddress: Email address of the user.
	EmailAddress string `json:"emailAddress,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DisplayName") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *User) MarshalJSON() ([]byte, error) {
	type NoMethod User
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// UserChanges: Alerts from UserChanges bucket Rules for predefined
// rules which contain the below rules. Suspended user made active New
// user Added User suspended (by admin) User granted admin privileges
// User admin privileges revoked User deleted Users password changed
type UserChanges struct {
	// Name: Rule name
	Name string `json:"name,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Name") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Name") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *UserChanges) MarshalJSON() ([]byte, error) {
	type NoMethod UserChanges
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// UserDefinedDetectorInfo: Detector defined by administrators.
type UserDefinedDetectorInfo struct {
	// DisplayName: Display name of the detector.
	DisplayName string `json:"displayName,omitempty"`

	// ResourceName: Resource name that uniquely identifies the detector.
	ResourceName string `json:"resourceName,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DisplayName") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *UserDefinedDetectorInfo) MarshalJSON() ([]byte, error) {
	type NoMethod UserDefinedDetectorInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// method id "alertcenter.alerts.batchDelete":

type AlertsBatchDeleteCall struct {
	s                        *Service
	batchdeletealertsrequest *BatchDeleteAlertsRequest
	urlParams_               gensupport.URLParams
	ctx_                     context.Context
	header_                  http.Header
}

// BatchDelete: Performs batch delete operation on alerts.
func (r *AlertsService) BatchDelete(batchdeletealertsrequest *BatchDeleteAlertsRequest) *AlertsBatchDeleteCall {
	c := &AlertsBatchDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.batchdeletealertsrequest = batchdeletealertsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *AlertsBatchDeleteCall) Fields(s ...googleapi.Field) *AlertsBatchDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *AlertsBatchDeleteCall) Context(ctx context.Context) *AlertsBatchDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *AlertsBatchDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AlertsBatchDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210518")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.batchdeletealertsrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/alerts:batchDelete")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "alertcenter.alerts.batchDelete" call.
// Exactly one of *BatchDeleteAlertsResponse or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *BatchDeleteAlertsResponse.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *AlertsBatchDeleteCall) Do(opts ...googleapi.CallOption) (*BatchDeleteAlertsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &BatchDeleteAlertsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Performs batch delete operation on alerts.",
	//   "flatPath": "v1beta1/alerts:batchDelete",
	//   "httpMethod": "POST",
	//   "id": "alertcenter.alerts.batchDelete",
	//   "parameterOrder": [],
	//   "parameters": {},
	//   "path": "v1beta1/alerts:batchDelete",
	//   "request": {
	//     "$ref": "BatchDeleteAlertsRequest"
	//   },
	//   "response": {
	//     "$ref": "BatchDeleteAlertsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/apps.alerts"
	//   ]
	// }

}

// method id "alertcenter.alerts.batchUndelete":

type AlertsBatchUndeleteCall struct {
	s                          *Service
	batchundeletealertsrequest *BatchUndeleteAlertsRequest
	urlParams_                 gensupport.URLParams
	ctx_                       context.Context
	header_                    http.Header
}

// BatchUndelete: Performs batch undelete operation on alerts.
func (r *AlertsService) BatchUndelete(batchundeletealertsrequest *BatchUndeleteAlertsRequest) *AlertsBatchUndeleteCall {
	c := &AlertsBatchUndeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.batchundeletealertsrequest = batchundeletealertsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *AlertsBatchUndeleteCall) Fields(s ...googleapi.Field) *AlertsBatchUndeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *AlertsBatchUndeleteCall) Context(ctx context.Context) *AlertsBatchUndeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *AlertsBatchUndeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AlertsBatchUndeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210518")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.batchundeletealertsrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/alerts:batchUndelete")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "alertcenter.alerts.batchUndelete" call.
// Exactly one of *BatchUndeleteAlertsResponse or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *BatchUndeleteAlertsResponse.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *AlertsBatchUndeleteCall) Do(opts ...googleapi.CallOption) (*BatchUndeleteAlertsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &BatchUndeleteAlertsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Performs batch undelete operation on alerts.",
	//   "flatPath": "v1beta1/alerts:batchUndelete",
	//   "httpMethod": "POST",
	//   "id": "alertcenter.alerts.batchUndelete",
	//   "parameterOrder": [],
	//   "parameters": {},
	//   "path": "v1beta1/alerts:batchUndelete",
	//   "request": {
	//     "$ref": "BatchUndeleteAlertsRequest"
	//   },
	//   "response": {
	//     "$ref": "BatchUndeleteAlertsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/apps.alerts"
	//   ]
	// }

}

// method id "alertcenter.alerts.delete":

type AlertsDeleteCall struct {
	s          *Service
	alertId    string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Marks the specified alert for deletion. An alert that has
// been marked for deletion is removed from Alert Center after 30 days.
// Marking an alert for deletion has no effect on an alert which has
// already been marked for deletion. Attempting to mark a nonexistent
// alert for deletion results in a `NOT_FOUND` error.
//
// - alertId: The identifier of the alert to delete.
func (r *AlertsService) Delete(alertId string) *AlertsDeleteCall {
	c := &AlertsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.alertId = alertId
	return c
}

// CustomerId sets the optional parameter "customerId": The unique
// identifier of the Google Workspace organization account of the
// customer the alert is associated with. Inferred from the caller
// identity if not provided.
func (c *AlertsDeleteCall) CustomerId(customerId string) *AlertsDeleteCall {
	c.urlParams_.Set("customerId", customerId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *AlertsDeleteCall) Fields(s ...googleapi.Field) *AlertsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *AlertsDeleteCall) Context(ctx context.Context) *AlertsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *AlertsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AlertsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210518")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/alerts/{alertId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"alertId": c.alertId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "alertcenter.alerts.delete" call.
// Exactly one of *Empty or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified
// was returned.
func (c *AlertsDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Marks the specified alert for deletion. An alert that has been marked for deletion is removed from Alert Center after 30 days. Marking an alert for deletion has no effect on an alert which has already been marked for deletion. Attempting to mark a nonexistent alert for deletion results in a `NOT_FOUND` error.",
	//   "flatPath": "v1beta1/alerts/{alertId}",
	//   "httpMethod": "DELETE",
	//   "id": "alertcenter.alerts.delete",
	//   "parameterOrder": [
	//     "alertId"
	//   ],
	//   "parameters": {
	//     "alertId": {
	//       "description": "Required. The identifier of the alert to delete.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "customerId": {
	//       "description": "Optional. The unique identifier of the Google Workspace organization account of the customer the alert is associated with. Inferred from the caller identity if not provided.",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta1/alerts/{alertId}",
	//   "response": {
	//     "$ref": "Empty"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/apps.alerts"
	//   ]
	// }

}

// method id "alertcenter.alerts.get":

type AlertsGetCall struct {
	s            *Service
	alertId      string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the specified alert. Attempting to get a nonexistent alert
// returns `NOT_FOUND` error.
//
// - alertId: The identifier of the alert to retrieve.
func (r *AlertsService) Get(alertId string) *AlertsGetCall {
	c := &AlertsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.alertId = alertId
	return c
}

// CustomerId sets the optional parameter "customerId": The unique
// identifier of the Google Workspace organization account of the
// customer the alert is associated with. Inferred from the caller
// identity if not provided.
func (c *AlertsGetCall) CustomerId(customerId string) *AlertsGetCall {
	c.urlParams_.Set("customerId", customerId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *AlertsGetCall) Fields(s ...googleapi.Field) *AlertsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *AlertsGetCall) IfNoneMatch(entityTag string) *AlertsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *AlertsGetCall) Context(ctx context.Context) *AlertsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *AlertsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AlertsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210518")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/alerts/{alertId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"alertId": c.alertId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "alertcenter.alerts.get" call.
// Exactly one of *Alert or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *Alert.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified
// was returned.
func (c *AlertsGetCall) Do(opts ...googleapi.CallOption) (*Alert, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &Alert{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets the specified alert. Attempting to get a nonexistent alert returns `NOT_FOUND` error.",
	//   "flatPath": "v1beta1/alerts/{alertId}",
	//   "httpMethod": "GET",
	//   "id": "alertcenter.alerts.get",
	//   "parameterOrder": [
	//     "alertId"
	//   ],
	//   "parameters": {
	//     "alertId": {
	//       "description": "Required. The identifier of the alert to retrieve.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "customerId": {
	//       "description": "Optional. The unique identifier of the Google Workspace organization account of the customer the alert is associated with. Inferred from the caller identity if not provided.",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta1/alerts/{alertId}",
	//   "response": {
	//     "$ref": "Alert"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/apps.alerts"
	//   ]
	// }

}

// method id "alertcenter.alerts.getMetadata":

type AlertsGetMetadataCall struct {
	s            *Service
	alertId      string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetMetadata: Returns the metadata of an alert. Attempting to get
// metadata for a non-existent alert returns `NOT_FOUND` error.
//
// - alertId: The identifier of the alert this metadata belongs to.
func (r *AlertsService) GetMetadata(alertId string) *AlertsGetMetadataCall {
	c := &AlertsGetMetadataCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.alertId = alertId
	return c
}

// CustomerId sets the optional parameter "customerId": The unique
// identifier of the Google Workspace organization account of the
// customer the alert metadata is associated with. Inferred from the
// caller identity if not provided.
func (c *AlertsGetMetadataCall) CustomerId(customerId string) *AlertsGetMetadataCall {
	c.urlParams_.Set("customerId", customerId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *AlertsGetMetadataCall) Fields(s ...googleapi.Field) *AlertsGetMetadataCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *AlertsGetMetadataCall) IfNoneMatch(entityTag string) *AlertsGetMetadataCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *AlertsGetMetadataCall) Context(ctx context.Context) *AlertsGetMetadataCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *AlertsGetMetadataCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AlertsGetMetadataCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210518")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/alerts/{alertId}/metadata")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"alertId": c.alertId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "alertcenter.alerts.getMetadata" call.
// Exactly one of *AlertMetadata or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *AlertMetadata.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *AlertsGetMetadataCall) Do(opts ...googleapi.CallOption) (*AlertMetadata, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &AlertMetadata{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Returns the metadata of an alert. Attempting to get metadata for a non-existent alert returns `NOT_FOUND` error.",
	//   "flatPath": "v1beta1/alerts/{alertId}/metadata",
	//   "httpMethod": "GET",
	//   "id": "alertcenter.alerts.getMetadata",
	//   "parameterOrder": [
	//     "alertId"
	//   ],
	//   "parameters": {
	//     "alertId": {
	//       "description": "Required. The identifier of the alert this metadata belongs to.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "customerId": {
	//       "description": "Optional. The unique identifier of the Google Workspace organization account of the customer the alert metadata is associated with. Inferred from the caller identity if not provided.",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta1/alerts/{alertId}/metadata",
	//   "response": {
	//     "$ref": "AlertMetadata"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/apps.alerts"
	//   ]
	// }

}

// method id "alertcenter.alerts.list":

type AlertsListCall struct {
	s            *Service
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists the alerts.
func (r *AlertsService) List() *AlertsListCall {
	c := &AlertsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	return c
}

// CustomerId sets the optional parameter "customerId": The unique
// identifier of the Google Workspace organization account of the
// customer the alerts are associated with. Inferred from the caller
// identity if not provided.
func (c *AlertsListCall) CustomerId(customerId string) *AlertsListCall {
	c.urlParams_.Set("customerId", customerId)
	return c
}

// Filter sets the optional parameter "filter": A query string for
// filtering alert results. For more details, see Query filters
// (/admin-sdk/alertcenter/guides/query-filters) and Supported query
// filter fields
// (/admin-sdk/alertcenter/reference/filter-fields#alerts.list).
func (c *AlertsListCall) Filter(filter string) *AlertsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": The sort order of the
// list results. If not specified results may be returned in arbitrary
// order. You can sort the results in descending order based on the
// creation timestamp using `order_by="create_time desc". Currently,
// supported sorting are `create_time asc`, `create_time desc`,
// `update_time desc`
func (c *AlertsListCall) OrderBy(orderBy string) *AlertsListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": The requested page
// size. Server may return fewer items than requested. If unspecified,
// server picks an appropriate default.
func (c *AlertsListCall) PageSize(pageSize int64) *AlertsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A token
// identifying a page of results the server should return. If empty, a
// new iteration is started. To continue an iteration, pass in the value
// from the previous ListAlertsResponse's next_page_token field.
func (c *AlertsListCall) PageToken(pageToken string) *AlertsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *AlertsListCall) Fields(s ...googleapi.Field) *AlertsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *AlertsListCall) IfNoneMatch(entityTag string) *AlertsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *AlertsListCall) Context(ctx context.Context) *AlertsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *AlertsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AlertsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210518")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/alerts")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "alertcenter.alerts.list" call.
// Exactly one of *ListAlertsResponse or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *ListAlertsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *AlertsListCall) Do(opts ...googleapi.CallOption) (*ListAlertsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &ListAlertsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists the alerts.",
	//   "flatPath": "v1beta1/alerts",
	//   "httpMethod": "GET",
	//   "id": "alertcenter.alerts.list",
	//   "parameterOrder": [],
	//   "parameters": {
	//     "customerId": {
	//       "description": "Optional. The unique identifier of the Google Workspace organization account of the customer the alerts are associated with. Inferred from the caller identity if not provided.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "filter": {
	//       "description": "Optional. A query string for filtering alert results. For more details, see [Query filters](/admin-sdk/alertcenter/guides/query-filters) and [Supported query filter fields](/admin-sdk/alertcenter/reference/filter-fields#alerts.list).",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "orderBy": {
	//       "description": "Optional. The sort order of the list results. If not specified results may be returned in arbitrary order. You can sort the results in descending order based on the creation timestamp using `order_by=\"create_time desc\"`. Currently, supported sorting are `create_time asc`, `create_time desc`, `update_time desc`",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "Optional. The requested page size. Server may return fewer items than requested. If unspecified, server picks an appropriate default.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "Optional. A token identifying a page of results the server should return. If empty, a new iteration is started. To continue an iteration, pass in the value from the previous ListAlertsResponse's next_page_token field.",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta1/alerts",
	//   "response": {
	//     "$ref": "ListAlertsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/apps.alerts"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *AlertsListCall) Pages(ctx context.Context, f func(*ListAlertsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "alertcenter.alerts.undelete":

type AlertsUndeleteCall struct {
	s                    *Service
	alertId              string
	undeletealertrequest *UndeleteAlertRequest
	urlParams_           gensupport.URLParams
	ctx_                 context.Context
	header_              http.Header
}

// Undelete: Restores, or "undeletes", an alert that was marked for
// deletion within the past 30 days. Attempting to undelete an alert
// which was marked for deletion over 30 days ago (which has been
// removed from the Alert Center database) or a nonexistent alert
// returns a `NOT_FOUND` error. Attempting to undelete an alert which
// has not been marked for deletion has no effect.
//
// - alertId: The identifier of the alert to undelete.
func (r *AlertsService) Undelete(alertId string, undeletealertrequest *UndeleteAlertRequest) *AlertsUndeleteCall {
	c := &AlertsUndeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.alertId = alertId
	c.undeletealertrequest = undeletealertrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *AlertsUndeleteCall) Fields(s ...googleapi.Field) *AlertsUndeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *AlertsUndeleteCall) Context(ctx context.Context) *AlertsUndeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *AlertsUndeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AlertsUndeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210518")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.undeletealertrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/alerts/{alertId}:undelete")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"alertId": c.alertId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "alertcenter.alerts.undelete" call.
// Exactly one of *Alert or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *Alert.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified
// was returned.
func (c *AlertsUndeleteCall) Do(opts ...googleapi.CallOption) (*Alert, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &Alert{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Restores, or \"undeletes\", an alert that was marked for deletion within the past 30 days. Attempting to undelete an alert which was marked for deletion over 30 days ago (which has been removed from the Alert Center database) or a nonexistent alert returns a `NOT_FOUND` error. Attempting to undelete an alert which has not been marked for deletion has no effect.",
	//   "flatPath": "v1beta1/alerts/{alertId}:undelete",
	//   "httpMethod": "POST",
	//   "id": "alertcenter.alerts.undelete",
	//   "parameterOrder": [
	//     "alertId"
	//   ],
	//   "parameters": {
	//     "alertId": {
	//       "description": "Required. The identifier of the alert to undelete.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta1/alerts/{alertId}:undelete",
	//   "request": {
	//     "$ref": "UndeleteAlertRequest"
	//   },
	//   "response": {
	//     "$ref": "Alert"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/apps.alerts"
	//   ]
	// }

}

// method id "alertcenter.alerts.feedback.create":

type AlertsFeedbackCreateCall struct {
	s             *Service
	alertId       string
	alertfeedback *AlertFeedback
	urlParams_    gensupport.URLParams
	ctx_          context.Context
	header_       http.Header
}

// Create: Creates new feedback for an alert. Attempting to create a
// feedback for a non-existent alert returns `NOT_FOUND` error.
// Attempting to create a feedback for an alert that is marked for
// deletion returns `FAILED_PRECONDITION' error.
//
// - alertId: The identifier of the alert this feedback belongs to.
func (r *AlertsFeedbackService) Create(alertId string, alertfeedback *AlertFeedback) *AlertsFeedbackCreateCall {
	c := &AlertsFeedbackCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.alertId = alertId
	c.alertfeedback = alertfeedback
	return c
}

// CustomerId sets the optional parameter "customerId": The unique
// identifier of the Google Workspace organization account of the
// customer the alert is associated with. Inferred from the caller
// identity if not provided.
func (c *AlertsFeedbackCreateCall) CustomerId(customerId string) *AlertsFeedbackCreateCall {
	c.urlParams_.Set("customerId", customerId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *AlertsFeedbackCreateCall) Fields(s ...googleapi.Field) *AlertsFeedbackCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *AlertsFeedbackCreateCall) Context(ctx context.Context) *AlertsFeedbackCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *AlertsFeedbackCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AlertsFeedbackCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210518")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.alertfeedback)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/alerts/{alertId}/feedback")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"alertId": c.alertId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "alertcenter.alerts.feedback.create" call.
// Exactly one of *AlertFeedback or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *AlertFeedback.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *AlertsFeedbackCreateCall) Do(opts ...googleapi.CallOption) (*AlertFeedback, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &AlertFeedback{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Creates new feedback for an alert. Attempting to create a feedback for a non-existent alert returns `NOT_FOUND` error. Attempting to create a feedback for an alert that is marked for deletion returns `FAILED_PRECONDITION' error.",
	//   "flatPath": "v1beta1/alerts/{alertId}/feedback",
	//   "httpMethod": "POST",
	//   "id": "alertcenter.alerts.feedback.create",
	//   "parameterOrder": [
	//     "alertId"
	//   ],
	//   "parameters": {
	//     "alertId": {
	//       "description": "Required. The identifier of the alert this feedback belongs to.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "customerId": {
	//       "description": "Optional. The unique identifier of the Google Workspace organization account of the customer the alert is associated with. Inferred from the caller identity if not provided.",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta1/alerts/{alertId}/feedback",
	//   "request": {
	//     "$ref": "AlertFeedback"
	//   },
	//   "response": {
	//     "$ref": "AlertFeedback"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/apps.alerts"
	//   ]
	// }

}

// method id "alertcenter.alerts.feedback.list":

type AlertsFeedbackListCall struct {
	s            *Service
	alertId      string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all the feedback for an alert. Attempting to list
// feedbacks for a non-existent alert returns `NOT_FOUND` error.
//
// - alertId: The alert identifier. The "-" wildcard could be used to
//   represent all alerts.
func (r *AlertsFeedbackService) List(alertId string) *AlertsFeedbackListCall {
	c := &AlertsFeedbackListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.alertId = alertId
	return c
}

// CustomerId sets the optional parameter "customerId": The unique
// identifier of the Google Workspace organization account of the
// customer the alert feedback are associated with. Inferred from the
// caller identity if not provided.
func (c *AlertsFeedbackListCall) CustomerId(customerId string) *AlertsFeedbackListCall {
	c.urlParams_.Set("customerId", customerId)
	return c
}

// Filter sets the optional parameter "filter": A query string for
// filtering alert feedback results. For more details, see Query filters
// (/admin-sdk/alertcenter/guides/query-filters) and Supported query
// filter fields
// (/admin-sdk/alertcenter/reference/filter-fields#alerts.feedback.list).
func (c *AlertsFeedbackListCall) Filter(filter string) *AlertsFeedbackListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *AlertsFeedbackListCall) Fields(s ...googleapi.Field) *AlertsFeedbackListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *AlertsFeedbackListCall) IfNoneMatch(entityTag string) *AlertsFeedbackListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *AlertsFeedbackListCall) Context(ctx context.Context) *AlertsFeedbackListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *AlertsFeedbackListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AlertsFeedbackListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210518")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/alerts/{alertId}/feedback")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"alertId": c.alertId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "alertcenter.alerts.feedback.list" call.
// Exactly one of *ListAlertFeedbackResponse or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *ListAlertFeedbackResponse.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *AlertsFeedbackListCall) Do(opts ...googleapi.CallOption) (*ListAlertFeedbackResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &ListAlertFeedbackResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists all the feedback for an alert. Attempting to list feedbacks for a non-existent alert returns `NOT_FOUND` error.",
	//   "flatPath": "v1beta1/alerts/{alertId}/feedback",
	//   "httpMethod": "GET",
	//   "id": "alertcenter.alerts.feedback.list",
	//   "parameterOrder": [
	//     "alertId"
	//   ],
	//   "parameters": {
	//     "alertId": {
	//       "description": "Required. The alert identifier. The \"-\" wildcard could be used to represent all alerts.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "customerId": {
	//       "description": "Optional. The unique identifier of the Google Workspace organization account of the customer the alert feedback are associated with. Inferred from the caller identity if not provided.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "filter": {
	//       "description": "Optional. A query string for filtering alert feedback results. For more details, see [Query filters](/admin-sdk/alertcenter/guides/query-filters) and [Supported query filter fields](/admin-sdk/alertcenter/reference/filter-fields#alerts.feedback.list).",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta1/alerts/{alertId}/feedback",
	//   "response": {
	//     "$ref": "ListAlertFeedbackResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/apps.alerts"
	//   ]
	// }

}

// method id "alertcenter.getSettings":

type V1beta1GetSettingsCall struct {
	s            *Service
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetSettings: Returns customer-level settings.
func (r *V1beta1Service) GetSettings() *V1beta1GetSettingsCall {
	c := &V1beta1GetSettingsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	return c
}

// CustomerId sets the optional parameter "customerId": The unique
// identifier of the Google Workspace organization account of the
// customer the alert settings are associated with. Inferred from the
// caller identity if not provided.
func (c *V1beta1GetSettingsCall) CustomerId(customerId string) *V1beta1GetSettingsCall {
	c.urlParams_.Set("customerId", customerId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *V1beta1GetSettingsCall) Fields(s ...googleapi.Field) *V1beta1GetSettingsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *V1beta1GetSettingsCall) IfNoneMatch(entityTag string) *V1beta1GetSettingsCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *V1beta1GetSettingsCall) Context(ctx context.Context) *V1beta1GetSettingsCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *V1beta1GetSettingsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *V1beta1GetSettingsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210518")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/settings")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "alertcenter.getSettings" call.
// Exactly one of *Settings or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *Settings.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *V1beta1GetSettingsCall) Do(opts ...googleapi.CallOption) (*Settings, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &Settings{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Returns customer-level settings.",
	//   "flatPath": "v1beta1/settings",
	//   "httpMethod": "GET",
	//   "id": "alertcenter.getSettings",
	//   "parameterOrder": [],
	//   "parameters": {
	//     "customerId": {
	//       "description": "Optional. The unique identifier of the Google Workspace organization account of the customer the alert settings are associated with. Inferred from the caller identity if not provided.",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta1/settings",
	//   "response": {
	//     "$ref": "Settings"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/apps.alerts"
	//   ]
	// }

}

// method id "alertcenter.updateSettings":

type V1beta1UpdateSettingsCall struct {
	s          *Service
	settings   *Settings
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// UpdateSettings: Updates the customer-level settings.
func (r *V1beta1Service) UpdateSettings(settings *Settings) *V1beta1UpdateSettingsCall {
	c := &V1beta1UpdateSettingsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.settings = settings
	return c
}

// CustomerId sets the optional parameter "customerId": The unique
// identifier of the Google Workspace organization account of the
// customer the alert settings are associated with. Inferred from the
// caller identity if not provided.
func (c *V1beta1UpdateSettingsCall) CustomerId(customerId string) *V1beta1UpdateSettingsCall {
	c.urlParams_.Set("customerId", customerId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *V1beta1UpdateSettingsCall) Fields(s ...googleapi.Field) *V1beta1UpdateSettingsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *V1beta1UpdateSettingsCall) Context(ctx context.Context) *V1beta1UpdateSettingsCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *V1beta1UpdateSettingsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *V1beta1UpdateSettingsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210518")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.settings)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/settings")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "alertcenter.updateSettings" call.
// Exactly one of *Settings or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *Settings.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *V1beta1UpdateSettingsCall) Do(opts ...googleapi.CallOption) (*Settings, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &Settings{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates the customer-level settings.",
	//   "flatPath": "v1beta1/settings",
	//   "httpMethod": "PATCH",
	//   "id": "alertcenter.updateSettings",
	//   "parameterOrder": [],
	//   "parameters": {
	//     "customerId": {
	//       "description": "Optional. The unique identifier of the Google Workspace organization account of the customer the alert settings are associated with. Inferred from the caller identity if not provided.",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta1/settings",
	//   "request": {
	//     "$ref": "Settings"
	//   },
	//   "response": {
	//     "$ref": "Settings"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/apps.alerts"
	//   ]
	// }

}
