// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package alexaforbusiness

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type SearchProfilesInput struct {
	_ struct{} `type:"structure"`

	// The filters to use to list a specified set of room profiles. Supported filter
	// keys are ProfileName and Address. Required.
	Filters []Filter `type:"list"`

	// The maximum number of results to include in the response. If more results
	// exist than the specified MaxResults value, a token is included in the response
	// so that the remaining results can be retrieved.
	MaxResults *int64 `min:"1" type:"integer"`

	// An optional token returned from a prior request. Use this token for pagination
	// of results from this action. If this parameter is specified, the response
	// includes only results beyond the token, up to the value specified by MaxResults.
	NextToken *string `min:"1" type:"string"`

	// The sort order to use in listing the specified set of room profiles. Supported
	// sort keys are ProfileName and Address.
	SortCriteria []Sort `type:"list"`
}

// String returns the string representation
func (s SearchProfilesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SearchProfilesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SearchProfilesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.SortCriteria != nil {
		for i, v := range s.SortCriteria {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "SortCriteria", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type SearchProfilesOutput struct {
	_ struct{} `type:"structure"`

	// The token returned to indicate that there is more data available.
	NextToken *string `min:"1" type:"string"`

	// The profiles that meet the specified set of filter criteria, in sort order.
	Profiles []ProfileData `type:"list"`

	// The total number of room profiles returned.
	TotalCount *int64 `type:"integer"`
}

// String returns the string representation
func (s SearchProfilesOutput) String() string {
	return awsutil.Prettify(s)
}

const opSearchProfiles = "SearchProfiles"

// SearchProfilesRequest returns a request value for making API operation for
// Alexa For Business.
//
// Searches room profiles and lists the ones that meet a set of filter criteria.
//
//    // Example sending a request using SearchProfilesRequest.
//    req := client.SearchProfilesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchProfiles
func (c *Client) SearchProfilesRequest(input *SearchProfilesInput) SearchProfilesRequest {
	op := &aws.Operation{
		Name:       opSearchProfiles,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &SearchProfilesInput{}
	}

	req := c.newRequest(op, input, &SearchProfilesOutput{})
	return SearchProfilesRequest{Request: req, Input: input, Copy: c.SearchProfilesRequest}
}

// SearchProfilesRequest is the request type for the
// SearchProfiles API operation.
type SearchProfilesRequest struct {
	*aws.Request
	Input *SearchProfilesInput
	Copy  func(*SearchProfilesInput) SearchProfilesRequest
}

// Send marshals and sends the SearchProfiles API request.
func (r SearchProfilesRequest) Send(ctx context.Context) (*SearchProfilesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &SearchProfilesResponse{
		SearchProfilesOutput: r.Request.Data.(*SearchProfilesOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewSearchProfilesRequestPaginator returns a paginator for SearchProfiles.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.SearchProfilesRequest(input)
//   p := alexaforbusiness.NewSearchProfilesRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewSearchProfilesPaginator(req SearchProfilesRequest) SearchProfilesPaginator {
	return SearchProfilesPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *SearchProfilesInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// SearchProfilesPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type SearchProfilesPaginator struct {
	aws.Pager
}

func (p *SearchProfilesPaginator) CurrentPage() *SearchProfilesOutput {
	return p.Pager.CurrentPage().(*SearchProfilesOutput)
}

// SearchProfilesResponse is the response type for the
// SearchProfiles API operation.
type SearchProfilesResponse struct {
	*SearchProfilesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// SearchProfiles request.
func (r *SearchProfilesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
